/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClockRouter {
    EditingPreferences ep;
    Cell cell;
    Technology tech;
    double scaleUnits;
    double horizScale;
    double vertScale;
    double stubLength;
    Cell repeaterCell;
    PortProto repeaterIn;
    PortProto repeaterOut;
    double repeaterDistance;
    String repeaterInstancePrefix;
    String repeaterNetworkPrefix;
    List<RowSpec> repeaterRows;
    ArcProto repeaterArc;
    double repeaterArcWidth;
    ArcProto horizArc;
    ArcProto vertArc;
    double horizArcWidth;
    double vertArcWidth;
    PrimitiveNode cornerContact;
    List<SubTree> allGroups;
    private static final int LEFT_EDGE = 0;
    private static final int RIGHT_EDGE = 1;
    private static final int UP_EDGE = 2;
    private static final int DOWN_EDGE = 3;

    public ClockRouter(EditingPreferences ep, Cell cell) {
        this.ep = ep;
        this.cell = cell;
        this.allGroups = new ArrayList<SubTree>();
        this.tech = Technology.getCurrent();
        this.scaleUnits = 1.0;
        this.vertScale = 1.0;
        this.horizScale = 1.0;
        this.stubLength = 10.0;
        this.repeaterDistance = 0.0;
        this.repeaterInstancePrefix = "CLK_BUF";
        this.repeaterNetworkPrefix = "CLK";
        this.repeaterRows = new ArrayList<RowSpec>();
        this.repeaterArc = null;
    }

    public double getArcWidth(ArcProto ap) {
        double arcWidth = ap.getDefaultLambdaBaseWidth(this.ep) * this.horizScale;
        return arcWidth;
    }

    public double getStubLength(ArcProto ap) {
        return this.stubLength;
    }

    private Point2D getContactSize(PrimitiveNode pnp, ArcProto ap1, double width1, ArcProto ap2, double width2) {
        double extra1 = width1 - ap1.getDefaultLambdaBaseWidth(this.ep);
        double extra2 = width2 - ap2.getDefaultLambdaBaseWidth(this.ep);
        double sizeX = pnp.getDefWidth(this.ep) + extra1;
        double sizeY = pnp.getDefHeight(this.ep) + extra2;
        return new Point2D.Double(sizeX, sizeY);
    }

    private PrimitiveNode findContact(Technology tech, int l1, int l2) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            Technology.NodeLayer[] layers = pn.getNodeLayers();
            boolean sourceFound = false;
            boolean destFound = false;
            for (int j = 0; j < layers.length; ++j) {
                Layer.Function fun = layers[j].getLayer().getFunction();
                if (!fun.isMetal()) continue;
                if (fun.getLevel() == l1) {
                    sourceFound = true;
                }
                if (fun.getLevel() != l2) continue;
                destFound = true;
            }
            if (!sourceFound || !destFound) continue;
            return pn;
        }
        return null;
    }

    public static void routeHTree() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ArrayList<NeededHTree> treesToRoute = new ArrayList<NeededHTree>();
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() == 0) {
            NeededHTree nht = new NeededHTree();
            treesToRoute.add(nht);
        } else {
            Netlist netList = cell.getNetlist();
            if (netList == null) {
                System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
                return;
            }
            Map<Network, ArcInst[]> arcMap = netList.getArcInstsByNetwork();
            for (Network net : nets) {
                ArcInst ai;
                int i;
                ArcInst[] arcs = arcMap.get(net);
                if (arcs == null) {
                    System.out.println("WARNING: Network " + net.describe(false) + " has no arcs on it");
                    continue;
                }
                NeededHTree nht = new NeededHTree();
                for (i = 0; i < arcs.length; ++i) {
                    ai = arcs[i];
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    for (int e = 0; e < 2; ++e) {
                        PortInst pi = ai.getPortInst(e);
                        NodeInst ni = pi.getNodeInst();
                        if (!ni.isCellInstance()) continue;
                        Export ex = (Export)pi.getPortProto();
                        PortCharacteristic pc = ex.getCharacteristic();
                        if (pc.isClock()) {
                            nht.addDestination(new SerializablePortInst(pi));
                            continue;
                        }
                        if (pc != PortCharacteristic.OUT) continue;
                        SerializablePortInst spiNew = new SerializablePortInst(pi);
                        if (nht.source != null) {
                            if (nht.source.equals(spiNew)) continue;
                            System.out.println("ERROR: Network " + net.describe(false) + " has multiple drivers: " + nht.source.ni.describe(false) + ", port " + nht.source.portName + " and " + ni.describe(false) + ", port " + ex.getName());
                            continue;
                        }
                        nht.source = spiNew;
                    }
                }
                if (nht.source == null) {
                    System.out.println("ERROR: Network " + net.describe(false) + " has no source (driver)");
                    continue;
                }
                for (i = 0; i < arcs.length; ++i) {
                    ai = arcs[i];
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    nht.originalArcs.add(ai);
                }
                treesToRoute.add(nht);
            }
        }
        String fileName = OpenFile.chooseInputFile(FileType.TEXT, "Clock-Tree Routing Directive file:");
        if (fileName == null) {
            return;
        }
        new ClockTreeRouteJob(treesToRoute, fileName, cell);
    }

    private boolean routeAlgorithm2(NeededHTree nht, String fileName, Cell cell) {
        String destinationNodeName = "";
        String destinationPortName = "";
        double sourceStubX = 0.0;
        double sourceStubY = 0.0;
        String pnrOutputFile = null;
        double pnrOutputScale = 1.0;
        SerializablePortInst sourceSPI = null;
        URL url = com.sun.electric.util.TextUtils.makeURLToFile(fileName);
        try {
            String directive;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            block2: while ((directive = lineReader.readLine()) != null) {
                ArcProto.Function fun;
                ArcProto ap;
                Iterator<Object> it;
                String firstPart;
                String[] splitParts = directive.split(" ");
                ArrayList<String> parts = new ArrayList<String>();
                for (int j = 0; j < splitParts.length; ++j) {
                    if (splitParts[j].length() <= 0) continue;
                    parts.add(splitParts[j]);
                }
                if (parts.size() == 0 || (firstPart = (String)parts.get(0)).startsWith("#")) continue;
                if (firstPart.equalsIgnoreCase("DESTINATION")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("node=")) {
                            destinationNodeName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("port=")) {
                            destinationPortName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stub=")) {
                            String stubStr = ((String)parts.get(j)).substring(5);
                            this.stubLength = this.convertToUnits(stubStr);
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of DESTINATION directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("SOURCE")) {
                    String sourceNodeName = "";
                    String sourcePortName = "";
                    for (int j = 1; j < parts.size(); ++j) {
                        String stubStr;
                        if (((String)parts.get(j)).toLowerCase().startsWith("node=")) {
                            sourceNodeName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("port=")) {
                            sourcePortName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stubx=")) {
                            stubStr = ((String)parts.get(j)).substring(6);
                            sourceStubX = this.convertToUnits(stubStr);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stuby=")) {
                            stubStr = ((String)parts.get(j)).substring(6);
                            sourceStubY = this.convertToUnits(stubStr);
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of SOURCE directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni = it.next();
                        if (!ni.isCellInstance() || !ni.getProto().getName().equals(sourceNodeName)) continue;
                        PortProto pp = ni.getProto().findPortProto(sourcePortName);
                        if (pp == null) {
                            System.out.println("ERROR on line " + lineReader.getLineNumber() + " of SOURCE directive: cannot find port " + sourcePortName + " on node " + ni.describe(false));
                            lineReader.close();
                            return false;
                        }
                        sourceSPI = new SerializablePortInst(ni.findPortInstFromProto(pp));
                        continue block2;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("REPEATER")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("cell=")) {
                            String repeaterCellName = ((String)parts.get(j)).substring(5);
                            for (Library lib : Library.getVisibleLibraries()) {
                                this.repeaterCell = lib.findNodeProto(repeaterCellName);
                                if (this.repeaterCell == null) continue;
                                break;
                            }
                            if (this.repeaterCell == null) {
                                System.out.println("WARNING on line " + lineReader.getLineNumber() + " REPEATER cell unknown (" + repeaterCellName + ").  Not placing repeaters.");
                            }
                            this.repeaterOut = null;
                            this.repeaterIn = null;
                            it = this.repeaterCell.getPorts();
                            while (it.hasNext()) {
                                PortProto pp = (PortProto)it.next();
                                PortCharacteristic pc = pp.getCharacteristic();
                                if (pc == PortCharacteristic.IN) {
                                    if (this.repeaterIn != null) {
                                        System.out.println("WARNING: repeater cell " + this.repeaterCell.describe(false) + " has multiple input ports.");
                                    }
                                    this.repeaterIn = pp;
                                }
                                if (pc != PortCharacteristic.OUT) continue;
                                if (this.repeaterOut != null) {
                                    System.out.println("WARNING: repeater cell " + this.repeaterCell.describe(false) + " has multiple output ports.");
                                }
                                this.repeaterOut = pp;
                            }
                            if (this.repeaterIn == null) {
                                System.out.println("WARNING: repeater cell " + this.repeaterCell.describe(false) + " has no input ports. Not placing repeaters.");
                            }
                            if (this.repeaterOut == null) {
                                System.out.println("WARNING: repeater cell " + this.repeaterCell.describe(false) + " has no output ports. Not placing repeaters.");
                            }
                            if (this.repeaterIn != null && this.repeaterOut != null) continue;
                            this.repeaterCell = null;
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("dist=")) {
                            String distNum = ((String)parts.get(j)).substring(5);
                            this.repeaterDistance = this.convertToUnits(distNum);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("instname=")) {
                            this.repeaterInstancePrefix = ((String)parts.get(j)).substring(9);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("netname=")) {
                            this.repeaterNetworkPrefix = ((String)parts.get(j)).substring(8);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("connect=")) {
                            this.repeaterArc = null;
                            int level = com.sun.electric.util.TextUtils.atoi(((String)parts.get(j)).substring(8));
                            it = this.tech.getArcs();
                            while (it.hasNext()) {
                                ap = (ArcProto)it.next();
                                fun = ap.getFunction();
                                if (!fun.isMetal() || fun.getLevel() != level) continue;
                                this.repeaterArc = ap;
                            }
                            if (this.repeaterArc == null) {
                                System.out.println("ERROR on line " + lineReader.getLineNumber() + " repeater connection layer unknown (" + level + ")");
                                lineReader.close();
                                return false;
                            }
                            this.repeaterArcWidth = this.getArcWidth(this.repeaterArc);
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of REPEATER directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("UNITS")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        if (!((String)parts.get(j)).toLowerCase().startsWith("microns=")) continue;
                        this.scaleUnits = com.sun.electric.util.TextUtils.atof(((String)parts.get(j)).substring(8));
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("ROW")) {
                    if (parts.size() != 14) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of ROW directive: expecting 14 keywords but found " + parts.size());
                        continue;
                    }
                    if (!((String)parts.get(6)).toLowerCase().equals("do")) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of ROW directive: missing 'DO' keyword");
                        continue;
                    }
                    if (!((String)parts.get(8)).toLowerCase().equals("by")) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of ROW directive: missing 'BY' keyword");
                        continue;
                    }
                    if (!((String)parts.get(10)).toLowerCase().equals("step")) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of ROW directive: missing 'STEP' keyword");
                        continue;
                    }
                    if (!((String)parts.get(13)).equals(";")) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of ROW directive: missing ';'");
                        continue;
                    }
                    RowSpec rs = new RowSpec();
                    rs.origX = this.convertToUnits((String)parts.get(3));
                    rs.origY = this.convertToUnits((String)parts.get(4));
                    String orientStr = (String)parts.get(5);
                    rs.orient = this.getOrientation(orientStr);
                    rs.repeatX = com.sun.electric.util.TextUtils.atoi((String)parts.get(7));
                    rs.repeatY = com.sun.electric.util.TextUtils.atoi((String)parts.get(9));
                    rs.stepX = this.convertToUnits((String)parts.get(11));
                    rs.stepY = this.convertToUnits((String)parts.get(12));
                    this.repeaterRows.add(rs);
                    continue;
                }
                if (firstPart.equalsIgnoreCase("PNR-OUTPUT")) {
                    if (!IOTool.hasPnR()) {
                        System.out.println("WARNING: PNR-OUTPUT directive ignored because PNR module is not installed");
                        continue;
                    }
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("file=")) {
                            pnrOutputFile = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("scale=")) {
                            pnrOutputScale = com.sun.electric.util.TextUtils.atof(((String)parts.get(j)).substring(6));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of PNR-OUTPUT directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("LAYERS")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        int level;
                        if (((String)parts.get(j)).toLowerCase().startsWith("horizontal=")) {
                            this.horizArc = null;
                            level = com.sun.electric.util.TextUtils.atoi(((String)parts.get(j)).substring(11));
                            it = this.tech.getArcs();
                            while (it.hasNext()) {
                                ap = (ArcProto)it.next();
                                fun = ap.getFunction();
                                if (!fun.isMetal() || fun.getLevel() != level) continue;
                                this.horizArc = ap;
                            }
                            if (this.horizArc == null) {
                                System.out.println("ERROR on line " + lineReader.getLineNumber() + " horizontal layer unknown (" + level + ")");
                                lineReader.close();
                                return false;
                            }
                            this.horizArcWidth = this.getArcWidth(this.horizArc);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("vertical=")) {
                            this.vertArc = null;
                            level = com.sun.electric.util.TextUtils.atoi(((String)parts.get(j)).substring(9));
                            it = this.tech.getArcs();
                            while (it.hasNext()) {
                                ap = (ArcProto)it.next();
                                fun = ap.getFunction();
                                if (!fun.isMetal() || fun.getLevel() != level) continue;
                                this.vertArc = ap;
                            }
                            if (this.vertArc == null) {
                                System.out.println("ERROR on line " + lineReader.getLineNumber() + " vertical layer unknown (" + level + ")");
                                lineReader.close();
                                return false;
                            }
                            this.vertArcWidth = this.getArcWidth(this.vertArc);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("horizontal-scale=")) {
                            this.horizScale = com.sun.electric.util.TextUtils.atof(((String)parts.get(j)).substring(17));
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("vertical-scale=")) {
                            this.vertScale = com.sun.electric.util.TextUtils.atof(((String)parts.get(j)).substring(15));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of LAYERS directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    if (this.horizArc == null || this.vertArc == null) continue;
                    int l1 = this.horizArc.getFunction().getLevel();
                    int l2 = this.vertArc.getFunction().getLevel();
                    this.cornerContact = this.findContact(this.tech, l1, l2);
                    if (this.cornerContact != null) continue;
                    System.out.println("WARNING on line " + lineReader.getLineNumber() + " cannot find contact to join metals " + l1 + " and " + l2);
                    lineReader.close();
                    return false;
                }
                if (!firstPart.equalsIgnoreCase("CHANNEL")) continue;
                SubTree st = new SubTree();
                for (int j = 1; j < parts.size(); ++j) {
                    SubTree subST;
                    String part = (String)parts.get(j);
                    if (part.toLowerCase().startsWith("name=")) {
                        st.setTreeName(part.substring(5));
                        continue;
                    }
                    if (part.toLowerCase().startsWith("in=")) {
                        st.inEdge = this.getDirectionName(part.substring(3));
                        if (st.inEdge >= 0) continue;
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown 'in' edge (" + part.substring(3) + ")");
                        lineReader.close();
                        return false;
                    }
                    if (part.toLowerCase().startsWith("out=")) {
                        st.outEdge = this.getDirectionName(part.substring(4));
                        if (st.outEdge >= 0) continue;
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown 'out' edge (" + part.substring(4) + ")");
                        lineReader.close();
                        return false;
                    }
                    SerializablePortInst found = null;
                    Iterator<NodeInst> it2 = cell.getNodes();
                    while (it2.hasNext()) {
                        NodeInst ni = it2.next();
                        if (!ni.isCellInstance() || !ni.getProto().getName().equals(destinationNodeName) || !ni.getName().endsWith(part)) continue;
                        PortProto pp = ni.getProto().findPortProto(destinationPortName);
                        if (pp == null) {
                            System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: cannot find port " + destinationPortName + " on node " + ni.describe(false));
                            lineReader.close();
                            return false;
                        }
                        found = new SerializablePortInst(ni.findPortInstFromProto(pp));
                        break;
                    }
                    if (found == null && (subST = this.findSubTree(part)) != null) {
                        found = subST.output;
                    }
                    if (found == null) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown node name (" + part + ")");
                        lineReader.close();
                        return false;
                    }
                    st.connections.add(found);
                }
                for (int i = 0; i < 100 && !st.route(); ++i) {
                }
                this.allGroups.add(st);
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
        ArrayList<MakeConnection> everyConnection = new ArrayList<MakeConnection>();
        ArrayList<MakePoint> everyPoint = new ArrayList<MakePoint>();
        for (SubTree st : this.allGroups) {
            for (MakeConnection mc : st.allConnections) {
                everyConnection.add(mc);
            }
            for (MakePoint mp : st.allPoints) {
                everyPoint.add(mp);
            }
        }
        EPoint sourcePT = null;
        if (sourceSPI != null) {
            PortInst sourcePI = sourceSPI.getPortInst();
            sourcePT = sourcePI.getCenter();
            if (sourceStubX != 0.0 || sourceStubY != 0.0) {
                MakePoint sourceMP = new MakePoint(sourceSPI);
                EPoint ctr = EPoint.fromLambda(sourcePT.getX() + sourceStubX, sourcePT.getY() + sourceStubY);
                Point2D mpSize = this.getContactSize(this.cornerContact, this.horizArc, this.horizArcWidth, this.vertArc, this.vertArcWidth);
                MakePoint mp = new MakePoint(this.cornerContact, ctr, mpSize.getX(), mpSize.getY(), this.ep, cell);
                everyPoint.add(mp);
                everyConnection.add(new MakeConnection(sourceMP, mp));
                sourceSPI = new SerializablePortInst(mp.ni.getOnlyPortInst());
            }
            this.connectToSource(sourceSPI, everyConnection, everyPoint);
        }
        if (sourcePT != null) {
            RoutePath fullPath = new RoutePath(everyConnection, sourcePT, null, 1);
            if (this.repeaterDistance > 0.0) {
                HashMap levelCount = new HashMap();
                fullPath.addRepeaters(everyConnection, this.repeaterDistance, everyPoint, levelCount);
            }
        }
        this.placeArcs(everyConnection, everyPoint, cell);
        if (pnrOutputFile != null && IOTool.hasPnR()) {
            String outFileName = com.sun.electric.util.TextUtils.getFilePath(url) + pnrOutputFile;
            ArrayList<Geometric> allGeometry = new ArrayList<Geometric>();
            for (MakePoint mp : everyPoint) {
                NodeInst ni = mp.ni;
                if (ni == null) continue;
                allGeometry.add(ni);
            }
            for (MakeConnection mc : everyConnection) {
                ArcInst ai = mc.ai;
                if (ai == null) continue;
                allGeometry.add(ai);
            }
            IOTool.PnRPreferences pnrp = new IOTool.PnRPreferences(true);
            pnrp.writePnR(allGeometry, pnrOutputScale, outFileName);
        }
        return false;
    }

    private SubTree findSubTree(String name) {
        for (SubTree subST : this.allGroups) {
            if (!name.equalsIgnoreCase(subST.treeName)) continue;
            return subST;
        }
        return null;
    }

    public int getDirectionName(String name) {
        if (name.equalsIgnoreCase("left")) {
            return 0;
        }
        if (name.equalsIgnoreCase("right")) {
            return 1;
        }
        if (name.equalsIgnoreCase("up")) {
            return 2;
        }
        if (name.equalsIgnoreCase("down")) {
            return 3;
        }
        return -1;
    }

    private void placeArcs(List<MakeConnection> connections, List<MakePoint> points, Cell cell) {
        for (int i = 0; i < connections.size(); ++i) {
            MakeConnection mc = connections.get(i);
            if (mc.ap == null) {
                System.out.println("CANNOT PLACE ARC!");
                continue;
            }
            MakePoint mp1 = this.ensureArcConnectsToPort(mc, mc.from, connections, points);
            if (mp1 == null) {
                System.out.println("CANNOT PLACE ARC, FROM END!");
                continue;
            }
            MakePoint mp2 = this.ensureArcConnectsToPort(mc, mc.to, connections, points);
            if (mp2 == null) {
                System.out.println("CANNOT PLACE ARC, TO END!");
                continue;
            }
            PortInst pi1 = mp1.spi != null ? mp1.spi.getPortInst() : mp1.ni.getOnlyPortInst();
            PortInst pi2 = mp2.spi != null ? mp2.spi.getPortInst() : mp2.ni.getOnlyPortInst();
            mc.ai = ArcInst.makeInstanceBase(mc.ap, this.ep, mc.width, pi1, pi2);
            if (mc.ai == null || mc.netName == null) continue;
            mc.ai.setName(mc.netName, this.ep);
        }
    }

    private MakePoint ensureArcConnectsToPort(MakeConnection mc, MakePoint mp, List<MakeConnection> connections, List<MakePoint> points) {
        PortInst pi;
        if (mc.ap == null) {
            return mp;
        }
        PortInst portInst = pi = mp.spi != null ? mp.spi.getPortInst() : mp.ni.getOnlyPortInst();
        if (pi.getPortProto().connectsTo(mc.ap)) {
            return mp;
        }
        EPoint stackLoc = pi.getCenter();
        int destinationLevel = mc.ap.getFunction().getLevel();
        int bestDist = Integer.MAX_VALUE;
        int sourceLevel = -1;
        ArcProto[] portConnections = pi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < portConnections.length; ++i) {
            int dist;
            int levelAlt;
            ArcProto apAlt = portConnections[i];
            if (apAlt.getTechnology() == Generic.tech() || (levelAlt = apAlt.getFunction().getLevel()) < 0 || (dist = Math.abs(destinationLevel - levelAlt)) >= bestDist) continue;
            bestDist = dist;
            sourceLevel = levelAlt;
        }
        if (destinationLevel == sourceLevel) {
            return mp;
        }
        int dir = (destinationLevel - sourceLevel) / Math.abs(destinationLevel - sourceLevel);
        int sl = sourceLevel;
        int dl = destinationLevel;
        if (dir > 0) {
            ++sl;
            ++dl;
        }
        for (int i = sl; i != dl; i += dir) {
            PrimitiveNode connection = this.findContact(this.tech, i - 1, i);
            if (connection == null) {
                System.out.println("Warning: Cannot bring source node " + pi.getNodeInst().describe(false) + " up to Metal-" + destinationLevel + " because there is no Metal-" + (i - 1) + "-to-Metal-" + i + " contact in technology " + this.tech.getTechName());
                return null;
            }
            ArcProto arcIn = null;
            ArcProto arcOut = null;
            ArcProto[] possibleCons = connection.getPort(0).getConnections();
            for (int j = 0; j < possibleCons.length; ++j) {
                if (possibleCons[j].getTechnology() == Generic.tech()) continue;
                if (possibleCons[j].getFunction().getLevel() == i - 1) {
                    arcIn = possibleCons[j];
                }
                if (possibleCons[j].getFunction().getLevel() != i) continue;
                arcOut = possibleCons[j];
            }
            if (dir < 0) {
                arcIn = arcOut;
            }
            Point2D mpSize = this.getContactSize(connection, arcIn, this.getArcWidth(arcIn), arcOut, this.getArcWidth(arcOut));
            MakePoint mpNew = new MakePoint(connection, stackLoc, mpSize.getX(), mpSize.getY(), this.ep, this.cell);
            points.add(mpNew);
            MakeConnection mcNew = new MakeConnection(mp, mpNew);
            mcNew.ap = arcIn;
            mcNew.width = this.getArcWidth(arcIn);
            connections.add(mcNew);
            mp = mpNew;
        }
        return mp;
    }

    public void connectToSource(SerializablePortInst sourceSPI, List<MakeConnection> everyConnection, List<MakePoint> everyPoint) {
        PortInst sourcePI = sourceSPI.getPortInst();
        EPoint sourcePT = sourcePI.getCenter();
        SubTree topTree = this.allGroups.get(this.allGroups.size() - 1);
        SerializablePortInst destSPI = topTree.output;
        MakePoint sourceMP = new MakePoint(sourceSPI);
        MakePoint destMP = new MakePoint(destSPI);
        PortInst destPI = destSPI.getPortInst();
        EPoint destPT = destPI.getCenter();
        sourcePT = sourcePI.getCenter();
        if (destPT.getX() != sourcePT.getX() && destPT.getY() != sourcePT.getY()) {
            EPoint ctr = EPoint.fromLambda(sourcePT.getX(), destPT.getY());
            Point2D mpSize = this.getContactSize(this.cornerContact, this.horizArc, this.horizArcWidth, this.vertArc, this.vertArcWidth);
            MakePoint mp = new MakePoint(this.cornerContact, ctr, mpSize.getX(), mpSize.getY(), this.ep, this.cell);
            everyPoint.add(mp);
            everyConnection.add(new MakeConnection(sourceMP, mp));
            everyConnection.add(new MakeConnection(destMP, mp));
        } else {
            everyConnection.add(new MakeConnection(destMP, sourceMP));
        }
    }

    private double convertToUnits(String val) {
        double v = com.sun.electric.util.TextUtils.atof(val) / this.scaleUnits;
        return TextUtils.convertFromDistance(v, this.tech, TextUtils.UnitScale.MICRO);
    }

    private Orientation getOrientation(String key) {
        int angle;
        boolean transpose2 = false;
        if (key.equalsIgnoreCase("N")) {
            angle = 0;
        } else if (key.equalsIgnoreCase("S")) {
            angle = 1800;
        } else if (key.equalsIgnoreCase("E")) {
            angle = 2700;
        } else if (key.equalsIgnoreCase("W")) {
            angle = 900;
        } else if (key.equalsIgnoreCase("FN")) {
            angle = 900;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FS")) {
            angle = 2700;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FE")) {
            angle = 1800;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FW")) {
            angle = 0;
            transpose2 = true;
        } else {
            return null;
        }
        return Orientation.fromC(angle, transpose2);
    }

    private class MakeConnection {
        ArcProto ap = null;
        ArcInst ai;
        double width = 0.0;
        MakePoint from;
        MakePoint to;
        int treeDepth = 0;
        String netName = null;

        MakeConnection(MakePoint from2, MakePoint to2) {
            if (from2.loc.getX() == to2.loc.getX()) {
                this.ap = ClockRouter.this.vertArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            } else if (from2.loc.getY() == to2.loc.getY()) {
                this.ap = ClockRouter.this.horizArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            }
            if (this.ap == null) {
                System.out.println("WARNING: Connection from (" + from2.loc.getX() + "," + from2.loc.getY() + ") to (" + to2.loc.getX() + "," + to2.loc.getY() + ") is nonManhattan");
                this.ap = ClockRouter.this.horizArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            }
            this.from = from2;
            this.to = to2;
        }

        public void swapEnds() {
            MakePoint swap = this.from;
            this.from = this.to;
            this.to = swap;
        }
    }

    private static class MakePoint {
        SerializablePortInst spi;
        NodeInst ni;
        EPoint loc;

        MakePoint(NodeProto np, EPoint loc, double wid, double hei, EditingPreferences ep, Cell cell) {
            this.loc = loc;
            this.ni = NodeInst.makeInstance(np, ep, loc, wid, hei, cell);
        }

        MakePoint(NodeProto np, EPoint loc, double wid, double hei, Orientation orient, String name, EditingPreferences ep, Cell cell) {
            this.loc = loc;
            this.ni = NodeInst.makeInstance(np, ep, loc, wid, hei, cell, orient, name);
        }

        MakePoint(SerializablePortInst spi) {
            this.loc = spi.getPortInst().getCenter();
            this.spi = spi;
        }
    }

    private static class SortConnections
    implements Comparator<SerializablePortInst> {
        private boolean horizontal;

        SortConnections(boolean horizontal) {
            this.horizontal = horizontal;
        }

        @Override
        public int compare(SerializablePortInst s1, SerializablePortInst s2) {
            EPoint p1 = s1.getPortInst().getCenter();
            EPoint p2 = s2.getPortInst().getCenter();
            if (this.horizontal) {
                return Double.compare(p1.getX(), p2.getX());
            }
            return Double.compare(p1.getY(), p2.getY());
        }
    }

    private class SubTree {
        private String treeName;
        List<SerializablePortInst> connections = new ArrayList<SerializablePortInst>();
        int inEdge;
        int outEdge;
        SerializablePortInst output;
        List<MakePoint> allPoints = new ArrayList<MakePoint>();
        List<MakeConnection> allConnections = new ArrayList<MakeConnection>();

        public void setTreeName(String name) {
            this.treeName = name;
        }

        public boolean route() {
            double chanHei;
            double chanWid;
            this.allConnections.clear();
            this.allPoints.clear();
            double lXPort = 0.0;
            double hXPort = 0.0;
            double lYPort = 0.0;
            double hYPort = 0.0;
            double lXNodes = 0.0;
            double hXNodes = 0.0;
            double lYNodes = 0.0;
            double hYNodes = 0.0;
            boolean first = true;
            for (SerializablePortInst spi : this.connections) {
                PortInst pi = spi.getPortInst();
                EPoint pt = pi.getCenter();
                ERectangle bound = spi.ni.getBounds();
                if (first) {
                    lXPort = hXPort = pt.getX();
                    lYPort = hYPort = pt.getY();
                    lXNodes = bound.getMinX();
                    hXNodes = bound.getMaxX();
                    lYNodes = bound.getMinY();
                    hYNodes = bound.getMaxY();
                    first = false;
                    continue;
                }
                if (pt.getX() < lXPort) {
                    lXPort = pt.getX();
                }
                if (pt.getX() > hXPort) {
                    hXPort = pt.getX();
                }
                if (pt.getY() < lYPort) {
                    lYPort = pt.getY();
                }
                if (pt.getY() > hYPort) {
                    hYPort = pt.getY();
                }
                if (bound.getMinX() < lXNodes) {
                    lXNodes = bound.getMinX();
                }
                if (bound.getMaxX() > hXNodes) {
                    hXNodes = bound.getMaxX();
                }
                if (bound.getMinY() < lYNodes) {
                    lYNodes = bound.getMinY();
                }
                if (!(bound.getMaxY() > hYNodes)) continue;
                hYNodes = bound.getMaxY();
            }
            if (hXPort - lXPort > hYPort - lYPort) {
                chanWid = hXNodes - lXNodes;
                chanHei = 10000.0;
            } else {
                chanWid = 10000.0;
                chanHei = hYNodes - lYNodes;
            }
            double lXChan = 0.0;
            double hXChan = 0.0;
            double lYChan = 0.0;
            double hYChan = 0.0;
            switch (this.outEdge) {
                case 0: {
                    lXChan = hXNodes;
                    hXChan = lXChan + chanWid;
                    lYChan = (lYNodes + hYNodes) / 2.0 - chanHei / 2.0;
                    hYChan = lYChan + chanHei;
                    break;
                }
                case 1: {
                    hXChan = lXNodes;
                    lXChan = hXChan - chanWid;
                    lYChan = (lYNodes + hYNodes) / 2.0 - chanHei / 2.0;
                    hYChan = lYChan + chanHei;
                    break;
                }
                case 2: {
                    lXChan = (lXNodes + hXNodes) / 2.0 - chanWid / 2.0;
                    hXChan = lXChan + chanWid;
                    hYChan = lYNodes;
                    lYChan = hYChan - chanHei;
                    break;
                }
                case 3: {
                    lXChan = (lXNodes + hXNodes) / 2.0 - chanWid / 2.0;
                    hXChan = lXChan + chanWid;
                    lYChan = hYNodes;
                    hYChan = lYChan + chanHei;
                }
            }
            Point2D mpSize = ClockRouter.this.getContactSize(ClockRouter.this.cornerContact, ClockRouter.this.horizArc, ClockRouter.this.horizArcWidth, ClockRouter.this.vertArc, ClockRouter.this.vertArcWidth);
            boolean horizontal = true;
            double stubX = 0.0;
            double stubY = 0.0;
            switch (this.outEdge) {
                case 0: {
                    horizontal = false;
                    stubX = ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 1: {
                    horizontal = false;
                    stubX = -ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 2: {
                    stubY = -ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                    break;
                }
                case 3: {
                    stubY = ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                }
            }
            Collections.sort(this.connections, new SortConnections(horizontal));
            List<SerializablePortInst> reducedConnections = this.connections;
            while (reducedConnections.size() > 1) {
                ArrayList<SerializablePortInst> newConnections = new ArrayList<SerializablePortInst>();
                for (int i = 0; i < reducedConnections.size() - 1; i += 2) {
                    SubTree subST;
                    SerializablePortInst sToLenghten;
                    double separation;
                    SerializablePortInst s1 = reducedConnections.get(i);
                    SerializablePortInst s2 = reducedConnections.get(i + 1);
                    PortInst pi1 = s1.getPortInst();
                    PortInst pi2 = s2.getPortInst();
                    EPoint p1 = pi1.getCenter();
                    EPoint p2 = pi2.getCenter();
                    double cX1 = p1.getX() + stubX;
                    double cY1 = p1.getY() + stubY;
                    double dist1 = s1.distanceTraversed + Math.abs(stubX) + Math.abs(stubY);
                    double cX2 = p2.getX() + stubX;
                    double cY2 = p2.getY() + stubY;
                    double dist2 = s2.distanceTraversed + Math.abs(stubX) + Math.abs(stubY);
                    if (horizontal) {
                        if (cY1 != cY2) {
                            if (this.outEdge == 3) {
                                if (cY1 < cY2) {
                                    dist1 += cY2 - cY1;
                                    cY1 = cY2;
                                } else {
                                    dist2 += cY1 - cY2;
                                    cY2 = cY1;
                                }
                            } else if (cY2 < cY1) {
                                dist1 += cY1 - cY2;
                                cY1 = cY2;
                            } else {
                                dist2 += cY2 - cY1;
                                cY2 = cY1;
                            }
                        }
                    } else if (cX1 != cX2) {
                        if (this.outEdge == 0) {
                            if (cX1 < cX2) {
                                dist1 += cX2 - cX1;
                                cX1 = cX2;
                            } else {
                                dist2 += cX1 - cX2;
                                cX2 = cX1;
                            }
                        } else if (cX2 < cX1) {
                            dist1 += cX1 - cX2;
                            cX1 = cX2;
                        } else {
                            dist2 += cX2 - cX1;
                            cX2 = cX1;
                        }
                    }
                    EPoint bend1 = EPoint.fromLambda(cX1, cY1);
                    EPoint bend2 = EPoint.fromLambda(cX2, cY2);
                    MakePoint mp1 = new MakePoint(ClockRouter.this.cornerContact, bend1, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mp1);
                    MakePoint mp1a = new MakePoint(s1);
                    this.allConnections.add(new MakeConnection(mp1, mp1a));
                    MakePoint mp2 = new MakePoint(ClockRouter.this.cornerContact, bend2, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mp2);
                    MakePoint mp2a = new MakePoint(s2);
                    this.allConnections.add(new MakeConnection(mp2, mp2a));
                    double pinX = 0.0;
                    double pinY = 0.0;
                    double lengthDifference = Math.abs(dist1 - dist2);
                    if (horizontal) {
                        pinY = cY1;
                        separation = Math.abs(cX1 - cX2);
                        if (lengthDifference <= separation) {
                            pinX = (cX1 + cX2) / 2.0;
                            pinX = cX1 > cX2 ? (pinX -= (dist1 - dist2) / 2.0) : (pinX -= (dist1 - dist2) / 2.0);
                        } else {
                            SerializablePortInst serializablePortInst = sToLenghten = dist1 < dist2 ? s1 : s2;
                            if (sToLenghten.subTreeName != null) {
                                subST = ClockRouter.this.findSubTree(sToLenghten.subTreeName);
                                if (subST != null) {
                                    SerializablePortInst newSPI = subST.addSerpentineAmount(lengthDifference);
                                    for (int j = 0; j < this.connections.size(); ++j) {
                                        if (this.connections.get(j) != sToLenghten) continue;
                                        this.connections.set(j, newSPI);
                                    }
                                    for (MakePoint mp : this.allPoints) {
                                        mp.ni.kill();
                                    }
                                    return false;
                                }
                                System.out.println("HORIZONTAL SUBTREE " + this.treeName + " NEEDS TO MAKE " + sToLenghten.subTreeName + " SERPENTINE BY " + lengthDifference + " WHICH DOESN'T FIT IN " + separation);
                            }
                        }
                    } else {
                        pinX = cX1;
                        separation = Math.abs(cY1 - cY2);
                        if (lengthDifference <= separation) {
                            pinY = (cY1 + cY2) / 2.0;
                            pinY = cY1 > cY2 ? (pinY -= (dist1 - dist2) / 2.0) : (pinY -= (dist1 - dist2) / 2.0);
                        } else {
                            SerializablePortInst serializablePortInst = sToLenghten = dist1 < dist2 ? s1 : s2;
                            if (sToLenghten.subTreeName != null) {
                                subST = ClockRouter.this.findSubTree(sToLenghten.subTreeName);
                                if (subST != null) {
                                    SerializablePortInst newSPI = subST.addSerpentineAmount(lengthDifference);
                                    for (int j = 0; j < this.connections.size(); ++j) {
                                        if (this.connections.get(j) != sToLenghten) continue;
                                        this.connections.set(j, newSPI);
                                    }
                                    for (MakePoint mp : this.allPoints) {
                                        mp.ni.kill();
                                    }
                                    return false;
                                }
                                System.out.println("VERTICAL SUBTREE " + this.treeName + " NEEDS TO MAKE " + sToLenghten.subTreeName + " SERPENTINE BY " + lengthDifference + " WHICH DOESN'T FIT IN " + separation);
                            }
                        }
                    }
                    EPoint pinLoc = EPoint.fromLambda(pinX, pinY);
                    if (dist1 + pinLoc.distance(bend1) != dist2 + pinLoc.distance(bend2)) {
                        System.out.println("HEY!!! " + dist1 + " + " + pinLoc.distance(bend1) + " NOT EQUAL TO " + dist2 + " + " + pinLoc.distance(bend2));
                    }
                    MakePoint mpPin = new MakePoint(ClockRouter.this.cornerContact, pinLoc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mpPin);
                    this.allConnections.add(new MakeConnection(mp1, mpPin));
                    this.allConnections.add(new MakeConnection(mp2, mpPin));
                    SerializablePortInst spiPin = new SerializablePortInst(mpPin.ni.getOnlyPortInst());
                    spiPin.distanceTraversed = dist1 + pinLoc.distance(bend1);
                    newConnections.add(spiPin);
                }
                if ((reducedConnections.size() & 1) != 0) {
                    newConnections.add(reducedConnections.get(reducedConnections.size() - 1));
                }
                reducedConnections = newConnections;
            }
            SerializablePortInst sTop = reducedConnections.get(0);
            PortInst piTop = sTop.getPortInst();
            EPoint pTop = piTop.getCenter();
            double outLocX = 0.0;
            double outLocY = 0.0;
            boolean outHorizontal = false;
            switch (this.inEdge) {
                case 0: {
                    outLocX = !horizontal ? pTop.getX() - ClockRouter.this.getStubLength(ClockRouter.this.horizArc) : lXChan;
                    outLocY = pTop.getY();
                    break;
                }
                case 1: {
                    outLocX = !horizontal ? pTop.getX() + ClockRouter.this.getStubLength(ClockRouter.this.horizArc) : hXChan;
                    outLocY = pTop.getY();
                    break;
                }
                case 2: {
                    outLocX = pTop.getX();
                    outLocY = horizontal ? pTop.getY() + ClockRouter.this.getStubLength(ClockRouter.this.vertArc) : hYChan;
                    outHorizontal = true;
                    break;
                }
                case 3: {
                    outLocX = pTop.getX();
                    outLocY = horizontal ? pTop.getY() - ClockRouter.this.getStubLength(ClockRouter.this.vertArc) : lYChan;
                    outHorizontal = true;
                }
            }
            MakePoint mpTop = new MakePoint(sTop);
            if (outHorizontal != horizontal) {
                EPoint pTopShift = EPoint.fromLambda(pTop.getX() + stubX, pTop.getY() + stubY);
                MakePoint mp = new MakePoint(ClockRouter.this.cornerContact, pTopShift, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                this.allPoints.add(mp);
                this.allConnections.add(new MakeConnection(mp, mpTop));
                outLocX += stubX;
                outLocY += stubY;
                sTop.distanceTraversed += Math.abs(stubX) + Math.abs(stubY);
                pTop = pTopShift;
                mpTop = mp;
            }
            EPoint finalPt = EPoint.fromLambda(outLocX, outLocY);
            PrimitiveNode stubNP = outHorizontal ? ClockRouter.this.vertArc.findPinProto() : ClockRouter.this.horizArc.findPinProto();
            MakePoint mp = new MakePoint(stubNP, finalPt, stubNP.getDefWidth(ClockRouter.this.ep), stubNP.getDefHeight(ClockRouter.this.ep), ClockRouter.this.ep, ClockRouter.this.cell);
            this.allPoints.add(mp);
            this.allConnections.add(new MakeConnection(mp, mpTop));
            this.output = new SerializablePortInst(mp.ni.getOnlyPortInst());
            this.output.distanceTraversed = sTop.distanceTraversed + finalPt.distance(pTop);
            this.output.subTreeName = this.treeName;
            return true;
        }

        public SerializablePortInst addSerpentineAmount(double amount) {
            double jogX = 0.0;
            double jogY = 0.0;
            switch (this.outEdge) {
                case 0: {
                    jogX = ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 1: {
                    jogX = -ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 2: {
                    jogY = -ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                    break;
                }
                case 3: {
                    jogY = ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                }
            }
            double awaydist = (amount - (jogX + jogY) * 2.0) / 2.0;
            double awayX = 0.0;
            double awayY = 0.0;
            switch (this.inEdge) {
                case 0: {
                    awayX = awaydist;
                    break;
                }
                case 1: {
                    awayX = -awaydist;
                    break;
                }
                case 2: {
                    awayY = -awaydist;
                    break;
                }
                case 3: {
                    awayY = awaydist;
                }
            }
            EPoint outLoc = this.output.getPortInst().getCenter();
            EPoint pin1Loc = EPoint.fromLambda(outLoc.getX() + jogX, outLoc.getY() + jogY);
            EPoint pin2Loc = EPoint.fromLambda(outLoc.getX() + jogX + awayX, outLoc.getY() + jogY + awayY);
            EPoint pin3Loc = EPoint.fromLambda(outLoc.getX() + jogX * 2.0 + awayX, outLoc.getY() + jogY * 2.0 + awayY);
            EPoint pin4Loc = EPoint.fromLambda(outLoc.getX() + jogX * 2.0, outLoc.getY() + jogY * 2.0);
            MakePoint mpOut = new MakePoint(this.output);
            Point2D mpSize = ClockRouter.this.getContactSize(ClockRouter.this.cornerContact, ClockRouter.this.horizArc, ClockRouter.this.horizArcWidth, ClockRouter.this.vertArc, ClockRouter.this.vertArcWidth);
            MakePoint mp1 = new MakePoint(ClockRouter.this.cornerContact, pin1Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp2 = new MakePoint(ClockRouter.this.cornerContact, pin2Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp3 = new MakePoint(ClockRouter.this.cornerContact, pin3Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp4 = new MakePoint(ClockRouter.this.cornerContact, pin4Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            this.allPoints.add(mp1);
            this.allPoints.add(mp2);
            this.allPoints.add(mp3);
            this.allPoints.add(mp4);
            this.allConnections.add(new MakeConnection(mpOut, mp1));
            this.allConnections.add(new MakeConnection(mp1, mp2));
            this.allConnections.add(new MakeConnection(mp2, mp3));
            this.allConnections.add(new MakeConnection(mp3, mp4));
            SerializablePortInst newOutput = new SerializablePortInst(mp4.ni.getOnlyPortInst());
            newOutput.distanceTraversed = this.output.distanceTraversed + amount;
            this.output = newOutput;
            return this.output;
        }
    }

    private class RoutePath {
        List<MakeConnection> path = new ArrayList<MakeConnection>();
        RoutePath next1;
        RoutePath next2;

        private RoutePath(List<MakeConnection> initialConnections, EPoint startPt, MakeConnection startMC, int treeDepth) {
            if (startMC != null) {
                startMC.treeDepth = treeDepth;
                this.path.add(startMC);
            }
            ArrayList<MakeConnection> everyConnection = new ArrayList<MakeConnection>();
            for (MakeConnection mc : initialConnections) {
                everyConnection.add(mc);
            }
            while (true) {
                MakeConnection mc1 = null;
                MakeConnection mc2 = null;
                for (MakeConnection mc : everyConnection) {
                    if (!mc.from.loc.equals(startPt) && !mc.to.loc.equals(startPt)) continue;
                    if (mc1 == null) {
                        mc1 = mc;
                        continue;
                    }
                    mc2 = mc;
                }
                if (mc1 == null) break;
                if (mc2 == null) {
                    if (mc1.to.loc.equals(startPt)) {
                        mc1.swapEnds();
                    }
                    startPt = mc1.to.loc;
                    this.path.add(mc1);
                    mc1.treeDepth = treeDepth;
                    everyConnection.remove(mc1);
                    continue;
                }
                if (mc1.to.loc.equals(startPt)) {
                    mc1.swapEnds();
                }
                EPoint nextPt = mc1.to.loc;
                everyConnection.remove(mc1);
                this.next1 = new RoutePath(everyConnection, nextPt, mc1, treeDepth + 1);
                if (mc2.to.loc.equals(startPt)) {
                    mc2.swapEnds();
                }
                nextPt = mc2.to.loc;
                everyConnection.remove(mc2);
                this.next2 = new RoutePath(everyConnection, nextPt, mc2, treeDepth + 1);
            }
        }

        private void addRepeaters(List<MakeConnection> everyConnection, double distToRepeater, List<MakePoint> everyPoint, Map<Integer, MutableInteger> levelCount) {
            for (int i = 0; i < this.path.size(); ++i) {
                MakeConnection mc = this.path.get(i);
                double dist = mc.from.loc.distance(mc.to.loc);
                if (dist >= distToRepeater) {
                    Comparable<PrimitiveNode> np;
                    boolean validRepeater;
                    double sign2;
                    double repeatLocX = mc.from.loc.getX();
                    double repeatLocY = mc.from.loc.getY();
                    if (mc.from.loc.getX() == mc.to.loc.getX()) {
                        sign2 = 1.0;
                        if (mc.from.loc.getY() > mc.to.loc.getY()) {
                            sign2 = -1.0;
                        }
                        repeatLocY = mc.from.loc.getY() + distToRepeater * sign2;
                    } else if (mc.from.loc.getY() == mc.to.loc.getY()) {
                        sign2 = 1.0;
                        if (mc.from.loc.getX() > mc.to.loc.getX()) {
                            sign2 = -1.0;
                        }
                        repeatLocX = mc.from.loc.getX() + distToRepeater * sign2;
                    } else {
                        double angle = DBMath.figureAngleRadians(mc.from.loc, mc.to.loc);
                        repeatLocX = mc.from.loc.getX() + distToRepeater * Math.cos(angle);
                        repeatLocY = mc.from.loc.getY() + distToRepeater * Math.sin(angle);
                        System.out.println("ANGLE FROM (" + mc.from.loc.getX() + "," + mc.from.loc.getY() + ") TO (" + mc.to.loc.getX() + "," + mc.to.loc.getY() + ") IS " + angle + " SO " + distToRepeater + " ALONG THAT PATH IS (" + repeatLocX + "," + repeatLocY + ")");
                    }
                    boolean bl = validRepeater = ClockRouter.this.repeaterCell != null;
                    if (validRepeater) {
                        np = ClockRouter.this.repeaterCell;
                        AlignRepeater ap = new AlignRepeater(repeatLocX, repeatLocY);
                        EPoint pt = ap.getLocation();
                        double wid = np.getDefWidth(ClockRouter.this.ep);
                        double hei = np.getDefHeight(ClockRouter.this.ep);
                        ERectangle cellBound = ClockRouter.this.repeaterCell.getBounds();
                        double shiftX = cellBound.getMinX();
                        double shiftY = cellBound.getMinY();
                        pt = EPoint.fromLambda(pt.getX() - shiftX, pt.getY() - shiftY);
                        Orientation orient = ap.getOrientation();
                        Integer key = mc.treeDepth;
                        MutableInteger levelIndex = levelCount.get(key);
                        if (levelIndex == null) {
                            levelIndex = new MutableInteger(0);
                            levelCount.put(key, levelIndex);
                        }
                        levelIndex.increment();
                        String instName = ClockRouter.this.repeaterInstancePrefix + "_L" + mc.treeDepth + "I" + levelIndex.intValue();
                        String netName = ClockRouter.this.repeaterNetworkPrefix + "_L" + mc.treeDepth + "I" + levelIndex.intValue() + "_OUT";
                        MakePoint mp = new MakePoint((NodeProto)((Object)np), pt, wid, hei, orient, instName, ClockRouter.this.ep, ClockRouter.this.cell);
                        ERectangle placed = mp.ni.getBounds();
                        everyPoint.add(mp);
                        PortInst piIn = mp.ni.findPortInstFromProto(ClockRouter.this.repeaterIn);
                        PortInst piOut = mp.ni.findPortInstFromProto(ClockRouter.this.repeaterOut);
                        EPoint inCtr = piIn.getCenter();
                        EPoint outCtr = piOut.getCenter();
                        MakePoint mpRepeaterIn = new MakePoint(new SerializablePortInst(piIn));
                        MakePoint mpRepeaterOut = new MakePoint(new SerializablePortInst(piOut));
                        double fromEndX = mc.from.loc.getX();
                        double fromEndY = mc.from.loc.getY();
                        double toEndX = mc.from.loc.getX();
                        double toEndY = mc.from.loc.getY();
                        if (mc.from.loc.getX() == mc.to.loc.getX()) {
                            if (mc.from.loc.getY() < pt.getY()) {
                                fromEndY = placed.getMinY();
                                toEndY = placed.getMaxY();
                            } else {
                                fromEndY = placed.getMaxY();
                                toEndY = placed.getMinY();
                            }
                        } else if (mc.from.loc.getY() == mc.to.loc.getY()) {
                            if (mc.from.loc.getX() < pt.getX()) {
                                fromEndX = placed.getMinX();
                                toEndX = placed.getMaxX();
                            } else {
                                fromEndX = placed.getMaxX();
                                toEndX = placed.getMinX();
                            }
                        }
                        double fromBendX = fromEndX;
                        double fromBendY = fromEndY;
                        double toBendX = toEndX;
                        double toBendY = toEndY;
                        if (mc.from.loc.getX() == mc.to.loc.getX()) {
                            fromBendX = inCtr.getX();
                            toBendX = outCtr.getX();
                        } else if (mc.from.loc.getY() == mc.to.loc.getY()) {
                            fromBendY = inCtr.getY();
                            toBendY = outCtr.getY();
                        }
                        ArcProto conAP = mc.ap;
                        double conWidth = mc.width;
                        if (ClockRouter.this.repeaterArc != null) {
                            conAP = ClockRouter.this.repeaterArc;
                            conWidth = ClockRouter.this.repeaterArcWidth;
                        }
                        np = conAP.findPinProto();
                        wid = np.getDefWidth(ClockRouter.this.ep);
                        hei = np.getDefHeight(ClockRouter.this.ep);
                        MakePoint mpIn = new MakePoint((NodeProto)((Object)np), EPoint.fromLambda(fromEndX, fromEndY), wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                        everyPoint.add(mpIn);
                        MakePoint mpOut = new MakePoint((NodeProto)((Object)np), EPoint.fromLambda(toEndX, toEndY), wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                        everyPoint.add(mpOut);
                        MakePoint mpBendIn = new MakePoint((NodeProto)((Object)np), EPoint.fromLambda(fromBendX, fromBendY), wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                        everyPoint.add(mpBendIn);
                        MakePoint mpBendOut = new MakePoint((NodeProto)((Object)np), EPoint.fromLambda(toBendX, toBendY), wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                        everyPoint.add(mpBendOut);
                        MakeConnection mcIn = new MakeConnection(mc.from, mpIn);
                        MakeConnection mcOut = new MakeConnection(mpOut, mc.to);
                        mcIn.treeDepth = mc.treeDepth;
                        mcOut.treeDepth = mc.treeDepth;
                        everyConnection.add(mcIn);
                        everyConnection.add(mcOut);
                        MakeConnection mcBendIn = new MakeConnection(mpIn, mpBendIn);
                        mcBendIn.ap = conAP;
                        mcBendIn.width = conWidth;
                        mcBendIn.treeDepth = mc.treeDepth;
                        MakeConnection mcBendOut = new MakeConnection(mpBendOut, mpOut);
                        mcBendOut.ap = conAP;
                        mcBendOut.width = conWidth;
                        mcBendOut.treeDepth = mc.treeDepth;
                        everyConnection.add(mcBendIn);
                        everyConnection.add(mcBendOut);
                        MakeConnection mcRepIn = new MakeConnection(mpBendIn, mpRepeaterIn);
                        mcRepIn.ap = conAP;
                        mcRepIn.width = conWidth;
                        mcRepIn.treeDepth = mc.treeDepth;
                        MakeConnection mcRepOut = new MakeConnection(mpRepeaterOut, mpBendOut);
                        mcRepOut.ap = conAP;
                        mcRepOut.width = conWidth;
                        mcRepOut.treeDepth = mc.treeDepth;
                        mcRepOut.netName = netName;
                        everyConnection.add(mcRepIn);
                        everyConnection.add(mcRepOut);
                        everyConnection.remove(mc);
                        this.path.set(i, mcIn);
                        this.path.add(i + 1, mcOut);
                        distToRepeater = ClockRouter.this.repeaterDistance;
                        continue;
                    }
                    np = Generic.tech().drcNode;
                    double wid = np.getDefWidth(ClockRouter.this.ep) * 50.0;
                    double hei = np.getDefHeight(ClockRouter.this.ep) * 50.0;
                    EPoint pt = EPoint.fromLambda(repeatLocX, repeatLocY);
                    MakePoint mp = new MakePoint((NodeProto)((Object)np), pt, wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                    everyPoint.add(mp);
                    np = mc.ap.findPinProto();
                    wid = np.getDefWidth(ClockRouter.this.ep);
                    hei = np.getDefHeight(ClockRouter.this.ep);
                    mp = new MakePoint((NodeProto)((Object)np), pt, wid, hei, ClockRouter.this.ep, ClockRouter.this.cell);
                    everyPoint.add(mp);
                    MakeConnection mcIn = new MakeConnection(mc.from, mp);
                    MakeConnection mcOut = new MakeConnection(mp, mc.to);
                    mcIn.treeDepth = mc.treeDepth;
                    mcOut.treeDepth = mc.treeDepth;
                    everyConnection.remove(mc);
                    everyConnection.add(mcIn);
                    everyConnection.add(mcOut);
                    this.path.set(i, mcIn);
                    this.path.add(i + 1, mcOut);
                    distToRepeater = ClockRouter.this.repeaterDistance;
                    continue;
                }
                distToRepeater -= dist;
            }
            if (this.next1 != null) {
                this.next1.addRepeaters(everyConnection, distToRepeater, everyPoint, levelCount);
            }
            if (this.next2 != null) {
                this.next2.addRepeaters(everyConnection, distToRepeater, everyPoint, levelCount);
            }
        }
    }

    private class AlignRepeater {
        EPoint loc;
        Orientation orient;

        public AlignRepeater(double x2, double y) {
            RowSpec closest = null;
            double bestDist = Double.MAX_VALUE;
            for (RowSpec rs : ClockRouter.this.repeaterRows) {
                double dist = Math.abs(x2 - rs.origX) + Math.abs(y - rs.origY);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
                closest = rs;
            }
            this.orient = Orientation.IDENT;
            if (closest != null) {
                this.orient = closest.orient;
                if (closest.repeatX == 1) {
                    x2 = closest.origX;
                    long repeatFactor = Math.round((y - closest.origY) / closest.stepY);
                    if (repeatFactor < 0L) {
                        repeatFactor = 0L;
                    }
                    if (repeatFactor > (long)closest.repeatY) {
                        repeatFactor = closest.repeatY;
                    }
                    y = (double)repeatFactor * closest.stepY + closest.origY;
                } else {
                    long repeatFactor = Math.round((x2 - closest.origX) / closest.stepX);
                    if (repeatFactor < 0L) {
                        repeatFactor = 0L;
                    }
                    if (repeatFactor > (long)closest.repeatX) {
                        repeatFactor = closest.repeatX;
                    }
                    x2 = (double)repeatFactor * closest.stepX + closest.origX;
                    y = closest.origY;
                }
            }
            this.loc = EPoint.fromLambda(x2, y);
        }

        public EPoint getLocation() {
            return this.loc;
        }

        public Orientation getOrientation() {
            return this.orient;
        }
    }

    private class RowSpec {
        double origX;
        double origY;
        int repeatX;
        int repeatY;
        double stepX = 1.0;
        double stepY = 1.0;
        Orientation orient;

        RowSpec() {
        }
    }

    private static class ClockTreeRouteJob
    extends Job {
        private List<NeededHTree> treesToRoute;
        private String fileName;
        private Cell cell;

        protected ClockTreeRouteJob(List<NeededHTree> treesToRoute, String fileName, Cell cell) {
            super("Clock-Tree Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.treesToRoute = treesToRoute;
            this.fileName = fileName;
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ClockRouter router = new ClockRouter(this.getEditingPreferences(), this.cell);
            for (NeededHTree nht : this.treesToRoute) {
                boolean good = router.routeAlgorithm2(nht, this.fileName, this.cell);
                if (!good) continue;
                for (ArcInst ai : nht.originalArcs) {
                    ai.kill();
                }
            }
            return true;
        }
    }

    private static class SerializablePortInst
    implements Serializable {
        NodeInst ni;
        String portName;
        double distanceTraversed;
        String subTreeName;

        public SerializablePortInst(PortInst pi) {
            this.ni = pi.getNodeInst();
            this.portName = pi.getPortProto().getName();
            this.distanceTraversed = 0.0;
            this.subTreeName = null;
        }

        public PortProto getPortProto() {
            return this.ni.getProto().findPortProto(this.portName);
        }

        public PortInst getPortInst() {
            return this.ni.findPortInstFromProto(this.getPortProto());
        }

        public boolean equals(SerializablePortInst spi) {
            return this.ni == spi.ni && this.portName.equals(spi.portName);
        }
    }

    private static class NeededHTree
    implements Serializable {
        SerializablePortInst source = null;
        List<SerializablePortInst> destinations = new ArrayList<SerializablePortInst>();
        List<ArcInst> originalArcs = new ArrayList<ArcInst>();

        public void addDestination(SerializablePortInst spi) {
            for (SerializablePortInst spiTest : this.destinations) {
                if (!spiTest.equals(spi)) continue;
                return;
            }
            this.destinations.add(spi);
        }
    }
}

