/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class SeaOfGates {
    public static void seaOfGatesRoute(boolean justSubCells) {
        if (justSubCells) {
            UserInterface ui = Job.getUserInterface();
            Cell cell = ui.needCurrentCell();
            if (cell == null) {
                return;
            }
            HashSet<Cell> subCells = new HashSet<Cell>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                subCells.add((Cell)ni.getProto());
            }
            for (Cell subCell : subCells) {
                ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
                Iterator<ArcInst> it2 = subCell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai = it2.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    selected.add(ai);
                }
                if (selected.isEmpty()) continue;
                SeaOfGatesHandlers.startInJob(subCell, selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            }
        } else {
            SeaOfGates.seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        }
    }

    public static void seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected == null) {
            return;
        }
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        SeaOfGatesHandlers.startInJob(cell, selected, version);
    }

    public static void seaOfGatesRoute(EditingPreferences ep, SeaOfGatesEngine router) {
        if (router == null) {
            throw new NullPointerException();
        }
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        Job job = Job.getRunningJob();
        router.routeIt(SeaOfGatesHandlers.getDefault(cell, router.getPrefs().resultCellName, router.getPrefs().contactPlacementAction, job, ep), cell, false, selected);
    }

    private static List<ArcInst> getSelected() {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return null;
        }
        ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
        List<Geometric> highlighted = wnd.getHighlightedEObjs(false, true);
        for (Geometric h : highlighted) {
            ArcInst ai = (ArcInst)h;
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            selected.add(ai);
        }
        if (selected.isEmpty()) {
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                selected.add(ai);
            }
        }
        return selected;
    }

    public static class SeaOfGatesCellParameters
    implements Serializable {
        private Cell cell;
        private boolean steinerDone;
        private boolean canPlaceContactDownToAvoidedLayer;
        private boolean canPlaceContactUpToAvoidedLayer;
        private boolean forceHorVer;
        private boolean favorHorVer;
        private boolean horEven;
        private boolean canRotateContacts;
        private Map<ArcProto, String> gridSpacing;
        private Map<ArcProto, String> removeLayers;
        private Set<ArcProto> preventedArcs;
        private Set<ArcProto> favoredArcs;
        private Set<ArcProto> taperOnlyArcs;
        private Set<ArcProto> forceGridArcs;
        private Map<ArcProto, SeaOfGatesArcProperties> overrides;
        private List<String> netsToRoute;
        private Map<String, List<ArcProto>> netsAndArcsToRoute;
        private Map<String, Map<ArcProto, SeaOfGatesArcProperties>> netAndArcOverrides;
        private List<SeaOfGatesExtraBlockage> extraBlockages;
        private String ignorePrimitives;
        private String acceptOnly1XPrimitives;
        private String acceptOnly2XPrimitives;
        private String routingBoundsLayerName;
        private static final Variable.Key ROUTING_SOG_PARAMETERS_KEY = Variable.newKey("ATTR_ROUTING_SOG_PARAMETERS");

        public void clear() {
            this.steinerDone = false;
            this.canPlaceContactDownToAvoidedLayer = true;
            this.canPlaceContactUpToAvoidedLayer = true;
            this.forceHorVer = false;
            this.favorHorVer = true;
            this.horEven = false;
            this.canRotateContacts = true;
            this.gridSpacing = new HashMap<ArcProto, String>();
            this.removeLayers = new HashMap<ArcProto, String>();
            this.preventedArcs = new HashSet<ArcProto>();
            this.favoredArcs = new HashSet<ArcProto>();
            this.forceGridArcs = new HashSet<ArcProto>();
            this.taperOnlyArcs = new HashSet<ArcProto>();
            this.overrides = new HashMap<ArcProto, SeaOfGatesArcProperties>();
            this.netsToRoute = new ArrayList<String>();
            this.netsAndArcsToRoute = new TreeMap<String, List<ArcProto>>();
            this.netAndArcOverrides = new HashMap<String, Map<ArcProto, SeaOfGatesArcProperties>>();
            this.extraBlockages = new ArrayList<SeaOfGatesExtraBlockage>();
            this.ignorePrimitives = null;
            this.acceptOnly1XPrimitives = null;
            this.acceptOnly2XPrimitives = null;
            this.routingBoundsLayerName = null;
        }

        public SeaOfGatesCellParameters(Cell cell) {
            this.cell = cell;
            this.clear();
            Variable var = cell.getVar(ROUTING_SOG_PARAMETERS_KEY);
            if (var != null) {
                String[] lines2 = (String[])var.getObject();
                for (int i = 0; i < lines2.length; ++i) {
                    String[] parts = lines2[i].split(" ");
                    if (parts.length <= 0 || parts[0].startsWith(";")) continue;
                    if (parts[0].equalsIgnoreCase("SteinerTreesDone")) {
                        this.steinerDone = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("PreventContactDownToAvoidedLayer")) {
                        this.canPlaceContactDownToAvoidedLayer = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("PreventContactUpToAvoidedLayer")) {
                        this.canPlaceContactUpToAvoidedLayer = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("NoContactRotation")) {
                        this.canRotateContacts = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Accept1XContacts")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.acceptOnly1XPrimitives = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Accept2XContacts")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.acceptOnly2XPrimitives = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("RoutingBoundsLayerName")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.routingBoundsLayerName = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("IgnoreContacts")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.ignorePrimitives = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ForceHorVer")) {
                        this.forceHorVer = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("IgnoreHorVer")) {
                        this.favorHorVer = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalEven")) {
                        this.horEven = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcGrid") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.gridSpacing.put(ap, parts[2]);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcAvoid") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.preventedArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcFavor") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.favoredArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcGridForce") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.forceGridArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcTaperOnly") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.taperOnlyArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcWidthOverride") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setWidthOverride(TextUtils.atof(parts[2]));
                        continue;
                    }
                    if (parts[0].toLowerCase().startsWith("arcspacingoverride") && parts.length >= 3) {
                        int axis = parts[0].substring(parts[0].length() - 1).equals("X") ? 0 : 1;
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setSpacingOverride(TextUtils.atof(parts[2]), axis);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("WidthOf2X") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setWidthOf2X(TextUtils.atof(parts[2]));
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("TaperTo1X") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setTaperTo1X(TextUtils.atof(parts[2]));
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("RemoveLayer") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.removeLayers.put(ap, parts[2]);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Blockage") && parts.length >= 6) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        double x1 = TextUtils.atof(parts[2]);
                        double y1 = TextUtils.atof(parts[3]);
                        double x2 = TextUtils.atof(parts[4]);
                        double y2 = TextUtils.atof(parts[5]);
                        SeaOfGatesExtraBlockage sogeb = new SeaOfGatesExtraBlockage(x1, y1, x2, y2, ap);
                        this.extraBlockages.add(sogeb);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Network") && parts.length >= 2) {
                        String netName = parts[1];
                        List<ArcProto> arcs = this.netsAndArcsToRoute.get(netName);
                        if (arcs == null) {
                            arcs = new ArrayList<ArcProto>();
                            this.netsAndArcsToRoute.put(netName, arcs);
                        }
                        this.netsToRoute.add(netName);
                        for (int p = 2; p < parts.length; ++p) {
                            ArcProto ap = this.parseArcName(parts[p]);
                            arcs.add(ap);
                        }
                        continue;
                    }
                    if (!parts[0].equalsIgnoreCase("NetworkOverride") || parts.length < 2) continue;
                    String netName = parts[1];
                    Map<ArcProto, SeaOfGatesArcProperties> arcs = this.netAndArcOverrides.get(netName);
                    if (arcs == null) {
                        arcs = new HashMap<ArcProto, SeaOfGatesArcProperties>();
                        this.netAndArcOverrides.put(netName, arcs);
                    }
                    SeaOfGatesArcProperties curOverrides = null;
                    for (int p = 2; p < parts.length; ++p) {
                        if (parts[p].startsWith("W=")) {
                            if (curOverrides == null) continue;
                            curOverrides.setWidthOverride(TextUtils.atof(parts[p].substring(2)));
                            continue;
                        }
                        if (parts[p].startsWith("S=")) {
                            if (curOverrides == null) continue;
                            curOverrides.setSpacingOverride(TextUtils.atof(parts[p].substring(2)), 0);
                            curOverrides.setSpacingOverride(TextUtils.atof(parts[p].substring(2)), 1);
                            continue;
                        }
                        ArcProto ap = this.parseArcName(parts[p]);
                        curOverrides = arcs.get(ap);
                        if (curOverrides != null) continue;
                        curOverrides = new SeaOfGatesArcProperties();
                        arcs.put(ap, curOverrides);
                    }
                }
            }
        }

        public void importData(String fileName, Cell cell, Technology curTech) {
            URL url = TextUtils.makeURLToFile(fileName);
            try {
                String buf;
                URLConnection urlCon = url.openConnection();
                InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
                LineNumberReader lineReader = new LineNumberReader(is);
                this.clear();
                ArrayList<ArcProto> layersToOverride = new ArrayList<ArcProto>();
                HashMap<ArcProto, Double> widthsToOverride = new HashMap<ArcProto, Double>();
                HashMap<ArcProto, Double> spacingsToOverride = new HashMap<ArcProto, Double>();
                boolean figuredOutAlternation = false;
                this.forceHorVer = true;
                this.canRotateContacts = false;
                this.canPlaceContactDownToAvoidedLayer = false;
                this.canPlaceContactUpToAvoidedLayer = false;
                ArrayList<ArcProto> arcDefList = new ArrayList<ArcProto>();
                ArrayList tmpList = new ArrayList(3);
                String[] extraLayers = new String[]{"", "_MASK_1", "_MASK_2"};
                HashMap trackLines = new HashMap();
                while ((buf = lineReader.readLine()) != null) {
                    double v;
                    if (buf.length() == 0 || buf.startsWith(";")) continue;
                    ArrayList<String> slist = new ArrayList<String>();
                    StringTokenizer p = new StringTokenizer(buf, " ", false);
                    while (p.hasMoreTokens()) {
                        slist.add(p.nextToken());
                    }
                    String[] parts = slist.toArray(new String[slist.size()]);
                    if (parts.length <= 0 || parts[0].equalsIgnoreCase("Project") || parts[0].equalsIgnoreCase("Library") || parts[0].equalsIgnoreCase("View") || parts[0].equalsIgnoreCase("PowerNets")) continue;
                    if (parts[0].equalsIgnoreCase("Cell")) {
                        if (this.getCell().getName().equals(parts[1])) continue;
                        System.out.println("WARNING: Cell name " + parts[1] + " on line " + lineReader.getLineNumber() + " doesn't match current cell (" + this.getCell().describe(false) + ")");
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("RoutingBoundsLayer")) {
                        assert (parts.length > 1);
                        this.routingBoundsLayerName = parts[1];
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalEven")) {
                        this.horEven = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("AllowViaDown")) {
                        this.canPlaceContactDownToAvoidedLayer = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("AllowViaUp")) {
                        this.canPlaceContactUpToAvoidedLayer = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ContactInclusion")) {
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            this.acceptOnly1XPrimitives = parts[1];
                            continue;
                        }
                        System.out.println("WARNING: no regular expression for ContactInclusion on line " + lineReader.getLineNumber());
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ContactInclusion2X")) {
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            this.acceptOnly2XPrimitives = parts[1];
                            continue;
                        }
                        System.out.println("WARNING: no regular expression for ContactInclusion2x on line " + lineReader.getLineNumber());
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalMetals")) {
                        assert (parts.length > 1);
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        for (ArcProto ap : apList) {
                            int level = ap.getFunction().getLevel();
                            this.horEven = level % 2 == 0;
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("VerticalMetals")) {
                        assert (parts.length > 1);
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        for (ArcProto ap : apList) {
                            int level = ap.getFunction().getLevel();
                            this.horEven = level % 2 != 0;
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("DefaultRouteMetals")) {
                        HashSet<ArcProto> allowed = new HashSet<ArcProto>();
                        for (int i = 1; i < parts.length; ++i) {
                            List<ArcProto> apList = this.getArcProtoList(parts[i], lineReader.getLineNumber(), curTech, extraLayers);
                            allowed.addAll(apList);
                        }
                        Iterator<ArcProto> it = curTech.getArcs();
                        while (it.hasNext()) {
                            ArcProto ap;
                            this.setPrevented(ap, !allowed.contains(ap = it.next()));
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("TaperOnlyMetal")) {
                        HashSet<ArcProto> allowed = new HashSet<ArcProto>();
                        for (int i = 1; i < parts.length; ++i) {
                            List<ArcProto> apList = this.getArcProtoList(parts[i], lineReader.getLineNumber(), curTech, extraLayers);
                            allowed.addAll(apList);
                        }
                        for (ArcProto ap : allowed) {
                            this.setTaperOnly(ap, true);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("DefaultMetalWS") && parts.length >= 5) {
                        tmpList.clear();
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        for (ArcProto arc : apList) {
                            if (arcDefList.contains(arc)) {
                                System.out.println("Metal width and spacing already defined for " + arc.getName() + " Skipping second definition");
                                continue;
                            }
                            arcDefList.add(arc);
                            double width = TextUtils.atof(parts[2]);
                            width = TextUtils.convertFromDistance(width, curTech, TextUtils.UnitScale.MICRO);
                            this.setDefaultWidthOverride(arc, width);
                            double spacingX = TextUtils.atof(parts[3]);
                            spacingX = TextUtils.convertFromDistance(spacingX, curTech, TextUtils.UnitScale.MICRO);
                            this.setDefaultSpacingOverride(arc, spacingX, 0);
                            double spacingY = TextUtils.atof(parts[4]);
                            spacingY = TextUtils.convertFromDistance(spacingY, curTech, TextUtils.UnitScale.MICRO);
                            this.setDefaultSpacingOverride(arc, spacingY, 1);
                            if (parts.length < 6) continue;
                            double width2X = TextUtils.atof(parts[5]);
                            width2X = TextUtils.convertFromDistance(width2X, curTech, TextUtils.UnitScale.MICRO);
                            this.set2XWidth(arc, width2X);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Taper") && parts.length >= 3) {
                        tmpList.clear();
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        for (ArcProto arc : apList) {
                            double taperLength = TextUtils.atof(parts[2]);
                            taperLength = TextUtils.convertFromDistance(taperLength, curTech, TextUtils.UnitScale.MICRO);
                            this.setTaperLength(arc, taperLength);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("CutLayer")) {
                        if (parts.length < 3) {
                            System.out.println("ERROR on line " + lineReader.getLineNumber() + ": RemoveLayer needs two parameters: <layer> <layerWhichCuts>");
                            continue;
                        }
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        int maskNum = SeaOfGatesTrack.getSpecificMaskNumber(parts[1]);
                        for (ArcProto ap : apList) {
                            if (ap.getMaskLayer() != maskNum) continue;
                            this.removeLayers.put(ap, parts[2]);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Blockage")) {
                        if (parts.length < 6) {
                            System.out.println("ERROR: invalid blockage information in line " + lineReader.getLineNumber());
                            continue;
                        }
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        if (apList.size() < 1) {
                            System.out.println("ERROR: unknown arc on line " + lineReader.getLineNumber());
                            continue;
                        }
                        ArcProto met = apList.get(0);
                        double x1 = TextUtils.atof(parts[2]);
                        x1 = TextUtils.convertFromDistance(x1, curTech, TextUtils.UnitScale.MICRO);
                        double y1 = TextUtils.atof(parts[3]);
                        y1 = TextUtils.convertFromDistance(y1, curTech, TextUtils.UnitScale.MICRO);
                        double x2 = TextUtils.atof(parts[4]);
                        x2 = TextUtils.convertFromDistance(x2, curTech, TextUtils.UnitScale.MICRO);
                        double y2 = TextUtils.atof(parts[5]);
                        y2 = TextUtils.convertFromDistance(y2, curTech, TextUtils.UnitScale.MICRO);
                        SeaOfGatesExtraBlockage sogeb = new SeaOfGatesExtraBlockage(x1, y1, x2, y2, met);
                        this.extraBlockages.add(sogeb);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Track")) {
                        if (parts.length < 6) {
                            System.out.println("ERROR: invalid track information in line " + lineReader.getLineNumber());
                            continue;
                        }
                        List<ArcProto> apList = this.getArcProtoList(parts[1], lineReader.getLineNumber(), curTech, extraLayers);
                        int maskNum = SeaOfGatesTrack.getSpecificMaskNumber(parts[1]);
                        for (ArcProto ap : apList) {
                            boolean wantHorEven;
                            int arcLevel = ap.getFunction().getLevel();
                            if (parts[2].equalsIgnoreCase("t")) {
                                wantHorEven = arcLevel % 2 == 0;
                            } else {
                                boolean bl = wantHorEven = arcLevel % 2 != 0;
                            }
                            if (figuredOutAlternation) {
                                if (wantHorEven != this.horEven) {
                                    System.out.println("Warning: Horizontal layers are " + (this.horEven ? "" : " not") + " even but metal " + parts[1] + " has horizontal set to " + parts[2]);
                                }
                            } else {
                                this.horEven = wantHorEven;
                                figuredOutAlternation = true;
                            }
                            TreeSet<SeaOfGatesTrack> gridValues = new TreeSet<SeaOfGatesTrack>();
                            String formerGrid = this.gridSpacing.get(ap);
                            if (formerGrid != null) {
                                String[] gridParts = formerGrid.split(",");
                                for (int i = 0; i < gridParts.length; ++i) {
                                    String part = gridParts[i].trim();
                                    if (part.length() == 0) continue;
                                    int trackColor = SeaOfGatesTrack.getSpecificMaskNumber(part);
                                    if (!Character.isDigit(part.charAt(part.length() - 1))) {
                                        part = part.substring(0, part.length() - 1);
                                    }
                                    double val = TextUtils.atof(part);
                                    gridValues.add(new SeaOfGatesTrack(val, trackColor));
                                }
                            }
                            ArrayList<SeaOfGatesTrack> tracksOnThisLine = new ArrayList<SeaOfGatesTrack>();
                            trackLines.put(buf, tracksOnThisLine);
                            double coord = TextUtils.atof(parts[3]);
                            coord = TextUtils.convertFromDistance(coord, curTech, TextUtils.UnitScale.MICRO);
                            double spacing = TextUtils.atof(parts[4]);
                            spacing = TextUtils.convertFromDistance(spacing, curTech, TextUtils.UnitScale.MICRO);
                            int numTracks = TextUtils.atoi(parts[5]);
                            for (int i = 0; i < numTracks; ++i) {
                                SeaOfGatesTrack sogt = new SeaOfGatesTrack(coord, maskNum);
                                tracksOnThisLine.add(sogt);
                                gridValues.add(sogt);
                                coord += spacing;
                            }
                            String newGrid = "";
                            for (SeaOfGatesTrack sogt : gridValues) {
                                if (newGrid.length() > 0) {
                                    newGrid = newGrid + ",";
                                }
                                newGrid = newGrid + TextUtils.formatDouble(sogt.coordinate);
                                if (sogt.maskNum == 0) continue;
                                newGrid = newGrid + (char)(97 + sogt.maskNum - 1);
                            }
                            this.gridSpacing.put(ap, newGrid);
                            this.forceGridArcs.add(ap);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Net")) {
                        if (parts.length < 2) {
                            System.out.println("ERROR: invalid Net information in line " + lineReader.getLineNumber());
                            continue;
                        }
                        parts[1] = parts[1].replace("<", "[").replace(">", "]");
                        this.addNetToRoute(parts[1]);
                        for (ArcProto ap : layersToOverride) {
                            this.addArcToNet(parts[1], ap);
                        }
                        for (ArcProto ap : widthsToOverride.keySet()) {
                            Double width = (Double)widthsToOverride.get(ap);
                            this.setWidthOverrideForArcOnNet(parts[1], ap, width);
                        }
                        for (ArcProto ap : spacingsToOverride.keySet()) {
                            Double spacing = (Double)spacingsToOverride.get(ap);
                            this.setSpacingOverrideForArcOnNet(parts[1], ap, spacing);
                        }
                        layersToOverride.clear();
                        widthsToOverride.clear();
                        spacingsToOverride.clear();
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Layers")) {
                        for (int i = 1; i < parts.length; ++i) {
                            List<ArcProto> apList = this.getArcProtoList(parts[i], lineReader.getLineNumber(), curTech, extraLayers);
                            for (ArcProto ap : apList) {
                                layersToOverride.add(ap);
                            }
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Width")) {
                        for (int i = 1; i < parts.length; i += 2) {
                            List<ArcProto> apList = this.getArcProtoList(parts[i], lineReader.getLineNumber(), curTech, extraLayers);
                            for (ArcProto ap : apList) {
                                v = TextUtils.atof(parts[i + 1]);
                                v = TextUtils.convertFromDistance(v, curTech, TextUtils.UnitScale.MICRO);
                                widthsToOverride.put(ap, new Double(v));
                            }
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Spacing")) {
                        for (int i = 1; i < parts.length; i += 2) {
                            List<ArcProto> apList = this.getArcProtoList(parts[i], lineReader.getLineNumber(), curTech, extraLayers);
                            for (ArcProto ap : apList) {
                                v = TextUtils.atof(parts[i + 1]);
                                v = TextUtils.convertFromDistance(v, curTech, TextUtils.UnitScale.MICRO);
                                spacingsToOverride.put(ap, new Double(v));
                            }
                        }
                        continue;
                    }
                    System.out.println("WARNING: unknown keyword on line " + lineReader.getLineNumber() + ": " + buf);
                }
                lineReader.close();
                HashMap<Integer, Map<Double, Map<Integer, MutableInteger>>> cellData = null;
                HashMap<Integer, MutableInteger> cellDataHor = null;
                HashMap<Integer, MutableInteger> cellDataVer = null;
                HashMap<String, ArrayList<String>> messages = null;
                for (ArcProto ap : this.gridSpacing.keySet()) {
                    if (cellData == null) {
                        cellData = new HashMap<Integer, Map<Double, Map<Integer, MutableInteger>>>();
                        cellDataHor = new HashMap<Integer, MutableInteger>();
                        cellDataVer = new HashMap<Integer, MutableInteger>();
                        messages = new HashMap<String, ArrayList<String>>();
                        this.gatherArea(cell, Orientation.IDENT.pureRotate(), cellData, cellDataHor, cellDataVer);
                    }
                    String spacing = this.gridSpacing.get(ap);
                    Integer metNo = ap.getFunction().getLevel() - 1;
                    String[] gridParts = spacing.split(",");
                    block27: for (int i = 0; i < gridParts.length; ++i) {
                        Double coordVal;
                        HashMap coordData;
                        String part = gridParts[i].trim();
                        if (part.length() == 0) continue;
                        int trackColor = SeaOfGatesTrack.getSpecificMaskNumber(part);
                        if (!Character.isDigit(part.charAt(part.length() - 1))) {
                            part = part.substring(0, part.length() - 1);
                        }
                        double val = TextUtils.atof(part);
                        HashMap metData = (HashMap)cellData.get(metNo);
                        if (metData == null) {
                            metData = new HashMap();
                            cellData.put(metNo, metData);
                        }
                        if ((coordData = (HashMap)metData.get(coordVal = new Double(val))) == null) {
                            coordData = new HashMap();
                            metData.put(coordVal, coordData);
                        }
                        int[] found = new int[10];
                        int totalFound = 0;
                        for (Integer mi : coordData.keySet()) {
                            MutableInteger count2 = (MutableInteger)coordData.get(mi);
                            int n = mi;
                            found[n] = found[n] + count2.intValue();
                            totalFound += count2.intValue();
                        }
                        if (totalFound <= 0 || trackColor <= 0 || found[trackColor] != 0) continue;
                        String coord = this.horEven == (ap.getFunction().getLevel() % 2 == 0) ? "Y" : "X";
                        String msg = "Coordinate " + coord + "=" + TextUtils.formatDistance(val) + " has geometry on";
                        boolean foundMore = false;
                        for (int j = 1; j < found.length; ++j) {
                            if (j == trackColor || found[j] == 0) continue;
                            foundMore = true;
                            msg = msg + " Metal " + (metNo + 1) + (char)(65 + j - 1);
                        }
                        if (!foundMore) continue;
                        for (String trackLine : trackLines.keySet()) {
                            List sogtList = (List)trackLines.get(trackLine);
                            boolean foundLine = false;
                            for (SeaOfGatesTrack sogt : sogtList) {
                                if (!DBMath.areEquals(sogt.getCoordinate(), val) || sogt.getMaskNum() != trackColor) continue;
                                foundLine = true;
                                break;
                            }
                            if (!foundLine) continue;
                            ArrayList<String> msgs = (ArrayList<String>)messages.get(trackLine);
                            if (msgs == null) {
                                msgs = new ArrayList<String>();
                                messages.put(trackLine, msgs);
                            }
                            msgs.add(msg);
                            continue block27;
                        }
                    }
                }
                if (messages != null) {
                    for (String trackLine : messages.keySet()) {
                        System.out.println("WARNING: Line '" + trackLine + "' may be wrong because:");
                        List msgs = (List)messages.get(trackLine);
                        for (String msg : msgs) {
                            System.out.println("        " + msg);
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error reading " + fileName);
                return;
            }
        }

        private void gatherArea(Cell cell, FixpTransform transToTop, Map<Integer, Map<Double, Map<Integer, MutableInteger>>> cellData, Map<Integer, MutableInteger> horCount, Map<Integer, MutableInteger> verCount) {
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) {
                    FixpTransform transBack = ni.transformOut(transToTop);
                    this.gatherArea((Cell)ni.getProto(), transBack, cellData, horCount, verCount);
                    continue;
                }
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                if (pNp.getFunction() == PrimitiveNode.Function.PIN) continue;
                FixpTransform nodeTrans = ni.rotateOut(transToTop);
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Poly poly = nodeInstPolyList[i];
                    this.gatherLayer(poly, nodeTrans, cellData, horCount, verCount);
                }
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                if (ai.getProto() == Generic.tech().unrouted_arc) continue;
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    this.gatherLayer(poly, transToTop, cellData, horCount, verCount);
                }
            }
        }

        private void gatherLayer(PolyBase poly, FixpTransform trans, Map<Integer, Map<Double, Map<Integer, MutableInteger>>> cellData, Map<Integer, MutableInteger> horCount, Map<Integer, MutableInteger> verCount) {
            Integer maskLayer;
            MutableInteger count2;
            Double coordVal;
            Map<Integer, MutableInteger> coordData;
            Layer layer = poly.getLayer();
            Layer.Function fun = layer.getFunction();
            if (!fun.isMetal()) {
                return;
            }
            if (poly.getStyle() != Poly.Type.FILLED) {
                return;
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                return;
            }
            Integer metNo = fun.getLevel() - 1;
            Map<Double, Map<Integer, MutableInteger>> metData = cellData.get(metNo);
            if (metData == null) {
                metData = new HashMap<Double, Map<Integer, MutableInteger>>();
                cellData.put(metNo, metData);
            }
            if ((coordData = metData.get(coordVal = new Double(this.horEven == ((metNo + 1) % 2 == 0) ? ((RectangularShape)bounds).getCenterY() : ((RectangularShape)bounds).getCenterX()))) == null) {
                coordData = new HashMap<Integer, MutableInteger>();
                metData.put(coordVal, coordData);
            }
            if ((count2 = coordData.get(maskLayer = Integer.valueOf(layer.getFunction().getMaskColor()))) == null) {
                count2 = new MutableInteger(0);
                coordData.put(maskLayer, count2);
            }
            count2.increment();
        }

        private List<ArcProto> getArcProtoList(String rootName, int lineNumber, Technology tech, String[] extra) {
            if (!rootName.startsWith("M")) {
                System.out.println("ERROR: Unrecognized layer name on line " + lineNumber + ": " + rootName);
                return null;
            }
            int metNum = TextUtils.atoi(rootName.substring(1));
            if (metNum <= 0 || metNum > tech.getNumArcs()) {
                System.out.println("ERROR: Unrecognized metal number on line " + lineNumber + ": " + rootName);
                return null;
            }
            ArrayList<ArcProto> foundList = new ArrayList<ArcProto>();
            int maskNum = SeaOfGatesTrack.getSpecificMaskNumber(rootName);
            if (maskNum > 0) {
                Iterator<ArcProto> it = tech.getArcs();
                while (it.hasNext()) {
                    ArcProto ap = it.next();
                    if (ap.getFunction().getLevel() != metNum || ap.getMaskLayer() != 0 && ap.getMaskLayer() != maskNum) continue;
                    foundList.add(ap);
                }
            } else {
                for (String ex : extra) {
                    String name = rootName + ex;
                    ArcProto ap = tech.findArcProto(name);
                    if (ap == null || ap.getFunction().getLevel() != metNum) continue;
                    foundList.add(ap);
                }
            }
            if (foundList.isEmpty()) {
                System.out.println("ERROR: Unrecognized metal layer on line " + lineNumber + ": " + rootName);
                return null;
            }
            return foundList;
        }

        private ArcProto parseArcName(String name) {
            int colonPos = name.indexOf(58);
            if (colonPos < 0) {
                return null;
            }
            String techName = name.substring(0, colonPos);
            String layerName = name.substring(colonPos + 1);
            Technology tech = Technology.findTechnology(techName);
            ArcProto ap = tech.findArcProto(layerName);
            return ap;
        }

        private int getPrimaryDirection(ArcProto ap) {
            boolean isHorizontalMetal = ap.getLayer(0).getFunction().getLevel() % 2 == 0 == this.getHorizontalEvenMetals();
            return isHorizontalMetal ? 1 : 0;
        }

        public void saveParameters(EditingPreferences ep) {
            Object arcs;
            String line;
            ArrayList<String> strings = new ArrayList<String>();
            strings.add("; Parameters for Cell " + this.cell.describe(false));
            if (this.steinerDone) {
                strings.add("SteinerTreesDone");
            }
            if (!this.canPlaceContactDownToAvoidedLayer) {
                strings.add("PreventContactDownToAvoidedLayer");
            }
            if (!this.canPlaceContactUpToAvoidedLayer) {
                strings.add("PreventContactUpToAvoidedLayer");
            }
            if (!this.canRotateContacts) {
                strings.add("NoContactRotation");
            }
            if (this.ignorePrimitives != null && this.ignorePrimitives.length() > 0) {
                strings.add("IgnoreContacts " + this.ignorePrimitives);
            }
            if (this.acceptOnly1XPrimitives != null && this.acceptOnly1XPrimitives.length() > 0) {
                strings.add("Accept1XContacts " + this.acceptOnly1XPrimitives);
            }
            if (this.acceptOnly2XPrimitives != null && this.acceptOnly2XPrimitives.length() > 0) {
                strings.add("Accept2XContacts " + this.acceptOnly2XPrimitives);
            }
            if (!this.favorHorVer) {
                strings.add("IgnoreHorVer");
            }
            if (this.forceHorVer) {
                strings.add("ForceHorVer");
            }
            if (this.horEven) {
                strings.add("HorizontalEven");
            }
            if (this.routingBoundsLayerName != null) {
                strings.add("RoutingBoundsLayerName " + this.routingBoundsLayerName);
            }
            for (ArcProto ap : this.gridSpacing.keySet()) {
                String grid = this.gridSpacing.get(ap);
                strings.add("ArcGrid " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + grid);
            }
            for (ArcProto ap : this.preventedArcs) {
                strings.add("ArcAvoid " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.favoredArcs) {
                strings.add("ArcFavor " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.forceGridArcs) {
                strings.add("ArcGridForce " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.taperOnlyArcs) {
                strings.add("ArcTaperOnly " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.overrides.keySet()) {
                SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                if (sogap.getWidthOverride() != null) {
                    strings.add("ArcWidthOverride " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getWidthOverride());
                }
                if (sogap.getSpacingOverride(0) != null) {
                    strings.add("ArcSpacingOverrideX " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getSpacingOverride(0));
                }
                if (sogap.getSpacingOverride(1) != null) {
                    strings.add("ArcSpacingOverrideY " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getSpacingOverride(1));
                }
                if (sogap.getWidthOf2X() != null) {
                    strings.add("WidthOf2X " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getWidthOf2X());
                }
                if (sogap.getTaperTo1X() == null) continue;
                strings.add("TaperTo1X " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getTaperTo1X());
            }
            for (ArcProto ap : this.removeLayers.keySet()) {
                String removeLayer = this.removeLayers.get(ap);
                if (removeLayer == null) continue;
                strings.add("RemoveLayer " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + removeLayer);
            }
            for (SeaOfGatesExtraBlockage sogeb : this.extraBlockages) {
                strings.add("Blockage " + sogeb.met.getTechnology().getTechName() + ":" + sogeb.met.getName() + " " + sogeb.x1 + " " + sogeb.y1 + " " + sogeb.x2 + " " + sogeb.y2);
            }
            for (String netName : this.netsToRoute) {
                line = "Network " + netName;
                arcs = this.netsAndArcsToRoute.get(netName);
                if (arcs != null) {
                    Iterator<ArcProto> i$ = arcs.iterator();
                    while (i$.hasNext()) {
                        ArcProto ap = i$.next();
                        line = line + " " + ap.getTechnology().getTechName() + ":" + ap.getName();
                    }
                }
                strings.add(line);
            }
            for (String netName : this.netAndArcOverrides.keySet()) {
                line = "NetworkOverride " + netName;
                arcs = this.netAndArcOverrides.get(netName);
                if (arcs != null) {
                    for (ArcProto ap : arcs.keySet()) {
                        int axis;
                        SeaOfGatesArcProperties overrides = (SeaOfGatesArcProperties)arcs.get(ap);
                        if (overrides == null) continue;
                        line = line + " " + ap.getTechnology().getTechName() + ":" + ap.getName();
                        if (overrides.getWidthOverride() != null) {
                            line = line + " W=" + overrides.getWidthOverride();
                        }
                        if (overrides.getSpacingOverride(axis = this.getPrimaryDirection(ap)) == null) continue;
                        line = line + " S=" + overrides.getSpacingOverride(axis);
                    }
                }
                strings.add(line);
            }
            String[] paramArray = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                paramArray[i] = (String)strings.get(i);
            }
            this.cell.newVar(ROUTING_SOG_PARAMETERS_KEY, (Object)paramArray, ep);
        }

        public Cell getCell() {
            return this.cell;
        }

        public void setSteinerDone(boolean sd) {
            this.steinerDone = sd;
        }

        public boolean isSteinerDone() {
            return this.steinerDone;
        }

        public void setContactAllowedDownToAvoidedLayer(boolean a) {
            this.canPlaceContactDownToAvoidedLayer = a;
        }

        public boolean isContactAllowedDownToAvoidedLayer() {
            return this.canPlaceContactDownToAvoidedLayer;
        }

        public void setContactAllowedUpToAvoidedLayer(boolean a) {
            this.canPlaceContactUpToAvoidedLayer = a;
        }

        public boolean isContactAllowedUpToAvoidedLayer() {
            return this.canPlaceContactUpToAvoidedLayer;
        }

        public void setFavorHorVer(boolean f) {
            this.favorHorVer = f;
        }

        public boolean isFavorHorVer() {
            return this.favorHorVer;
        }

        public void setForceHorVer(boolean f) {
            this.forceHorVer = f;
        }

        public boolean isForceHorVer() {
            return this.forceHorVer;
        }

        public void setHorizontalEven(boolean he) {
            this.horEven = he;
        }

        public boolean isHorizontalEven() {
            return this.horEven;
        }

        public void setContactsRotate(boolean he) {
            this.canRotateContacts = he;
        }

        public boolean isContactsRotate() {
            return this.canRotateContacts;
        }

        public void setPrevented(ArcProto ap, boolean prevent) {
            if (prevent) {
                this.preventedArcs.add(ap);
            } else {
                this.preventedArcs.remove(ap);
            }
        }

        public boolean isPrevented(ArcProto ap) {
            return this.preventedArcs.contains(ap);
        }

        public void setFavored(ArcProto ap, boolean f) {
            if (f) {
                this.favoredArcs.add(ap);
            } else {
                this.favoredArcs.remove(ap);
            }
        }

        public boolean isFavored(ArcProto ap) {
            return this.favoredArcs.contains(ap);
        }

        public void setTaperOnly(ArcProto ap, boolean f) {
            if (f) {
                this.taperOnlyArcs.add(ap);
            } else {
                this.taperOnlyArcs.remove(ap);
            }
        }

        public boolean isTaperOnly(ArcProto ap) {
            return this.taperOnlyArcs.contains(ap);
        }

        public void setGridForced(ArcProto ap, boolean f) {
            if (f) {
                this.forceGridArcs.add(ap);
            } else {
                this.forceGridArcs.remove(ap);
            }
        }

        public boolean isGridForced(ArcProto ap) {
            return this.forceGridArcs.contains(ap);
        }

        public Double getDefaultWidthOverride(ArcProto ap) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.getWidthOverride();
        }

        public void setDefaultWidthOverride(ArcProto ap, Double w) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setWidthOverride(w);
        }

        public Double getDefaultSpacingOverride(ArcProto ap, int axis) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.getSpacingOverride(axis);
        }

        public void setDefaultSpacingOverride(ArcProto ap, Double s2, int axis) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setSpacingOverride(s2, axis);
        }

        public Double get2XWidth(ArcProto ap) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.getWidthOf2X();
        }

        public void set2XWidth(ArcProto ap, Double w) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setWidthOf2X(w);
        }

        public Double getTaperLength(ArcProto ap) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.getTaperTo1X();
        }

        public void setTaperLength(ArcProto ap, Double t) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setTaperTo1X(t);
        }

        public List<String> getNetsToRoute() {
            return this.netsToRoute;
        }

        public void addNetToRoute(String netName) {
            ArrayList<String> names = new ArrayList<String>();
            int index = netName.indexOf(":");
            if (index != -1) {
                int end;
                String[] values = netName.split("\\[");
                assert (values.length == 2);
                String root = values[0];
                values = values[1].replace("]", "").split(":");
                assert (values.length == 2);
                int start = Integer.valueOf(values[0]);
                if (start > (end = Integer.valueOf(values[1]).intValue())) {
                    int tmp = start;
                    start = end;
                    end = tmp;
                }
                for (int i = start; i <= end; ++i) {
                    names.add(root + "[" + i + "]");
                }
            } else {
                names.add(netName);
            }
            for (String name : names) {
                List<ArcProto> arcs = this.netsAndArcsToRoute.get(name);
                if (arcs == null) {
                    arcs = new ArrayList<ArcProto>();
                    this.netsAndArcsToRoute.put(name, arcs);
                }
                this.netsToRoute.add(name);
            }
        }

        public void removeNetToRoute(String netName) {
            List<ArcProto> arcs = this.netsAndArcsToRoute.get(netName);
            if (arcs != null) {
                this.netsAndArcsToRoute.remove(netName);
            }
            this.netsToRoute.remove(netName);
        }

        public List<ArcProto> getArcsOnNet(String net) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                return null;
            }
            return arcsOnNet;
        }

        public void addArcToNet(String net, ArcProto ap) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new ArrayList<ArcProto>();
                this.netsAndArcsToRoute.put(net, arcsOnNet);
            }
            arcsOnNet.add(ap);
        }

        public void removeArcFromNet(String net, ArcProto ap) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                return;
            }
            arcsOnNet.remove(ap);
        }

        public SeaOfGatesArcProperties getOverridesForArcsOnNet(String net, ArcProto ap) {
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                return null;
            }
            SeaOfGatesArcProperties sogap = arcsOnNet.get(ap);
            return sogap;
        }

        public void setWidthOverrideForArcOnNet(String net, ArcProto ap, Double width) {
            SeaOfGatesArcProperties sogap;
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new HashMap<ArcProto, SeaOfGatesArcProperties>();
                this.netAndArcOverrides.put(net, arcsOnNet);
            }
            if ((sogap = arcsOnNet.get(ap)) == null) {
                sogap = new SeaOfGatesArcProperties();
                arcsOnNet.put(ap, sogap);
            }
            sogap.setWidthOverride(width);
        }

        public void setSpacingOverrideForArcOnNet(String net, ArcProto ap, Double spacing) {
            SeaOfGatesArcProperties sogap;
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new HashMap<ArcProto, SeaOfGatesArcProperties>();
                this.netAndArcOverrides.put(net, arcsOnNet);
            }
            if ((sogap = arcsOnNet.get(ap)) == null) {
                sogap = new SeaOfGatesArcProperties();
                arcsOnNet.put(ap, sogap);
            }
            sogap.setSpacingOverride(spacing, this.getPrimaryDirection(ap));
        }

        public String getGrid(ArcProto ap) {
            String v = this.gridSpacing.get(ap);
            return v;
        }

        public void setGrid(ArcProto ap, String grid) {
            if (grid == null) {
                this.gridSpacing.remove(ap);
            } else {
                this.gridSpacing.put(ap, grid);
            }
        }

        public String getRemoveLayer(ArcProto ap) {
            String v = this.removeLayers.get(ap);
            return v;
        }

        public void setRemoveLayer(ArcProto ap, String layerName) {
            if (layerName == null) {
                this.removeLayers.remove(ap);
            } else {
                this.removeLayers.put(ap, layerName);
            }
        }

        public String getAcceptOnly1XPrimitives() {
            return this.acceptOnly1XPrimitives;
        }

        public void setAcceptOnly1XPrimitives(String s2) {
            this.acceptOnly1XPrimitives = s2;
        }

        public String getAcceptOnly2XPrimitives() {
            return this.acceptOnly2XPrimitives;
        }

        public void setAcceptOnly2XPrimitives(String s2) {
            this.acceptOnly2XPrimitives = s2;
        }

        public String getRoutingBoundsLayerName() {
            return this.routingBoundsLayerName;
        }

        public void setRoutingBoundsLayerName(String n) {
            this.routingBoundsLayerName = n;
        }

        public String getIgnorePrimitives() {
            return this.ignorePrimitives;
        }

        public void setIgnorePrimitive(String s2) {
            this.ignorePrimitives = s2;
        }

        public boolean getHorizontalEvenMetals() {
            return this.horEven;
        }

        public List<SeaOfGatesExtraBlockage> getBlockages() {
            return this.extraBlockages;
        }

        public void setBlockages(List<SeaOfGatesExtraBlockage> e) {
            this.extraBlockages = e;
        }
    }

    public static class SeaOfGatesExtraBlockage
    implements Serializable {
        double x1;
        double y1;
        double x2;
        double y2;
        ArcProto met;

        public SeaOfGatesExtraBlockage(double x1, double y1, double x2, double y2, ArcProto m) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.met = m;
        }

        public ArcProto getLayer() {
            return this.met;
        }

        public double getLX() {
            return Math.min(this.x1, this.x2);
        }

        public double getHX() {
            return Math.max(this.x1, this.x2);
        }

        public double getLY() {
            return Math.min(this.y1, this.y2);
        }

        public double getHY() {
            return Math.max(this.y1, this.y2);
        }
    }

    public static class SeaOfGatesArcProperties
    implements Serializable {
        private Double overrideWidth = null;
        private Double overrideSpacingX = null;
        private Double overrideSpacingY = null;
        private Double widthOf2X = null;
        private Double taperTo1X = null;

        public void setWidthOverride(Double w) {
            this.overrideWidth = w;
        }

        public Double getWidthOverride() {
            return this.overrideWidth;
        }

        public void setSpacingOverride(Double s2, int axis) {
            if (axis == 0) {
                this.overrideSpacingX = s2;
            } else {
                this.overrideSpacingY = s2;
            }
        }

        public Double getSpacingOverride(int axis) {
            return axis == 0 ? this.overrideSpacingX : this.overrideSpacingY;
        }

        public void setWidthOf2X(Double w) {
            this.widthOf2X = w;
        }

        public Double getWidthOf2X() {
            return this.widthOf2X;
        }

        public void setTaperTo1X(Double t) {
            this.taperTo1X = t;
        }

        public Double getTaperTo1X() {
            return this.taperTo1X;
        }
    }

    public static class SeaOfGatesOptions
    implements Serializable {
        public boolean useParallelFromToRoutes = true;
        public boolean useParallelRoutes = false;
        public boolean runOnConnectedRoutes = true;
        public Routing.SoGContactsStrategy contactPlacementAction = Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL;
        public double maxArcWidth = 10.0;
        public int complexityLimit = 200000;
        public int rerunComplexityLimit = 400000;
        public int maxDistance = 2;
        public boolean useGlobalRouter = false;
        public boolean reRunFailedRoutes = false;
        public boolean enableSpineRouting = false;
        public int forcedNumberOfThreads = 0;
        public String resultCellName = null;
        public ElapseTimer theTimer;
        public PrintStream qualityPrintStream = null;

        public void getOptionsFromPreferences(boolean factory) {
            if (factory) {
                this.useParallelFromToRoutes = Routing.isFactorySeaOfGatesUseParallelFromToRoutes();
                this.useParallelRoutes = Routing.isFactorySeaOfGatesUseParallelRoutes();
                this.runOnConnectedRoutes = Routing.isFactorySeaOfGatesRunOnConnectedRoutes();
                this.contactPlacementAction = Routing.SoGContactsStrategy.findByLevel(Routing.getFactorySeaOfGatesContactPlacementAction());
                this.maxArcWidth = Routing.getFactorySeaOfGatesMaxWidth();
                this.complexityLimit = Routing.getFactorySeaOfGatesComplexityLimit();
                this.rerunComplexityLimit = Routing.getFactorySeaOfGatesRerunComplexityLimit();
                this.useGlobalRouter = Routing.isFactorySeaOfGatesUseGlobalRouting();
                this.reRunFailedRoutes = Routing.isFactorySeaOfGatesRerunFailedRoutes();
                this.enableSpineRouting = Routing.isFactorySeaOfGatesEnableSpineRouting();
                this.forcedNumberOfThreads = Routing.getFactorySeaOfGatesForcedProcessorCount();
                this.maxDistance = Routing.getFactorySeaOfGatesMaxDistance();
            } else {
                this.useParallelFromToRoutes = Routing.isSeaOfGatesUseParallelFromToRoutes();
                this.useParallelRoutes = Routing.isSeaOfGatesUseParallelRoutes();
                this.runOnConnectedRoutes = Routing.isSeaOfGatesRunOnConnectedRoutes();
                this.contactPlacementAction = Routing.SoGContactsStrategy.findByLevel(Routing.getSeaOfGatesContactPlacementAction());
                this.maxArcWidth = Routing.getSeaOfGatesMaxWidth();
                this.complexityLimit = Routing.getSeaOfGatesComplexityLimit();
                this.rerunComplexityLimit = Routing.getSeaOfGatesRerunComplexityLimit();
                this.useGlobalRouter = Routing.isSeaOfGatesUseGlobalRouting();
                this.reRunFailedRoutes = Routing.isSeaOfGatesRerunFailedRoutes();
                this.enableSpineRouting = Routing.isSeaOfGatesEnableSpineRouting();
                this.forcedNumberOfThreads = Routing.getSeaOfGatesForcedProcessorCount();
                this.maxDistance = Routing.getSeaOfGatesMaxDistance();
            }
        }
    }

    public static class SeaOfGatesTrack
    implements Comparable {
        private double coordinate;
        private int maskNum;

        public SeaOfGatesTrack(double v, int c) {
            this.coordinate = v;
            this.maskNum = c;
        }

        public double getCoordinate() {
            return this.coordinate;
        }

        public int getMaskNum() {
            return this.maskNum;
        }

        public int compareTo(Object o) {
            double other = ((SeaOfGatesTrack)o).coordinate;
            double diff2 = this.coordinate - other;
            if (diff2 < 0.0) {
                return -1;
            }
            if (diff2 > 0.0) {
                return 1;
            }
            return 0;
        }

        public static int getSpecificMaskNumber(String layerName) {
            int maskNum = 0;
            char lastChar = layerName.charAt(layerName.length() - 1);
            if (!Character.isDigit(lastChar)) {
                maskNum = Character.toLowerCase(lastChar) - 97 + 1;
            }
            return maskNum;
        }
    }
}

