/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.extract.TransistorSearch;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RectangularShape;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class CellLists
extends EDialog {
    Cell curCell;
    private static int whichSwitch = 0;
    private static boolean onlyViewSwitch = false;
    private static View viewSwitch = View.SCHEMATIC;
    private static boolean alsoIconSwitch = false;
    private static boolean excOldVersSwitch = false;
    private static boolean excNewVersSwitch = false;
    private static boolean evaluateNumbers = true;
    private static int orderingSwitch = 0;
    private static int destinationSwitch = 0;
    private JRadioButton allCells;
    private JCheckBox alsoIconViews;
    private JButton cancel;
    private ButtonGroup destination;
    private JRadioButton displayInMessages;
    private JCheckBox evaluateNumerically;
    private JCheckBox excludeNewestVersions;
    private JCheckBox excludeOlderVersions;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JButton ok;
    private JRadioButton onlyCellsNotUsedElsewhere;
    private JRadioButton onlyCellsUnderCurrent;
    private JRadioButton onlyCellsUsedElsewhere;
    private JRadioButton onlyPlaceholderCells;
    private JCheckBox onlyThisView;
    private JRadioButton orderByDate;
    private JRadioButton orderByName;
    private JRadioButton orderByStructure;
    private ButtonGroup ordering;
    private JRadioButton saveToDisk;
    private JComboBox views;
    private ButtonGroup whichCells;

    public static void generalCellListsCommand() {
        TopLevel jf = TopLevel.getCurrentJFrame();
        CellLists dialog = new CellLists(jf, true);
        dialog.setVisible(true);
        dialog.toFront();
    }

    private CellLists(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        for (View v : View.getOrderedViews()) {
            this.views.addItem(v.getFullName());
        }
        this.curCell = WindowFrame.getCurrentCell();
        this.onlyCellsUnderCurrent.setEnabled(this.curCell != null);
        switch (whichSwitch) {
            case 0: {
                this.allCells.setSelected(true);
                break;
            }
            case 1: {
                this.onlyCellsUsedElsewhere.setSelected(true);
                break;
            }
            case 2: {
                this.onlyCellsNotUsedElsewhere.setSelected(true);
                break;
            }
            case 3: {
                this.onlyCellsUnderCurrent.setSelected(true);
                break;
            }
            case 4: {
                this.onlyPlaceholderCells.setSelected(true);
            }
        }
        this.onlyThisView.setSelected(onlyViewSwitch);
        this.views.setSelectedItem(viewSwitch.getFullName());
        this.views.setEnabled(onlyViewSwitch);
        this.alsoIconViews.setSelected(alsoIconSwitch);
        this.excludeOlderVersions.setSelected(excOldVersSwitch);
        this.excludeNewestVersions.setSelected(excNewVersSwitch);
        this.evaluateNumerically.setSelected(evaluateNumbers);
        switch (orderingSwitch) {
            case 0: {
                this.orderByName.setSelected(true);
                break;
            }
            case 1: {
                this.orderByDate.setSelected(true);
                break;
            }
            case 2: {
                this.orderByStructure.setSelected(true);
            }
        }
        switch (destinationSwitch) {
            case 0: {
                this.displayInMessages.setSelected(true);
                break;
            }
            case 1: {
                this.saveToDisk.setSelected(true);
            }
        }
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private static String makeCellLine(Cell cell, int maxlen, DRC.DRCPreferences dp) {
        Object line = cell.noLibDescribe();
        if (maxlen < 0) {
            line = (String)line + "\t";
        } else {
            for (int i = ((String)line).length(); i < maxlen; ++i) {
                line = (String)line + " ";
            }
        }
        String versionString = TextUtils.toBlankPaddedString(cell.getVersion(), 5);
        line = (String)line + versionString;
        line = maxlen < 0 ? (String)line + "\t" : (String)line + "   ";
        Date creationDate = cell.getCreationDate();
        line = creationDate == null ? (maxlen < 0 ? (String)line + "UNRECORDED" : (String)line + "     UNRECORDED     ") : (String)line + TextUtils.formatDate(creationDate);
        line = maxlen < 0 ? (String)line + "\t" : (String)line + "   ";
        Date revisionDate = cell.getRevisionDate();
        line = revisionDate == null ? (maxlen < 0 ? (String)line + "UNRECORDED" : (String)line + "     UNRECORDED     ") : (String)line + TextUtils.formatDate(revisionDate);
        line = maxlen < 0 ? (String)line + "\t" : (String)line + "   ";
        if (cell.getView().isTextView()) {
            int len = 0;
            String[] textLines = cell.getTextViewContents();
            if (textLines != null) {
                len = textLines.length;
            }
            line = maxlen < 0 ? (String)line + len + " lines" : (String)line + TextUtils.toBlankPaddedString(len, 8) + " lines   ";
        } else {
            Object width = TextUtils.formatDistance(cell.getBounds().getWidth(), cell.getTechnology());
            if (maxlen >= 0) {
                while (((String)width).length() < 7) {
                    width = " " + (String)width;
                }
            }
            Object height = TextUtils.formatDistance(cell.getBounds().getHeight(), cell.getTechnology());
            if (maxlen >= 0) {
                while (((String)height).length() < 7) {
                    height = (String)height + " ";
                }
            }
            line = (String)line + (String)width + " x " + (String)height;
        }
        if (maxlen < 0) {
            line = (String)line + "\t";
        }
        int total = 0;
        Iterator<NodeInst> it = cell.getInstancesOf();
        while (it.hasNext()) {
            ++total;
            it.next();
        }
        line = maxlen < 0 ? (String)line + total : (String)line + TextUtils.toBlankPaddedString(total, 4);
        line = maxlen < 0 ? (String)line + "\t" : (String)line + "   ";
        line = cell.isAllLocked() ? (String)line + "L" : (String)line + " ";
        line = maxlen < 0 ? (String)line + "\t" : (String)line + " ";
        line = cell.isInstancesLocked() ? (String)line + "I" : (String)line + " ";
        line = maxlen < 0 ? (String)line + "\t" : (String)line + " ";
        line = SCLibraryGen.isStandardCell(cell) ? (String)line + "S" : (String)line + " ";
        line = maxlen < 0 ? (String)line + "\t" : (String)line + " ";
        boolean goodDRC = false;
        int activeBits = DRC.getActiveBits(cell.getTechnology(), dp);
        Date lastGoodDate = DRC.getLastDRCDateBasedOnBits(cell, true, activeBits, true);
        if (!Job.getDebug() && lastGoodDate != null && cell.getRevisionDate().before(lastGoodDate)) {
            goodDRC = true;
        }
        line = goodDRC ? (String)line + "D" : (String)line + " ";
        goodDRC = false;
        lastGoodDate = DRC.getLastDRCDateBasedOnBits(cell, false, activeBits, true);
        if (!Job.getDebug() && lastGoodDate != null && cell.getRevisionDate().before(lastGoodDate)) {
            goodDRC = true;
        }
        line = goodDRC ? (String)line + "A" : (String)line + " ";
        line = maxlen < 0 ? (String)line + "\t" : (String)line + " ";
        return line;
    }

    public static void listNodesAndArcsInCellCommand() {
        MutableInteger count;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        HashMap<NodeProto, MutableInteger> nodeCount = new HashMap<NodeProto, MutableInteger>();
        HashMap<ArcProto, MutableInteger> arcCount = new HashMap<ArcProto, MutableInteger>();
        CellLists.addObjects(curCell, nodeCount, arcCount);
        System.out.println("Contents of " + curCell + ":");
        Technology printtech = null;
        Iterator<Comparable<Technology>> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology curtech = it.next();
            int totalVal = 0;
            Iterator<Comparable<PrimitiveNode>> nIt = curtech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode np = nIt.next();
                count = (MutableInteger)nodeCount.get(np);
                if (count == null) continue;
                if (curtech != printtech) {
                    System.out.println(curtech.getTechName() + " technology:");
                    printtech = curtech;
                }
                System.out.println("\t" + TextUtils.toBlankPaddedString(count.intValue(), 6) + " " + np.describe(true) + " nodes");
                totalVal += count.intValue();
            }
            if (totalVal > 0) {
                System.out.println(TextUtils.toBlankPaddedString(totalVal, 6) + " Total nodes for " + curtech.getTechName() + " technology");
            }
            totalVal = 0;
            nIt = curtech.getArcs();
            while (nIt.hasNext()) {
                ArcProto ap = (ArcProto)nIt.next();
                count = (MutableInteger)arcCount.get(ap);
                if (count == null) continue;
                if (curtech != printtech) {
                    System.out.println(curtech.getTechName() + " technology:");
                    printtech = curtech;
                }
                System.out.println("\t" + TextUtils.toBlankPaddedString(count.intValue(), 6) + " " + ap.describe() + " arcs");
                totalVal += count.intValue();
            }
            if (totalVal <= 0) continue;
            System.out.println(TextUtils.toBlankPaddedString(totalVal, 6) + " Total arcs for " + curtech.getTechName() + " technology");
        }
        it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Library printlib = null;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                count = (MutableInteger)nodeCount.get(cell);
                if (count == null) continue;
                if (lib != printlib) {
                    System.out.println(lib + ":");
                    printlib = lib;
                }
                System.out.println(TextUtils.toBlankPaddedString(count.intValue(), 6) + " " + cell.describe(true) + " nodes");
            }
        }
    }

    private static void addObjects(Cell cell, Map<NodeProto, MutableInteger> nodeCount, Map<ArcProto, MutableInteger> arcCount) {
        MutableInteger count;
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isIconOfParent()) continue;
            NodeProto np = ni.getProto();
            count = nodeCount.get(np);
            if (count == null) {
                count = new MutableInteger(0);
                nodeCount.put(np, count);
            }
            count.increment();
            if (!ni.isCellInstance()) continue;
            Cell subCell = (Cell)np;
            if (ni.isIconOfParent()) continue;
            Cell cnp = subCell.contentsView();
            if (cnp == null) {
                cnp = subCell;
            }
            CellLists.addObjects(cnp, nodeCount, arcCount);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ArcProto ap = ai.getProto();
            count = arcCount.get(ap);
            if (count == null) {
                count = new MutableInteger(0);
                arcCount.put(ap, count);
            }
            count.increment();
        }
    }

    public static void listCellInstancesCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        HashMap<Cell, MutableInteger> nodeCount = new HashMap<Cell, MutableInteger>();
        Iterator<NodeInst> it = curCell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            MutableInteger count = (MutableInteger)nodeCount.get(ni.getProto());
            if (count == null) {
                count = new MutableInteger(0);
                nodeCount.put((Cell)ni.getProto(), count);
            }
            count.increment();
        }
        boolean first = true;
        Iterator<Library> it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library lib = it2.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                MutableInteger count = (MutableInteger)nodeCount.get(cell);
                if (count == null) continue;
                if (first) {
                    System.out.println("Instances appearing in " + curCell);
                }
                first = false;
                String line = "   " + count.intValue() + " instances of " + cell + " at";
                Iterator<NodeInst> nIt = curCell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    if (ni.getProto() != cell) continue;
                    line = line + " (" + ni.getAnchorCenterX() + "," + ni.getAnchorCenterY() + ")";
                }
                System.out.println(line);
            }
        }
        if (first) {
            System.out.println("There are no instances in " + curCell);
        }
    }

    public static void numberOfTransistorsCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        TransistorSearch.countNumberOfTransistors(curCell);
    }

    public static void listCellUsageCommand(boolean recursive) {
        Cell c = WindowFrame.needCurCell();
        if (c == null) {
            return;
        }
        HashMap nodeCount = new HashMap();
        ArrayList<Cell> cellsToConsider = new ArrayList<Cell>();
        cellsToConsider.add(c);
        for (int i = 0; i < cellsToConsider.size(); ++i) {
            Cell bottom = (Cell)cellsToConsider.get(i);
            Iterator<ElectricObject> nIt = bottom.getInstancesOf();
            while (nIt.hasNext()) {
                MutableInteger instanceCount;
                HashMap<Cell, MutableInteger> tally;
                NodeInst ni = nIt.next();
                Cell top = ni.getParent();
                if (recursive && !cellsToConsider.contains(top)) {
                    cellsToConsider.add(top);
                }
                if ((tally = (HashMap<Cell, MutableInteger>)nodeCount.get(top)) == null) {
                    tally = new HashMap<Cell, MutableInteger>();
                    nodeCount.put(top, tally);
                }
                if ((instanceCount = (MutableInteger)tally.get(bottom)) == null) {
                    instanceCount = new MutableInteger(0);
                    tally.put(bottom, instanceCount);
                }
                instanceCount.increment();
            }
            if (bottom.getView() != View.SCHEMATIC) continue;
            for (Cell iconCell : bottom.getCellsInGroup()) {
                if (iconCell.getView() != View.ICON) continue;
                Iterator<NodeInst> nIt2 = iconCell.getInstancesOf();
                while (nIt2.hasNext()) {
                    int arraySize;
                    MutableInteger instanceCount;
                    HashMap<Cell, MutableInteger> tally;
                    NodeInst ni = nIt2.next();
                    if (ni.isIconOfParent()) continue;
                    Cell top = ni.getParent();
                    if (recursive && !cellsToConsider.contains(top)) {
                        cellsToConsider.add(top);
                    }
                    if ((tally = (HashMap<Cell, MutableInteger>)nodeCount.get(top)) == null) {
                        tally = new HashMap<Cell, MutableInteger>();
                        nodeCount.put(top, tally);
                    }
                    if ((instanceCount = (MutableInteger)tally.get(bottom)) == null) {
                        instanceCount = new MutableInteger(0);
                        tally.put(bottom, instanceCount);
                    }
                    if ((arraySize = ni.getNameKey().busWidth()) > 1) {
                        instanceCount.setValue(instanceCount.intValue() + arraySize);
                        continue;
                    }
                    instanceCount.increment();
                }
            }
        }
        if (nodeCount.size() == 0) {
            System.out.println("Cell " + c.describe(true) + " is not used anywhere");
            return;
        }
        if (recursive) {
            System.out.println("Cell " + c.describe(true) + " recursive usage:");
        } else {
            System.out.println("Cell " + c.describe(true) + " usage:");
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Map tally = (Map)nodeCount.get(cell);
                if (tally == null) continue;
                for (Cell bottom : tally.keySet()) {
                    MutableInteger count = (MutableInteger)tally.get(bottom);
                    System.out.println("  " + cell + " has " + count.intValue() + " instances of " + bottom);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void designSummaryCommand(boolean onlySelected) {
        void var10_20;
        void var10_18;
        MutableInteger count;
        Layer layer;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        TreeMap layerTable = new TreeMap();
        TreeMap instanceTable = new TreeMap();
        Iterator<ArcInst> arcIt = curCell.getArcs();
        Iterator<NodeInst> nodeIt = curCell.getNodes();
        if (onlySelected) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            List<Geometric> list = wnd.getHighlightedEObjs(false, true);
            ArrayList<ArcInst> arcList = new ArrayList<ArcInst>(list.size());
            for (Geometric geometric : list) {
                arcList.add((ArcInst)geometric);
            }
            arcIt = arcList.iterator();
            list = wnd.getHighlightedEObjs(true, false);
            ArrayList<NodeInst> nodeList = new ArrayList<NodeInst>(list.size());
            for (Geometric g : list) {
                nodeList.add((NodeInst)g);
            }
            nodeIt = nodeList.iterator();
            if (!nodeIt.hasNext() && !arcIt.hasNext()) {
                System.out.println("No content selected in cell");
                return;
            }
        }
        System.out.println("                   Cell Environment");
        System.out.println("******************************************************");
        Library curLib = curCell.getLibrary();
        System.out.println("Cell:      " + curCell.noLibDescribe());
        System.out.println("Library:   " + curLib.getName());
        String editMode = "?";
        URL url = curLib.getLibFile();
        if (url != null) {
            File f = new File(url.getPath());
            if (f.canRead()) {
                editMode = "Read";
            }
            if (f.canWrite()) {
                editMode = "Write";
            }
            System.out.println("Path:      " + url.getPath());
            System.out.println("Edit Mode: " + editMode);
        } else {
            System.out.println("!!! No disk file associated with this library");
        }
        int selectCount = 0;
        while (arcIt.hasNext()) {
            ArcInst arcInst = arcIt.next();
            ArcProto ap = arcInst.getProto();
            ++selectCount;
            for (int idx = 0; idx < ap.getNumArcLayers(); ++idx) {
                layer = ap.getLayer(idx);
                MutableInteger.addToBag(layerTable, layer);
            }
        }
        System.out.println(selectCount + " arcs analyzed");
        selectCount = 0;
        while (nodeIt.hasNext()) {
            NodeInst nodeInst = nodeIt.next();
            if (nodeInst.isCellInstance()) {
                if (nodeInst.isIconOfParent()) continue;
                Cell subcell = (Cell)nodeInst.getProto();
                MutableInteger.addToBag(instanceTable, subcell);
            } else {
                Technology.NodeLayer[] nodeLayerList;
                NodeProto np = nodeInst.getProto();
                PrimitiveNode pn = (PrimitiveNode)np;
                if (pn.getTechnology() instanceof Generic) continue;
                for (Technology.NodeLayer nl : nodeLayerList = pn.getNodeLayers()) {
                    Layer layer2 = nl.getLayer();
                    MutableInteger.addToBag(layerTable, layer2);
                }
            }
            ++selectCount;
        }
        System.out.println(selectCount + " nodes analyzed");
        System.out.println("******************************************************");
        System.out.println();
        System.out.println("                     Layer Usage");
        System.out.println("******************************************************");
        System.out.println("Count\tLayer");
        boolean bl = false;
        for (Map.Entry e : layerTable.entrySet()) {
            layer = (Layer)e.getKey();
            count = (MutableInteger)e.getValue();
            System.out.printf("%5s\t%s\n", count, layer.getFullName());
            var10_18 += count.intValue();
        }
        System.out.println("------- Total: " + (int)var10_18 + " -------");
        System.out.println("******************************************************");
        System.out.println();
        System.out.println("                    Cell Instances");
        System.out.println("******************************************************");
        System.out.println("Count\tInstance");
        boolean bl2 = false;
        for (Map.Entry e : instanceTable.entrySet()) {
            Cell subcell = (Cell)e.getKey();
            count = (MutableInteger)e.getValue();
            System.out.printf("%5s\t%s\n", count, subcell.describe(false));
            var10_20 += count.intValue();
        }
        System.out.println("------- Total: " + (int)var10_20 + " -------");
        System.out.println("******************************************************");
    }

    public static void describeThisCellCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        new DescribeThisCellJob(curCell).startJob();
    }

    private static void printHeaderLine(int maxLen) {
        Object header = "Cell";
        for (int i = 4; i < maxLen; ++i) {
            header = (String)header + "-";
        }
        header = (String)header + "Version--------Creation date";
        header = (String)header + "---------------Revision Date--------------Size-------Usage--L-I-S-D";
        System.out.println((String)header);
    }

    private void initComponents() {
        this.whichCells = new ButtonGroup();
        this.ordering = new ButtonGroup();
        this.destination = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.allCells = new JRadioButton();
        this.onlyCellsUsedElsewhere = new JRadioButton();
        this.onlyCellsNotUsedElsewhere = new JRadioButton();
        this.onlyCellsUnderCurrent = new JRadioButton();
        this.onlyPlaceholderCells = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.onlyThisView = new JCheckBox();
        this.views = new JComboBox();
        this.alsoIconViews = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.excludeOlderVersions = new JCheckBox();
        this.excludeNewestVersions = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.orderByName = new JRadioButton();
        this.orderByDate = new JRadioButton();
        this.orderByStructure = new JRadioButton();
        this.jSeparator4 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.displayInMessages = new JRadioButton();
        this.saveToDisk = new JRadioButton();
        this.evaluateNumerically = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Cell Lists");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CellLists.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellLists.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellLists.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Which cells:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.whichCells.add(this.allCells);
        this.allCells.setText("All cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.getContentPane().add((Component)this.allCells, gridBagConstraints);
        this.whichCells.add(this.onlyCellsUsedElsewhere);
        this.onlyCellsUsedElsewhere.setText("Only those used elsewhere");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.getContentPane().add((Component)this.onlyCellsUsedElsewhere, gridBagConstraints);
        this.whichCells.add(this.onlyCellsNotUsedElsewhere);
        this.onlyCellsNotUsedElsewhere.setText("Only those not used elsewhere");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.getContentPane().add((Component)this.onlyCellsNotUsedElsewhere, gridBagConstraints);
        this.whichCells.add(this.onlyCellsUnderCurrent);
        this.onlyCellsUnderCurrent.setText("Only those under current cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.getContentPane().add((Component)this.onlyCellsUnderCurrent, gridBagConstraints);
        this.whichCells.add(this.onlyPlaceholderCells);
        this.onlyPlaceholderCells.setText("Only placeholder cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 4, 4);
        this.getContentPane().add((Component)this.onlyPlaceholderCells, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText("View filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.onlyThisView.setText("Show only this view:");
        this.onlyThisView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellLists.this.onlyThisViewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.getContentPane().add((Component)this.onlyThisView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 40, 4, 4);
        this.getContentPane().add((Component)this.views, gridBagConstraints);
        this.alsoIconViews.setText("Also include icon views");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.getContentPane().add((Component)this.alsoIconViews, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel3.setText("Version filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.excludeOlderVersions.setText("Exclude older versions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.getContentPane().add((Component)this.excludeOlderVersions, gridBagConstraints);
        this.excludeNewestVersions.setText("Exclude newest versions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 4, 4);
        this.getContentPane().add((Component)this.excludeNewestVersions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel4.setText("Display ordering:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.ordering.add(this.orderByName);
        this.orderByName.setText("Order by name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.getContentPane().add((Component)this.orderByName, gridBagConstraints);
        this.ordering.add(this.orderByDate);
        this.orderByDate.setText("Order by modification date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.getContentPane().add((Component)this.orderByDate, gridBagConstraints);
        this.ordering.add(this.orderByStructure);
        this.orderByStructure.setText("Order by skeletal structure");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 4, 4);
        this.getContentPane().add((Component)this.orderByStructure, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        this.jLabel5.setText("Destination:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.destination.add(this.displayInMessages);
        this.displayInMessages.setText("Display in messages window");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.getContentPane().add((Component)this.displayInMessages, gridBagConstraints);
        this.destination.add(this.saveToDisk);
        this.saveToDisk.setText("Save to disk");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 4, 4);
        this.getContentPane().add((Component)this.saveToDisk, gridBagConstraints);
        this.evaluateNumerically.setText("Evaluate Numbers when Sorting Names");
        this.evaluateNumerically.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.evaluateNumerically.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 40, 0, 4);
        this.getContentPane().add((Component)this.evaluateNumerically, gridBagConstraints);
        this.pack();
    }

    private void onlyThisViewActionPerformed(ActionEvent evt) {
        boolean selected = this.onlyThisView.isSelected();
        this.views.setEnabled(selected);
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        new GeneralCellListsJob(this.curCell, this.allCells.isSelected(), this.onlyCellsUnderCurrent.isSelected(), this.onlyCellsUsedElsewhere.isSelected(), this.onlyCellsNotUsedElsewhere.isSelected(), this.onlyThisView.isSelected(), (String)this.views.getSelectedItem(), this.alsoIconViews.isSelected(), this.excludeOlderVersions.isSelected(), this.excludeNewestVersions.isSelected(), this.orderByName.isSelected(), this.evaluateNumerically.isSelected(), this.orderByDate.isSelected(), this.orderByStructure.isSelected(), this.saveToDisk.isSelected()).startJob();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        if (this.allCells.isSelected()) {
            whichSwitch = 0;
        } else if (this.onlyCellsUsedElsewhere.isSelected()) {
            whichSwitch = 1;
        } else if (this.onlyCellsNotUsedElsewhere.isSelected()) {
            whichSwitch = 2;
        } else if (this.onlyCellsUnderCurrent.isSelected()) {
            whichSwitch = 3;
        } else if (this.onlyPlaceholderCells.isSelected()) {
            whichSwitch = 4;
        }
        onlyViewSwitch = this.onlyThisView.isSelected();
        viewSwitch = View.findView((String)this.views.getSelectedItem());
        alsoIconSwitch = this.alsoIconViews.isSelected();
        excOldVersSwitch = this.excludeOlderVersions.isSelected();
        excNewVersSwitch = this.excludeNewestVersions.isSelected();
        evaluateNumbers = this.evaluateNumerically.isSelected();
        if (this.orderByName.isSelected()) {
            orderingSwitch = 0;
        } else if (this.orderByDate.isSelected()) {
            orderingSwitch = 1;
        } else if (this.orderByStructure.isSelected()) {
            orderingSwitch = 2;
        }
        if (this.displayInMessages.isSelected()) {
            destinationSwitch = 0;
        } else if (this.saveToDisk.isSelected()) {
            destinationSwitch = 1;
        }
        this.setVisible(false);
        this.dispose();
    }

    private static class DescribeThisCellJob
    extends Job {
        private Cell cell;
        private DRC.DRCPreferences dp = new DRC.DRCPreferences(false);

        public DescribeThisCellJob(Cell cell) {
            super("DescribeThisCell", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        @Override
        public boolean doIt() {
            int maxLen = this.cell.describe(false).length();
            CellLists.printHeaderLine(maxLen);
            String line = CellLists.makeCellLine(this.cell, maxLen, this.dp);
            System.out.println(line);
            ERectangle bounds = this.cell.getBounds();
            Technology tech = this.cell.getTechnology();
            System.out.println("Cell runs from " + TextUtils.formatDistance(bounds.getMinX(), tech) + " <= X <= " + TextUtils.formatDistance(bounds.getMaxX(), tech) + " and " + TextUtils.formatDistance(bounds.getMinY(), tech) + " <= Y <= " + TextUtils.formatDistance(bounds.getMaxY(), tech));
            return true;
        }
    }

    private static class GeneralCellListsJob
    extends Job {
        private final Cell curCell;
        private final boolean allCells;
        private final boolean onlyCellsUnderCurrent;
        private final boolean onlyCellsUsedElsewhere;
        private final boolean onlyCellsNotUsedElsewhere;
        private final boolean onlyThisView;
        private final String viewName;
        private final boolean alsoIconViews;
        private final boolean excludeOlderVersions;
        private final boolean excludeNewestVersions;
        private final boolean orderByName;
        private final boolean evaluateNumerically;
        private final boolean orderByDate;
        private final boolean orderByStructure;
        private final boolean saveToDisk;
        private final String saveNameFile;
        private DRC.DRCPreferences dp = new DRC.DRCPreferences(false);

        private GeneralCellListsJob(Cell curCell, boolean allCells, boolean onlyCellsUnderCurrent, boolean onlyCellsUsedElsewhere, boolean onlyCellsNotUsedElsewhere, boolean onlyThisView, String viewName, boolean alsoIconViews, boolean excludeOlderVersions, boolean excludeNewestVersions, boolean orderByName, boolean evaluateNumerically, boolean orderByDate, boolean orderByStructure, boolean saveToDisk) {
            super("GeneralCellLists", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.allCells = allCells;
            this.onlyCellsUnderCurrent = onlyCellsUnderCurrent;
            this.onlyCellsUsedElsewhere = onlyCellsUsedElsewhere;
            this.onlyCellsNotUsedElsewhere = onlyCellsNotUsedElsewhere;
            this.onlyThisView = onlyThisView;
            this.viewName = viewName;
            this.alsoIconViews = alsoIconViews;
            this.excludeOlderVersions = excludeOlderVersions;
            this.excludeNewestVersions = excludeNewestVersions;
            this.orderByName = orderByName;
            this.evaluateNumerically = evaluateNumerically;
            this.orderByDate = orderByDate;
            this.orderByStructure = orderByStructure;
            this.saveToDisk = saveToDisk;
            this.saveNameFile = saveToDisk ? OpenFile.chooseOutputFile(FileType.READABLEDUMP, null, "celllist.txt") : null;
        }

        @Override
        public boolean doIt() {
            Cell cell4;
            Iterator<Cell> cIt;
            Library lib;
            Iterator<Library> it;
            View v;
            Cell cell22;
            Iterator<Cell> cIt2;
            Library lib2;
            Iterator<Library> it2;
            HashSet<Cell> cellsSeen = new HashSet<Cell>();
            if (this.allCells) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        cellsSeen.add(cell22);
                    }
                }
            } else if (this.onlyCellsUnderCurrent) {
                GeneralCellListsJob.recursiveMark(this.curCell, cellsSeen);
            } else if (this.onlyCellsUsedElsewhere) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        iconCell = cell22.iconView();
                        if (iconCell == null) {
                            iconCell = cell22;
                        }
                        if (!cell22.getInstancesOf().hasNext() && !iconCell.getInstancesOf().hasNext()) continue;
                        cellsSeen.add(cell22);
                    }
                }
            } else if (this.onlyCellsNotUsedElsewhere) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        iconCell = cell22.iconView();
                        if (iconCell != null) {
                            if (cell22.getInstancesOf().hasNext()) continue;
                            found = false;
                            nIt = iconCell.getInstancesOf();
                            while (nIt.hasNext()) {
                                ni = nIt.next();
                                if (!ni.isIconOfParent()) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                continue;
                            }
                        } else if (cell22.isIcon()) {
                            found = false;
                            nIt = cell22.getInstancesOf();
                            while (nIt.hasNext()) {
                                ni = nIt.next();
                                if (!ni.isIconOfParent()) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                continue;
                            }
                        } else if (cell22.getInstancesOf().hasNext()) continue;
                        cellsSeen.add(cell22);
                    }
                }
            } else {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        Variable var = cell22.getVar("IO_true_library");
                        if (var == null) continue;
                        cellsSeen.add(cell22);
                    }
                }
            }
            if (this.onlyThisView && (v = View.findView(this.viewName)) != null) {
                it = Library.getLibraries();
                while (it.hasNext()) {
                    lib = it.next();
                    cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        cell4 = cIt.next();
                        if (cell4.getView() == v || cell4.isIcon() && this.alsoIconViews) continue;
                        cellsSeen.remove(cell4);
                    }
                }
            }
            if (this.excludeOlderVersions) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        if (cell22.getNewestVersion() == cell22) continue;
                        cellsSeen.remove(cell22);
                    }
                }
            }
            if (this.excludeNewestVersions) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        cell22 = cIt2.next();
                        if (cell22.getNewestVersion() != cell22) continue;
                        cellsSeen.remove(cell22);
                    }
                }
            }
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            it = Library.getLibraries();
            while (it.hasNext()) {
                lib = it.next();
                if (lib.isHidden()) continue;
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell4 = cIt.next();
                    if (!cellsSeen.contains(cell4)) continue;
                    cellList.add(cell4);
                }
            }
            if (cellList.size() == 0) {
                System.out.println("No cells match this request");
            } else {
                if (this.orderByName) {
                    if (this.evaluateNumerically) {
                        Collections.sort(cellList);
                    } else {
                        Collections.sort(cellList, new TextUtils.CellsByName());
                    }
                } else if (this.orderByDate) {
                    Collections.sort(cellList, new TextUtils.CellsByDate());
                } else if (this.orderByStructure) {
                    Collections.sort(cellList, new SortByCellStructure());
                }
                if (this.saveToDisk) {
                    if (this.saveNameFile == null) {
                        System.out.println("Cannot write cell listing");
                    } else {
                        FileOutputStream fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(this.saveNameFile);
                        }
                        catch (FileNotFoundException lib3) {
                            // empty catch block
                        }
                        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
                        DataOutputStream dataOutputStream = new DataOutputStream(bufStrm);
                        try {
                            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                            Object header = "List of cells created on " + df.format(new Date()) + "\n";
                            dataOutputStream.write(((String)header).getBytes(), 0, ((String)header).length());
                            header = "Cell\tVersion\tCreation date\tRevision Date\tSize\tUsage\tLock\tInst-lock\tCell-lib\tDRC\tNCC\n";
                            dataOutputStream.write(((String)header).getBytes(), 0, ((String)header).length());
                            for (Cell cell3 : cellList) {
                                String line = CellLists.makeCellLine(cell3, -1, this.dp) + "\n";
                                dataOutputStream.write(line.getBytes(), 0, line.length());
                            }
                            dataOutputStream.close();
                            System.out.println("Wrote " + this.saveNameFile);
                        }
                        catch (IOException e) {
                            System.out.println("Error closing " + this.saveNameFile);
                        }
                    }
                } else {
                    int maxLen = 0;
                    for (Cell cell22 : cellList) {
                        maxLen = Math.max(maxLen, cell22.noLibDescribe().length());
                    }
                    maxLen = Math.max(maxLen + 2, 7);
                    CellLists.printHeaderLine(maxLen);
                    lib = null;
                    for (Cell cell4 : cellList) {
                        if (cell4.getLibrary() != lib) {
                            lib = cell4.getLibrary();
                            System.out.println("======== LIBRARY " + lib.getName() + ": ========");
                        }
                        System.out.println(CellLists.makeCellLine(cell4, maxLen, this.dp));
                    }
                }
            }
            return true;
        }

        private static void recursiveMark(Cell cell, Set<Cell> cellsSeen) {
            if (cellsSeen.contains(cell)) {
                return;
            }
            cellsSeen.add(cell);
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell subCell = (Cell)ni.getProto();
                GeneralCellListsJob.recursiveMark(subCell, cellsSeen);
                Cell contentsCell = subCell.contentsView();
                if (contentsCell == null) continue;
                GeneralCellListsJob.recursiveMark(contentsCell, cellsSeen);
            }
        }
    }

    private static class SortByCellStructure
    implements Comparator<Cell> {
        private SortByCellStructure() {
        }

        @Override
        public int compare(Cell c1, Cell c2) {
            int ys2;
            int xs2;
            ERectangle b1 = c1.getBounds();
            ERectangle b2 = c2.getBounds();
            int xs1 = (int)((RectangularShape)b1).getWidth();
            if (xs1 != (xs2 = (int)((RectangularShape)b2).getWidth())) {
                return xs1 - xs2;
            }
            int ys1 = (int)((RectangularShape)b1).getHeight();
            if (ys1 != (ys2 = (int)((RectangularShape)b2).getHeight())) {
                return ys1 - ys2;
            }
            int pc1 = c1.getNumPorts();
            pc1 = 0;
            int pc2 = c2.getNumPorts();
            if (pc1 != pc2) {
                return pc1 - pc2;
            }
            return 0;
        }
    }
}

