#define STAGE1_DECIM	5
#define STAGE2_DECIM	10
#define CHANNEL_BW	100e3

#define NEWFILT 0

#define SCA 0

/* -*- Mode: c++ -*-
*******************************************************************************
*
* File:         hifi_fm.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <make_GrMC4020Source.h>
#include <GrFFTSink.h>
#include <VrFixOffset.h>
#include <VrComplexFIRfilter.h>
#include <VrQuadratureDemod.h>
#include <GrFIRfilterFSF.h>
#include <VrAudioSink.h>
#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrAudioSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <VrGUI.h>
#include <VrInterpolatingSigProc.h>
#include <GrSimpleScopeSink.h>
#include <GrFreqXlatingFIRfilterSCF.h>
#include <GrIIRfilter.h>
// #include <GrCostasLoop.h>
#include <gr_firdes.h>


const int inputRate = 20000000;
const float FM_IF_Freq = 5.75e6;
const float IF_Freq = FM_IF_Freq;

const int chanTaps = 75; // 75, 150
const int CFIRdecimate = 50;
const float chanGain = 2.0;

const int InterpFactor = 3;
const float fm_demodGain = 8800; // 2200,1100,4400,8800

const float interpGain = 1.0; //HIFI

const int RFIRdecimate = 25; // HIFI, was 10
const int audioTaps = 100; // HIFI, was 50
const float audioGain = 10.0;

const int quadRate = inputRate / CFIRdecimate;
const int audioRate = quadRate * InterpFactor / RFIRdecimate; // HIFI


int main(int argc, char **argv)
{
  //float volume = 1.0;

  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();
  VrGUILayout *vert2 = horiz->horizontal()->vertical();


  cerr << "Input Sampling Rate: " << inputRate << endl;
  cerr << "Complex FIR decimation factor: " << CFIRdecimate << endl;
  cerr << "QuadDemod Sampling Rate: " << quadRate << endl;
  cerr << "Interpolation Factor: " << InterpFactor << endl;
  cerr << "Real FIR decimation factor: " << RFIRdecimate << endl;
  cerr << "Audio Sampling Rate: " << audioRate << endl;

  // --> short
 // VrSource<short>*source = new VrFileSource<short>(20000000,"hdtv_563.dat",0);
  
  VrSource<short> *source = 
    make_GrMC4020SourceS(inputRate, MCC_CH3_EN | MCC_ALL_1V);

  // short --> short 
  VrFixOffset<short,short> *offset_fixer =
    new VrFixOffset<short,short>();


  vector<float> channel_coeffs_stage1 =
	gr_firdes::low_pass (1.0, inputRate, CHANNEL_BW, 
			(inputRate/STAGE1_DECIM/2-CHANNEL_BW)*.8,
			gr_firdes::WIN_HAMMING);

  cerr << "Number of channel_coeffs stage 1: " << channel_coeffs_stage1.size () << endl;

  vector<float> channel_coeffs_stage2 =
	gr_firdes::low_pass (1.0, inputRate/STAGE1_DECIM, CHANNEL_BW,
			(inputRate/STAGE1_DECIM/STAGE2_DECIM/2-CHANNEL_BW)*.8,
			gr_firdes::WIN_HANN);

  cerr << "Number of channel_coeffs stage 2: " << channel_coeffs_stage2.size () << endl;

  // short --> VrComplex
  GrFreqXlatingFIRfilterSCF *chanfilt1 =
    new GrFreqXlatingFIRfilterSCF (STAGE1_DECIM, 
				   channel_coeffs_stage1, IF_Freq);

  // short --> VrComplex
  GrFreqXlatingFIRfilterSCF *chanfilt2 =
    new GrFreqXlatingFIRfilterSCF (STAGE2_DECIM, 
				   channel_coeffs_stage2, 0);

  VrComplexFIRfilter<short>* chanfilt = 
    new VrComplexFIRfilter<short>(50, chanTaps, IF_Freq, chanGain);

  // VrComplex --> float
  VrQuadratureDemod<float> *fm_demod =
    new VrQuadratureDemod<float>(1000); //fm_demodGain);

  VrInterpolatingSigProc<float,float> *simple_interp =
    new VrInterpolatingSigProc<float,float>(1,3);  //RFIRinterp);

 double transition_bw = 4e3;
   vector<float> audio_coeffs =
	             gr_firdes::low_pass (audioGain,12e5,16500,transition_bw,gr_firdes::WIN_HAMMING);

   cerr << "number of audio_coeffs: " << audio_coeffs.size () << endl;


   //  GrCostasLoop<float,float> *testcostas =
   //	  new GrCostasLoop<float,float>(1,0,0,0);

  // float --> short
  GrFIRfilterFSF *audio_filter =
    new GrFIRfilterFSF (RFIRdecimate, audio_coeffs);

#define TAU 75e-6  // 75us in US, 50us in EUR  
  vector<double> fftaps = vector<double>(2);
  vector <double> fbtaps = vector<double>(2);

  fftaps[0] = 1 - exp(-1/TAU/inputRate*50);
  fftaps[1] = 0;
  fbtaps[0] = 0;
  fbtaps[1] = exp(-1/TAU/inputRate*50);;

  GrIIRfilter<float,float,double> *deemph2 =
    new GrIIRfilter<float,float,double> (1,fftaps,fbtaps); 

  // sink1 is channel filter output
  VrSink<VrComplex> *fft_sink1 = new GrFFTSink<VrComplex>(vert, 40, 100, 512);

  // sink2 is channel filter output
  VrSink<float> *fft_sink2 = new GrFFTSink<float>(vert, -30, 100, 512);

  // sink3 is fm demod output
  VrSink<float> *fft_sink3 = new GrFFTSink<float>(vert2, -30, 100, 512);

  // sink4 is audio output
  VrSink<short> *fft_sink4 = new GrFFTSink<short>(vert2, -30, 100, 512);

  VrSink<short> *audio_sink = new VrAudioSink<short>("/dev/dsp");

  VrComplexFIRfilter<float> *sca_if_filter = new VrComplexFIRfilter<float>(5,50,67000,1);

  VrQuadratureDemod<float> *sca_demod = new VrQuadratureDemod<float>(1000);

  double sca_audio_transition_bw = 1e3;
  vector<float> sca_audio_coeffs =
    gr_firdes::low_pass (1,80e3,5e3,sca_audio_transition_bw,gr_firdes::WIN_HAMMING);

  cerr << "number of sca audio_coeffs: " << sca_audio_coeffs.size () << endl;

  GrFIRfilterFSF *sca_audio_filter = new GrFIRfilterFSF (5, sca_audio_coeffs);
  
  NWO_CONNECT (source, offset_fixer);
  
  if(NEWFILT)
  {
  	NWO_CONNECT (offset_fixer, chanfilt1);
  	NWO_CONNECT (chanfilt1, chanfilt2);
  	NWO_CONNECT (chanfilt2, fm_demod);
  	NWO_CONNECT (chanfilt1, fft_sink1);
  	NWO_CONNECT (chanfilt2, fft_sink2);
  }
  else
  {
  	NWO_CONNECT (offset_fixer, chanfilt);
  	NWO_CONNECT (chanfilt, fm_demod);
  	NWO_CONNECT (chanfilt, fft_sink1);
  	NWO_CONNECT (fm_demod, fft_sink2);
  }

  NWO_CONNECT (fm_demod, deemph2);
  if(SCA)
  {
	NWO_CONNECT (deemph2, sca_if_filter);
	NWO_CONNECT (sca_if_filter, sca_demod);
	NWO_CONNECT (sca_demod, sca_audio_filter);
	NWO_CONNECT (sca_demod, fft_sink3);
  	NWO_CONNECT (sca_audio_filter, fft_sink4);
	NWO_CONNECT (sca_audio_filter, audio_sink);
  }
  else
  {
	NWO_CONNECT (deemph2, fft_sink3);
	NWO_CONNECT (deemph2, simple_interp);
	NWO_CONNECT (simple_interp, audio_filter);
  	NWO_CONNECT (audio_filter, audio_sink);
  	NWO_CONNECT (audio_filter, fft_sink4);
  }

  VrMultiTask *m = new VrMultiTask ();
  m->add (fft_sink1);
  m->add (fft_sink2);
  m->add (fft_sink3);
  m->add (fft_sink4);
  m->add (audio_sink);

  m->start ();
  guimain->start ();

  while (1){
    guimain->processEvents(10 /*ms*/);
    m->process();
  }  
}

