/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GR_FIR_BUILDERS_H_
#define _GR_FIR_BUILDERS_H_

#include <vector>

/*!
 * \brief lame way in C++ to get a closure.
 * (I'd really prefer a straight forward lambda expression)
 *
 * Subclass this and pass the object to GrFIRfilterXXX or 
 * GrFreqXlatingFIRfilter constructor to delay the filter design until 
 * the sample rate is known in initialize...
 */

class gr_fir_builderS {
 public:
  virtual ~gr_fir_builderS () {};

  //! given \p sampling_freq return a vector of taps
  virtual std::vector<short> taps (double sampling_freq) = 0;
};

#endif /* _GR_FIR_BUILDER_H_ */
