/* -*- c++ -*- */
/*
 * Copyright 2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

class gr_msg_queue;
typedef boost::shared_ptr<gr_msg_queue> gr_msg_queue_sptr;
%template(gr_msg_queue_sptr) boost::shared_ptr<gr_msg_queue>;

%rename(msg_queue) gr_make_msg_queue;
gr_msg_queue_sptr gr_make_msg_queue ();

/*!
 * \brief thread-safe message queue
 */
%ignore gr_msg_queue;
class gr_msg_queue : public gr_msg_handler {
  omni_mutex		d_mutex;
  omni_condition	d_cond;
  gr_message_sptr	d_head;
  gr_message_sptr	d_tail;
  int			d_count;

public:
  gr_msg_queue ();
  ~gr_msg_queue ();

  //! Generic msg_handler method: insert the message.
  void handle (gr_message_sptr msg) { insert_tail (msg); }

  /*!
   * \brief insert \p msg at tail of queue
   * \param msg message
   */
  void insert_tail (gr_message_sptr msg);

  /*!
   * \brief Delete message from head of q and return it.
   * Block if no message is available.
   */
  gr_message_sptr delete_head ();

  /*!
   * \brief If there's a message in the q, delete it and return it.
   * If no message is available, return 0.
   */
  gr_message_sptr delete_head_nowait ();
  
  //! is the queue empty?
  bool empty_p () const { return d_count == 0; }
  
  //! return number of messages in queue
  int count () const { return d_count; }

  //! Delete all messages from the queue
  void flush ();
};
