;; Copyright (C) 2006 Free Software Foundation, Inc.
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public
;; License along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(load "tests.scm")
(or (getenv "DISPLAY")
    (begin
      (display "Cannot run gdk-gl tests without an X display\n")
      (exit 77)))

;; the source tree doesn't have gdk-gl.scm under the gtk-1.2 directory, so
;; can't use-modules it, instead load it directly
(primitive-load (string-append (getenv "srcdir")
			       "/../gtk-gl/gdk-gl.scm"))
;; then switch back to the normal guile-user module
(define-module (guile-user))

(use-modules (gtk-1.2 gtk)
	     (gtk-1.2 gdk-gl))



;;
;; gdk-gl-query
;;

(malloced-steady
 (lambda ()
   (let* ((query (gdk-gl-query))
	  (want  #t)
	  (got   (or (eq? #t query)
		     (eq? #f query))))
     (test  "gdk-gl-query" query want got))))


(tests-end)
