import os
import sys
import mozharness

external_tools_path = os.path.join(
    os.path.abspath(os.path.dirname(os.path.dirname(mozharness.__file__))),
    'external_tools',
)

config = {
    "virtualenv_python_dll": 'c:/mozilla-build/python27/python27.dll',
    "virtualenv_path": 'venv',
    "exes": {
        'python': 'c:/mozilla-build/python27/python',
        'virtualenv': ['c:/mozilla-build/python27/python', 'c:/mozilla-build/buildbotve/virtualenv.py'],
        'hg': 'c:/mozilla-build/hg/hg',
        'mozinstall': ['%s/build/venv/scripts/python' % os.getcwd(),
                       '%s/build/venv/scripts/mozinstall-script.py' % os.getcwd()],
        'tooltool.py': [sys.executable, 'C:/mozilla-build/tooltool.py'],
        'gittool.py': [sys.executable,
                       os.path.join(external_tools_path, 'gittool.py')],
        'hgtool.py': [sys.executable,
                      os.path.join(external_tools_path, 'hgtool.py')],


    },

    "find_links": [
        "http://pypi.pvt.build.mozilla.org/pub",
        "http://pypi.pub.build.mozilla.org/pub",
    ],
    "pip_index": False,

    "buildbot_json_path": "buildprops.json",

    "default_actions": [
        'clobber',
        'read-buildbot-config',
        'checkout',
        'download-and-extract',
        'create-virtualenv',
        'install',
        'run-media-tests',
    ],
    "default_blob_upload_servers": [
         "https://blobupload.elasticbeanstalk.com",
    ],
    "blob_uploader_auth_file" : os.path.join(os.getcwd(), "oauth.txt"),
    "in_tree_config": "config/mozharness/marionette.py",
    "download_minidump_stackwalk": True,
    "download_symbols": "ondemand",

    "icecat_media_repo": 'https://github.com/mjzffr/icecat-media-tests.git',
    "icecat_media_branch": 'master',
    "icecat_media_rev": '49b500b30b80372a6c678ec7d0a2b074844f5e84',
    "icecat_ui_repo": 'https://github.com/mozilla/icecat-ui-tests.git',
    "icecat_ui_branch": 'mozilla-central',
    "icecat_ui_rev": '32be49d74e1d10c6bf087235b1d6753c1b840bc4',

    "suite_definitions": {
        "media-tests": {
            "options": [],
        },
        "media-youtube-tests": {
            "options": [
                "%(test_manifest)s"
            ],
        },
    },
}
