
;;; d-flock.el --- My personal syntax highlighting preferences

;; Copyright (C) 2006-2015 Davin Pearson

;; Author/Maintainer: m4_davin_pearson
;; Keywords: My personal syntax highlighting font lock preferences
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; When you learn how to customise Emacs' syntax highlighting
;; preferences, it becomes an addictive activity adding new syntax
;; highlighting rules to make debugging your code easier.  This file
;; contains almost all of my syntax highlighting customisations that
;; are practical to fit into a single file like this one.  Warning:
;; overuse of this feature can render your code like Las Vegas.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-flock)

;;; Known Bugs:

;; Error during redisplay: (jit-lock-function *) signaled
;; (invalid-regexp "Unmatched [ or [^")
;;
;; Error during redisplay: ( 1) signaled (invalid-function 1)
;;
;; Invalid face reference: quote [55 times]
;;

;;; Code:

(progn
  (setq fg:lightred                             'fg:lightred)
  (setq d-face-cc-illegal-type                  'd-face-cc-illegal-type)
  (setq d-face-super-comment                    'd-face-super-comment)
  (setq d-face-cc-allegro                       'd-face-cc-allegro)
  (setq fg:white                                'fg:white)
  (setq bg:lightmagenta                         'bg:lightmagenta)
  (setq d-face-cc-debugging                     'd-face-cc-debugging)
  (setq bg:lightgreen                           'bg:lightgreen)
  (setq d-face-property-inverse                 'd-face-property-inverse)
  (setq d-face-cc-debugging                     'd-face-cc-debugging)
  (setq fg:lightmagenta                         'fg:lightmagenta)
  (setq fg:lightgreen                           'fg:lightgreen)
  (setq d-face-m4                               'd-face-m4)
  (setq d-face-m4-dnl                           'd-face-m4-dnl)
  (setq d-face-cc-digits                        'd-face-cc-digits)
  (setq d-debug-face                            'd-debug-face)
  (setq d-checkpoint-face                       'd-checkpoint-face)
  (setq d-face-el-quote                         'd-face-el-quote)
  (setq d-face-cc-debugging                     'd-face-cc-debugging)
  (setq d-face-cc-allegro                       'd-face-cc-allegro)
  (setq d-face-cc-illegal-type                  'd-face-cc-illegal-type)
  (setq bg:yellow                               'bg:yellow)
  (setq d-face-cc-libd                          'd-face-cc-libd)
  (setq d-face-cc-ctor-dtor                     'd-face-cc-ctor-dtor)
  (setq d-face-cc-clib                          'd-face-cc-clib)
  (setq fg:lightmagenta                         'fg:lightmagenta)
  (setq d-face-cc-global                        'd-face-cc-global)
  (setq d-face-cc-illegal-type                  'd-face-cc-illegal-type)
  (setq d-face-red-and-white                    'd-face-red-and-white)
  (setq d-face-green-and-black                  'd-face-green-and-black)
  (setq d-face-el-d-stuff                       'd-face-el-d-stuff)
  (setq d-face-el-quote                         'd-face-el-quote)
  (setq d-face-cc-opengl                        'd-face-cc-opengl)
  (setq d-face-makefile-dollar-dollar-highlight 'd-face-makefile-dollar-dollar-highlight)
  (setq d-face-makefile-dollar-dollar           'd-face-makefile-dollar-dollar)
  (setq fg:white                                'fg:white)
  (setq bg:lightmagenta                         'bg:lightmagenta)
  (setq d-face-cc-debugging                     'd-face-cc-debugging)
  (setq d-face-cc-private                       'd-face-cc-private)
  (setq bg:lightgreen                           'bg:lightgreen)
  (setq d-face-property                         'd-face-property)
  (setq d-face-property-inverse                 'd-face-property-inverse)
  (setq fg:lightmagenta                         'fg:lightmagenta)
  (setq fg:lightgreen                           'fg:lightgreen)
  (setq fg:lightmagenta                         'fg:lightmagenta)
  (setq fg:lightmagenta                         'fg:lightmagenta)
  (setq fg:lightgreen                           'fg:lightgreen)
  (setq fg:red                                  'fg:red)
  (setq fg:lightred                             'fg:lightred)
  (setq bg:lightred                             'bg:lightred)
  (setq bg:yellow                               'bg:yellow)
  (setq d-face-path                             'd-face-path)
  (setq d-face-red-and-yellow                   'd-face-red-and-yellow)
  (setq dc-face-dired-web                       'dc-face-dired-web)
  (setq dc-face-dired-text                      'dc-face-dired-text)
  (setq dc-face-dired-executable                'dc-face-dired-executable)
  (setq dc-face-dired-sounds                    'dc-face-dired-sounds)
  (setq dc-face-dired-sources                   'dc-face-dired-sources)
  (setq dc-face-dired-archives                  'dc-face-dired-archives)
  (setq dc-face-dired-graphics                  'dc-face-dired-graphics)
  (setq dc-face-dired-movies                    'dc-face-dired-movies)
  (setq dc-face-dired-unimportant               'dc-face-dired-unimportant)
  (setq d-face-m4                               'd-face-m4)
  (setq d-face-m5                               'd-face-m5)
  (setq d-face-m6                               'd-face-m6)
  (setq d-face-makefile-space                   'd-face-makefile-space)
  (setq d-face-el-d-stuff2                      'd-face-el-d-stuff2)
  (setq d-face-green-and-yellow                 'd-face-green-and-yellow)
  (setq default                                 'default)
  (setq bold                                    'bold)
  (setq fg:lightblue                            'fg:lightblue)
  (setq underline                               'underline)
  (setq d-face-html-entity                      'd-face-html-entity)
  (setq fg:brown                                'fg:brown)
  )

(require 'd-flock-coding-preferences)
(require 'd-flock-lisp++)
(require 'd-flock-private)
(require 'dired-colours)

(progn
  (add-hook 'font-lock-mode-hook 'd-font-lock-mode-hook)
  (add-hook 'font-lock-mode-hook 'd-80-column-hook t)
  (add-hook 'font-lock-mode-hook 'd-font-lock-mode-hook--post t)
  (setq parse-sexp-ignore-comments t)
  )

(defun d-flock-checkpoint (str)
  ;;(message "d-flock-checkpoint=%s" str)
  )

(defun d-font-lock-add-begin (keywords)
  (if (fboundp 'font-lock-add-keywords)
      (font-lock-add-keywords nil keywords nil)
    (setq font-lock-keywords
          (append
           keywords
           font-lock-keywords))))

(defun d-font-lock-add-end (keywords)
  (if (fboundp 'font-lock-add-keywords)
      (font-lock-add-keywords nil keywords 'end)
    (setq font-lock-keywords
          (append
           font-lock-keywords
           keywords))))

;;;
;;; NOTE: This function can stuff up font-lock-mode-hook and therefore post-command-hook
;;;
;;; (d-font-lock-mode-hook)
(defun d-font-lock-mode-hook ()

  ;; removes FONT from modeline:
  ;;(if (assq 'font-lock-mode minor-mode-alist)
  ;;    (setcar (cdr (assq 'font-lock-mode minor-mode-alist)) " F"))

  (d-flock-checkpoint "1")

  ;;; COOL: font-lock-string-face
  (if (eq major-mode 'fundamental-mode)
      (setq font-lock-string-face nil)
    (set (make-local-variable 'font-lock-string-face) 'font-lock-string-face))

  (setq font-lock-keywords-case-fold-search nil)

  (d-flock-checkpoint "2")

  (d-flock-checkpoint "3")

  (when (and prefs-font-lisp++-p
             (or (eq major-mode 'emacs-lisp-mode)
                 (eq major-mode 'text-mode)
                 (and (buffer-file-name)
                      (or (string-match "eraseme" (buffer-file-name))
                          (string-match "\\.\\(method\\|lisp[+][+]\\|temp\\)$" (buffer-file-name))
                          )
                      )))
    (d-font-lock-add-begin
     '(
       ("std::" 0 fg:lightred t)
       ("\\<jit-lock-stealth-fontify\\>" 0 d-face-cc-illegal-type nil)
       ("\\<jit-lock-refontify\\>"       0 d-face-cc-illegal-type nil)
       ("\\<font-lock-fontify-buffer\\>" 0 fg:lightred            nil)
       )))

  (d-flock-checkpoint "4")

  ;;(d-flock-checkpoint "5")
  (if (eq major-mode 'tes-mode)
      (d-font-lock-add-begin
       '(
         ("\\(\\\\index\\){\\([^{}]*\\)}" (1 bold nil) (2 bg:lightgreen t))
         ("^%.*$"            0 font-lock-comment-face t)
         ("^%%%+.*$"         0 d-face-super-comment t)
         ("^[ \t]*\\(\\\\begin\\){\\([^{}]*\\)}"          (1 bold nil) (2 font-lock-function-name-face nil))
         ("^[ \t]*\\(\\\\end\\){\\([^{}]*\\)}"            (1 bold nil) (2 font-lock-function-name-face nil))
         ("^[ \t]*\\(\\\\part\\){\\([^\r\n]*\\)}"            (1 bold nil) (2 font-lock-function-name-face nil))
         ("^[ \t]*\\(\\\\chapter\\){\\([^\r\n]*\\)}"            (1 bold nil) (2 font-lock-function-name-face nil))
         ("^[ \t]*\\(\\\\\\(sub\\)*section\\)[*]?{\\([^\r\n]*\\)}" (1 bold nil) (3 font-lock-function-name-face nil))
         ("^[ \t]*\\(\\\\documentclass\\)\\[\\([^\r\n]*\\)\\]{\\([^\r\n]*\\)}"
          (1 bold nil)
          (2 font-lock-function-name-face nil)
          (3 font-lock-function-name-face nil))
         ;;("^\\(include\\)(\\([^()]*\\))"            (1 bold nil) (2 fg:lightgreen nil))
         ("^[ \t]*\\(\\\\include\\){\\([^\r\n]*\\)}"        (1 bold nil) (2 fg:lightgreen nil))
         ("\\(\\<TT\\)(\\([^()]*\\))"               (1 bold nil) (2 fg:lightred nil))
         ("\\(\\<TT\\)(\\([^()]*([^()]*)[^()]*\\))" (1 bold nil) (2 fg:lightred nil))
         ("\\(\\<EM\\)(\\([^()]*\\))"               (1 bold nil) (2 italic nil))
         ("\\(\\<EM\\)(\\([^()]*([^()]*)[^()]*\\))" (1 bold nil) (2 fg:lightred nil))
         ("\\(\\<m4_ignore\\)("                        (1 d-face-m4-dnl nil))
         ("\\<m4[a-z]+" 0 d-face-cc-illegal-type nil)
         ("\\\\item\\>" 0 bold nil)
         ("\\<\\(BO\\)\\(([^()]*)\\)" (1 fg:lightred t) (2 bold nil))
         ("\\(\\<m4_[a-zA-Z0-9_]*\\)"  1 d-face-m4 t)
         ("\\\\noindent" 0 bold nil)
         ("\\(^\\|[^\\\\]\\)\\(%.*\\)$" 2 font-lock-comment-face nil)
         )
       )
    )

  (when (and prefs-font-lisp++-p
             (buffer-file-name)
             (or (eq major-mode 'c++-mode)
                 (string-match "eraseme" (buffer-file-name))
                 (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name))))
     ;;(d-foo)
    (d-font-lock-add-end
     '(
       ;;("\\<\\(ctor\\)\\>" 1 d-face-cc-ctor-dtor nil)
       ("\\<\\(ASSERT\\|assert\\)\\>" 1 font-lock-keyword-face nil)
       ("\\<safe_[a-z_]+"             0 d-face-cc-allegro nil)
       ;;("0x[0-9a-fA-F]+"            0 d-face-cc-digits t)
       ("\\<SAMPLE[&*]*"              0 font-lock-type-face nil)
       ("\\<BITMAP[&*]*"              0 font-lock-type-face nil)
       ("[A-Z][a-zA-Z0-9_]*[&*]+"     0 font-lock-type-face nil)
       ("\\<operator ?\\([^ ()]*\\)"
        (0 bold nil)
        (1 bg:yellow nil))
       ;;("\\<[A-Z]+[a-z][A-Za-z_]+[&*]*" 0 font-lock-type-face t)
       ("\\<\\(break\\|case\\|const\\|class\\|default\\|friend\\|return\\|template\\|this\\|virtual\\)\\>"
        (1 font-lock-keyword-face nil)
        )
       ("\\<true\\|false\\>" 0 fg:lightred nil)
       ("\\<safe_[a-z]*\\>" 0 font-lock-type-face nil)
       ("\\<\\(char\\|double\\|int\\|string\\|string_buffer\\|int\\|v3d\\|xyd\\|float\\|bool\\|void\\)\\>" 1 font-lock-type-face nil)
       ("ptr<[A-Za-z0-9_]+>" 0 font-lock-type-face nil)
       ("ptr<[A-Za-z0-9_]+<[A-Za-z0-9_]+>>" 0 font-lock-type-face nil)
       ("this->" 0 font-lock-keyword-face nil)

       ("\\<allegro_font->" 0 d-face-cc-allegro nil)
       ("new \\([A-Za-z0-9_<>]+\\)("    1 font-lock-type-face t)
       ("c-extends \\([A-Za-z0-9_]+\\)" 1 font-lock-type-face nil)
       ;;("\\<\\([A-Za-z0-9]+[*]+\\) \\([a-zA-Z0-9]+\\)\\>" (1 font-lock-type-face t) (1 font-lock-variable-name-face t))
       ("\\<\\(instanceof_[a-zA-Z0-9_]+\\)" 1 fg:lightred t)
       )))

  (d-flock-checkpoint "6")

  ;; *** no error here
  ;; error here: void variable default
;;; error here

  (when (and prefs-font-xtra-p (eq major-mode 'emacs-lisp-mode))
    (d-font-lock-add-begin
     `(
       ("(provide '\\([a-zA-Z0-9_]+\\))"
        1 bold t)
       ("^[ \t]*;;.*$"             0 font-lock-comment-face t)
       ("^[ \t]*;;;.*$"            0 d-face-super-comment t)
       ("[ \t()]\\(&[a-z0-9_]+\\)" 1 fg:lightred t)
       ("[ \t()]\\(:[a-z0-9_]+\\)" 1 fg:lightred t)
       ;;("\\(https?://\\)\\([^ \t\r\n\"<>?]*\\)" (1 bg:lightred t) (2 fg:lightred t))
       (,(concat "\\<\\(nu" "ll\\|true\\|false\\)\\>") 1 font-lock-constant-face nil)
       ;;("\\<d-[-a-zA-Z0-9_]*\\>"         0 fg:lightblue nil)
       ;;("\\<font-lock-[-a-zA-Z0-9_]*\\>" 0 fg:lightblue nil)
       ("(require '\\([a-zA-Z_][-a-zA-Z0-9_+]*\\)" 1 fg:lightred t)
       )))

  (d-flock-checkpoint "7")

  (if (and prefs-font-lisp++-p
           (and (buffer-file-name)
                (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$"  (buffer-file-name))
                ))
      (d-font-lock-add-end
       '(
         ;;("(carg [a-zA-Z0-9_ <>]* \\([a-zA-Z0-9_]+\\))" 1 font-lock-variable-name-face nil)
         ;;("\\<c-[a-z-]*"                                0 d-face-cc-illegal-type nil)
         ;;("\\<c[a-z][a-z-]*"                            0 d-face-cc-illegal-type nil)
         )))

  (if (and (buffer-file-name) (string-match "\\.css$" (buffer-file-name)))
      (d-font-lock-add-end
       '(
         ("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]L?" 0 d-face-cc-digits t))
       )
    )

  (d-flock-checkpoint "8")

  (when (or (eq major-mode 'c-mode)
            (eq major-mode 'c++-mode)
            (eq major-mode 'java-mode)
            (eq major-mode 'jtw-mode)
            (eq major-mode 'text-mode)
            )
    (d-font-lock-add-end
     '(
       ("\\<0[xX][0-9A-Fa-f]+L?" 0 d-face-cc-digits nil)
       ("\\<\\(myassert\\)("     1 fg:lightmagenta  t)
       ("\\<\\(rollingBack\\)("  1 fg:lightmagenta  nil)
       ("\\<superfor\\>"         0 bold t)
       ("var \\(\\([a-z]+\\.\\)*\\)" 1 fg:lightred t)
       ))
    )

  (d-flock-checkpoint "9")

  (when (or (eq major-mode 'c-mode)
            (eq major-mode 'c++-mode)
            (eq major-mode 'java-mode)
            (eq major-mode 'jtw-mode)
            (eq major-mode 'text-mode)
            (eq major-mode 'c2j-mode)
            (eq major-mode 'emacs-lisp-mode))
    (d-font-lock-add-end
     '(
       ;;("[^a-z]\\([012]\\)[^a-z]"                 1 d-face-cc-illegal-type t)
       ;;("[^a-zA-Z0-9]\\([012]\\)\\[^a-zA-Z0-9]" 1 d-face-cc-illegal-type t)
       ;;("\\(^\\|[][ \t\r\n():]\\)\\(\\([-]*\\)\\([0-9]+[.]\\)?[0-9]+\\([eE][+-]?[0-9]+\\)?\\)"  2 d-face-cc-digits nil)
       ("\\(\\$\\|\\<\\)\\([+-]?[0-9,]+\\)\\(\\.[0-9]+\\)?\\([eE][+-]?[0-9]+\\)?L?\\>" 0 d-face-cc-digits nil)
       ("\\<unsigned\\>"                                                0 font-lock-type-face nil)
       ))
    )

  (d-flock-checkpoint "10")

  ;;(d-quote ofofo)
  (when (and prefs-font-p prefs-font-xtra-p)
    (when (or (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'text-mode))
      ;;(d-beeps "Foo")
      (d-font-lock-add-begin
       '(
         ("\\<\\(debug\\|debug-on-error\\|error\\|d-foo\\)\\>"   0 d-debug-face nil)
         ("\\<\\(d-n?beeps?\\)\\>"                               0 d-checkpoint-face nil)
         ("\\<checkpoint\\>"                                     0 d-checkpoint-face nil)
         ("\\(safe-require\\)\\s-'\\([-a-zA-Z0-9_+=:&]+\\)"     (1 font-lock-keyword-face) (2 font-lock-reference-face))
         ("\\<\\(d-quote\\|quote\\)\\>"                          1 d-face-el-quote nil)
         ("^[^;()]*(defun \\([-a-zA-Z0-9_+=:&<>]+\\)"            1 font-lock-function-name-face t))
         )))

  (d-flock-checkpoint "11")

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c++-mode)
              (and (buffer-file-name)
                   (or ;;(eq major-mode 'text-mode)
                       (string-match "eraseme" (buffer-file-name))
                       (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\\)$" (buffer-file-name)))))
      (d-font-lock-add-end
       `(("\\<\\(exit\\)(\\([^)]*\\))" (1 font-lock-keyword-face) (2 font-lock-reference-face))

         ("\\<\\(CONTRACT_[123]\\|contract_[123]\\)\\>" 0 bg:yellow t)

         ("\\<\\(ASSERT\\|assert\\)("                1 font-lock-keyword-face nil)
         ("\\<\\(ASSERT_INFO\\|assert_info\\)\\>"    1 font-lock-keyword-face nil)

         ("[^a-zA-Z0-9_]\\(init[a-z0-9_]*\\)("         1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(deinit[a-z_]*\\)("          1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(new_[a-zA-Z0-9_]*\\)("      1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(delete_[a-z_]*\\)("         1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(create[a-z0-9_]*\\)("       1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(copy[a-z0-9_]*\\)("         1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(clone[a-z0-9_]*\\)("        1 d-face-cc-ctor-dtor nil)
         ("[^a-zA-Z0-9_]\\(destroy[a-z_]*\\)("         1 d-face-cc-ctor-dtor nil)

         ("\\<\\(free\\|malloc\\|new\\|delete\\)\\>" 0 d-face-cc-ctor-dtor nil)

         ("\\<debug[_a-z0-9]*"                       0 d-face-cc-debugging nil)

         ("\\(\\<strobe\\>\\)("                      1 d-face-cc-debugging t)
         ;;("ESC_CONDITI"                         0 fg:lightred nil)
         ;;("USER_PRESSED_QUIT"                   0 fg:lightred nil)
         ;;("\\<\\(new\\|delete\\)\\>"            1 fg:lightred t)

;;;
;;; BEGIN_...();          BEGIN_ALLEGRO()
;;; ALLEGRO_..._ERROR()   ALLEGRO_MATH_OVERFLOW_ERROR()
;;; END_,..()             END_OF_MAIN()
         ;;("\\<\\(BEGIN[A-Z_]*\\|EXIT_ON[A-Z_]*\\|[A-Z_]*ERROR\\|END[A-Z_]*\\)\\>(" 1 fg:lightred t)
         ;; EXTENDED ALLEGRO FUNCTIONS! smeg abcdefghijklmnopqrstuvwxyz
         ;; EXTENDED ALLEGRO FUNCTIONS: smog abcdefghijklmnopqrstuvwxyz
         ("\\<\\(press_key_to_continue[_a-z]*\\|qcos\\|qsin\\)("                              1 d-face-cc-allegro)
         ;;("\\<\\(load_rle\\|save_rle\\)("                                                     1 d-face-cc-allegro)
         ("\\<\\(safe_load_sample\\|safe_load_bitmap\\|safe_load_midi\\|safe_play_sample\\)(" 1 d-face-cc-allegro)

         ("\\(\\<qclamp_[a-z_]*\\)(" 1 d-face-cc-allegro)

         ("\\<\\(BEGIN_ALLEGRO\\)\\>" 0 d-face-cc-illegal-type t)
         ("\\<\\(END_OF_MAIN\\)\\>" 0 font-lock-keyword-face t)
         ("\\<\\(BEGIN_FUNCTION\\|END_FUNCTION\\)\\>" 0 d-face-cc-debugging t)

         ("\\<\\(EXIT_ON_[A-Z0-9_]*\\)\\>" 1 bg:yellow t)
         ("\\<\\(ALLEGRO_[A-Z_]*\\|SHOULD_NEVER_HAPPEN\\|should_never_happen\\)(" 1 font-lock-keyword-face nil)

         ("\\<\\(allegro_user_pressed_quit\\|allegro_on\\|allegro_quit[a-z_]*\\|allegro_window_close_hook\\)\\>"
          1 font-lock-keyword-face nil)

         ("\\<allegro_init[a-z_]*\\>" 0 d-face-cc-ctor-dtor nil)
         ("\\<install_[a-z_]*\\>"     0 d-face-cc-ctor-dtor nil)
         ("\\<remove_[a-z_]*\\>"     0 d-face-cc-ctor-dtor nil)

;;; ALLEGRO_ONLINE, DAVINS_IO_ONLINE, DMM_ONLINE
         ("\\<[A-Z_]*ONLINE\\>"   0 d-face-cc-libd nil)
         ("\\<NDEBUG\\>"          0 d-face-cc-libd nil)

         ;;("\\<ERROR_PADDING\\>" 0 fg:lightred  t)
         ("\\<PRINTF_AND_EXIT\\>" 0 font-lock-keyword-face nil)

         ("[a-z_]*eraseme[a-z_]*"   0 d-face-cc-illegal-type  t)
         ;;("[a-z_]*debug[a-z0-9_]*"  0 d-face-cc-debugging  t)
         ;;("\\<dmm[a-z0-9_]*"        0 d-face-cc-debugging  t)

         ;;("\\<SDL_\\sw+" 0 fg:white t)

         ;;("\\<global_[a-z0-9_]*" 0 d-face-cc-global t)
         ;;("\\<GLOBAL_[A-Z0-9_]*" 0 d-face-cc-global t)

         ("\\<DEBUG[A-Z0-9_]*\\>" 0 d-face-cc-debugging t)
         ("\\<[A-Z_]*ERROR\\>"    0 font-lock-keyword-face t)

         ("\\<\\(inner\\.[^;(]*\\)("  1 d-face-property t)
         ("\\<\\(inner\\.[^ ;(]*\\)(" 1 d-face-property t)

         ;;("\\<PROP_[A-Z0-9_]*" 0 font-lock-variable-name-face nil)
         ;;("\\<prop_[a-z0-9_]*" 0 font-lock-variable-name-face nil)
         ;;("\\<local_[a-z0-9_]*" 0 font-lock-variable-name-face nil)
         ;;("\\<LOCAL_[A-Z0-9_]*" 0 font-lock-variable-name-face nil)

         ;; MYLIB FUNCTIONS!
         ("\\<\\(char_star\\|const_char_star\\|distance[a-z0-9_]*\\|equals\\|fgeti16\\|fputi16\\|get_char_at\\|get_length\\|get_m?ptr\\|gulp_quoted_string\\|skip\\|looking_at\\|mag\\|mag2\\|mag_by_sums\\|set_char_at\\|cross\\|unit_vector\\|is_unit_vector\\|dot\\|cross\\|rot90\\|on\\|xyi_to_xyd\\|xyi_to_xyf\\)(" 1 d-face-cc-libd nil)

         ;; MYSTRING FUNCTIONS!
         ("\\<\\(string[a-z0-9_]*\\|strings_equal\\|strings_equal_ignore_case\\)(" 1 d-face-cc-libd nil)

         ;; MYLIB WORDS!
         ("[^a-zA-Z0-9_]\\(cerr\\|endl\\|cout\\)[^a-zA-Z0-9_]" 1 d-face-cc-clib nil)

         ;; MYLIST FUNCTIONS/METHODS!
         (,(concat "[^a-zA-Z0-9_]\\(add_after\\|add_before\\|add_element\\|add_element_deep\\|add_list\\|add_list_deep\\|add_to_end\\|add_to_start\\|clear_dirty\\|clone_deep\\|clone_shallow\\|empty\\|get_cyclic_next\\|get_cyclic_next_const\\|cyclic_previous\\|cyclic_previous_const\\|delete_deep\\delete_duplicates_eq\\|delete_duplicates_equal\\|delete_duplicates_equal_deep\\|delete_shallow\\|get_data\\|get_data_const\\|get_dirty\\|get_element_at[a-z_]*\\|get_element_at_const[a-z_]*\\|get_first\\|get_first_const\\|get_index\\|get_iterator\\|get_iterator_backwards\\|get_last\\|get_last_const\\|get_length\\|get_next\\|get_next_const\\|get_owner\\|get_owner_const\\|get_previous\\|get_previous_const\\|get_second\\|get_second_const\\|get_second_to_last\\|get_second_to_last_const\\|get_third\\|get_third_const\\|get_third_to_last\\|get_third_to_last_const\\|is_empty\\|is_first\\|is_last\\|lists_equal\\|OK\\|remove_element\\|reverse\\|set_data\\|set_element_at[a-z_]*\\|xs_equal\\|quicksort\\)" (if (eq major-mode 'c++-mode) "(" "")) 1 d-face-cc-libd nil)

         ("[^a-zA-Z0-9_]\\(advance\\|has_more\\|retreat\\)(" 1 d-face-cc-libd nil)

         ("[^a-zA-Z0-9_]\\(find_element[a-z0-9_]*\\)(" 1 d-face-cc-libd nil)

         ;; MYARRAY FUNCTIONS/METHODS!
         ("[^a-zA-Z0-9_]\\(add_element_at\\|remove_element_at\\|cascade_down\\|cascade_up\\)(" 1 d-face-cc-libd nil)
         ("\\<SUBMODES[A-Z_]*" 0 fg:lightred nil)
         ("\\<\\([GS]ETTER\\)\\(([^)]*)\\)" (1 fg:lightred nil))
         ("\\<\\([GS]ETTER_LONG\\)\\(([^)]*)\\)" (1 fg:lightred nil))
         ("\\<INFINITE_LOOP\\>" 0 fg:lightred nil)
         ("\\<error[a-z_]*\\>" 0 fg:lightred nil)

         ))))

  (d-flock-checkpoint "12")

  (d-quote
   (when (eq major-mode 'java-mode)
     (d-font-lock-add-end
      '(
      ("\\<debug[0-9A-Za-z_]*" 0 fg:lightmagenta t)
      ))))

  (d-flock-checkpoint "13")

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c++-mode)
              (and (buffer-file-name) (or (eq major-mode 'text-mode)
                                          (string-match "eraseme" (buffer-file-name))
                                          (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))
      (d-font-lock-add-end
       '(
         ;; DLIB WORDS!
         ("\\<libd_[a-z0-9_]*\\>" 0 d-face-cc-libd nil)
         ("\\<my[a-zA-Z0-9_]+"    0 d-face-cc-libd nil)
         ))))

  (d-flock-checkpoint "14")

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c++-mode)
              (eq major-mode 'text-mode)
              (and (buffer-file-name) (or (string-match "eraseme" (buffer-file-name))
                                          (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))
      (d-font-lock-add-end
       '( ;; CLIB VARIABLES!
         ("\\<\\(abs\\|atoi\\|calloc\\|rand\\|fclose\\|fgetc\\|fopen\\|fprintf\\|fseek\\|ftell\\|fputc\\|fputs\\|fread\\|getenv\\|isalnum\\|isalpha\\|isdigit\\|islower\\|isupper\\|isxdigit\\|log\\|mid\\|pow\\|printf\\|sprintf\\|srand\\|strcmp\\|strlen\\|sin\\|cos\\|sqrt\\|system\\|strcpy\\|strncpy\\|toupper\\|tolower\\)\\>" 1 d-face-cc-clib)

         ;; CLIB FUNCTIONS!
         ("\\<\\(time\\|exp\\|min\\|max\\)(" 1 d-face-cc-clib)

         ;; EXTENDED CLIB FUNCTIONS!
         ("\\<\\(fput16\\|fget16\\)(" 1 d-face-cc-clib)
         ;;("\\<\\(to_hex_[0-9]*\\)("   1 d-face-cc-clib)

         ;; CLIB VARIABLES!
         ("\\<\\(argc\\|argv\\|EOF\\|INT_MAX\\|PI\\|stdin\\|stdout\\|stderr\\)\\>" 1 d-face-cc-clib)
         ("\\<std::[a-z_]*\\>" 0 d-face-cc-clib)

         ("\\<\\(EXIT_SUCCESS\\|EXIT_FAILURE\\)\\>" 0 font-lock-constant-face nil)

         ("[^a-zA-Z0-9_]\\(sqrt\\|cos\\|sin\\|tan\\|acos\\|asin\\|atan2?\\|abs\\)\\>" 1 d-face-cc-clib nil)

         ;; ALLEGRO VARIABLES!
         ("[^a-zA-Z0-9_]\\(acquire_[a-z_]*\\|adjust_sample\\|allegro_[a-z0-9_]*\\|bitmap_color_depth\\|blit\\|calc_spline\\|clamp\\|circle\\|circlefill\\|clear\\|clear_bitmap\\|clear_keybuf\\|clear_to_color\\|color_map\\|datafile\\|desktop_color_depth\\|do_line\\|draw_lit_sprite\\|draw_rle_sprite\\|draw_sprite[a-z_]*\\|draw_lit_rle_sprite\\|draw_trans_sprite\\|drawing_mode\\|ellipse\\|ellipsefill\\|enable_triple_buffer\\|exists\\|file_exists\\|floodfill\\|for_each_file\\|get_rle_sprite\\|getr[0-9]*\\|getg[0-9]*\\|getb[0-9]*\\|getpixel\\|get_[a-zA-Z0-9_]*\\|set_[a-zA-Z0-9_]*\\|get_desktop_resolution\\|hline\\|hsv_to_rgb\\|install_joystick\\|install_keyboard\\|install_mouse\\|install_sound\\|install_timer\\|is_linear_bitmap\\|is_video_bitmap\\|keyboard_needs_poll\\|keypressed\\|line\\|load_bitmap\\|load_midi\\|load_datafile\\|load_sample\\|makeacol32\\|makecol[0-9]*\\|masked_blit\\|masked_stretch_blit\\|midi_seek\\|pivot_sprite\\|play_midi\\|play_sample\\|poll_joystick\\|poll_keyboard\\|poll_scroll\\|position_mouse\\|polygon\\|putpixel\\|readkey\\|rect\\|rectfill\\|release_[a-z_]*\\|request_scroll\\|request_video_bitmap\\|rest_callback\\|rgb_to_hsv\\|rotate_sprite\\|save_bitmap\\|scare_mouse\\|scroll_screen\\|select_palette\\|set_alpha_blender\\|set_burn_blender\\|set_clip\\|set_color_conversion\\|set_color_depth\\|set_display_switch_mode\\|set_gfx_mode\\|set_mouse_[a-z_]*\\|set_trans_blender\\|set_window_close_button\\|set_window_close_hook\\|set_window_title\\|set_volume\\|show_mouse\\|solid_mode\\|show_video_bitmap\\|spline\\|stop_midi\\|stop_sample\\|stretch_blit\\|stretch_sprite\\|textprintf\\|textprintf_centre\\|text_height\\|text_length\\|textout\\|textout_[a-z_]*\\|text_mode\\|triangle\\|unscare_mouse\\|unselect_palette\\|vline\\|vsync\\|xor_mode\\|yield_timeslice\\)\\>"  1 d-face-cc-allegro nil)

         ("\\<al_[a-z0-9_]*\\>" 0 d-face-cc-allegro nil)

         ;; ALLEGRO FUNCTIONS!
         ("[^a-zA-Z0-9_]\\(line\\|rest\\|time\\)(" 1 d-face-cc-allegro nil)

         ;; ALLEGRO ARRAYS!
         ("\\<\\(joy\\|key\\)\\[" 1 d-face-cc-allegro nil)

         ;; ALLEGRO VARIABLES AND CONSTANTS!
         ;; was [^a-zA-Z0-9_]
         ("\\<\\(allegro_[a-z_]*\\|ALLEGRO_[A-Z0-9_]*\\|allegro_error\\|COLORCONV_[A-Z0-9_]*\\|DIGI_[A-Z0-9_]*\\|DRAW_MODE_[A-Z0-9_]*\\|errno\\|FA_[A-Z]*\\|font\\|gfx_capabilities\\|GFX_[A-Z0-9_]*\\|JOY_[A-Z_]*\\|joy_\\(x\\|y\\|left\\|right\\|up\\|down\\)\\|key_led_flag\\|KEY_[A-Z0-9_]*\\|MASK_COLOR_[0-9]*\\|MIDI_[A-Z0-9_]*\\|midi_pos\\|mouse_[xyzb]\\|mouse_sprite\\|mouse_[xy]_focus\\|num_joysticks\\|PAL_SIZE\\|QUICK_MAX\\|retrace_count\\|screen\\|SCREEN_W\\|SCREEN_H\\|SWITCH_[A-Z]*\\|three_finger_flag\\)\\>" 1 d-face-cc-allegro nil)

         ))))

  (d-flock-checkpoint "15")

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c++-mode)
              (eq major-mode 'text-mode)
              (and (buffer-file-name)
                   (or (string-match "eraseme" (buffer-file-name))
                       (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))
      (d-font-lock-add-end
       '( ;;("class \\([a-zA-Z][a-zA-Z0-9_]*\\)" 1 font-lock-type-face t)
         ;;
         ;; NOTE: smeg
         ;;
         ;;("\\<[A-Z][a-z][a-zA-Z0-9_]*_A\\>"   0 font-lock-type-face nil)
         ("\\(\\<[A-Z]+[a-zA-Z0-9_]*\\)::" 1 font-lock-type-face nil)
         ("\\<\\(Round\\|Floor\\)\\>" 1 d-face-cc-libd t)
         ("\\<\\(File_Gulper\\|File_Reader\\|File_Writer\\|Gulper\\|Io_Worker\\|Reader\\|Reader_Core\\|String_Gulper\\|String_Internal\\|String_Reader\\|Writer\\)\\>" 1 font-lock-type-face nil)
         ("\\<\\(Auto_G_C\\|Root_G_C\\|Super_G_C\\|Manual_G_C\\)\\>" 1 font-lock-type-face nil)
         ("\\<\\(Temp_Blit\\)\\>"          1 font-lock-type-face nil)

         ("\\<[a-z_][a-z0-9_]+_t\\>"       0 d-face-cc-illegal-type t)
         ("\\<[a-zA-Z_][a-zA-Z0-9_]*_t\\>" 0 font-lock-type-face nil)

         ("\\<[a-z][a-z0-9_]*_e\\>"        0 font-lock-constant-face t)
         ;;("\\<[A-Z][a-zA-Z0-9_]*_E\\>" 0 d-face-red-and-yellow t) ;;; ERROR!

         ;;("\\<0x[A-Za-z0-9]*\\>" 0 default t)
         ("\\<LOOP_OK\([^)]*)"   0 bold t)
         ("\\<STAR_OK\([^)]*)"   0 bold t)
         ("\\<for_list ?([^)]*)" 0 bold t)
         ("\\<for_list_backwards ?([^)]*)" 0 bold t)
         ("\\<PTR\\>" 0 fg:lightred t)

         ;; // COMMENTS: here to force unfontification of types in comments
         ;;
         ))))

  (d-flock-checkpoint "16")

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c-mode)
              (eq major-mode 'c++-mode)
              ;;(eq major-mode 'text-mode)
              (eq major-mode 'html-mode)
              (and (buffer-file-name) (or (string-match "eraseme" (buffer-file-name))
                                          (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))
      ;;(setq tab-width 3)
      (let* ((class-name "\\([A-Z]\\|[A-Z][A-Za-z0-9_]+\\)") ;; 1
             (stuff-in-angle-brackets "<[^>]*>")             ;; 0
             (class-name-with-template (concat "\\(" class-name stuff-in-angle-brackets "\\)")) ;; 2
             (class-name-with-possibly-template (concat "\\(" class-name "\\(" stuff-in-angle-brackets "\\)?" "\\)")) ;; 3
             )
        (d-font-lock-add-end
         `(

           ;; TEMPLATE CLASS:
           (,class-name-with-template (1 font-lock-type-face nil))

           ;; TEMPLATE VARIABLE THAT IS NOT CLASS MEMBER:
           (,(concat class-name-with-template "\\**"
                     "\\s-+"
                     "\\([a-z]\\sw*\\)[^:(a-zA-Z]")
            (3 font-lock-variable-name-face nil))


           ;; TEMPLATE VARIABLE THAT IS CLASS MEMBER:
           (,(concat class-name-with-template "\\**"
                     "\\s-+\\(\\sw+"
                     "\\(" stuff-in-angle-brackets "\\)?"
                     "\\)::"
                     "\\(\\sw+\\)[^:(a-zA-Z]")
            (5 font-lock-variable-name-face t))

           ;; TEMPLATE FUNCTION THAT IS-OR-IS-NOT CLASS MEMBER:
           (,(concat class-name-with-template "\\**"
                     "\\s-+"
                     "\\(" class-name-with-possibly-template "::\\)?"
                     "\\([a-z]\\sw*\\)(")
            (7 font-lock-function-name-face t))

           ;; NON TEMPLATE FUNCTION THAT IS CLASS MEMBER:
           (,(concat "\\<[A-Za-z]\\sw*[&*]*"
                     "\\s-+"
                     "\\(" class-name-with-possibly-template "::\\)"
                     "\\([a-z]\\sw*\\)(")
            (5 font-lock-function-name-face t))

           ;; CONSTRUCTOR AND DESTRUCTOR:
           ("\\(\\|::\\)\\(~?\\<[A-Z]+[a-z][A-Za-z_]*\\)(" 2 font-lock-type-face nil)
           ("\\(~[A-Za-z_]*\\)(" 1 font-lock-type-face nil)

           ;; COLONED CONSTRUCTOR OR DESTRUCTOR:
           ;;("::\\(~?[A-Z]+[a-z][A-Za-z_]*\\)"  1 font-lock-type-face nil)

           (,(concat "\\<\\(nu" "ll\\|true\\|false\\)\\>") 1 font-lock-constant-face nil)
           ("\\<\\(NULL\\|NIL\\|FALSE\\|TRUE\\)\\>" 1 font-lock-constant-face nil)

           ("\\<\\(IF\\|ENDIF\\)(\\(\\sw+\\))" (0 d-face-red-and-white t) (2 fg:white t))

           ("\\<private_\\sw+"                0 d-face-cc-private nil)
           ("\\(^\\|[ ()\t\r\n]\\)\\(_[^_ ][a-zA-Z0-9][a-zA-Z0-9_]*\\)"  2 d-face-cc-private nil)
           ("\\<ABSTRACT\\>"                  0 font-lock-keyword-face nil)
           ("\\<FINAL\\>"                     0 font-lock-keyword-face nil)

           ("\\(\\<ctor[_A-Za-z0-9]*\\)("           1 d-face-cc-ctor-dtor nil)
           ("\\(\\<dtor[_A-Za-z0-9]*\\)("           1 d-face-cc-ctor-dtor nil)
           ("\\(\\<init[_A-Za-z0-9]*\\)("           1 d-face-cc-ctor-dtor nil)
           ("\\(\\<instance_of_[_A-Za-z0-9]*\\)\\>" 1 font-lock-keyword-face t)
           ("\\(\\<cast_to_[_A-Za-z0-9]*\\)\\>"     1 font-lock-keyword-face t)

           ("\\<\\(PRINT[A-Z0-9_]*\\|TELL\\)(\\([^();]*\\));"               (1 d-face-cc-debugging t) (2 d-face-cc-debugging t))
           ("\\<\\(PRINT[A-Z0-9_]*\\|TELL\\)(\\([^();]*([^();]*)[^();]*\\));" (1 d-face-cc-debugging t) (2 d-face-cc-debugging t))
           ("\\<\\(PRINT[A-Z0-9_]*\\|TELL\\)(\\([^();]*([^();]*([^();]*)[^();]*)[^();]*\\));" (1 d-face-cc-debugging t) (2 d-face-cc-debugging t))
           ;;("\\(xx_\\)\\sw*" 1 fg:white t)
           ("^ *\\<INT\\>;? *\n"          0 d-face-cc-debugging t)
           ("\\<BREAKPOINT\\>" 0 d-face-cc-debugging t)
           ("\\<CHECKPOINT\\>" 0 d-face-cc-debugging nil)
           ("\\<PLEASE_EMAIL_DAVIN\\>" 0 fg:lightred t)

           ))) ;; PLEASE_EMAIL_DAVIN
      ))

  (d-flock-checkpoint "17")

  (when (eq major-mode 'tes-mode)
    (d-font-lock-add-end
     '(
       ("\\<EOL\\>" 0 fg:lightred nil)
       ("\\<PD\\>"  0 fg:lightred nil)
       ("\\<NI\\>"  0 fg:lightred nil)
       ("\\<DOWNTU\\|TU\\>"  0 bold nil)
       )))

  

  (setq d-face-makefile-tab                     'd-face-makefile-tab)
  (setq d-face-makefile-space                   'd-face-makefile-space)
  (setq d-face-makefile-dollar-dollar           'd-face-makefile-dollar-dollar)
  (setq d-face-makefile-dollar-dollar-highlight 'd-face-makefile-dollar-dollar-highlight)

  (when (and prefs-font-xtra-p (eq major-mode 'makefile-mode))
    (d-font-lock-add-end
     '(
       ("^\t+"                                     0 d-face-makefile-tab t)
       ("^ +"                                      0 d-face-makefile-space t)
       ("[^$]\\($([^ ]+)\\)"                       1 font-lock-variable-name-face t)
       ("[^$]\\($([^()]+)\\)"                      1 font-lock-variable-name-face t)
       ("[^$]\\($([^()]*([^()]*)[^()]*)\\)"        1 font-lock-variable-name-face t)
       ("[^$]\\($([^()]*([^()]*)[^()]*([^()]*)\\)" 1 font-lock-variable-name-face t)
       ("$$(\\([a-zA-Z0-9._-]* ?\\)[^()]*"
        (0 d-face-makefile-dollar-dollar t)
        (1 d-face-makefile-dollar-dollar-highlight t)
        )
       ("$$(\\([a-zA-Z0-9._-]* ?\\)[^()]*(\\([a-zA-Z0-9._-]* ?\\)[^()]*)[^()]*)"
        (0 d-face-makefile-dollar-dollar t)
        (1 d-face-makefile-dollar-dollar-highlight t)
        (2 d-face-makefile-dollar-dollar-highlight t)
        )
       ("$$[A-Z]+" 0 font-lock-variable-name-face t)


       ("^\\(ifdef\\|else\\|endif\\)" 0 fg:lightred t)
       )
     )
    ;; patches the incorrectly fontified as font-lock-constant-face to be font-lock-variable-name-face
    ;;(set (make-local-variable 'font-lock-constant-face) 'font-lock-variable-name-face)
    )

  (when (and prefs-font-xtra-p (or (eq major-mode 'c-mode)
                                 (eq major-mode 'c++-mode)
                                 (eq major-mode 'java-mode)
                                 (eq major-mode 'text-mode)
                                 (and (buffer-file-name) (or (string-match "eraseme" (buffer-file-name))
                                                             (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))
                                 ;;(eq major-mode 'jde-mode)
                                 )))

    (d-font-lock-add-end
     '(
       ("&&\\|||" . font-lock-keyword-face)
       ("\\<debug[a-zA-Z0-9_]*" 0 fg:lightmagenta nil)
       ("\\(RTTI_SAME\\|RTTI_ROOT\\)\\(.*\\)" 0 d-face-m4 t)
       ;;("/\\*\\*.*" 0 d-face-super-comment t)

       )))

  (d-quote (when (eq major-mode 'java-mode)

           (d-font-lock-add-end
            '(
              ;; Abc def
              ("\\([A-Z][a-zA-Z_-]*\\)[ \t]+\\([a-z][a-zA-Z_-<>]*\\);" (1 fg:lightcyan t) (2 fg:cyan t))
              ("\\([A-Z][a-zA-Z_-]*\\)[ \t]+\\([a-z][a-zA-Z_<>-]*\\)(" (1 fg:lightcyan t) (2 bg:yellow t))
              ("\\<\\([A-Z]+\\)[ \t]+\\([a-z][a-zA-Z_-]*\\)[ \t]*[;=]" (1 fg:lightcyan t) (2 fg:cyan t))
              ("\\<\\([A-Z]+\\)[ \t]+\\([a-z][a-zA-Z_-]*\\)[ \t]*[(]" (1 fg:lightcyan t) (2 bg:yellow t))

              ))))

  (when (and prefs-font-libd-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c++-mode)
              (eq major-mode 'text-mode)
              (and (buffer-file-name) (or (string-match "eraseme" (buffer-file-name))
                                          (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))

      (d-font-lock-add-end
       '(
         ("\\<DCODE_GENERIC\\>"     0 d-face-cc-illegal-type nil)
         ("\\<DCODE_[A-Z0-9_]*\\>"  0 d-face-red-and-white   nil)
         ("\\<DCODE_TRI_[A-Z0-9_]*" 0 d-face-green-and-black nil)
         ;;("\\<DCODE_UNKNOWN_A\\>"   0 d-face-cc-illegal-type t)
         ))))

  (when (and prefs-font-xtra-p (or (eq major-mode 'c-mode) (eq major-mode 'c++-mode)))
    (d-font-lock-add-end
     '(
       ("\\<gl[A-Z][a-zA-Z0-9]*\\>" 0 d-face-cc-opengl)
       ("\\<glu[A-Z][a-zA-Z0-9]*\\>" 0 d-face-cc-opengl)
       ("\\<glut[A-Z][a-zA-Z0-9]*\\>" 0 d-face-cc-opengl)
       ("\\<GL_[A-Z0-9_]*\\>" 0 d-face-cc-opengl)
       ("\\<GLUT_[A-Z0-9_]*\\>" 0 d-face-cc-opengl)
       )
     )
    )

  ;;`((1 2 3) (,@(list (concat "a" "b") 4 5)))

  (when (and prefs-font-xtra-p (eq major-mode 'java-mode))
    (d-font-lock-add-begin
     `(
       ("\\<[A-Z]\\>" 0 font-lock-type-face nil)

       ("\\<\\(static\\|public\\|private\\|protected\\) \\([A-Za-z0-9_<>]*\\)[ \t]+\\([_a-zA-Z0-9]+\\)[ \t]*[;=]"
        (2 font-lock-type-face t)
        (3 font-lock-variable-name-face nil))

       ("\\<\\([A-Z]+[a-z][_a-zA-Z0-9<>,]*\\)[ \t]+\\([a-z][_a-zA-Z0-9]*\\)"
        (1 font-lock-type-face nil)
        (2 font-lock-variable-name-face nil))

       ("\\<\\([A-Z]+[a-z][_a-zA-Z0-9<>,]*\\)(" 1 font-lock-type-face nil)

       ("\\<\\(case\\) \\([_a-zA-Z0-9.]+\\):"
        (1 font-lock-keyword-face t)
        (2 font-lock-type-face t))

       ,@(list (list (concat "^"
                             (make-string c-basic-offset ? )
                             "\\(\\(private\\|protected\\|public\\) \\)?"
                             "\\(\\(abstract\\|static\\|final\\) \\)*"
                             "\\([A-Z]+[a-z][A-Za-z0-9<>]+\\)(")
                     5 font-lock-function-name-face t))

       ,@(list (list (concat "^"
                             (make-string c-basic-offset ? )
                             "\\(\\(private\\|protected\\|public\\) \\)?"
                             "\\(\\(abstract\\|static\\|final\\) \\)*"
                             "\\([A-Z]+[a-z][A-Za-z0-9<>]+\\)(")
                     5 font-lock-function-name-face t)))))

  

  (when (eq major-mode 'html-mode)
    (setq font-lock-keywords nil)
    (setq font-lock-keywords-case-fold-search nil))

  (when (and prefs-font-p prefs-font-xtra-p
             (or (eq major-mode 'html-mode)
                 (eq major-mode 'latex-mode)
                 (eq major-mode 'tes-mode)))

    (d-font-lock-add-end
     `(
       ("\\<EM(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 fg:lightred t) (1 bold t))
       ("\\<EM(\\([^()\n\r]*\\))?"                       (0 fg:lightred t) (1 bold t))
       ("\\<TT(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 fg:lightred t) (1 bold t))
       ("\\<TT(\\([^()\n\r]*\\))?"                       (0 fg:lightred t) (1 bold t))
       ("\\(\\<PCOD\\)(\\([^)]*\\))" (1 fg:lightgreen t) (2 bold t)) ;;; PHP code
       ("\\(\\<FCOD\\)(\\([^)]*\\))" (1 fg:lightred t) (2 bold t)) ;;; FILE code (filename)
       ("\\(\\<MCOD\\)(\\([^)]*\\))" (1 fg:lightmagenta t) (2 bold t)) ;;; MAKE code
       ("\\<\\(WEBSITE\\)(\\(.*\\))"                     (1 fg:lightred t) (2 bold t))
       ("\\<BO(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 fg:lightred t) (1 bold t))
       ("\\<BO(\\([^()\n\r]*\\))?"                       (0 fg:lightred t) (1 bold t))
       ("\\<M4_\\([_A-Z][_A-Z0-9]*\\)"                   (0 d-face-el-d-stuff t) )
       ("\\(^\\|[^a-zA-Z]\\)\\(COMM\\)(\\([^)]*\\)" (2 bold t) (3 font-lock-comment-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(KEYW\\)(\\([^)]*\\)" (2 bold t) (3 fg:lightgreen t))
       ("\\(^\\|[^a-zA-Z]\\)\\(STRI\\)(\\([^()]*\\))" (2 bold t) (3 font-lock-string-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(STRI\\)(\\([^()]*([^()]*)[^()]*\\)" (2 bold t) (3 font-lock-string-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(NUMB\\)(\\([^)]*\\)" (2 bold t) (3 fg:lightmagenta t))
       ("\\(^\\|[^a-zA-Z]\\)\\(CLSS\\)(\\([^)]*\\)" (2 bold t) (3 font-lock-type-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(VARI\\)(\\([^)]*\\)" (2 bold t) (3 font-lock-variable-name-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(PRVT\\)(\\([^)]*\\)" (2 bold t) (3 d-face-cc-private t))
       ("\\(^\\|[^a-zA-Z]\\)\\(FUNC\\)(\\([^)]*\\)" (2 bold t) (3 font-lock-function-name-face t))
       ("\\(^\\|[^a-zA-Z]\\)\\(PADD\\)(\\([^)]*\\)" (2 bold t) )
       ("\\(\\<KB\\)(\\([^)]*\\)"   (1 bold t) (2 fg:lightred t))
       ("\\<SECT_[^ \r\n\t,<>]*\\>" 0 font-lock-function-name-face t)
       ("\\<QEST_[^ \r\n\t,<>]*\\>" 0 font-lock-function-name-face t)
       ("\\<TUTE_[^ \r\n\t,<>]*\\>" 0 font-lock-function-name-face t)

       ("\\<\\(BS\\|LT\\|GT\\)\\>" 1 bold nil)

       (,(concat "[^a-zA-Z0-9_]\\(INTERFACE\\|IMPORT\\|PACKAGE\\|GOTO\\|ABSTRACT\\|AND\\|ASSERT\\|CL" "ASS\\|BEGIN\\|BEGINMAIN\\|BREAK\\|CASE\\|CONSTRUCTOR\\|D" "U\\|ELSE\\|END\\|ENDMAIN\\|EXTENDS\\|F" "INAL\\|F" "UR\\|FUNCTION\\|I" "F\\|INSTANCEOF\\|METHOD\\|N" "EW\\|OR\\|P" "RIVATE\\|PROPERTY\\|P" "ROTECTED\\|P" "OBLIC\\|R" "ETURN\\|STATIC\\|SUPER\\|SWITCH\\|THEN\\|T" "HIS\\|VAR\\|W" "HILE\\|SUPERFOR\\|ELSEIF\\|POBLIC\\|PRIVATE\\)[^a-zA-Z0-9_]") 1 font-lock-keyword-face nil)

       ("\\<JAVADOC\\>" 0 bold t)

       (,(concat "\\<\\(BOOLEAN\\|BOOL\\|C" "HAR\\|D" "OUBLE\\|FLOAT\\|I" "NT\\|"
                 "LONG\\|SHORT\\|STRING\\|V" "OID\\)\\>")
        0 font-lock-type-face nil)
       (,(concat "\\<\\(CMETHOD\\|CPROPERTY\\|C_STATIC_METHOD\\|"
                 "C_STATIC_PROPERTY\\|CFUNCTION\\|CLASSVAR\\|"
                 "CGLOBAL\\|CRET\\|CTYPE\\|CNAME\\|CARGS\\|CARG\\|"
                 "CPROGN\\|CFOR\\|CFOREVER\\|CWHILE\\|CDO\\|DEFUN\\|C_SUPER_FOR\\|"
                 "CCLASS\\|CXX_2_LISPXX\\|LISPXX_2_CXX\\|F\\|S\\|"
                 "C_CONSTRUCTOR_METHOD\\|C_DESTRUCTOR_METHOD\\|C_RAW_HXX\\|"
                 "CAUTOGC\\|C_FOR_EACH_BACKWARDS\\|C_UNWIND_PROTECT\\|C_RAW_CXX\\|"
                 "C_FOR_EACH\\|C_RAW_GLOBAL_HXX\\|"
                 "EXTERN\\|TYPEDEF\\|CASSERT\\|CFRIEND\\|CTYPEDEF\\|"
                 "CPAUSE\\|CINIT\\|CONST\\|STATIC\\|MAIN\\|CHARACTER\\|"
                 "TEMPLATE\\|OPERATOR\\|VIRTUAL\\|FRIEND\\|DELETE\\|"
                 "CIF\\|CELSEIF\\|CELSE\\|CBRACKETS\\|CPUBLIC\\|"
                 "CPRIVATE\\|CPROTECTED\\|CINCLUDE\\|STRUCT\\|INLINE\\|"
                 "GT\\|GTGT\\|LT\\|LTLT\\|LTEQ\\|GTEQ\\|PRINTF\\|"
                 "DOLLAR\\|HASH\\|PERCENT\\|HORIZONTAL_RULE\\|CSUPERFOR\\|"
                 "TILDE\\|LR\\|ARROW\\|AMP\\|BAR\\|SQU\\|GLY\\|SUP\\|"
                 "STEP\\|TU\\|DOWNTU\\|UNWIND_PROTECT\\|SIZEOF\\|CLET\\|CLETSTAR\\|COUT\\)\\>")
        0 bold t)
       ("\\<SYSTEM_OUT_PRINT\\(LN\\)?\\>" 0 d-face-cc-global t)
       ("\\<\\(NULL\\|NIL\\|FALSE\\|TRUE\\)\\>"
        1 font-lock-constant-face nil)
       ("\\<ENTY([^()]*)"  0 fg:red t)
       ("\\<PRUP([^()]*)"  0 fg:orange t)
       ("^\\(CHAPTER\\|SECTION\\|SUBSECTION\\)(\\(.*\\))"
        (1 bold nil)
        (2 font-lock-function-name-face nil))
       ("\\<\\(PCLOSE\\|POPEN\\|PP\\)\\>" 1 bold nil)
       ("\\<EOL\\>" 0 fg:lightred nil)
       ("\\<PD\\>"  0 fg:lightred nil)
       ("\\<NO\\>"  0 fg:lightred nil)
       ("\\(RED\\)([^()]*)"                1 fg:lightred   nil)
       ("\\(RED\\)([^()]*([^()]*)[^()]*)"  1 fg:lightred   nil)
       ("\\(BGRN\\)([^()]*)"               1 fg:lightgreen nil)
       ("\\(BGRN\\)([^()]*([^()]*)[^()]*)" 1 fg:lightgreen nil)
       ("\\(GRN\\)([^()]*)"                1 fg:lightgreen nil)
       ("\\(GRN\\)([^()]*([^()]*)[^()]*)"  1 fg:lightgreen nil)
       ("\\(BLU\\)([^()]*)"                1 fg:lightblue  nil)
       ("\\(BLU\\)([^()]*([^()]*)[^()]*)"  1 fg:lightblue  nil)
       )))

  (when (eq major-mode 'html-mode)
    ;;(set (make-local-variable 'font-lock-string-face) nil)
    ;;(setq font-lock-string-face nil)
    (d-font-lock-add-end
     `(
       (,(concat "\\<m4" "_esyscmd(\\(.*\\))") 1 bold t)
       ;;("\\<m4_r?include(\\(.*\\))" 1 bold t)
       ;;("m4 subsection[a-z_]*(\\(.*\\))" 1 bg:yellow t)
       ;;("m4 section[a-z_]*(\\(.*\\))"    1 bg:yellow t)
       ;;("m4 input_[a-z]*(\\(.*\\))"      1 fg:lightred t)
       ;;("[Hh][Rr][Ee][Ff]=[^>]*>"        0 fg:lightred t)
       ;;("<\\(.\\|[\t\r\n]\\)*>" 0 bold t)
       ("\\<private_\\sw+" 0 d-face-cc-private t)
       ("<[Aa] [^>\n]*>\\([^\n<>]*\\)" 1 fg:lightblue t)
       ("</[Aa]>" ("\\([^\n<>]*\\)</[Aa]>" (beginning-of-line) (end-of-line) (1 fg:lightblue t)))
       ("<[Aa] .*>\\(.*\\)</[Aa]>" 1 fg:lightblue t)


       ("[^-]>" ("[^<>\r\t ]*>" (beginning-of-line) (end-of-line) (0 font-lock-keyword-face t)))

       ("<[Ee][Mm]>\\([^<]*\\)" 1 bold t)
       ("</[Ee][Mm]>" ("\\([^<>]*\\)</[Ee][Mm]>" (beginning-of-line) (end-of-line) (1 bold t)))

       ;;         ("<[Ss][Pp][Aa][Nn][^>]*>\\([^<>\n]*\\)" 1 d-face-green-and-black)
       ;;         ("</[Ss][Pp][Aa][Nn]>" ("\\([^<>\n]*\\)</[Ss][Pp][Aa][Nn]>"
       ;;                                 (beginning-of-line)
       ;;                                 (end-of-line)
       ;;                                 (1 d-face-green-and-black t)))
       ;;
       ;;         ("<[Ff][Oo][Nn][Tt][^>]*>\\([^<>\n]*\\)" 1 d-face-green-and-black)
       ;;         ("</[Ff][Oo][Nn][Tt]>" ("\\([^<>\n]*\\)</[Ff][Oo][Nn][Tt]>"
       ;;                                 (beginning-of-line)
       ;;                                 (end-of-line)
       ;;                                 (1 d-face-green-and-black t)))
       ;;
       ;;         ("<[Ii]>\\([^<]*\\)" 1 italic t)
       ("</[Ii]>" ("\\([^<>]*\\)</[Ii]>" (beginning-of-line) (end-of-line) (1 italic t)))

       ("<[Ii]>\\(.*\\)</[Ii]>" 1 italic t)
       ("<[Bb]>\\(.*\\)</[Bb]>" 1 bold t)
       ("<[Uu]>\\(.*\\)</[Uu]>" 1 underline t)

       ("<[Ee][Mm]>\\(.*\\)</[Ee][Mm]>" 1 bold t)
       ("<[Tt][Tt]>\\(.*\\)</[Tt][Tt]>" 1 bold t)
       ("<[Ss][Tt][Rr][Oo][Nn][Gg]>\\(.*\\)</[Ss][Tt][Rr][Oo][Nn][Gg]>" 1 bold t)
       ("<[Tt][Ii][Tt][Ll][Ee]>\\(.*\\)</[Tt][Ii][Tt][Ll][Ee]>" 1 font-lock-function-name-face t)
       ("<[Hh][0-9]>\\(.*\\)</[Hh][0-9]>" 1 font-lock-function-name-face t)

       ("<[^! ][^ \r\n>]*[^-]>?" 0 font-lock-keyword-face t)

       ("</?\\(form\\|label\\|input\\|select\\|textarea\\|option\\)[^>]*>?" 0 fg:green t)
       ("</?\\(applet\\|param\\)[^>]*>?" 0 fg:red dt)
       ("<!--[^>\r\n]*>?" 0 font-lock-comment-face t)

       ("\\([][\" ().,<>='-]\\|^\\)\\(m4_[_a-zA-Z0-9]*\\)" (2 d-face-m4 t))
       ("\\([][\" ().,<>='-]\\|^\\)\\(m5_[_a-zA-Z0-9]*\\)" (2 d-face-m5 t))
       ("\\([][\" ().,<>='-]\\|^\\)\\(m6_[_a-zA-Z0-9]*\\)" (2 d-face-m6 t))

       (,(concat "\\(\\<m4" "_dnl\\>\\)\\([^\r\n]*\\)$") (1 d-face-m4-dnl t) (2 font-lock-comment-face t))
       (,(concat "\\(\\<m4" "_ignore\\>\\)")             (1 d-face-m4-dnl t))

       ("^\\(H2\\)(\\([^()\n\r]*\\))?"                       (1 bold t) (2 font-lock-function-name-face t))
       ("^\\(H2\\)(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (1 bold t) (2 font-lock-function-name-face t))

       ("^\\(H3\\)(\\([^()\n\r]*\\))?"                       (1 bold t) (2 font-lock-function-name-face t))
       ("^\\(H3\\)(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (1 bold t) (2 font-lock-function-name-face t))

       ("^\\(H4\\)(\\([^()\n\r]*\\))?"                       (1 bold t) (2 font-lock-function-name-face t))
       ("^\\(H4\\)(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (1 bold t) (2 font-lock-function-name-face t))

       ("\\(\\<NOTE[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 bg:lightmagenta t) (2 fg:lightmagenta t))
       ("\\(\\<TODO[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 bg:lightmagenta t) (2 fg:lightmagenta t))
       ("\\(\\<COOL[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 bg:lightmagenta t) (2 fg:lightmagenta t))

       ("&[a-zA-Z0-9]+;"  0 d-face-html-entity t)
       ("&#[0-9]+;"       0 d-face-html-entity t)

       ("^[ \t]*[ \t]*[\r\n]" 0 d-face-linefeed t))))

  (when (and prefs-font-xtra-p (eq major-mode 'asm-mode))
    (d-font-lock-add-end
     '(
       ("\\(^\tcall[ \t]*\\)\\([^\n]*$\\)" (1 fg:white t) (2 bg:yellow t))
       ("\\<_debug\\|_smeg\\>" 0 bg:yellow t)
       )))

  (when (and prefs-font-xtra-p (eq major-mode 'java-mode))
    (d-font-lock-add-begin
     `(
       ("\\(\\<[A-Z]+[a-z][A-Za-z0-9]*\\)\\." 1 font-lock-constant-face nil)
       ("\\<_\\sw+"                           0 d-face-green-and-black t)
       ("\\(\\<assert\\>\\)"                 (0 fg:lightred t))
       ("\\(\\<assert\\)\\([^\n]*\\);"      (1 fg:lightred t) (2 fg:white t))
       ("\\<\\(Assert\\)\\."                  1 font-lock-keyword-face nil)
       ("\\<\\(assertEquals\\|assertFalse\\|assertNotNull\\|assertNotSame\\|assertNull\\|assertSame\\|assertTrue\\|fail\\)(" 1 font-lock-keyword-face nil)
       ("\\<\\(append\\(ln\\)?\\)("                    1 d-face-cc-global t)
       ("\\<\\(System\\.[^(){} \r\n]*\\)("             1 d-face-cc-global t)
       ("\\.\\(printStackTrace\\)("                    1 d-face-cc-global nil)

       (,(concat "\\<\\(nu" "ll\\|true\\|false\\)\\>") 1 font-lock-constant-face nil)
       )))

  (when (and prefs-font-lisp++-p prefs-font-xtra-p)
    (if (or (eq major-mode 'c++-mode)
            (eq major-mode 'text-mode)
            (and (buffer-file-name) (or (string-match "eraseme" (buffer-file-name))
                                        (string-match "\\.\\(method\\|lisp\\+\\+\\|temp\\)$" (buffer-file-name)))))
            ;;(eq major-mode 'text-mode) ;;; NOTE: no because of Abcdef would be fontified in text-mode
        (d-font-lock-add-end
         '(
           ("\\(\\<[A-Z]+[a-z][a-zA-Z0-9_]*<.+>\\)::"     1 font-lock-type-face nil)
           ("\\(\\<[A-Z]+[a-z][a-zA-Z0-9_]*_A<.+>\\)::"   1 font-lock-type-face nil)

           ;;("\\<String\\>"                  0 font-lock-type-face t)
           ;;("\\<String_Buffer\\>"           0 font-lock-type-face t)

           ("\\<[A-Z]+[a-z][a-zA-Z0-9_]*_A::"            0 font-lock-type-face     nil)
           ("\\<\\(Allegro_Init\\|Auto_G_C\\|Dialog\\|File_Reader\\|File_Writer\\|Font\\|Font_Mine\\|Gulper\\|Reader\\|Reader_Core\\|Return_Values\\|Round\\|Sprite_A\\|Sprite_Grabber\\|Temp_Blit\\|Writer\\)\\>"  0 font-lock-type-face     nil)
           ("\\<[A-Z]+[a-z][a-zA-Z0-9_]*::"                        0 font-lock-type-face nil)
           ("\\<[A-Z]+[a-z][a-zA-Z0-9_]*<[A-Z]+[0-9a-zA-Z_]*>" 0 font-lock-type-face nil)
           ("\\<Array<Array<[A-Z]+[a-zA-Z0-9]*> >"           0 font-lock-type-face nil)
           ("\\<ptr<[A-Z]+[a-z][a-zA-Z0-9_]*>"                   0 font-lock-type-face nil)
           ("\\<ptr<[A-Z]+[a-z][a-zA-Z0-9_]*<[A-Z]+> >"          0 font-lock-type-face nil)
           ("\\<ptr<[A-Z]+[a-z][a-zA-Z0-9_]*<[A-Z]+[a-z][a-zA-Z0-9_]*> >" 0 font-lock-type-face nil)
           ("\\<ptr<[A-Z]+[a-z][a-zA-Z0-9_]*<[A-Z]+[a-z][a-zA-Z0-9_]*<[A-Z]+[a-z][a-zA-Z0-9_]*> > >" 0 font-lock-type-face nil)
           ("\\<[A-Z]+[a-z][a-zA-Z0-9_]*\\*+"  0 d-face-cc-illegal-type t)

           )
         )))

  (when (and prefs-font-xtra-p (or (eq major-mode 'c-mode)
                                 (eq major-mode 'c++-mode)
                                 (eq major-mode 'java-mode)))
    (d-font-lock-add-end
     '(
       ("/[*][*][*].*[*][*][*]/" 0 d-face-super-comment t)
       ;;("/faggot/"               0 d-face-super-comment t)
       )))

  (when (and prefs-font-xtra-p (or (eq major-mode 'c++-mode) (eq major-mode 'emacs-lisp-mode)))
    (d-font-lock-add-end
     '(
       ("N?DEBUG:.*$" 0 fg:lightmagenta t)
       ("\\(\\<LINE:[0-9]+\\)[ \t\n]" 1 d-face-m4 t)

       )))

  (when (and prefs-font-xtra-p (eq major-mode 'gud-mode))
    (d-font-lock-add-end
     '(
       ("^(gdb)" 0 fg:white)
       ("^\\((gdb) \\)?\\(print\\)" 2 bg:yellow)
       ("^\\((gdb) \\)?\\(bt\\)" 2    bg:yellow)
       ("at \\([^ ]+:[0-9]+\\)" 1 fg:lightred)
       ("in \\([^ (]+\\) ?(" (1 bg:yellow t))
       ("#0  \\([^(]+\\)" (1 bg:yellow t))
       ("^.*(y or n)"    0 font-lock-keyword-face)
       )))

  (if (and prefs-font-xtra-p
           (buffer-file-name)
           (or (string-match diary-file (buffer-file-name))
               (eq major-mode 'tex-mode)))
      (d-font-lock-add-end
       '(
         ("^\\(January\\|February\\|March\\|April\\|May\\|June\\|July\\|August\\|September\\|October\\|November\\|December\\) \\([0-9]+, [0-9][0-9][0-9][0-9]\\)[ \t]+\\([^ ].*$\\)" (1 bg:yellow) (2 bg:yellow) (3 fg:white))
         ("Blood.*$" 0 fg:lightred t)
         )))

  (when (and prefs-font-p prefs-font-xtra-p
             (or (eq major-mode 'text-mode)
                 (eq major-mode 'emacs-lisp-mode)))
    (d-font-lock-add-end
     '(
       ("\\<emacs-dialect--[-a-z+]*-p\\>"           0 d-face-cc-global  nil)
       ("\\<prefs-[-a-z+]*-p"                       0 d-face-cc-global  nil)
       ("\\<os-type--[-a-z+]*-p\\>"                 0 d-face-cc-global  nil)
       ("\\<emacs-version\\>"                       0 d-face-cc-global  nil)
       ("\\<noninteractive\\>"                      0 d-face-cc-global  nil)
       ("\\<window-system\\>"                       0 d-face-cc-global  nil)
       ("\\<d-[-a-zA-Z0-9+:&]*\\>"                  0 d-face-el-d-stuff nil)
       ("\\<dc-[-a-zA-Z0-9+:&]*\\>"                 0 d-face-el-d-stuff nil)
       ("\\<bak--[-a-zA-Z0-9+:&]*\\>"               0 d-face-el-d-stuff nil)
       ("\\<cbrow--[-a-zA-Z0-9+:&]*\\>"             0 d-face-el-d-stuff nil)
       ("\\<cfm--[-a-zA-Z0-9+:&]*\\>"               0 d-face-el-d-stuff nil)
       ("\\<cull-same-dates--[-a-zA-Z0-9+:&]*\\>"   0 d-face-el-d-stuff nil)
       ("\\<cull-size-quota--[-a-zA-Z0-9+:&]*\\>"   0 d-face-el-d-stuff nil)
       ("\\<diagnose--[-a-zA-Z0-9+:&]*\\>"          0 d-face-el-d-stuff nil)
       ("\\<demises--[-a-zA-Z0-9+:&]*\\>"           0 d-face-el-d-stuff nil)
       ("\\<datify--[-a-zA-Z0-9+:&]*\\>"            0 d-face-el-d-stuff nil)
       ("\\<flacs-compare[-a-zA-Z0-9+:&]*\\>"       0 d-face-el-d-stuff nil)
       ("\\<manaaki[-a-zA-Z0-9+:&]*\\>"             0 d-face-el-d-stuff nil)
       ("\\<meal-timer[-a-zA-Z0-9+:&]*\\>"          0 d-face-el-d-stuff nil)
       ("\\<my-[-a-zA-Z0-9+:&]*\\>"                 0 d-face-el-d-stuff nil)
       ("\\<log--[-a-zA-Z0-9+:&]*\\>"               0 d-face-el-d-stuff nil)
       ("\\<font-lock-[-a-zA-Z0-9+:&]*\\>"          0 d-face-el-d-stuff nil)
       ("\\<flacs-[-a-zA-Z0-9+:&]*\\>"              0 d-face-el-d-stuff nil)
       ("\\<rsi-[-a-zA-Z0-9+:&]*\\>"                0 d-face-el-d-stuff nil)
       ("\\<safe-[-a-zA-Z0-9+:&]*"                  0 d-face-el-d-stuff nil)
       ("\\<read-str\\>"                            0 d-face-el-d-stuff nil)
       ("\\<read-ready\\>"                          0 d-face-el-d-stuff nil)
       ("\\<simbad--[-a-zA-Z0-9+:&]*\\>"            0 d-face-el-d-stuff nil)
       ("\\<jtw-[-a-zA-Z0-9+:&]*\\>"                0 d-face-el-d-stuff nil)
       ("\\<jtw2m4-[-a-zA-Z0-9+:&]*\\>"             0 d-face-el-d-stuff nil)
       ("\\<testlinks--[-a-zA-Z0-9+:&]*\\>"         0 d-face-el-d-stuff nil)
       ("\\<trashcan--[-a-zA-Z0-9+:&]*\\>"          0 d-face-el-d-stuff nil)
       ("\\<warn--[-a-z0-9+:&]*\\>"                 0 d-face-el-d-stuff nil)
       ("\\<weblint--[-a-zA-Z0-9+:&]*\\>"           0 d-face-el-d-stuff nil)
       ("\\<ptr[-a-zA-Z0-9+]*"                      0 d-face-el-d-stuff2 nil)
       )))

  (when (and prefs-font-xtra-p (eq major-mode 'makefile-mode))
    (d-font-lock-add-end
     '(
       ("^###+.*$" 0 d-face-super-comment t)
       ;;("^#[^#].*$" 0 font-lock-comment-face t)
       )))

  (when (and prefs-font-xtra-p (or (eq major-mode 'latex-mode)
                                   (eq major-mode 'text-mode)))
    (d-font-lock-add-end
     '(
       ("^%%%+.*$"         0 d-face-super-comment t)
       ("^%.*$"            0 font-lock-comment-face t)
       ("\\(^include\\)\\(([^()]*)\\)" (1 d-face-m4 t) (2 fg:lightgreen t))
       ("\\(\\<ignore\\)(" 1 d-face-m4-dnl t)
       ("\\(\\<dnl\\>\\)\\(.*$\\)" (1 d-face-m4-dnl t) (2 font-lock-comment-face t))
       ("\\<m4_[a-z_]+"       0 d-face-m4 t)
       ("\\<m5_[a-z_]+"       0 d-face-m5 t)
       ("\\<m6_[a-z_]+"       0 d-face-m5 t)
       ("\\(\\<define\\)("  1 d-face-m4 t)
       ("\\(\\<BO\\)\\(([^()]*)\\)" (1 bold t) (2 fg:lightgreen t))
       )
     )
    )

;;;
;;; END COMMENTS:
;;; BEGIN POST COMMENTS:
;;;

  (when (and prefs-font-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c-mode)
              (eq major-mode 'c++-mode)
              (eq major-mode 'java-mode)
              (eq major-mode 'haskell-mode)
              (eq major-mode 'asm-mode)
              ;;(eq major-mode 'html-mode)
              (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'lisp-mode)
              (eq major-mode 'prolog-mode)
              (eq major-mode 'makefile-mode)
              (eq major-mode 'pov-mode)
              (eq major-mode 'latex-mode)
              (eq major-mode 'fundamental-mode)
              (eq major-mode 'text-mode)
              (eq major-mode 'compilation-mode)
              (eq major-mode 'wiki-mode)
              (eq major-mode 'jtw-mode)
              (eq major-mode 'tes-mode)
              )
      ;;(d-foo)
      (d-font-lock-add-end
       '( ;; vvvv foooo    nnnn foooo
         ("\\(vvv+\\|nnn+\\)\\(\\([ ][^ \t\n]+\\)+\\)\\([ \t]\\|$\\)" (1 fg:red t) (2 fg:lightblue t))
         ;;  (1) zap skip                     (23443) sdfsdf
         ;; [ ]* 0 ...
         ;; [ ][ ]*    is [ ]+    is 1 ...
         ;; [ ][ ][ ]* is [ ][ ]+ is 2 ...
         ;; (234) not fontified
         ;;  (234) yes fontified
         ;;   (234) yes fontified
         ;;   (234)yes fontified
         ;;("\\(^\\|[ \t]\\)\\(([0-9*. ]+)\\)\\(\\([ ][^ \t\n]+\\)+\\)\\([ \t]\\|$\\)"
         ("\\(^\\|[ \t][ \t]+\\)\\(([0-9*. ]+)\\)\\(.*\\)" (2 fg:red t) (3 fg:lightblue t))
         ;; IMPORTANT NOTES: smeg    mazza
         ;; A    SEF BAR: dfgsdfgsd
         ;;  (123) abc
;;; FIXME: sdfsdfsdfdfdf
         ;;("\\(\\(\\<[A-Z][^a-z\n!:;() ]*[ ]\\)*[:]+\\)\\(.*$\\)"
         ;;("abc[$]" 0 bg:yellow)

         ))))

  (when (and prefs-font-p prefs-font-xtra-p (not noninteractive))
    (when (or (eq major-mode 'text-mode)
              (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'compilation-mode)
              (eq major-mode 'makefile-mode))
              ;;(eq major-mode 'java-mode)
              ;;(eq major-mode 'c++-mode)
              ;;(eq major-mode 'c-mode)
      (d-font-lock-add-end
       '(
         ;; NOTE: File paths
         ;;  /sdfasdffsd/dasfasdff
         ;; ~/sdfasdffsd/dasfasdff
         ;; ~dmp/sdfasdffsd/dasfasdff
         ;; c:/affsdaf
         ;; "c:/asdsd"
         ;;("\\(~/foo\\)"                    1 d-face-path t)
         ("\\(^\\|[^-a-zA-Z0-9_:/.$]\\)\\(~[a-z0-9_]*/[^? ()\t\r\n\":;']*\\)"      2 d-face-path t)
         ("\\(^\\|[^-a-zA-Z0-9_:/.$]\\)\\([a-zA-Z]:/[^ ()\t\r\n\":;']*\\)"         2 d-face-path t)
         ("\\(^\\|[^-a-zA-Z0-9_:/.$]\\)\\([.][./]+[^][ ()\t\r\n\":;']+\\)"         2 d-face-path t)
         ;;("\\(^\\|[^a-zA-Z0-9_:=/.]\\)\\(/[^][ ()\t\r\n\":;']+\\)"                2 d-face-path t)
         ("\\(^\\|[^-a-zA-Z0-9_:/.+$]\\)\\([-A-Za-z0-9_][-A-Za-z0-9/+$_]*\\(\\.[-a-zA-Z0-9_+$]+\\)+\\)" 2 d-face-super-comment t)
         ;;("\\(^\\|[^a-zA-Z0-9:=/.]\\)cd \\([-A-Za-z0-9/.+_$]+\\)"               2 d-face-path t)
         ;;("\"[a-zA-Z]:/[^\"\t\r\n]*\""                                          0 d-face-path)
         ;;("sex" 0 d-face-path t)
         ))))

  (when (and prefs-font-p prefs-font-xtra-p (not noninteractive))
    (when (or (eq major-mode 'text-mode)
              (eq major-mode 'html-mode))
      (d-font-lock-add-end
       '(
;;; Headings
         (">>>+.*$"     0 bg:yellow t)
         ("====+.*$"    0 bg:yellow t)
         ("^#+.*$"      0 bg:yellow t)
         ("^[ \t]+#.*$" 0 fg:lightred t)
         ))
      ;;(set (make-local-variable 'font-lock-string-face) nil)
      ))

  (when (or (eq major-mode 'html-mode)
            (eq major-mode 'text-mode))
    (d-font-lock-add-end
     `(
       (,(concat "\\<RE" "D([^()]*)")                0 fg:red t)
       (,(concat "\\<RE" "D([^()]*([^()]*)[^()]*)")  0 fg:red t)
       (,(concat "\\<GR" "N([^()]*)")                0 fg:lightgreen t)
       (,(concat "\\<GR" "N([^()]*([^()]*)[^()]*)")  0 fg:lightgreen t)
       (,(concat "\\<PU" "R([^()]*)")                0 fg:magenta t)
       (,(concat "\\<PU" "R([^()]*([^()]*)[^()]*)")  0 fg:magenta t)
       (,(concat "\\<BL" "U([^()]*)")                0 fg:blue t)
       (,(concat "\\<BL" "U([^()]*([^()]*)[^()]*)")  0 fg:blue t))))

  (when (eq major-mode 'text-mode)
    (d-font-lock-add-end
     '(
       ("</?[a-z]+>" 0 default t)
       ("\\<\\(public\\|protected\\|package\\|private\\)\\>" 1 bold t)
       )))

  (when (and prefs-font-xtra-p (eq major-mode 'makefile-mode))
    (d-font-lock-add-end
     '(
       ("^#[^#].*$" 0 font-lock-comment-face t)
       )))

  (d-quote
   (d-font-lock-add-end
    '(

      ("abc" 0 d-face-cc-global t) ;; defabcdef

      )))

  (if (eq major-mode 'html-mode)
      (font-lock-add-keywords nil
                              '(
                                ("\\(^\\|[ ()]\\)\\(_[a-zA-Z0-9_]+\\)" 2 d-face-cc-private t)
                                )))

  (if (string= "*Class Browser*" (buffer-name))
      (d-font-lock-add-end
       '(
         ("\\(SUPERCLASS:\\|SUBCLASS:\\) \\([a-zA-Z0-9_]+\\)"
          (1 bold t)
          (2 font-lock-type-face t)
          )
         ("\\([a-zA-Z0-9_]+::\\)\\([a-zA-Z0-9_]+\\)"
          (1 fg:lightred t)
          (2 font-lock-type-face t))
         ("\\(::\\)\\([a-zA-Z0-9_]+\\)"
          (1 bold t)
          (2 font-lock-type-face t))
         ("\\(LINE:\\)\\([0-9]+\\)" (1 bold t) (2 fg:lightgreen t))
         ("\\(public\\|private\\|protected\\) \\([a-zA-Z0-9_]+\\)"
          (2 font-lock-type-face t))
         )))

  (if (eq major-mode 'c++-mode)
      (d-font-lock-add-end
       '(
         ("reinterpret_cast<\\([a-zA-Z0-9_]*[&*]*\\)>"
          (1 font-lock-type-face nil))
         ("sizeof(\\([a-zA-Z0-9_]+[&*]*\\))"
          (1 font-lock-type-face nil))
         )))

  (if (eq major-mode 'java-mode)
      (d-font-lock-add-end
       '(
         ("for[ \t]*(\\([A-Z][a-zA-Z0-9_]*\\)[ \t]+\\([a-z][A-Za-z0-9_]*\\)"
          (1 font-lock-type-face t)
          (2 font-lock-variable-name-face t))

         ("\\(\\<[A-Z][a-zA-Z0-9_<>,]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*\\)("
          (1 font-lock-type-face t)
          (2 font-lock-function-name-face t))

         ("\\(\\<[A-Z][a-zA-Z0-9_<>,]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*\\)[ \t]*[;=]"
          (1 font-lock-type-face t)
          (2 font-lock-variable-name-face t))

         ;;("\\([A-Z][a-zA-Z0-9_]+\\)<\\([A-Z][a-zA-Z0-9_,]*\\)> +\\([a-zA-Z0-9_]+\\)"
         ;; (1 font-lock-type-face nil)
         ;; (2 font-lock-type-face nil)
         ;; (3 font-lock-variable-name-face nil)
         ;;)
         ;;("\\([A-Z][a-zA-Z0-9_]+\\)<\\([A-Z][a-zA-Z0-9_,]*\\)> +\\([a-zA-Z0-9_]+\\)("
         ;; (1 font-lock-type-face nil)
         ;; (2 font-lock-type-face nil)
         ;; (3 font-lock-function-name-face t)
         ;;)
         ;;("\\([A-Z][a-zA-Z0-9_]+\\)<\\([a-zA-Z0-9_]+\\)>("
         ;; (1 font-lock-type-face nil)
         ;; (2 font-lock-type-face nil)
         ;; ;;(4 font-lock-variable-name-face nil)
         ;;)
         ("\\(public\\) \\([A-Z][a-zA-Z0-9_]+\\)("
          (2 font-lock-function-name-face nil)
          )
         ("\\<\\(ctor[_A-Za-z0-9]*\\)(" 1 d-face-cc-ctor-dtor nil)
         )))

  (if (eq major-mode 'c-mode)
      (d-font-lock-add-end
       '(
         ;;("\\(\\<foo\\)(" 1 fg:lightred t)
         ("\\(\\<alert\\)(" 1 fg:lightred t)
         )
       )
    )

  (when (eq major-mode 'java-mode)
    (d-font-lock-add-end
     '(
       ("instanceof \\([a-zA-Z0-9_]*\\)" 1 font-lock-type-face nil)
       ("<[a-zA-Z0-9_]+,[a-zA-Z0-9_]+>"  0 font-lock-type-face nil)
       )))

  (when (and prefs-font-xtra-p (or (eq major-mode 'compilation-mode)
                                 ;;(eq major-mode 'c++-mode)
                                 (eq major-mode 'c2j-mode)
                                 (eq major-mode 'Info-mode)))
    (d-font-lock-add-begin
     '(
       ("(\\([^ ()]*\\.jtw\\):\\([0-9]+\\))" (1 d-face-link t) (2 d-face-line t))

       ;; NOTE: Various levels of documentation
       ;;("^\\*.*$"             0 fg:cyan t)
       ;;("^\\*\\*.*$"          0 fg:green t)
       ;;("^\\*\\*\\*.*$"       0 fg:lightred t)
       ;;("^\\*\\*\\*\\*.*$"    0 bg:yellow t)

       ("^[ \t]*/*[*][^\r\n]*[\r\n]+"          0 fg:lightblue t)
       ("^[ \t]*/*[*][*][^\r\n]*[\r\n]+"       0 fg:lightgreen t)
       ("^[ \t]*/*[*][*][*][^\r\n]*[\r\n]+"    0 fg:lightred t)
       ("^[ \t]*/*[*][*][*][*][^\r\n]*[\r\n]+" 0 bg:yellow t)

       ("^cd .*$"                            0 font-lock-keyword-face t)
       ("^make .*$"                          0 font-lock-keyword-face t)
       ("^.*tar cf.*$"                       0 font-lock-keyword-face t)
       ("^-----.*$"                          0 fg:cyan t)
       ("^\\(Compilation\\|Grep\\) \\(started\\|exited\\|finished\\|interrupt\\).*$" 0 font-lock-keyword-face t)
       ("^Compilation took.*$" 0 font-lock-keyword-face t)

       )))

  (d-quote when (and prefs-advanced-user-p (eq major-mode 'c2j-mode))
    (d-font-lock-add-end
     '(
       ("\\<nop beg.*$"  0 font-lock-function-name-face t)
       ("\\<nop end.*$"  0 font-lock-function-name-face t)
       ("\\<nop BEG.*$"  0 font-lock-function-name-face t)
       ("\\<nop END.*$"  0 font-lock-function-name-face t)
       )))

  (when (eq major-mode 'emacs-lisp-mode)
    (d-font-lock-add-end
     '(
       ("\\<assert\\>" 0 'fg:lightred nil))))

  (when (and (or (eq major-mode 'html-mode)
                 (eq major-mode 'php-mode))
             (save-excursion
               (goto-char (point-min))
               (re-search-forward "<\\?php" nil t)))
    (d-font-lock-add-begin
     `(
       ("\\<\\(class\\)[ \t]+\\([A-Za-z0-9_]+\\)" (1 bold t) (2 font-lock-type-face t))
       ("\\<\\(var\\)[ \t]+\\([$]?[a-zA-Z0-9_]+\\)" (1 font-lock-keyword-face nil) (2 font-lock-type-face t))
       ("^[ \t]*\\(\\(\\(public\\|private\\|protected\\|static\\)[ \t]*\\)*\\)\\(function\\)[ \t]+\\(&?[a-zA-Z0-9_]+\\)(" (1 bold t) (4 bold t) (5 font-lock-function-name-face t))
       ("\\<\\(function\\)[ \t]+\\([a-zA-Z0-9_]+\\) ?("  (1 bold t) (2 font-lock-function-name-face t))
       ("\\<\\(define\\)\\>" 1 bold t)
       ("\\<\\(\\(ORDER BY\\|GROUP BY\\|WHERE\\|FROM\\|SELECT\\|INSERT\\|UPDATE\\|DELETE\\).*\\)" 1 fg:lightred t)
       ("\\<\\(public\\|private\\|protected\\|final\\|abstract\\)\\>" 1 bold t)
       ("\\<\\(extends\\)[ \t]+\\([A-Z][a-zA-Z0-9_]+\\)"    (1 bold t) (2 font-lock-type-face t))
       ("\\<\\(implements\\)[ \t]+\\([A-Z][a-zA-Z0-9_]+\\)" (1 bold t) (2 font-lock-type-face t))
       ("^\\<\\(global\\|header\\|foreach\\)\\>"           1 bold t)
       ("\\<\\(alert\\|require_once\\|require\\|include_once\\|include\\)\\>" (1 bold t))
       ("\\<\\(MYSQL_[A-Z_]*\\|mysqli?_[a-z_]*\\)\\>"   1 fg:brown t)
       ("\\<\\(unset\\|as\\|global\\|exit\\|for\\|xconst\\|gmdate\\|foreach\\|default\\|case\\|break\\|switch\\|continue\\|static\\|echo\\|and\\|or\\|while\\|if\\|else\\|elseif\\|return\\)\\>" 1 fg:brown nil)

       ("\\<assert\\>" 0 fg:lightred t)
       ("\\<\\(array_length\\|h1\\|h1error\\|h1ok\\|pre\\)(" 1 prop-face t)
       ("\\<h1debug\\>" 0 fg:lightcyan t)
       ("\\<\\(endif\\|endforeach\\);" 1 fg:brown t)
       ("\\<\\(my[a-zA-Z0-9_]*\\)(" 1 bold t)
       ("\\<\\(form_open\\|form_close\\)(" 1 d-face-path t)
       ("\\<\\(fgets\\|srand\\|mkdir\\|move_uploaded_file\\|mail\\|array_slice\\|list\\|chr\\|hexdec\\|microtime\\|url_title\\|pdf_create\\|get_instance\\|config_item\\|redirect\\|extension_loaded\\|show_error\\|ucfirst\\|get_class\\|method_exists\\|prep_url\\|auto_link\\|auto_typography\\|nl2br\\|cos\\|sin\\|preg_quote\\|ord\\|str_repeat\\|is_object\\|md5\\|rand\\|version_compare\\|error_reporting\\|phpversion\\|array_splice\\|func_get_args\\|eval\\|class_exists\\|is_bool\\|round\\|count\\|form_hidden\\|log_message\\|formatted_invoice_date\\|floor\\|now\\|anchor\\|strtotime\\|site_url\\|new\\|timespan\\|explode\\|implode\\|end\\|preg_replace_callback\\|rawurldecode\\|sprintf\\|in_array\\|is_array\\|exec\\|escapeshellarg\\|is_readable\\|is_writable\\|defined\\|is_string\\|preg_match\\|is_null\\|strncmp\\|str_pad\\|str_replace\\|strlen\\|strpos\\|strrpos\\|substr\\|strtolower\\|strtoupper\\|substr_count\\|is_numeric\\|strrev\\|array\\|for\\|preg_replace\\|preg_split\\|[lr]?trim\\|function_exists\\|exit\\|is_dir\\|isset\\|time\\|date\\|mktime\\|file_exists\\|dirname\\|flock\\|feof\\|empty\\|fputcsv\\|fgetcsv\\|fclose\\|fwrite\\|htmlspecialchars\\|fopen\\|add_filter\\|add_action\\|do_action\\|sha1\\)(" 1 fg:brown nil)
       ("||\\|&&" 0 bold t)
       ("\\<wp_[a-zA-Z0-9_]*" 0 fg:brown t)
       ("(\\(array\\|int\\|string\\|float\\))" 0 font-lock-type-face t)
       ("\\<\\(self\\)::" 1 font-lock-type-face t)
       ("\\<\\(instanceof\\)[ \t]+\\([A-Z][a-zA-Z0-9_]*\\)\\>" (1 bold t) (2 font-lock-type-face t))
       ("\\<\\(die\\)("                                                                                  (1 bold t))
       ("\\<[A-Z][A-Z_]+\\>" 0 fg:lightred nil)
       (,(concat "\\<\\(true\\|false\\|nu" "ll\\)\\>") 1 fg:lightred nil)
       ("[$][a-zA-Z_][a-zA-Z0-9_]+"       0 font-lock-variable-name-face t)
       ("\\<\\([0-9]+\\(\\.[0-9]+\\)?\\)" 1 d-face-cc-digits nil)
       ("\\<\\(new\\)[ \t]+\\([A-Z][a-zA-Z0-9_]*\\)(" (1 bold t) (2 font-lock-type-face t))
       ("[a-zA-Z0-9]+::[a-zA-Z0-9_]+" 0 font-lock-type-face t)
       ;;("^[ \t]*\\(//.*$\\)" 1 font-lock-comment-face nil)
       ("\\<E_[A-Z_]*" 0 bold t)
       ("[^a-zA-Z0-9_]\\(_[a-zA-Z0-9_]*\\)"      1 d-face-cc-private t)
       ;;("[^\\]\\(\"\\([^\"\r\n]\\|\\\"\\)*\"\\)" 1 font-lock-string-face t)
       ;;("[^\\r\n]*"                           0 font-lock-string-face t)
       ;;("\"\\([^\"]\\|\\\\\\\"\\)*\"" 0 font-lock-string-face t)
       ("mb_[a-zA-Z0-9_]*" 0 fg:brown t)

       ("\\(@[a-z][a-zA-Z0-9_]*\\)\\([^{}()\r\n]*\\)" (1 fg:lightred t) (2 d-face-super-comment t))
       ("\\<number_format\\>" 0 fg:brown t)
       ;;("Modify" 0 fg:lightred t)
       )))

     ;;; end of smegs

  (when (and prefs-font-p prefs-font-xtra-p (eq major-mode 'emacs-lisp-mode))
    (d-font-lock-add-end
     '(
       ("\\<\\(oset\\|oref\\)\\>" 1 bold t)
       ("\\(\\<make-instance\\>\\)" 1 bold t)
       ("\\(\\<eieio[a-zA-Z0-9-]*\\)" 1 d-face-cc-global t)
       )))

  (when (and prefs-font-p prefs-font-xtra-p)
    (when (or (eq major-mode 'c-mode)
              (eq major-mode 'c++-mode)
              (eq major-mode 'java-mode)
              (eq major-mode 'haskell-mode)
              (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'lisp-mode)
              (eq major-mode 'prolog-mode)
              (eq major-mode 'makefile-mode)
              (eq major-mode 'pov-mode)
              ;;(eq major-mode 'latex-mode)
              ;;(eq major-mode 'fundamental-mode)
              ;;(eq major-mode 'text-mode)
              (eq major-mode 'compilation-mode)
              (eq major-mode 'tes-mode)
              (eq major-mode 'php-mode)
              ;;(eq major-mode 'jtw-mode)
              ;;(eq major-mode 'html-mode)
              )
      (d-font-lock-add-end
       `(
         ("\\(^\\|[][ ()]\\)\\(m4_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 d-face-m4 t)
         ("\\(^\\|[][ ()]\\)\\(m5_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 d-face-m5 t)
         ("\\(^\\|[][ ()]\\)\\(m6_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 d-face-m6 t)
         (,(concat "\\<m4" "_ignore\\>")                   0 d-face-m4-dnl t)
         (,(concat "\\(\\<m4" "_dnl\\>\\)\\([^\r\n]*\\)$") (1 d-face-m4-dnl t) (2 font-lock-comment-face nil))
         ;;("^[ \t]*.*\n" 0 d-face-linefeed t)
         ("---+" 0 fg:lightred t)  ;; -------------
         ("<--+" 0 fg:lightred t)  ;; <----------
         ))))

  )

(defun d-font-lock-mode-hook--post ()

  (when (and prefs-font-xtra-p (or (eq major-mode 'c-mode)
                                   (eq major-mode 'c++-mode)
                                   (eq major-mode 'java-mode)
                                   (eq major-mode 'html-mode)
                                   ))
    (d-font-lock-add-end
     '(
       ("^[ \t]*//.*$"  0 font-lock-comment-face t)
       ("^[ \t]*///.*$" 0 d-face-super-comment   t)
       )))

  (when (and prefs-font-p prefs-font-xtra-p (not noninteractive))
    (when (or (eq major-mode 'c-mode)
              (eq major-mode 'c++-mode)
              (eq major-mode 'java-mode)
              (eq major-mode 'haskell-mode)
              (eq major-mode 'asm-mode)
              (eq major-mode 'html-mode)
              (eq major-mode 'php-mode)
              (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'lisp-mode)
              (eq major-mode 'prolog-mode)
              (eq major-mode 'makefile-mode)
              (eq major-mode 'pov-mode)
              (eq major-mode 'latex-mode)
              (eq major-mode 'fundamental-mode)
              (eq major-mode 'text-mode)
              (eq major-mode 'compilation-mode)
              (eq major-mode 'wiki-mode)
              (eq major-mode 'jtw-mode)
              (eq major-mode 'css-mode)
              (eq major-mode 'tes-mode)
              (eq major-mode 'c2j-mode)
              (eq major-mode 'sql-mode)
              )
      (d-font-lock-add-end
       '(
         ;; FOO-SAD-FSDF: sadfadf
         ;; NOTE: adfasdfosdf
         ;;("\\([ ]\\|^\\)\\(\\([A-z'-]+[ ]\\)*[A-Z][A-Z0-9.'-]+:\\) \\(.*$\\)"
         ;; (2 d-face-special-reference t) (4 d-face-cc-debugging t)) ;; was fg:white

         ("\\([A-Z][a-zA-Z0-9_]*\\)::" 1 font-lock-type-face nil)
         ("\\([A-Z]*\\):" (1 fg:white nil))

         ;; QUESTION: hello (not smegged)
         ;;("DUCK" 1 d-face-property t)
         ("\\(\\<BACK ADDED:\\)\\(.*$\\)"                    (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<LIMITATION[-A-Z +]*:\\)\\(.*$\\)"           (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<CODE:\\)\\([A-Z +]*\\)\\(.*$\\)"            (1 bg:lightgreen t) (2 fg:lightgreen t) (3 default t))
         ("\\(\\<NOT FOUND:\\)\\(.*$\\)"                     (1 bg:lightgreen t) (2 fg:lightgreen t))
         ("\\(\\<DELETE ?ME:\\)\\(.*$\\)"                    (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<FIXED:\\)\\(.*$\\)"                         (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<BURNED:\\)\\(.*$\\)"                        (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<SOLUTION:\\)\\(.*$\\)"                      (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<SEE:\\)\\(.*$\\)"                           (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<NEW[A-Z ]*:\\)\\(.*$\\)"                    (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<COPY:\\)\\(.*$\\)"                          (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<RENAME:\\)\\(.*$\\)"                        (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<PUT:\\)\\(.*$\\)"                           (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<URL:\\)\\(.*$\\)"                           (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<COOL:\\)\\(.*$\\)"                          (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<TOMORROW:\\)\\(.*$\\)"                      (1 d-face-cc-debugging t) (2 fg:lightgreen t))
         ("\\(\\<FAILED[A-Z +]*\\)\\(.*$\\)"                 (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<MISSING[A-Z +]*\\)\\(.*$\\)"                (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<REMOVE ?ME:\\)\\(.*$\\)"                    (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<PUT BACK:\\)\\(.*$\\)"                      (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<NOT DO:\\)\\(.*$\\)"                        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<TEMP:\\)\\(.*$\\)"                          (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<SEARCH FOR:\\)\\(.*$\\)"                    (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<COMPILE:\\)\\(.*$\\)"                       (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ;;("\\(\\<ADD[A-Z ]*:\\)\\(.*$\\)"                  (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<FIXME[?:!]+\\)\\(.*$\\)"                    (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<BROKEN[-A-Z0-9 .+&/]*[:?]\\)\\(.*$\\)"      (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<DONT[-A-Z0-9 .+&/]*[:?]\\)\\(.*$\\)"        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<TODO[-A-Z0-9 .+&/]*[:?]\\)\\(.*$\\)"        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<TEST[-A-Z0-9 .+]*[:?]\\)\\(.*$\\)"          (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<PULL ?OUT:\\)\\(.*$\\)"                     (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<LATER:\\)\\(.*$\\)"                         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<PROBLEM:\\)\\(.*$\\)"                       (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<CLASH:\\)\\(.*$\\)"                         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ;;("\\(\\<REVERTED[A-Z0-9 .]*:\\)\\(.*$\\)"         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<REVERTED[-A-Z0-9 .+]*:\\)\\(.*$\\)"           (1 d-face-property-inverse t) (2 d-face-property t))

         ("\\(\\<PULLED BACK[-A-Z0-9 .+]*:\\)\\(.*$\\)"        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<DEBUG[-A-Z0-9 .+]*:\\)\\(.*$\\)"              (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<DEBUGGED[-A-Z0-9 .+]*:\\)\\(.*$\\)"           (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<OKAY[-A-Za-z0-9 +]*:\\)\\(.*$\\)"             (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<HOWTO[-A-Za-z0-9 +]*:\\)\\(.*$\\)"            (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<DOING:\\)\\(.*$\\)"                           (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<ISIN:\\)\\(.*$\\)"                            (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<RESOLVE CLASH:\\)\\(.*$\\)"                   (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<INSTALLED:\\)\\(.*$\\)"                       (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<PATCH[-A-Z0-9 +]*:\\)\\(.*$\\)"               (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<BUG[-A-Z0-9 +]*:\\)\\(.*$\\)"                 (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<WHY[-A-Z0-9 +]*[?:]+\\)\\(.*$\\)"             (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<WHEREIS[-A-Z0-9 +]*[?:]+\\)\\(.*$\\)"         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<PENDING[-A-Z0-9 +]*[?:]+\\)\\(.*$\\)"         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<WTF[-A-Z0-9 +]*[?:]+\\)\\(.*$\\)"             (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<WARNING[-A-Z0-9 +]*[?:]+\\)\\(.*$\\)"         (1 d-face-red-and-yellow t) (2 fg:red t))
         ("\\(\\<ERROR:\\)\\(.*$\\)"                         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<NOT[-a-zA-Z0-9'. +]*:\\)\\(.*$\\)"                         (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<URGENT:\\)\\(.*$\\)"                        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<REDO:\\)\\(.*$\\)"                          (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<REMOVE:\\)\\(.*$\\)"                        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<RESOLVE[-A-Z' +]*:\\)\\(.*$\\)"               (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<BUGGER[-A-Z' +]*:\\)\\(.*$\\)"                (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ("\\(\\<TIME[-A-Z +]*[:!?]\\)[ \t]+\\([^\r\n]*\\)"    (1 bg:lightgreen t)   (2 fg:lightgreen t))
         ("\\(\\<MILESTONE[:!?]\\)[ \t]+\\([^\r\n]*\\)"      (1 bg:lightgreen t)   (2 fg:lightgreen t))
         ("\\(\\<QUERY[:!?]\\)[ \t]+\\([^\r\n]*\\)"          (1 bg:lightmagenta t)   (2 fg:lightmagenta t))
         ("\\(\\<BUGFIXED:\\)\\(.*$\\)"                      (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<NOTE[-A-Z0-9 _.+/]*:\\)\\(.*$\\)"              (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<TOTAL[-A-Z0-9 +]*:\\)\\(.*$\\)"               (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<SPLATTED[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"         (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<SEMI[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"             (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<DONE[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"             (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<GOT[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"              (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<ADDED[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"            (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<CHANGED[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"          (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<REMOVED[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"          (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<DOWNLOADED[-A-Z0-9 .&/+]*:\\)\\(.*$\\)"       (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<NOT DONE[-A-Z0-9,. _+]*:\\)\\(.*$\\)"        (1 bg:lightmagenta t) (2 fg:lightmagenta t))
         ;;("\\(\\<SEMI[A-Z0-9 .&/]*:\\)\\(.*$\\)"           (1 d-face-property-inverse t) (2 d-face-property t))
         ("\\(\\<class:\\) \\([-a-zA-Z0-9_.+]*\\)"            (1 bold t) (2 font-lock-type-face t))
         ("\\(\\<constructor:\\) \\([-a-zA-Z0-9_.+]*\\)"      (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<method:\\) \\([-a-zA-Z0-9_.+]*\\)"           (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<methods:\\) \\(\\([-a-zA-Z0-9_.+]* *\\)*\\)" (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<function:\\) \\([-a-zA-Z0-9_.+]*\\)"         (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<variable:\\) \\([-a-zA-Z0-9_.+]*\\)"         (1 bold t) (2 font-lock-variable-name-face t))
         ("\\(\\<classVar:\\) \\([-a-zA-Z0-9_.+]*\\)"         (1 bold t) (2 font-lock-variable-name-face t))
         ("\\(\\<defun:\\) \\([-a-zA-Z0-9_.+]*\\)"            (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<defmacro:\\) \\([-a-zA-Z0-9_.+]*\\)"         (1 bold t) (2 font-lock-function-name-face t))
         ("\\(\\<file:\\) \\([a-zA-Z0-9_.+]*\\)"              (1 bold t))
         ("\\(\\<line:\\) \\([0-9]+\\)"                       (1 bold t) (2 fg:lightmagenta t))
         ("#[-a-zA-Z0-9'.:+]+"                                 0 font-lock-function-name-face t)
         ;;  end of smegs
         ("^[ \t]*[^\n\r]*[\r\n]"                            0 d-face-red-and-white t)
         ;;("\\<message-and-sit\\>"                            0 d-debug-face t)
         ;; IMPORTANT NOTES! sdfsdf
         ;; IMPORTANT NOTES? sdfsdff
         ("\\(\\<[A-Z]+[^a-z\r\n!:;()]*[A-Z0-9][!?]+\\)\\(.*$\\)"
          (1 d-face-green-and-yellow t)
          (2 bg:yellow t))
         ))
      ))

  (when (and prefs-font-p prefs-font-xtra-p (not noninteractive))
    (setq suffix "\\)\\([ \t\r\n\"\\\\(){}<>,';:]\\|$\\)")
    (when (or (eq major-mode 'text-mode)
              (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'c++-mode)
              (eq major-mode 'html-mode)
              (eq major-mode 'php-mode)
              (eq major-mode 'tes-mode)
              (eq major-mode 'sh-mode)
              (eq major-mode 'c2j-mode)
              (eq major-mode 'java-mode)
              (eq major-mode 'texinfo-mode)
              (eq major-mode 'jtw-mode)
              (eq major-mode 'makefile-mode)
              (eq major-mode 'compilation-mode)
              )
      (d-font-lock-add-end
       `(
         ;;,@(list (concat "[^ \t\r\n(),\"{}]*\\." dc-files-regexp--archives "\\>") 0 dc-face-dired-archives t)
         ;;("[^ \t\r\n(),\"{}]*\\.\\(tar\\.gz\\|tar\\|zip\\)\\>"               0 dc-face-dired-archives   t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(css\\|hts\\|m4\\|html?\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--web)
                   suffix) 1 dc-face-dired-web t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(txt\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--text)
                   suffix) 1 dc-face-dired-text t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(exe\\|bat\\|dll\\|run\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--executable)
                   suffix) 1 dc-face-dired-executable t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(flac\\|mid\\|mp3\\|wav\\|wma\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--sounds)
                   suffix) 1 dc-face-dired-sounds t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(tar\\|gz\\|zip\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--archives)
                   suffix) 1 dc-face-dired-archives t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(bmp\\|dvi\\|eps\\|gif\\|jpg\\|fig\\|ico\\|pdf\\|ps\\|png\\|rle\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--graphics)
                   suffix)  1 dc-face-dired-graphics t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(c\\|ch\\|cc\\|el\\|h\\|hh\\|java\\|js\\|mk\\|php\\|jtw\\|src\\|sty\\|tex\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--sources)
                   suffix) 1 dc-face-dired-sources t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(mpe?g\\|mov\\|avi\\|wmv\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--movies)
                   suffix) 1 dc-face-dired-movies t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(bak\\|class\\|tmp\\|tm4\\|o\\|dep\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--unimportant)
                   suffix) 1 dc-face-dired-unimportant t)
         (,(concat "\\([^ \t\r\n(),=\"{}<>`]*\\."
                   ;;"\\(txt\\)\\)"
                   (d-flock--make-choice-regexp dc-files-list--text)
                   suffix) 1 dc-face-dired-text t)
         ("\\(\\([^ \t\r\n(),=\"{}<>`]*/\\)?Makefile\\)[' \t\r\n]" 1 dc-face-dired-sources t)
         ;; <a href="http://www.foo.com">Not Supposed to be me
         ;; supposed to be me</a>
         ("\\(udp://\\)\\([^ \t\r\n\"<>?]*\\)"            (1 bg:lightred t) (2 fg:lightred t))
         ("<?\\(https?://\\)\\([^ \t\r\n\"<>?]*\\)>?"     (1 bg:lightred t) (2 fg:lightred t))
         ("\\(file:///\\)\\([^ \t\r\n\"<>?]*\\)"          (1 bg:lightred t) (2 fg:lightred t))
         ("\\(ftps?://\\)\\([^ \t\r\n\"<>?]*\\)"          (1 bg:lightred t) (2 fg:lightred t))
         ("\\(mailto://\\)\\([^ \t\r\n\"<>?]*\\)"        (1 bg:lightred t) (2 fg:lightred t))
         ;;("[a-z0-9-]*\\.exe" 1 fg:orange t)
         ;;("\\(^\\|[ \t]\\)\\(/[a-zA-Z0-9][^ )\t\r\n\"]*\\)"                  2 fg:orange t)

         ("\\<gnu\\.emacs\\.bug\\>"                                            0 fg:lightred t)
         ("\\<gnu\\.emacs\\.help\\>"                                           0 fg:lightred t)
         ("\\<gnu\\.emacs\\.sources\\>"                                        0 fg:lightred t)

         ;; NOTE: Websites www.ADASD.Com
         ("\\<[Ww][Ww][Ww]\\.[^ \t\r\n]*"                                            0 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Oo][Mm]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Oo][Rr][Gg]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ee][Du][Uu]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Nn][Ee][Tt]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Nn][Zz]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Aa][Uu]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Uu][Kk]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Aa]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ff][Rr]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Xx]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ii][Ll]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n]"       1 fg:lightred t)
         ;; NOTE EMAIL ADDRESSES:
         ("[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+"                                     0 fg:lightred t)
         ("^[0-9?][0-9?][0-9?][0-9?]-[0-9?][0-9?]-[0-9?][0-9?]" 0 bg:yellow t)

         ;;("#[-a-zA-Z0-9.:]+" 0 font-lock-function-name-face t)
         ;;("~/[^ \t\r\n]*"                         0 d-face-property t)
         ;;("[ \t\r\n]\\([a-fA-F]:/[^ \t\r\n;]*\\)" 1 d-face-property t)

         ;;(1 bg:yellow t) (2 d-face-property t))
         ;;("~/[^ \t\r\n]*" 0 d-face-property nil)
         ))))

  (when (and prefs-font-xtra-p (or (eq major-mode 'emacs-lisp-mode)
                                   (eq major-mode 'html-mode)))
    (d-font-lock-add-end
     `(
       ("\\<m4_[a-zA-Z0-9_]*"                                         0 d-face-m4 t)
       (,(concat "\\<\\(m4_" "define\\)")                             0 d-face-m4 t)
       ("\\<m5_[a-zA-Z0-9_]*"                                         0 d-face-m5 t)
       ("\\<m6_[a-zA-Z0-9_]*"                                         0 d-face-m6 t)
       (,(concat "\\(\\<m4_" "ignore\\)\\(([^()]*)\\)")               (1 d-face-m4-dnl t) (2 font-lock-comment-face t))
       (,(concat "\\(\\<m4_" "ignore\\)\\(([^()]*([^()]*)[^()]*)\\)") (1 d-face-m4-dnl t) (2 font-lock-comment-face t))
       (,(concat "\\(\\<m4_" "dnl\\)\\( .*\\)")                       (1 d-face-m4-dnl t) (1 font-lock-comment-face t))
       )))

  )

(defun d-80-column-hook ()
  (if (and (not noninteractive)
           (or (eq major-mode 'tes-mode)
               (eq major-mode 'emacs-lisp-mode)
               (eq major-mode 'c++-mode)
               (eq major-mode 'html-mode)
               (eq major-mode 'c2j-mode)
               (eq major-mode 'java-mode)
               (eq major-mode 'dired-mode)
               ))
      (if (not (string= "*Class Browser*" (buffer-name)))
          (d-font-lock-add-end
           `(
             (,(concat "^" (make-string 80 ?.) "\\(.\\)") 1 d-face-makefile-space t)
             )))))

(defun d-flock--make-choice-regexp (suffix-list)
  (let ((answer nil)
        (n      0)
        (ptr    suffix-list))
    (setq answer "\\(")
    (while ptr
      (setq answer (concat answer (if (eq n 0) "" "\\|") (car ptr)))
      (incf n)
      (setq ptr (cdr ptr)))
    (setq answer (concat answer "\\)"))))

(kill-local-variable 'c++-font-lock-extra-types)
(if (not (boundp 'c++-font-lock-extra-types))
    (setq-default c++-font-lock-extra-types nil))
(setq-default c++-font-lock-extra-types
              (append '("FILE" "\\sw+_t" "tm" "ptr"
                        "BITMAP" "RGB" "SAMPLE" "PALETTE" "FONT" "RLE_SPRITE" "COLOR_MAP"
                        "PACKFILE" "DATAFILE" "MIDI"
                        "fix" "fixed" "quick"
                        "xy[ifqd]" "pol[iqd]"
                        "v3[iqd]";; "v3f"
                        "istream" "ostream" "streambuf" "filebuf"
                        "dirent" "DIR" "ptr_[a-z0-9_]+"
                        "enum_[a-z_]+" "func_[a-z_]+"
                        "safe_bool" "safe_int" "safe_float" "safe_double" "safe_uchar" "unsigned"
                        "j[a-zA-Z]+"
                        ) c++-font-lock-extra-types))


(progn
  ;;;
  ;;; remove C++ crap from types list
  ;;;
  (setq c++-font-lock-extra-types (delete "ios" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "rope" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "list" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "slist" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "deque" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "vector" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "bit_vector" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "set" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "multiset" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "map" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "multimap" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "stack" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "queue" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "priority_queue" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "iterator" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "const_iterator" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "reverse_iterator" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "const_reverse_iterator" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "reference" c++-font-lock-extra-types))
  (setq c++-font-lock-extra-types (delete "const_reference" c++-font-lock-extra-types))
  )
;; The following code fontifies string classes:
(setq-default c++-font-lock-extra-types (append '("string" "string_buffer") c++-font-lock-extra-types))

;; The following code fontifies capitalised classes:
(kill-local-variable 'c++-font-lock-extra-types)
(setq-default c++-font-lock-extra-types
      (append '("[A-Z]" "[A-Z]+[a-z][a-zA-Z0-9_]*")
              c++-font-lock-extra-types))

(provide 'd-flock)
;;; d-flock.el ends here
