/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.lists.Consumer;
import gnu.lists.Sequence;
import gnu.mapping.CallContext;
import gnu.mapping.CpsProcedure;
import gnu.mapping.Procedure;
import gnu.mapping.Values;

public class ValuesMap
extends CpsProcedure
implements CanInline,
Inlineable {
    public static final ValuesMap valuesMap = new ValuesMap();

    public int numArgs() {
        return 8194;
    }

    public void apply(CallContext callContext) throws Throwable {
        Procedure procedure = (Procedure)callContext.getNextArg();
        Consumer consumer = callContext.consumer;
        Object object2 = callContext.getNextArg();
        Procedure.checkArgCount(procedure, 1);
        if (object2 instanceof Values) {
            Object object3;
            int n = 0;
            Values values = (Values)object2;
            while ((object3 = values.getPosNext(n)) != Sequence.eofValue) {
                callContext.setArgs(object3);
                callContext.proc = procedure;
                callContext.runUntilDone();
                n = values.nextDataIndex(values.posToDataIndex(n));
                n <<= 1;
            }
        } else {
            callContext.setArgs(object2);
            callContext.proc = procedure;
            callContext.runUntilDone();
        }
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 2 && expressionArray[0] instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expressionArray[0];
            lambdaExp.setInlineOnly(true);
            lambdaExp.returnContinuation = applyExp;
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length != 2) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        if (!(target instanceof IgnoreTarget || target instanceof ConsumerTarget || target instanceof SeriesTarget)) {
            ConsumerTarget.compileUsingConsumer(applyExp, compilation, target);
            return;
        }
        Expression expression = expressionArray[1];
        if (!(expressionArray[0] instanceof LambdaExp)) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        LambdaExp lambdaExp = (LambdaExp)expressionArray[0];
        Declaration declaration = lambdaExp.firstDecl();
        if (declaration == null || declaration.nextDecl() != null) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        SeriesTarget seriesTarget = new SeriesTarget();
        seriesTarget.scope = codeAttr.pushScope();
        seriesTarget.function = new Label(codeAttr);
        seriesTarget.done = new Label(codeAttr);
        if (declaration.isSimple()) {
            declaration.allocateVariable(codeAttr);
        } else {
            declaration = new Declaration(codeAttr.addLocal(declaration.getType(), declaration.getName()));
        }
        seriesTarget.param = declaration;
        ClassType classType = Type.pointer_type;
        Variable variable = codeAttr.addLocal(classType);
        expression.compileWithPosition(compilation, seriesTarget);
        if (codeAttr.reachableHere()) {
            codeAttr.emitGoto(seriesTarget.done);
        }
        seriesTarget.function.define(codeAttr);
        codeAttr.pushType(classType);
        codeAttr.emitStore(variable);
        expressionArray = new Expression[]{new ReferenceExp(declaration)};
        new ApplyExp(lambdaExp, expressionArray).compile(compilation, target);
        codeAttr.emitRet(variable);
        codeAttr.popScope();
        seriesTarget.done.define(codeAttr);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }
}

