/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.CLispReader;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Language;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.LocationEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import kawa.lang.Lambda;
import kawa.standard.Scheme;
import kawa.standard.begin;
import kawa.standard.not;

public class CommonLisp
extends Lisp2 {
    static boolean charIsInt = false;
    static final CommonLisp instance;
    public static final Environment clispEnvironment;
    public static final NumberCompare numEqu;
    public static final NumberCompare numGrt;
    public static final NumberCompare numGEq;
    public static final NumberCompare numLss;
    public static final NumberCompare numLEq;
    static final AbstractFormat writeFormat;
    static final AbstractFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int n) {
        if (charIsInt) {
            return IntNum.make(n);
        }
        return Char.make((char)n);
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new CLispReader(inPort, sourceMessages);
    }

    public String getName() {
        return "CommonLisp";
    }

    public CommonLisp() {
        this.environ = clispEnvironment;
    }

    void initLisp() {
        LocationEnumeration locationEnumeration = Scheme.builtin().enumerateAllLocations();
        while (locationEnumeration.hasMoreElements()) {
            this.importLocation(locationEnumeration.nextLocation());
        }
        try {
            this.loadClass("kawa.lib.prim_syntax");
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Lambda lambda2 = new Lambda();
        lambda2.setKeywords(CommonLisp.asSymbol("&optional"), CommonLisp.asSymbol("&rest"), CommonLisp.asSymbol("&key"));
        lambda2.defaultDefault = nilExpr;
        this.defun("lambda", (Object)lambda2);
        this.defun("defun", (Object)new defun(lambda2));
        this.defun("defvar", (Object)new defvar(false));
        this.defun("defconst", (Object)new defvar(true));
        this.defun("defsubst", (Object)new defun(lambda2));
        this.defun("function", (Object)new function(lambda2));
        this.defun("setq", (Object)new setq());
        this.defun("prog1", (Object)new prog1("prog1", 1));
        this.defun("prog2", (Object)prog1.prog2);
        this.defun("progn", (Object)new begin());
        this.defun("unwind-protect", (Object)new UnwindProtect());
        not not2 = new not(this);
        this.defun("not", (Object)not2);
        this.defun("null", (Object)not2);
        this.defun("eq", (Object)new IsEq(this, "eq"));
        this.defun("equal", (Object)new IsEqual(this, "equal"));
        this.defun("typep", (Object)new InstanceOf(this));
        this.defun("princ", (Object)displayFormat);
        this.defun("prin1", (Object)writeFormat);
        this.defProcStFld("=", "gnu.commonlisp.lang.CommonLisp", "numEqu");
        this.defProcStFld("<", "gnu.commonlisp.lang.CommonLisp", "numLss");
        this.defProcStFld(">", "gnu.commonlisp.lang.CommonLisp", "numGrt");
        this.defProcStFld("<=", "gnu.commonlisp.lang.CommonLisp", "numLEq");
        this.defProcStFld(">=", "gnu.commonlisp.lang.CommonLisp", "numGEq");
        this.defProcStFld("functionp", "gnu.commonlisp.lisp.PrimOps");
    }

    public static CommonLisp getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(instance);
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return CLispReader.readObject(inPort);
    }

    public AbstractFormat getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public ReadTable createReadTable() {
        return ReadTable.getInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        clispEnvironment = Environment.make("clisp-environment");
        instance = new CommonLisp();
        instance.define("t", TRUE);
        instance.define("nil", FALSE);
        numEqu = NumberCompare.make(instance, "=", 8);
        numGrt = NumberCompare.make(instance, ">", 16);
        numGEq = NumberCompare.make(instance, ">=", 24);
        numLss = NumberCompare.make(instance, "<", 4);
        numLEq = NumberCompare.make(instance, "<=", 12);
        CallContext callContext = CallContext.getInstance();
        Environment environment = callContext.getEnvironmentRaw();
        try {
            callContext.setEnvironmentRaw(clispEnvironment);
            instance.initLisp();
        }
        finally {
            callContext.setEnvironmentRaw(environment);
        }
        writeFormat = new DisplayFormat(true, 'C');
        displayFormat = new DisplayFormat(false, 'C');
    }
}

