//
// delete.cc
//
// delete: Implement tests for the word database deletion.
//
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1999, 2000, 2001 The ht://Dig Group
// For copyright details, see the file COPYING in your distribution
// or the GNU General Public License version 2 or later
// <http://www.gnu.org/copyleft/gpl.html>
//
// $Id: delete.cc,v 1.4 2001/06/29 14:14:08 loic Exp $
//

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <WordContext.h>
#include <WordReference.h>
#include <WordList.h>
#include <Configuration.h>

int main(void) {
  //
  // WordContext is the central object from which all 
  // mifluz objects are created.
  //
  // WordContext *context = new WordContext(defaults);

  WordContext* context = new WordContext();
  WordList *words = context->List();
  words->Open("test", O_RDWR);

  static char* wordlist[] = {
	"akkurat 0 1025977500 1 9 318",
	"allerede 0 1025977500 1 9 169",
	"alvor 0 1025977500 1 9 277",
	"amerikansk 0 1025977500 1 9 8",
	"amerikansk 0 1025977500 1 9 33",
	"amerikansk 0 1025977500 1 9 306",
	"amerikansk 1 1025977500 1 9 8",
	"amerikanske 0 1025977500 1 9 122",
	"andr 0 1025977500 1 9 68",
	"andr_forgetdr 0 1025977500 1 9 68",
	"angrep 0 1025977500 1 9 335",
	"arbeidet 0 1025977500 1 9 93",
	"at 0 1025977500 1 9 79",
	"at 0 1025977500 1 9 92",
	"aum 0 1025977500 1 9 323",
	"aum_shinrikyokunne 0 1025977500 1 9 323",
	"av 0 1025977500 1 9 208",
	"av 0 1025977500 1 9 267",
	"av 0 1025977500 1 9 269",
	"av 0 1025977500 1 9 349",
	"bahamas 0 1025977500 1 9 174",
	"barn 0 1025977500 1 9 4",
	"barn 0 1025977500 1 9 188",
	"barn 1 1025977500 1 9 4",
	"barn 2 1025977500 1 9 4",
	"betalt 0 1025977500 1 9 12",
	"betalt 0 1025977500 1 9 37",
	"betalt 0 1025977500 1 9 126",
	"betalt 1 1025977500 1 9 12",
	"betydelige 0 1025977500 1 9 301",
	"bevartceller 0 1025977500 1 9 143",
	"bisarr 0 1025977500 1 9 75",
	"biskoper 0 1025977500 1 9 226",
	"ble 0 1025977500 1 9 65",
	"blir 0 1025977500 1 9 274",
	"boisellier 0 1025977500 1 9 71",
	"boisellier 0 1025977500 1 9 116",
	"boisellier 0 1025977500 1 9 118",
	"brigitte 0 1025977500 1 9 70",
	"brigitte_boisellier 0 1025977500 1 9 70",
	"britisk 0 1025977500 1 9 294",
	"claude 0 1025977500 1 9 59",
	"claude 0 1025977500 1 9 237",
	"claude_vorilhon 0 1025977500 1 9 59",
	"claude_vorilhon 0 1025977500 1 9 237",
	"da 0 1025977500 1 9 135",
	"daily 0 1025977500 1 9 316",
	"daily_express 0 1025977500 1 9 316",
	"datter 0 1025977500 1 9 29",
	"datter 0 1025977500 1 9 54",
	"datter 1 1025977500 1 9 29",
	"datteren 0 1025977500 1 9 132",
	"datteren 0 1025977500 1 9 145",
	"de 0 1025977500 1 9 140",
	"den 0 1025977500 1 9 153",
	"den 0 1025977500 1 9 199",
	"den 0 1025977500 1 9 210",
	"den 0 1025977500 1 9 285",
	"den 0 1025977500 1 9 320",
	"dennemneden 0 1025977500 1 9 101",
	"der 0 1025977500 1 9 63",
	"der 0 1025977500 1 9 263",
	"det 0 1025977500 1 9 121",
	"det 0 1025977500 1 9 149",
	"det 0 1025977500 1 9 252",
	"dette 0 1025977500 1 9 314",
	"dr 0 1025977500 1 9 117",
	"dde 0 1025977500 1 9 28",
	"dde 0 1025977500 1 9 53",
	"dde 0 1025977500 1 9 134",
	"dde 1 1025977500 1 9 28",
	"ddt 0 1025977500 1 9 3",
	"ddt 1 1025977500 1 9 3",
	"ddt 2 1025977500 1 9 3",
	"egne 0 1025977500 1 9 187",
	"ekspert 0 1025977500 1 9 307",
	"ekspertise 0 1025977500 1 9 287",
	"ekspertise 0 1025977500 1 9 345",
	"ekstrem 0 1025977500 1 9 14",
	"ekstrem 0 1025977500 1 9 39",
	"ekstrem 1 1025977500 1 9 14",
	"ekstreme 0 1025977500 1 9 211",
	"ektepar 0 1025977500 1 9 9",
	"ektepar 0 1025977500 1 9 34",
	"ektepar 1 1025977500 1 9 9",
	"ekteparetsom 0 1025977500 1 9 123",
	"en 0 1025977500 1 9 13",
	"en 0 1025977500 1 9 38",
	"en 0 1025977500 1 9 74",
	"en 0 1025977500 1 9 88",
	"en 0 1025977500 1 9 293",
	"en 0 1025977500 1 9 305",
	"en 1 1025977500 1 9 13",
	"enn 0 1025977500 1 9 219",
	"er 0 1025977500 1 9 81",
	"er 0 1025977500 1 9 178",
	"et 0 1025977500 1 9 7",
	"et 0 1025977500 1 9 32",
	"et 0 1025977500 1 9 171",
	"et 0 1025977500 1 9 194",
	"et 0 1025977500 1 9 196",
	"et 0 1025977500 1 9 334",
	"et 1 1025977500 1 9 7",
	"etablert 0 1025977500 1 9 170",
	"etablert 0 1025977500 1 9 193",
	"evig 0 1025977500 1 9 84",
	"express 0 1025977500 1 9 317",
	"fire 0 1025977500 1 9 17",
	"fire 0 1025977500 1 9 42",
	"fire 1 1025977500 1 9 17",
	"flere 0 1025977500 1 9 268",
	"for 0 1025977500 1 9 20",
	"for 0 1025977500 1 9 45",
	"for 0 1025977500 1 9 128",
	"for 0 1025977500 1 9 333",
	"for 1 1025977500 1 9 20",
	"forbud 0 1025977500 1 9 206",
	"fordi 0 1025977500 1 9 284",
	"fordi 0 1025977500 1 9 290",
	"forfekter 0 1025977500 1 9 227",
	"forgetdr 0 1025977500 1 9 69",
	"forml 0 1025977500 1 9 177",
	"foto 0 1025977500 1 9 67",
	"fra 0 1025977500 1 9 144",
	"fra 0 1025977500 1 9 298",
	"franske 0 1025977500 1 9 57",
	"franske 0 1025977500 1 9 235",
	"fremst 0 1025977500 1 9 283",
	"fri 0 1025977500 1 9 228",
	"frivillig 0 1025977500 1 9 112",
	"f 0 1025977500 1 9 22",
	"f 0 1025977500 1 9 47",
	"f 0 1025977500 1 9 130",
	"f 0 1025977500 1 9 184",
	"f 1 1025977500 1 9 22",
	"frst 0 1025977500 1 9 281",
	"frste 0 1025977500 1 9 97",
	"gjennomfre 0 1025977500 1 9 164",
	"gjennomfrekloningen 0 1025977500 1 9 152",
	"gjre 0 1025977500 1 9 148",
	"ha 0 1025977500 1 9 11",
	"ha 0 1025977500 1 9 36",
	"ha 0 1025977500 1 9 125",
	"ha 0 1025977500 1 9 142",
	"ha 0 1025977500 1 9 192",
	"ha 1 1025977500 1 9 11",
	"hadde 0 1025977500 1 9 256",
	"han 0 1025977500 1 9 249",
	"han 0 1025977500 1 9 264",
	"har 0 1025977500 1 9 103",
	"har 0 1025977500 1 9 168",
	"har 0 1025977500 1 9 204",
	"har 0 1025977500 1 9 217",
	"har 0 1025977500 1 9 224",
	"har 0 1025977500 1 9 240",
	"har 0 1025977500 1 9 300",
	"harmeldt 0 1025977500 1 9 110",
	"heller 0 1025977500 1 9 157",
	"hjelp 0 1025977500 1 9 23",
	"hjelp 0 1025977500 1 9 48",
	"hjelp 1 1025977500 1 9 23",
	"hjelpe 0 1025977500 1 9 180",
	"hjelper 0 1025977500 1 9 296",
	"homofile 0 1025977500 1 9 181",
	"hun 0 1025977500 1 9 136",
	"hvis 0 1025977500 1 9 176",
	"hyt 0 1025977500 1 9 327",
	"i 0 1025977500 1 9 90",
	"i 0 1025977500 1 9 198",
	"i 0 1025977500 1 9 221",
	"i 0 1025977500 1 9 261",
	"i 0 1025977500 1 9 278",
	"i 0 1025977500 1 9 311",
	"i 0 1025977500 1 9 338",
	"iflge 0 1025977500 1 9 292",
	"ikke 0 1025977500 1 9 120",
	"ikke 0 1025977500 1 9 158",
	"ikke 0 1025977500 1 9 203",
	"inn 0 1025977500 1 9 258",
	"innehar 0 1025977500 1 9 286",
	"japanske 0 1025977500 1 9 321",
	"kaller 0 1025977500 1 9 214",
	"kaller 0 1025977500 1 9 250",
	"kalt 0 1025977500 1 9 257",
	"kaltclonaid 0 1025977500 1 9 175",
	"kan 0 1025977500 1 9 147",
	"kjemikere 0 1025977500 1 9 329",
	"klone 0 1025977500 1 9 2",
	"klone 0 1025977500 1 9 26",
	"klone 0 1025977500 1 9 51",
	"klone 0 1025977500 1 9 95",
	"klone 1 1025977500 1 9 2",
	"klone 1 1025977500 1 9 26",
	"klone 2 1025977500 1 9 2",
	"klone-planene 0 1025977500 1 9 64",
	"klonet 0 1025977500 1 9 131",
	"klonet 0 1025977500 1 9 185",
	"kloning 0 1025977500 1 9 80",
	"kloning 0 1025977500 1 9 280",
	"kloning 0 1025977500 1 9 348",
	"kloningen 0 1025977500 1 9 165",
	"kloningved 0 1025977500 1 9 309",
	"kroner 0 1025977500 1 9 19",
	"kroner 0 1025977500 1 9 44",
	"kroner 1 1025977500 1 9 19",
	"kultsekt 0 1025977500 1 9 76",
	"kultsekter 0 1025977500 1 9 299",
	"kvinner 0 1025977500 1 9 109",
	"kvinner 0 1025977500 1 9 247",
	"laboratoriumi 0 1025977500 1 9 195",
	"land 0 1025977500 1 9 197",
	"land 0 1025977500 1 9 222",
	"leder 0 1025977500 1 9 58",
	"leder 0 1025977500 1 9 236",
	"lederen 0 1025977500 1 9 155",
	"lederi 0 1025977500 1 9 73",
	"ledet 0 1025977500 1 9 61",
	"lee 0 1025977500 1 9 303",
	"lee_silver 0 1025977500 1 9 303",
	"liv 0 1025977500 1 9 85",
	"london 0 1025977500 1 9 5",
	"london 0 1025977500 1 9 30",
	"london 1 1025977500 1 9 5",
	"london_vg 0 1025977500 1 9 5",
	"london_vg 0 1025977500 1 9 30",
	"london_vg 1 1025977500 1 9 5",
	"lovvestet 0 1025977500 1 9 205",
	"med 0 1025977500 1 9 246",
	"medlemmer 0 1025977500 1 9 220",
	"med 0 1025977500 1 9 94",
	"men 0 1025977500 1 9 166",
	"men 0 1025977500 1 9 288",
	"menneske 0 1025977500 1 9 98",
	"mennesker 0 1025977500 1 9 209",
	"mennesker 0 1025977500 1 9 350",
	"mer 0 1025977500 1 9 218",
	"millioner 0 1025977500 1 9 18",
	"millioner 0 1025977500 1 9 43",
	"millioner 1 1025977500 1 9 18",
	"montreal 0 1025977500 1 9 91",
	"montreal 0 1025977500 1 9 262",
	"motkloning 0 1025977500 1 9 207",
	"mulig 0 1025977500 1 9 150",
	"mneder 0 1025977500 1 9 139",
	"nakenhet 0 1025977500 1 9 232",
	"navnetrael 0 1025977500 1 9 242",
	"navnga 0 1025977500 1 9 119",
	"navngidet 0 1025977500 1 9 159",
	"nervegass 0 1025977500 1 9 332",
	"ndvendig 0 1025977500 1 9 344",
	"offentliggjort 0 1025977500 1 9 66",
	"ofre 0 1025977500 1 9 297",
	"og 0 1025977500 1 9 108",
	"og 0 1025977500 1 9 230",
	"og 0 1025977500 1 9 233",
	"og 0 1025977500 1 9 282",
	"ogs 0 1025977500 1 9 191",
	"ogs 0 1025977500 1 9 289",
	"omgitt 0 1025977500 1 9 266",
	"opplyste 0 1025977500 1 9 86",
	"organisasjonsom 0 1025977500 1 9 295",
	"par 0 1025977500 1 9 182",
	"pengene 0 1025977500 1 9 104",
	"pengene 0 1025977500 1 9 127",
	"potensielle 0 1025977500 1 9 271",
	"pr-medarbeidere 0 1025977500 1 9 251",
	"pressekonferanse 0 1025977500 1 9 89",
	"pressekonferansen 0 1025977500 1 9 62",
	"pressekonferansen 0 1025977500 1 9 260",
	"presterog 0 1025977500 1 9 225",
	"princeton 0 1025977500 1 9 312",
	"p 0 1025977500 1 9 87",
	"p 0 1025977500 1 9 173",
	"p 0 1025977500 1 9 276",
	"p 0 1025977500 1 9 308",
	"p 0 1025977500 1 9 336",
	"rael 0 1025977500 1 9 216",
	"rael-sekten 0 1025977500 1 9 341",
	"reiser 0 1025977500 1 9 243",
	"religis 0 1025977500 1 9 15",
	"religis 0 1025977500 1 9 40",
	"religis 1 1025977500 1 9 15",
	"rundt 0 1025977500 1 9 245",
	"sa 0 1025977500 1 9 115",
	"seg 0 1025977500 1 9 111",
	"seg 0 1025977500 1 9 215",
	"seg 0 1025977500 1 9 326",
	"seg 0 1025977500 1 9 343",
	"sekt 0 1025977500 1 9 16",
	"sekt 0 1025977500 1 9 41",
	"sekt 1 1025977500 1 9 16",
	"sekt-sjefen 0 1025977500 1 9 55",
	"sekten 0 1025977500 1 9 167",
	"sekten 0 1025977500 1 9 189",
	"sekten 0 1025977500 1 9 212",
	"sekten 0 1025977500 1 9 223",
	"sekten 0 1025977500 1 9 273",
	"sekten 0 1025977500 1 9 291",
	"sekten 0 1025977500 1 9 322",
	"sektens 0 1025977500 1 9 56",
	"sektens 0 1025977500 1 9 234",
	"sektens 0 1025977500 1 9 270",
	"selskap 0 1025977500 1 9 172",
	"sex 0 1025977500 1 9 229",
	"shinrikyokunne 0 1025977500 1 9 324",
	"sier 0 1025977500 1 9 313",
	"sier 0 1025977500 1 9 351",
	"silver 0 1025977500 1 9 304",
	"silver 0 1025977500 1 9 352",
	"sin 0 1025977500 1 9 27",
	"sin 0 1025977500 1 9 52",
	"sin 1 1025977500 1 9 27",
	"sine 0 1025977500 1 9 186",
	"skaffe 0 1025977500 1 9 342",
	"skal 0 1025977500 1 9 10",
	"skal 0 1025977500 1 9 35",
	"skal 0 1025977500 1 9 106",
	"skal 0 1025977500 1 9 124",
	"skal 0 1025977500 1 9 141",
	"skal 0 1025977500 1 9 163",
	"skal 0 1025977500 1 9 190",
	"skal 1 1025977500 1 9 10",
	"som 0 1025977500 1 9 77",
	"som 0 1025977500 1 9 105",
	"som 0 1025977500 1 9 113",
	"som 0 1025977500 1 9 133",
	"som 0 1025977500 1 9 146",
	"som 0 1025977500 1 9 162",
	"som 0 1025977500 1 9 202",
	"som 0 1025977500 1 9 213",
	"som 0 1025977500 1 9 239",
	"som 0 1025977500 1 9 248",
	"som 0 1025977500 1 9 255",
	"som 0 1025977500 1 9 319",
	"spontan 0 1025977500 1 9 231",
	"sprsmletom 0 1025977500 1 9 279",
	"starte 0 1025977500 1 9 100",
	"subject=10012 0 1025977500 1 9 0",
	"subject=10022 0 1025977500 1 9 0",
	"subject=10039 0 1025977500 1 9 0",
	"subject=102 0 1025977500 1 9 0",
	"subject=33 0 1025977500 1 9 0",
	"surrogatmdre 0 1025977500 1 9 114",
	"surrogatmdre 0 1025977500 1 9 272",
	"skan 0 1025977500 1 9 340",
	"t-banen 0 1025977500 1 9 337",
	"tatt 0 1025977500 1 9 241",
	"tatt 0 1025977500 1 9 275",
	"teamet 0 1025977500 1 9 161",
	"ti 0 1025977500 1 9 138",
	"til 0 1025977500 1 9 24",
	"til 0 1025977500 1 9 49",
	"til 0 1025977500 1 9 83",
	"til 0 1025977500 1 9 107",
	"til 0 1025977500 1 9 259",
	"til 0 1025977500 1 9 315",
	"til 0 1025977500 1 9 330",
	"til 0 1025977500 1 9 346",
	"til 1 1025977500 1 9 24",
	"tiltrekke 0 1025977500 1 9 325",
	"til 0 1025977500 1 9 183",
	"tokyo 0 1025977500 1 9 339",
	"tredje 0 1025977500 1 9 200",
	"tror 0 1025977500 1 9 78",
	"universitet 0 1025977500 1 9 310",
	"utdannede 0 1025977500 1 9 328",
	"var 0 1025977500 1 9 137",
	"var 0 1025977500 1 9 253",
	"var 0 1025977500 1 9 265",
	"veien 0 1025977500 1 9 82",
	"verden 0 1025977500 1 9 201",
	"verden 0 1025977500 1 9 244",
	"verdens 0 1025977500 1 9 96",
	"vg 0 1025977500 1 9 6",
	"vg 0 1025977500 1 9 31",
	"vg 1 1025977500 1 9 6",
	"vi 0 1025977500 1 9 102",
	"vil 0 1025977500 1 9 1",
	"vil 0 1025977500 1 9 99",
	"vil 1 1025977500 1 9 1",
	"vil 2 1025977500 1 9 1",
	"ville 0 1025977500 1 9 156",
	"vitenskapelig 0 1025977500 1 9 72",
	"vitenskapelige 0 1025977500 1 9 154",
	"vitenskapelige 0 1025977500 1 9 160",
	"vorilhon 0 1025977500 1 9 60",
	"vorilhon 0 1025977500 1 9 238",
	"vorilhon 0 1025977500 1 9 254",
	"fremstille 0 1025977500 1 9 331",
	"utfre 0 1025977500 1 9 347",
	"konomiskeressurser 0 1025977500 1 9 302",
	0
  };

  int i;
  for(i = 0; wordlist[i]; i++) {
    words->Override(words->Word(wordlist[i]));
  }
  
  for(i = 0; wordlist[i]; i++) {
    words->Delete(words->Word(wordlist[i]));
  }
  
  words->Close();
  delete words;
  delete context;
}
