/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "Case.h"
#include "Player.h"
#include <string>
#include <map>
#include <iostream>
#include <istream>
#include <ostream>
#include "Serializer.h"
class Board
{
public:
	enum ActualActionMode{
		ATTACK,
		DEFEND,
		GUERILLA,
		NOTCHOOSE
	};
	Board(int xSize,int ySize);
	Board(int xSize,int ySize,int warped,int players,int active_players,int remaining_players,int turn ,int n_att);
	virtual ~Board(void);
	//Case &getCase(int x, int y);
	Case *getCaseNoThrow(int x, int y);
	void setCase(int x, int y, Case pcase);
	void setCases(Case *pcase);
	std::string toString();
	int getWidth();
	int getHeight();
	void setWidth(int z);
	void setHeight(int z);

	Player *getOrCreatePlayerByName(std::string name);
	void setFirstPlayerAsActualPlayer();
	void setHazardPlayerAsActualPlayer();
	Player *getActualPlayer();
	void setActualPlayer(Player *act);
	void setPlayerChoosedByHazard(bool plByH);

	void setNbCoutRestant(int);
	void setNbCoupperTurnAttack(int);
	void setNbCoupperTurnDefend(int);
	void setNbCoupperTurnGuerilla(int);
	

	int getNbCoutRestant();
	int getNbCoupperTurnAttack();
	int getNbCoupperTurnDefend();
	int	getNbCoupperTurnGuerilla();

	void decNbCoutRestant();
	void incNbCoutRestant();

	void setNextPlayer();

	void setActionMode(ActualActionMode m);
	ActualActionMode getActionMode();
	Player * getWinner();
	void setWinner(Player * w);

	Player *getPlayer(int);

	int getNbPlayers(); 
	Board operator <<(const Board&  b) const;
	Board operator <<(const int&  b) const;
	friend std::istream& operator>> (std::istream& out, Board& per);
	friend std::ostream& operator<< (std::ostream& out, Board& per);
	friend Serializer& operator>> (Serializer& out, Board& per);
	friend Serializer& operator<< (Serializer& out, Board& per);
	void recalculatePlayer();
	//int Board::operator =(Board);

private:
	int xSize_;
	int ySize_;
	int warped_, players_, active_players_, remaining_players_, turn_ , n_att_;
	Case *case_;
	std::map<std::string,Player*> playerMap_; 
	Player * actualPlayer_;
	bool isPlayerChoosedByHazard;
	int nbCoutRestant_;
	int nbCoupperTurnAttack_;
	int nbCoupperTurnDefend_;
	int nbCoupperTurnGuerilla_;
	ActualActionMode actualAction_;
	
	Player * winner_;

};

