// Copyright (C) 2006 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// Necessary libraries
#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include "bayonne_rpc.h"

#ifdef  CCXX_NAMESPACES
using namespace ost;
using namespace std;
#endif

// Internally used constants
const char*	HOST		=	"localhost";
const char*	PROTOCOL	=	"udp";
const int	TIMEOUT		=	20;

int main( int argc, char *argv[] )
{ // Start of main( int argc, char* argv[] )
	////////////////////////
	// Variable declaration
	////////////////////////
	bayonne_info		biSystem;
	bayonne_policy		boGroup;
	bayonne_port		bpState;
	char*			pcPolicy;
	char*			pcToken;
	CLIENT*			pcliConnection;
	int			iCount;
	struct timeval		stvTimeout;

	//////////////////
	// Initialization
	//////////////////
	stvTimeout.tv_sec =  TIMEOUT;
	stvTimeout.tv_usec = 0;
	pcliConnection = NULL;
	memset( reinterpret_cast<void*>( &biSystem ), 0, sizeof ( bayonne_info ) );
	memset( reinterpret_cast<void*>( &boGroup ), 0, sizeof ( bayonne_policy ) );

	////////////////////////////////
	// Set up the remote connection
	////////////////////////////////
	pcliConnection = clnt_create( HOST, BAYONNE_PROGRAM, BAYONNE_VERSION, PROTOCOL );
	if ( pcliConnection == NULL )
	{
		printf( "RPC CONNECTION %s\n", clnt_spcreateerror( "CREATE" ) );
		return 1;
	} // End of if

	if ( !clnt_control( pcliConnection, CLSET_TIMEOUT, reinterpret_cast<char*>(  &stvTimeout ) ) )
	{
		printf( "RPC CONNECTION %s\n", clnt_sperror( pcliConnection, "TIMEOUT" ) );
		clnt_destroy( pcliConnection );
		return 1;
	} // End of if

	/////////////////
	// Signon header
	/////////////////
	if ( bayonne_query_1( NULL, &biSystem, pcliConnection ) != RPC_SUCCESS )
	{
		printf( "RPC QUERY %s\n", clnt_sperror( pcliConnection, "CALL" ) );
		clnt_destroy( pcliConnection );
		return 1;
	} // End of if

	printf( "Bayonne version %s is running on '%s' as user '%s' with %i of %i lines configured using the %s driver.\n",
		biSystem.tgi_version,
		biSystem.tgi_node,
		biSystem.tgi_user,
		biSystem.used,
		biSystem.ports,
		biSystem.tgi_driver );

	///////////////
	// Port status
	///////////////
	printf( "%-4.4s %-10.10s %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %-12.12s %-8.8s\n",
	       	"Port",
		"Group",
		"ANI",
		"DNIS",
		"Name",
		"User",
		"Info",
		"Language",
		"GUID",
		"Policy",
		"Capabilities",
		"Duration" );
	printf( "%-4.4s %-10.10s %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %-12.12s %-8.8s\n",
	       	"----",
	       	"-----",
		"---",
		"----",
		"----",
		"----",
		"----",
		"--------",
		"----",
		"------",
		"------------",
		"--------" );

	/////////////////////////
	// Walk the trunk groups
	/////////////////////////
	// Policy string as per bayonne_info, + '* ' + \0
	pcPolicy = new char[ strlen( biSystem.tgi_policy ) + 1 + 2 ];
	sprintf( pcPolicy, "* %s", biSystem.tgi_policy );

	if ( !clnt_freeres( pcliConnection, reinterpret_cast<xdrproc_t>( xdr_bayonne_info ), reinterpret_cast<char*>( &biSystem ) ) )
	{
		printf( "RPC QUERY %s\n", clnt_sperror( pcliConnection, "FREE" ) );
		clnt_destroy( pcliConnection );
		delete [] pcPolicy;
		return 1;
	} // End of if

	pcToken = strtok( pcPolicy, " \t" );
	while ( pcToken != NULL )
	{
		if ( bayonne_policy_1( &pcToken, &boGroup, pcliConnection ) != RPC_SUCCESS )
		{
			printf( "RPC POLICY '%s' %s\n", pcToken, clnt_sperror( pcliConnection, "CALL" ) );
			clnt_destroy( pcliConnection );
			delete [] pcPolicy;
			return 1;
		} // End of if

		for ( iCount = 0; iCount < boGroup.pol_ports.pol_ports_len ; iCount ++ )
		{
			///////////////////////////////
			// Show individual port status
			///////////////////////////////
			memset( reinterpret_cast<void*>( &bpState ), 0, sizeof ( bayonne_port ) );
			if ( bayonne_port_1( &( boGroup.pol_ports.pol_ports_val[ iCount ] ), &bpState, pcliConnection ) != RPC_SUCCESS )
			{
				printf( "RPC PORT %s\n", clnt_sperror( pcliConnection, "CALL" ) );
				clnt_destroy( pcliConnection );
				delete [] pcPolicy;
				return 1;
			} // End of if

			printf( "%-4.1i %-10.10s %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %12.1li %8.1li\n",
				boGroup.pol_ports.pol_ports_val[ iCount ],
				boGroup.pol_name,
				bpState.port_caller,
				bpState.port_dialed,
				bpState.port_name,
				bpState.port_user,
				bpState.port_info,
				bpState.port_lang,
				bpState.port_gid,
				bpState.port_policy,
				bpState.port_caps,
				bpState.port_duration );

			// Cleanup
			if ( !clnt_freeres( pcliConnection, reinterpret_cast<xdrproc_t>( xdr_bayonne_port ), reinterpret_cast<char*>( &bpState ) ) )
			{
				printf( "RPC PORT %s\n", clnt_sperror( pcliConnection, "FREE" ) );
				clnt_freeres( pcliConnection, reinterpret_cast<xdrproc_t>( xdr_bayonne_policy ), reinterpret_cast<char*>( &boGroup ) );
				clnt_destroy( pcliConnection );
				delete [] pcPolicy;
				return 1;
			} // End of if
		} // End of for

		// Cleanup
		if ( !clnt_freeres( pcliConnection, reinterpret_cast<xdrproc_t>( xdr_bayonne_policy ), reinterpret_cast<char*>( &boGroup ) ) )
		{
			printf( "RPC POLICY '%s' %s\n", pcToken, clnt_sperror( pcliConnection, "FREE" ) );
			clnt_destroy( pcliConnection );
			delete [] pcPolicy;
			return 1;
		} // End of if

		// Next iteration
		pcToken = strtok( NULL, " \t" );
	} // End of while

	printf( "%s", "\n" );

	///////////
	// Cleanup
	///////////
	clnt_destroy( pcliConnection );
	delete [] pcPolicy;

	return 0;
} // End of main( int argc, char* argv[] )
