/* LocaleInformation_ru.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ru extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "KES|TWD|LKR|BYB|TJS|RWF|ERN|TJR|GRD|IEP|ARS|SDD|GEL|GEK|AFA|CRC|FKP|EEK|MDL|HKD|IQD|SCR|VUV|KPW|DKK|IDR|SOS|AED|LVL|BWP|RUR|NIO|FJD|ADP|RUB|CDF|DJF|UZS|SBD|ECS|THB|PHP|LUF|FIM|TTD|SZL|MNT|UAK|SAR|UAH|HUF|QAR|COP|PTE|GBP|INR|BIF|LTL|AON|UYP|MZM|KZT|PGK|SYP|OMR|ZRN|NGN|CNY|GNF|MAD|HTG|MYR|XEU|LSL|SLL|BHD|BTN|TRL|KMF|CZK|ANG|AZM|KYD|GMD|BGN|CAD|BGL|VEB|ILS|MXN|GYD|CYP|SKK|XDR|PEN|LRD|AMD|BSD|HRK|HRD|CLP|XPF|FRF|BRR|MKD|ALL|MWK|BRL|TPE|DEM|XCD|KWD|NPR|GWP|YUN|SVC|SIT|JPY|XOF|MVR|TOP|BEF|ROL|BDT|AWG|NOK|ZAR|MUR|SHP|XAU|VND|TZS|GIP|TND|CVE|ZMK|XAF|JOD|LBP|UGS|STD|WST|KHR|DOP|EUR|CUP|MTL|TMM|SGD|NZD|USD|BOB|HNL|ITL|PAB|GTQ|AUD|GHC|LAK|NAD|KGS|MGF|BBD|CHF|PYG|PLZ|YER|ATS|ETB|BND|EGP|JMD|PLN|DZD|ISK|SRG|LYD|BZD|KRW|NLG|MRO|ZWD|SEK|BYR|IRR|PKR|BMD|BYL";

  private static final String currenciesDisplayNameValues = "\u041a\u0435\u043d\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433|\u041d\u043e\u0432\u044b\u0439 \u0442\u0430\u0439\u0432\u0430\u043d\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0428\u0440\u0438 - \u041b\u0430\u043d\u043a\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1994-1999)|\u0422\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439 \u0441\u043e\u043c\u043e\u043d\u0438|\u0424\u0440\u0430\u043d\u043a \u0420\u0443\u0430\u043d\u0434\u044b|\u041d\u0430\u043a\u0444\u0430|\u0422\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c|\u0414\u0440\u0430\u0445\u043c\u0430|\u0418\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u0421\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439 \u043b\u0430\u0440\u0438|\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439 \u043a\u0443\u043f\u043e\u043d|\u0410\u0444\u0433\u0430\u043d\u0438 (1927-2002)|\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d|\u0424\u0443\u043d\u0442 \u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u043e\u0432|\u041a\u0440\u043e\u043d\u0430|\u041c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438\u0439 \u043b\u0435\u0439|\u0413\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0418\u0440\u0430\u043a\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u0412\u0430\u0442\u0443|\u0421\u0435\u0432\u0435\u0440\u043e - \u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u0432\u043e\u043d\u0430|\u0414\u0430\u0442\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u0420\u0443\u043f\u0438\u044f|\u0421\u043e\u043c\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433|\u0414\u0438\u0440\u0445\u0430\u043c (\u041e\u0410\u042d)|\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0430\u0442|\u041f\u0443\u043b\u0430|\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1991-1998)|\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u043a\u043e\u0440\u0434\u043e\u0431\u0430|\u0414\u043e\u043b\u043b\u0430\u0440 \u0424\u0438\u0434\u0436\u0438|\u0410\u043d\u0434\u043e\u0440\u0440\u0441\u043a\u0430\u044f \u043f\u0435\u0441\u0435\u0442\u0430|\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c|\u041a\u043e\u043d\u0433\u043e\u043b\u0435\u0437\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u0424\u0440\u0430\u043d\u043a \u0414\u0436\u0438\u0431\u0443\u0442\u0438|\u0423\u0437\u0431\u0435\u043a\u0441\u043a\u0438\u0439 \u0441\u0443\u043c|\u0414\u043e\u043b\u043b\u0430\u0440 \u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u043e\u0432|\u0421\u0443\u043a\u0440\u0435|\u0411\u0430\u0442|\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u041c\u0430\u0440\u043a\u0430|\u0414\u043e\u043b\u043b\u0430\u0440 \u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434\u0430 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e|\u041b\u0438\u043b\u0430\u043d\u0433\u0435\u043d\u0438|\u0422\u0443\u0433\u0440\u0438\u043a|\u041a\u0430\u0440\u0431\u043e\u0432\u0430\u043d\u0435\u0446 (\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439)|\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b|\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0430\u044f \u0433\u0440\u0438\u0432\u043d\u0430|\u0424\u043e\u0440\u0438\u043d\u0442|\u041a\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b|\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0439\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u043e\u0435 \u044d\u0441\u043a\u0443\u0434\u043e|\u0424\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u043e\u0432|\u0418\u043d\u0434\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u0411\u0443\u0440\u0443\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u043b\u0438\u0442|\u041d\u043e\u0432\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430|\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u041c\u0435\u0442\u0438\u043a\u0430\u043b|\u0422\u0435\u043d\u0433\u0435 (\u043a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439)|\u041a\u0438\u043d\u0430|\u0421\u0438\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u041e\u043c\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b|\u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u0438\u0440|\u041d\u0430\u0439\u0440\u0430|\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u044e\u0430\u043d\u044c|\u0413\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u041c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u0440\u0445\u0430\u043c|\u0413\u0443\u0440\u0434|\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0438\u043d\u0433\u0433\u0438\u0442|\u042d\u041a\u042e (\u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0439 \u0432\u0430\u043b\u044e\u0442\u044b)|\u041b\u043e\u0442\u0438|\u041b\u0435\u043e\u043d\u0435|\u0411\u0430\u0445\u0440\u0435\u0439\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u041d\u0433\u0443\u043b\u0442\u0440\u0443\u043c|\u0422\u0443\u0440\u0435\u0446\u043a\u0430\u044f \u043b\u0438\u0440\u0430|\u0424\u0440\u0430\u043d\u043a \u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u043e\u0432|\u0427\u0435\u0448\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0430\u043d\u0442\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d|\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442|\u0414\u043e\u043b\u043b\u0430\u0440 \u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u044b\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u043e\u0432|\u0414\u0430\u043b\u0430\u0441\u0438|\u0411\u043e\u043b\u0433\u0430\u0440\u0441\u043a\u0438\u0439 \u043b\u0435\u0432|\u041a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041b\u0435\u0432|\u0411\u043e\u043b\u0438\u0432\u0430\u0440|\u0428\u0435\u043a\u0435\u043b\u044c|\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u043d\u043e\u0432\u043e\u0435 \u043f\u0435\u0441\u043e|\u0413\u0430\u0439\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041a\u0438\u043f\u0440\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u0421\u043b\u043e\u0432\u0430\u0446\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u0421\u0414\u0420 (\u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u0438\u043c\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f)|\u041d\u043e\u0432\u044b\u0439 \u0441\u043e\u043b\u044c|\u041b\u0438\u0431\u0435\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0410\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439 \u0434\u0440\u0430\u043c|\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041a\u0443\u043d\u0430|\u0425\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0427\u0438\u043b\u0438\u0439\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u0424\u0440\u0430\u043d\u043a \u041a\u0424\u041f|\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u041a\u0440\u0443\u0437\u0435\u0439\u0440\u043e \u0440\u0435\u0430\u043b|\u0414\u0435\u043d\u0430\u0440|\u041b\u0435\u043a|\u041a\u0432\u0430\u0447\u0430 (\u043c\u0430\u043b\u0430\u0432\u0438\u0439\u0441\u043a\u0430\u044f)|\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0440\u0435\u0430\u043b|\u0422\u0438\u043c\u043e\u0440\u0441\u043a\u043e\u0435 \u044d\u0441\u043a\u0443\u0434\u043e|\u041d\u0435\u043c\u0435\u0446\u043a\u0430\u044f \u043c\u0430\u0440\u043a\u0430|\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e - \u043a\u0430\u0440\u0438\u0431\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041a\u0443\u0432\u0435\u0439\u0442\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u041d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u041f\u0435\u0441\u043e \u0413\u0432\u0438\u043d\u0435\u0438 - \u0411\u0438\u0441\u0430\u0443|\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d|\u0422\u043e\u043b\u0430\u0440|\u0419\u0435\u043d\u0430|\u0424\u0440\u0430\u043d\u043a \u041a\u0424\u0410 \u0412\u0421\u0415\u0410\u041e|\u0420\u0443\u0444\u0438\u044f|\u041f\u0430\u0430\u043d\u0433\u0430|\u0411\u0435\u043b\u044c\u0433\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u041b\u0435\u0439|\u0422\u0430\u043a\u0430|\u0410\u0440\u0443\u0431\u0430\u043d\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d|\u041d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u0420\u044d\u043d\u0434|\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u0424\u0443\u043d\u0442 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u0432\u044f\u0442\u043e\u0439 \u0415\u043b\u0435\u043d\u044b|\u0417\u043e\u043b\u043e\u0442\u043e|\u0414\u043e\u043d\u0433|\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433|\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u0422\u0443\u043d\u0438\u0441\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u042d\u0441\u043a\u0443\u0434\u043e \u041a\u0430\u0431\u043e - \u0412\u0435\u0440\u0434\u0435|\u041a\u0432\u0430\u0447\u0430 (\u0437\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0430\u044f)|\u0424\u0440\u0430\u043d\u043a \u041a\u0424\u0410 \u0412\u0415\u0410\u0421|\u0418\u043e\u0440\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u041b\u0438\u0432\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u0423\u0433\u0430\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433|\u0414\u043e\u0431\u0440\u0430|\u0422\u0430\u043b\u0430|\u0420\u0438\u0435\u043b\u044c|\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u0415\u0432\u0440\u043e|\u041a\u0443\u0431\u0438\u043d\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e|\u041c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0430\u044f \u043b\u0438\u0440\u0430|\u041c\u0430\u043d\u0430\u0442|\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0414\u043e\u043b\u043b\u0430\u0440 \u0421\u0428\u0410|\u0411\u043e\u043b\u0438\u0432\u0438\u0430\u043d\u043e|\u041b\u0435\u043c\u043f\u0438\u0440\u0430|\u0418\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0430\u044f \u043b\u0438\u0440\u0430|\u0411\u0430\u043b\u044c\u0431\u043e\u0430|\u041a\u0435\u0442\u0441\u0430\u043b\u044c|\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0421\u0435\u0434\u0438|\u041a\u0438\u043f|\u0414\u043e\u043b\u043b\u0430\u0440 \u041d\u0430\u043c\u0438\u0431\u0438\u0438|\u0421\u043e\u043c (\u043a\u0438\u0440\u0433\u0438\u0437\u0441\u043a\u0438\u0439)|\u041c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a|\u0413\u0443\u0430\u0440\u0430\u043d\u0438|\u0417\u043b\u043e\u0442\u044b\u0439|\u0419\u0435\u043c\u0435\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b|\u0428\u0438\u043b\u043b\u0438\u043d\u0433|\u042d\u0444\u0438\u043e\u043f\u0441\u043a\u0438\u0439 \u0431\u044b\u0440|\u0411\u0440\u0443\u043d\u0435\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0415\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442|\u042f\u043c\u0430\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u041f\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u044b\u0439|\u0410\u043b\u0436\u0438\u0440\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0418\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d|\u041b\u0438\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440|\u0411\u0435\u043b\u0438\u0437\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0412\u043e\u043d\u0430|\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d|\u0423\u0433\u0438\u044f|\u0414\u043e\u043b\u043b\u0430\u0440 \u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435|\u0428\u0432\u0435\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c|\u0418\u0440\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b|\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f|\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1992-1994)";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "KES|TWD|LKR|BYB|TJS|RWF|ERN|TJR|GRD|IEP|ARS|SDD|GEL|GEK|AFA|CRC|FKP|EEK|MDL|HKD|IQD|SCR|VUV|KPW|DKK|IDR|SOS|AED|LVL|BWP|RUR|NIO|FJD|ADP|RUB|CDF|DJF|UZS|SBD|ECS|THB|PHP|LUF|FIM|TTD|SZL|MNT|UAK|SAR|UAH|HUF|QAR|COP|PTE|INR|BIF|LTL|AON|UYP|MZM|KZT|PGK|SYP|OMR|ZRN|NGN|CNY|GNF|MAD|HTG|MYR|XEU|LSL|SLL|BHD|BTN|TRL|KMF|CZK|ANG|AZM|KYD|GMD|BGN|CAD|BGL|VEB|ILS|MXN|GYD|CYP|SKK|XDR|PEN|LRD|AMD|BSD|HRK|HRD|CLP|XPF|FRF|BRR|MKD|ALL|MWK|BRL|TPE|DEM|XCD|KWD|NPR|GWP|YUN|SVC|SIT|XOF|MVR|TOP|BEF|ROL|BDT|AWG|NOK|ZAR|MUR|SHP|XAU|VND|TZS|GIP|TND|CVE|ZMK|XAF|JOD|LBP|UGS|STD|WST|KHR|DOP|CUP|MTL|TMM|SGD|NZD|USD|BOB|HNL|PAB|GTQ|AUD|GHC|LAK|NAD|KGS|MGF|BBD|CHF|PYG|PLZ|YER|ATS|ETB|BND|EGP|JMD|PLN|DZD|ISK|SRG|LYD|BZD|KRW|NLG|MRO|ZWD|SEK|BYR|IRR|PKR|BMD|BYL";

  private static final String currenciesSymbolValues = "K Sh|NT$|SL Re|BYB|TJS|RWF|ERN|TJR|GRD|IR\u00a3|Arg$|SDD|lari|GEK|AFA|C|FKP|EEK|MDL|HK$|ID|SR|VT|KPW|DKr|Rp|So. Sh.|AED|LVL|BWP|\u0440.|NIO|F$|ADP|RUB|CDF|DF|UZS|SI$|ECS|THB|PHP|LUF|FIM|TT$|E|Tug|UAK|SRl|\u0433\u0440\u043d.|Ft|QR|Col$|PTE|INR|Fbu|LTL|AON|UYP|Mt|T|PGK|LS|RO|ZRN|NGN|Y|GF|MAD|HTG|RM|XEU|M|SLL|BD|Nu|TL|CF|CZK|NA f.|AZM|KYD|GMD|BGN|Can$|lev|Be|ILS|MEX$|G$|\u00a3C|Sk|XDR|PEN|LRD|dram|BSD|HRK|HRD|Ch$|CFPF|FRF|BRR|MDen|lek|MK|R$|TPE|DEM|EC$|KD|Nrs|GWP|YUN|SVC|SIT|XOF|MVR|T$|BF|leu|Tk|AWG|NKr|R|MUR|SHP|XAU|VND|T Sh|GIP|TND|CVEsc|ZMK|XAF|JD|LL|UGS|Db|WST|CR|RD$|CUP|Lm|TMM|S$|$NZ|US$|Bs|L|PAB|Q|$A|GHC|LAK|N$|som|MGF|BDS$|SwF|PYG|PLZ|YRl|ATS|Br|BND|EGP|J$|Zl|DA|ISK|Sf|LD|BZ$|KRW|NLG|UM|Z$|SKr|Rbl|RI|Pra|Ber$|BYL";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u044f\u043d\u0432.",
    "\u0444\u0435\u0432\u0440.",
    "\u043c\u0430\u0440\u0442",
    "\u0430\u043f\u0440.",
    "\u043c\u0430\u0439",
    "\u0438\u044e\u043d\u044c",
    "\u0438\u044e\u043b\u044c",
    "\u0430\u0432\u0433.",
    "\u0441\u0435\u043d\u0442.",
    "\u043e\u043a\u0442.",
    "\u043d\u043e\u044f\u0431.",
    "\u0434\u0435\u043a.",
    null,
  };

  private static final String[] months = {
    "\u042f\u043d\u0432\u0430\u0440\u044c",
    "\u0424\u0435\u0432\u0440\u0430\u043b\u044c",
    "\u041c\u0430\u0440\u0442",
    "\u0410\u043f\u0440\u0435\u043b\u044c",
    "\u041c\u0430\u0439",
    "\u0418\u044e\u043d\u044c",
    "\u0418\u044e\u043b\u044c",
    "\u0410\u0432\u0433\u0443\u0441\u0442",
    "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c",
    "\u041e\u043a\u0442\u044f\u0431\u0440\u044c",
    "\u041d\u043e\u044f\u0431\u0440\u044c",
    "\u0414\u0435\u043a\u0430\u0431\u0440\u044c",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0412\u0441",
    "\u041f\u043d",
    "\u0412\u0442",
    "\u0421\u0440",
    "\u0427\u0442",
    "\u041f\u0442",
    "\u0421\u0431",
  };

  private static final String[] weekdays = {
    null,
    "\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435",
    "\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a",
    "\u0432\u0442\u043e\u0440\u043d\u0438\u043a",
    "\u0441\u0440\u0435\u0434\u0430",
    "\u0447\u0435\u0442\u0432\u0435\u0440\u0433",
    "\u043f\u044f\u0442\u043d\u0438\u0446\u0430",
    "\u0441\u0443\u0431\u0431\u043e\u0442\u0430",
  };

  private static final String[] eras = {
    "\u0434\u043e \u043d.\u044d.",
    "\u043d.\u044d.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0422\u0438\u043c\u043e\u0440|\u0422\u043e\u043a\u0435\u043b\u0430\u0443|\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d|\u0422\u0430\u0438\u043b\u0430\u043d\u0434|\u0422\u043e\u0433\u043e|\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0435 \u042e\u0436\u043d\u044b\u0435 \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438|\u0413\u0430\u0439\u0430\u043d\u0430|\u0427\u0430\u0434|\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0422\u0443\u0440\u043a\u0441 \u0438 \u041a\u0430\u0439\u043a\u043e\u0441|\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0441\u0430\u0443|\u0413\u0443\u0430\u043c|\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430|\u042e\u0436\u043d\u0430\u044f \u0414\u0436\u043e\u0440\u0434\u0436\u0438\u044f \u0438 \u042e\u0436\u043d\u044b\u0435 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0413\u0440\u0435\u0446\u0438\u044f|\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f|\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430|\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434|\u0421\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0431\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u0413\u0432\u0438\u043d\u0435\u044f|\u0413\u0430\u043c\u0431\u0438\u044f|\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f|\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440|\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438|\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440|\u0413\u0430\u043d\u0430|\u0421\u0443\u0440\u0438\u043d\u0430\u043c|\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0438\u0430\u043d\u0430|\u0421\u0435\u0440\u0431\u0438\u044f|\u0413\u0440\u0443\u0437\u0438\u044f|\u0421\u043e\u043c\u0430\u043b\u0438|\u0413\u0440\u0435\u043d\u0430\u0434\u0430|\u0421\u0435\u043d\u0435\u0433\u0430\u043b|\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e|\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f|\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435|\u0413\u0430\u0431\u043e\u043d|\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f|\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0416\u0430\u043d \u041c\u0430\u0439\u0435\u043d|\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f|\u041e\u0441\u0442\u0440\u043e\u0432 \u0421\u0432\u044f\u0442\u043e\u0439 \u0415\u043b\u0435\u043d\u044b|\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440|\u0428\u0432\u0435\u0446\u0438\u044f|\u0421\u0443\u0434\u0430\u043d|\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f|\u0424\u0440\u0430\u043d\u0446\u0438\u044f|\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430|\u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0435 \u0413\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u043e \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f|\u0420\u0443\u0430\u043d\u0434\u0430|\u0424\u043e\u043b\u044c\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0420\u043e\u0441\u0441\u0438\u044f|\u0424\u0438\u0434\u0436\u0438|\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f|\u0420\u0443\u043c\u044b\u043d\u0438\u044f|\u0420\u0435\u044e\u043d\u044c\u043e\u043d|\u042d\u0444\u0438\u043e\u043f\u0438\u044f|\u0418\u0441\u043f\u0430\u043d\u0438\u044f|\u042d\u0440\u0438\u0442\u0440\u0435\u044f|\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0421\u0430\u0445\u0430\u0440\u0430|\u0415\u0433\u0438\u043f\u0435\u0442|\u042d\u0441\u0442\u043e\u043d\u0438\u044f|\u042d\u043a\u0432\u0430\u0434\u043e\u0440|\u0410\u043b\u0436\u0438\u0440|\u041a\u0430\u0442\u0430\u0440|\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439|\u041e\u0441\u0442\u0440\u043e\u0432 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430|\u041f\u0430\u043b\u0430\u0443|\u0414\u0430\u043d\u0438\u044f|\u0414\u0436\u0438\u0431\u0443\u0442\u0438|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f|\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u0438\u044f|\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e|\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f|\u041e\u0441\u0442\u0440\u043e\u0432 \u041f\u0438\u0442\u043a\u044d\u0440\u043d|\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d|\u041f\u043e\u043b\u044c\u0448\u0430|\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d|\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u044b|\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f|\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f|\u0427\u0435\u0448\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u041f\u0435\u0440\u0443|\u041a\u0438\u043f\u0440|\u041e\u0441\u0442\u0440\u043e\u0432 \u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u0430|\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0417\u0435\u043b\u0435\u043d\u043e\u0433\u043e \u041c\u044b\u0441\u0430|\u041f\u0430\u043d\u0430\u043c\u0430|\u041a\u0443\u0431\u0430|\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430|\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f|\u041a\u0438\u0442\u0430\u0439|\u041a\u0430\u043c\u0435\u0440\u0443\u043d|\u0427\u0438\u043b\u0438|\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430|\u041a\u043e\u0442 \u0434\u2019\u0418\u0432\u0443\u0430\u0440|\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f|\u041a\u043e\u043d\u0433\u043e|\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e-\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u041a\u043e\u043d\u0433\u043e, \u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u044b\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430 (\u041a\u0438\u0438\u043b\u0438\u043d\u0433)|\u041e\u043c\u0430\u043d|\u041a\u0430\u043d\u0430\u0434\u0430|\u0411\u0435\u043b\u0438\u0437|\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c|\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430|\u041e\u0441\u0442\u0440\u043e\u0432 \u0411\u0443\u0432\u0435|\u0411\u0443\u0442\u0430\u043d|\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430|\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f|\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f|\u0411\u043e\u043b\u0438\u0432\u0438\u044f|\u0411\u0440\u0443\u043d\u0435\u0439 \u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c|\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041d\u0438\u0443\u0435|\u0411\u0435\u043d\u0438\u043d|\u0411\u0443\u0440\u0443\u043d\u0434\u0438|\u0411\u0430\u0445\u0440\u0435\u0439\u043d|\u041d\u0430\u0443\u0440\u0443|\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f|\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e|\u041d\u0435\u043f\u0430\u043b|\u0411\u0435\u043b\u044c\u0433\u0438\u044f|\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f|\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448|\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441|\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435|\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b|\u0411\u043e\u0441\u043d\u0438\u044f|\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430|\u041d\u0438\u0433\u0435\u0440\u0438\u044f|\u041e\u0441\u0442\u0440\u043e\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a|\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d|\u041d\u0438\u0433\u0435\u0440|\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f|\u0410\u0440\u0443\u0431\u0430|\u0417\u0430\u043c\u0431\u0438\u044f|\u041d\u0430\u043c\u0438\u0431\u0438\u044f|\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f|\u0410\u0432\u0441\u0442\u0440\u0438\u044f|\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0421\u0430\u043c\u043e\u0430|\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430|\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430|\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a|\u0410\u043d\u0433\u043e\u043b\u0430|\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f|\u0413\u043e\u043b\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0435 \u0410\u043d\u0442\u0438\u043b\u044c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041c\u0435\u043a\u0441\u0438\u043a\u0430|\u0410\u0440\u043c\u0435\u043d\u0438\u044f|\u041c\u0430\u043b\u0430\u0432\u0438|\u0410\u043b\u0431\u0430\u043d\u0438\u044f|\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u044b|\u042e\u0436\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430|\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439|\u041c\u0430\u043b\u044c\u0442\u0430|\u0410\u043d\u0433\u0443\u0438\u043b\u043b\u0430|\u041c\u043e\u043d\u0441\u0435\u0440\u0440\u0430\u0442|\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f|\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430|\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a|\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d|\u0421\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u041c\u0430\u0440\u0438\u0430\u043d\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0435 \u042d\u043c\u0438\u0440\u0430\u0442\u044b|\u041c\u0430\u043a\u0430\u043e (\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0441 \u041e\u0441\u043e\u0431\u044b\u043c \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u043c \u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c, \u041a\u0438\u0442\u0430\u0439)|\u0410\u043d\u0434\u043e\u0440\u0440\u0430|\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f|\u041c\u0430\u0439\u0430\u043d\u043c\u0430\u0440|\u041c\u0430\u043b\u0438|\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f|\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u044f|\u041c\u0430\u0439\u043e\u0442\u0442\u0430|\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440|\u041c\u043e\u043b\u0434\u043e\u0432\u0430|\u041c\u043e\u043d\u0430\u043a\u043e|\u041c\u0430\u0440\u043e\u043a\u043a\u043e|\u0419\u0435\u043c\u0435\u043d|\u041b\u0438\u0432\u0438\u044f|\u041b\u0430\u0442\u0432\u0438\u044f|\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433|\u041b\u0438\u0442\u0432\u0430|\u041b\u0435\u0441\u043e\u0442\u043e|\u041b\u0438\u0431\u0435\u0440\u0438\u044f|\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430|\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d|\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f|\u041b\u0438\u0432\u0430\u043d|\u041b\u0430\u043e\u0441|\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d|\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041a\u0443\u0432\u0435\u0439\u0442|\u042e\u0436\u043d\u0430\u044f \u041a\u043e\u0440\u0435\u044f|\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041a\u043e\u0440\u0435\u044f|\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441|\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438|\u0421\u0430\u043c\u043e\u0430|\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430|\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d|\u041a\u0435\u043d\u0438\u044f|\u042d\u043b\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430|\u042f\u043f\u043e\u043d\u0438\u044f|\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f|\u042f\u043c\u0430\u0439\u043a\u0430|\u0412\u0430\u043d\u0443\u0430\u0442\u0443|\u0412\u044c\u0435\u0442\u043d\u0430\u043c|\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0435 \u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0435 \u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430|\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430|\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u044b|\u0413\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u043e-\u0433\u043e\u0440\u043e\u0434 \u0412\u0430\u0442\u0438\u043a\u0430\u043d|\u0418\u0442\u0430\u043b\u0438\u044f|\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f|\u0418\u0440\u0430\u043d|\u0418\u0440\u0430\u043a|\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d|\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0435 \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0432 \u0418\u043d\u0434\u0438\u0439\u0441\u043a\u043e\u043c \u041e\u043a\u0435\u0430\u043d\u0435|\u0423\u0440\u0443\u0433\u0432\u0430\u0439|\u0418\u043d\u0434\u0438\u044f|\u0418\u0437\u0440\u0430\u0438\u043b\u044c|\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0428\u0442\u0430\u0442\u044b|\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f|\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f|\u0412\u043d\u0435\u0448\u043d\u0438\u0435 \u043c\u0430\u043b\u044b\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 (\u0421\u0428\u0410)|\u0423\u0433\u0430\u043d\u0434\u0430|\u0423\u043a\u0440\u0430\u0438\u043d\u0430|\u0412\u0435\u043d\u0433\u0440\u0438\u044f|\u0413\u0430\u0438\u0442\u0438|\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f|\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f|\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441|\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0425\u0435\u0440\u0434 \u0438 \u041c\u0430\u043a-\u0414\u043e\u043d\u0430\u043b\u044c\u0434|\u0422\u0430\u0439\u0432\u0430\u043d\u044c|\u0422\u0443\u0432\u0430\u043b\u0443|\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0441 \u041e\u0441\u043e\u0431\u044b\u043c \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u043c \u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c, \u041a\u0438\u0442\u0430\u0439)|\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e|\u0422\u0443\u0440\u0446\u0438\u044f|\u0422\u043e\u043d\u0433\u0430|\u0422\u0443\u043d\u0438\u0441|\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|kum|zap|cus|doi|vo|oto|vi|vai|raj|ota|nzi|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|ban|osa|bal|bai|tw|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|tg|te|kro|ta|efi|sw|sv|su|st|ss|sr|sq|men|crp|so|afh|sn|sm|grc|sl|sk|si|afa|sh|sg|sd|sa|rw|ru|ro|rn|rm|tiv|ady|zun|kpe|qu|tig|cpp|sog|ada|cpf|cpe|him|kok|hil|got|gon|din|nub|pt|ps|phn|goh|cop|yap|ach|yao|ace|pl|pi|pa|bug|iba|bua|mas|map|os|or|man|smi|mak|om|mai|mag|oj|mad|nso|oc|myn|gmh|no|nl|sla|ne|na|ter|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mg|mwr|bra|lv|lu|del|lt|lo|ln|ewo|la|jpr|vot|ky|sit|ku|sio|ks|awa|ko|kn|km|kl|kk|rom|sid|non|ka|mus|roa|nog|mun|mul|jv|gil|shn|fon|kho|ja|khi|pau|chy|tai|iu|it|pap|is|kha|chr|pam|pal|cho|chn|chm|tyv|bnt|ik|pag|chk|haw|lam|chg|sga|ie|paa|id|lah|chb|ia|lad|hai|hy|ath|hu|dak|hr|hi|dyu|he|ha|wen|gu|sem|iro|sel|gn|gl|arw|gez|art|gd|ira|ga|fy|bla|gem|arc|fr|fo|fj|fi|fa|eu|et|es|eo|en|el|tut|niu|mos|dz|nic|fiu|moh|luo|lun|lui|hup|bin|de|bik|was|und|war|da|dum|wal|mno|wak|cy|cv|mni|cs|sam|sal|dua|co|sai|sah|kaw|sad|bho|enm|kar|inc|gay|ca|umb|kam|tsi|ang|cau|kab|kaa|car|br|bo|bn|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|az|ay|as|ar|ilo|elx|zh|pra|am|new|za|af|ab|aa|yo|alg|ale|mkh|yi|dra|bem|bej";

  private static final String languagesValues = "\u0410\u043a\u043a\u0430\u0434\u0441\u043a\u0438\u0439|\u042d\u043a\u0430\u0434\u0436\u0443\u043a|\u0418\u0434\u0436\u043e|\u0425\u043e\u0437\u0430|\u0428\u0443\u043c\u0435\u0440\u0441\u043a\u0438\u0439|\u0421\u0443\u0441\u0443|\u0421\u043c\u0435\u0448\u0430\u043d\u043d\u044b\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041b\u043e\u0437\u0438|\u0422\u043e\u043d\u0433\u0430 (\u041d\u044c\u044f\u0441\u0430)|\u041f\u043e\u043d\u0430\u043f\u0435|\u041c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443|\u0421\u0443\u043a\u0443\u043c\u0430|\u0412\u043e\u043b\u043e\u0444|\u041c\u043e\u043d\u0433\u043e|\u041a\u0443\u0442\u0435\u043d\u0430\u0438|\u041c\u0438\u043a\u043c\u0430\u043a|\u041a\u0443\u043c\u044b\u043a\u0441\u043a\u0438\u0439|\u0421\u0430\u043f\u043e\u0442\u0435\u043a\u0441\u043a\u0438\u0439|\u041a\u0443\u0448\u0438\u0442\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0414\u043e\u0433\u0440\u0438|\u0412\u043e\u043b\u0430\u043f\u0430\u043a|\u041e\u0442\u043e\u043c\u0430\u043d\u0433\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0412\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0439|\u0412\u0430\u0438|\u0420\u0430\u0434\u0436\u0430\u0441\u0442\u0445\u0430\u043d\u0438|\u0421\u0442\u0430\u0440\u043e\u0442\u0443\u0440\u0435\u0446\u043a\u0438\u0439|\u041d\u0437\u0438\u043c\u0430|\u0423\u0437\u0431\u0435\u043a\u0441\u043a\u0438\u0439|\u0423\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u0438\u0439|\u0422\u0430\u043c\u0430\u0448\u0435\u043a|\u0421\u0435\u0432\u0435\u0440\u043d\u043e\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0438 \u0438\u043d\u0434\u0435\u0439\u0446\u0435\u0432 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0410\u0446\u0442\u0435\u043a\u0441\u043a\u0438\u0439|\u0423\u0440\u0434\u0443|\u0424\u0430\u043d\u0442\u0438|\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439|\u0414\u0440\u0435\u0432\u043d\u0435\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438\u0439|\u0423\u0439\u0433\u0443\u0440\u0441\u043a\u0438\u0439|\u0424\u0430\u043d\u0433|\u041d\u0438\u043b\u043e-\u0441\u0430\u0445\u0430\u0440\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0421\u0440\u0435\u0434\u043d\u0435\u0438\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u0411\u0430\u043b\u0442\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041d\u044c\u043e\u0440\u043e|\u0411\u0430\u0441\u0430|\u041d\u044c\u044f\u043d\u043a\u043e\u043b\u0435|\u041d\u044c\u044f\u043c\u0432\u0435\u0437\u0438|\u0411\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439|\u041e\u0441\u0435\u0434\u0436\u0438|\u0411\u0435\u043b\u0443\u0434\u0436\u0441\u043a\u0438\u0439|\u0411\u0430\u043c\u0438\u043b\u0435\u043a\u0435 \u044f\u0437\u044b\u043a\u0438|\u0422\u0432\u0438|\u0422\u043b\u0438\u043d\u0433\u0438\u0442|\u0422\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439|\u0422\u0441\u043e\u043d\u0433\u0430|\u0411\u0430\u043d\u0434\u0430|\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439|\u0422\u043e\u043d\u0433\u0430|\u0421\u0435\u0442\u0441\u0432\u0430\u043d\u0430|\u0422\u0430\u0433\u0430\u043b\u043e\u0433|\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438\u0439|\u0422\u0438\u0433\u0440\u0438\u043d\u0438\u0430|\u0422\u0430\u0439\u0441\u043a\u0438\u0439|\u0422\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439|\u0422\u0435\u043b\u0443\u0433\u0443|\u041a\u0440\u0443|\u0422\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0438\u0439|\u042d\u0444\u0438\u043a|\u0421\u0443\u0430\u0445\u0438\u043b\u0438|\u0428\u0432\u0435\u0434\u0441\u043a\u0438\u0439|\u0421\u0430\u043d\u0434\u0430\u043d\u0438\u0437\u0441\u043a\u0438\u0439|\u0421\u0435\u0441\u043e\u0442\u043e|\u0421\u0438\u0441\u0432\u0430\u0442\u0438|\u0421\u0435\u0440\u0431\u0441\u043a\u0438\u0439|\u0410\u043b\u0431\u0430\u043d\u0441\u043a\u0438\u0439|\u041c\u0435\u043d\u0434\u0435|\u041a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0435 \u0438 \u043f\u0438\u0434\u0436\u0438\u043d\u044b (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0421\u043e\u043c\u0430\u043b\u0438|\u0410\u0444\u0440\u0438\u0445\u0438\u043b\u0438|\u0428\u043e\u043d\u0430|\u0421\u0430\u043c\u043e\u0430|\u0414\u0440\u0435\u0432\u043d\u0435\u0433\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0439|\u0421\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0439|\u0421\u043b\u043e\u0432\u0430\u0446\u043a\u0438\u0439|\u0421\u0438\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439|\u0410\u0444\u0440\u0430\u0437\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0421\u0435\u0440\u0431\u0441\u043a\u043e-\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439|\u0421\u0430\u043d\u0433\u043e|\u0421\u0438\u043d\u0434\u0438|\u0421\u0430\u043d\u0441\u043a\u0440\u0438\u0442|\u041a\u0438\u043d\u044f\u0440\u0432\u0430\u043d\u0434\u0430|\u0420\u0443\u0441\u0441\u043a\u0438\u0439|\u0420\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439|\u041a\u0438\u0440\u0443\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439|\u0420\u0430\u0435\u0442\u043e-\u0440\u043e\u043c\u0430\u043d\u0441\u043a\u0438\u0439|\u0422\u0438\u0432\u0438|\u0410\u0434\u044b\u0433\u0435\u0439\u0441\u043a\u0438\u0439|\u0417\u0443\u043d\u044c\u0438|\u041a\u043f\u0435\u043b\u043b\u0435|\u041a\u0435\u0447\u0443\u0430|\u0422\u0438\u0433\u0440\u0435|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u043e\u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0435 \u0438 \u043f\u0438\u0434\u0436\u0438\u043d\u044b (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0421\u043e\u0433\u0434\u0438\u0439\u0441\u043a\u0438\u0439|\u0410\u0434\u0430\u043d\u0433\u043c\u0435|\u0424\u0440\u0430\u043d\u043a\u043e-\u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0435 \u0438 \u043f\u0438\u0434\u0436\u0438\u043d\u044b (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0410\u043d\u0433\u043b\u043e-\u043a\u0440\u0435\u043e\u043b\u044c\u0441\u043a\u0438\u0435 \u0438 \u043f\u0438\u0434\u0436\u0438\u043d\u044b (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0425\u0438\u043c\u0430\u0447\u0430\u043b\u0438|\u041a\u043e\u043d\u043a\u0430\u043d\u0438|\u0425\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d|\u0413\u043e\u0442\u0441\u043a\u0438\u0439|\u0413\u043e\u043d\u0434\u0438|\u0414\u0438\u043d\u043a\u0430|\u041d\u0443\u0431\u0438\u0439\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439|\u041f\u0430\u0448\u0442\u043e (\u041f\u0443\u0448\u0442\u043e)|\u0424\u0438\u043d\u0438\u043a\u0438\u0439\u0441\u043a\u0438\u0439|\u0421\u0442\u0430\u0440\u043e\u0432\u0435\u0440\u0445\u043d\u0435\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439|\u041a\u043e\u043f\u0442\u0441\u043a\u0438\u0439|\u042f\u043f|\u0410\u0447\u043e\u043b\u0438|\u042f\u043e|\u0410\u0447\u0435\u0445\u0441\u043a\u0438\u0439|\u041f\u043e\u043b\u044c\u0441\u043a\u0438\u0439|\u041f\u0430\u043b\u0438|\u041f\u0430\u043d\u0434\u0436\u0430\u0431\u0441\u043a\u0438\u0439|\u0411\u0443\u0433\u0438\u0439\u0441\u043a\u0438\u0439|\u0418\u0431\u0430\u043d\u0441\u043a\u0438\u0439|\u0411\u0443\u0440\u044f\u0442\u0441\u043a\u0438\u0439|\u041c\u0430\u0441\u0430\u0438|\u0410\u0432\u0441\u0442\u0440\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041e\u0441\u0435\u0442\u0438\u043d\u0441\u043a\u0438\u0439|\u041e\u0440\u0438\u044f|\u041c\u0430\u043d\u0434\u0438\u043d\u0433\u043e|\u0421\u0430\u0430\u043c\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u041c\u0430\u043a\u0430\u0441\u0441\u0430\u0440\u0441\u043a\u0438\u0439|\u041e\u0440\u043e\u043c\u043e (\u0410\u0444\u0430\u043d)|\u041c\u0430\u0439\u0442\u0445\u0438\u043b\u0438|\u041c\u0430\u0433\u0430\u0445\u0438|\u041e\u0434\u0436\u0438\u0431\u0432\u0430|\u041c\u0430\u0434\u0443\u0440\u0441\u043a\u0438\u0439|\u0421\u043e\u0442\u043e \u0421\u0435\u0432\u0435\u0440\u043d\u044b\u0439|\u041e\u043a\u0438\u0442\u0430\u043d|\u041c\u0430\u0439\u044f \u044f\u0437\u044b\u043a\u0438|\u0421\u0440\u0435\u0434\u043d\u0435\u0432\u0435\u0440\u0445\u043d\u0435\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439|\u041d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0439|\u0413\u043e\u043b\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u0421\u043b\u0430\u0432\u044f\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0438\u0439|\u041d\u0430\u0443\u0440\u0443|\u0422\u0435\u0440\u0435\u043d\u043e|\u0411\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0439|\u041b\u0435\u0437\u0433\u0438\u043d\u0441\u043a\u0438\u0439|\u041c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0438\u0439|\u0421\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439|\u041c\u0430\u043b\u0430\u0439\u0441\u043a\u0438\u0439|\u041c\u0430\u0440\u0430\u0442\u0438\u0439\u0441\u043a\u0438\u0439|\u0421\u0442\u0430\u0440\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439|\u041c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438\u0439|\u0421\u0440\u0435\u0434\u043d\u0435\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439|\u041c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0438\u0439|\u0415\u0432\u0440\u0435\u0439\u0441\u043a\u043e-\u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439|\u041c\u0430\u043b\u0430\u044f\u043b\u0430\u043c|\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0439|\u041c\u0430\u043e\u0440\u0438|\u041c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0441\u043a\u0438\u0439|\u041c\u0430\u0440\u0432\u0430\u0440\u0438|\u0411\u0440\u0430\u0443\u0438|\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0438\u0439|\u041b\u0443\u0431\u0430-\u041a\u0430\u0442\u0430\u043d\u0433\u0430|\u0414\u0435\u043b\u0430\u0432\u0430\u0440\u0441\u043a\u0438\u0439|\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438\u0439|\u041b\u0430\u043e\u0441\u0441\u043a\u0438\u0439|\u041b\u0438\u043d\u0433\u0430\u043b\u0430|\u042d\u0432\u043e\u043d\u0434\u043e|\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0439|\u0415\u0432\u0440\u0435\u0439\u0441\u043a\u043e-\u043f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439|\u0423\u0434\u043c\u0443\u0440\u0442\u0441\u043a\u0438\u0439 (\u0412\u043e\u0442\u044f\u0446\u043a\u0438\u0439)|\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u043a\u0438\u0439|\u0421\u0438\u043d\u043e\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041a\u0443\u0440\u0434\u0438\u0448|\u0421\u0438\u0443 \u044f\u0437\u044b\u043a\u0438|\u041a\u0430\u0448\u043c\u0438\u0440\u0441\u043a\u0438\u0439|\u0410\u0432\u0430\u0434\u0445\u0438|\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u0438\u0439|\u041a\u0430\u043d\u0430\u0434\u0430|\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0438\u0439\u0441\u043a\u0438\u0439|\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439|\u0426\u044b\u0433\u0430\u043d\u0441\u043a\u0438\u0439|\u0421\u0438\u0434\u0430\u043c\u0430|\u0421\u0442\u0430\u0440\u043e\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0439|\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439|\u041a\u0440\u0438\u043a|\u0420\u043e\u043c\u0430\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041d\u043e\u0433\u0430\u0439\u0441\u043a\u0438\u0439|\u041c\u0443\u043d\u0434\u0430 \u044f\u0437\u044b\u043a\u0438|\u0420\u0430\u0437\u043d\u044b\u0445 \u0441\u0435\u043c\u0435\u0439 \u044f\u0437\u044b\u043a\u0438|\u042f\u0432\u0430\u043d\u0441\u043a\u0438\u0439|\u0413\u0438\u043b\u044c\u0431\u0435\u0440\u0442\u0441\u043a\u0438\u0439|\u0428\u0430\u043d\u0441\u043a\u0438\u0439|\u0424\u043e\u043d|\u0425\u043e\u0442\u0430\u043d\u0441\u043a\u0438\u0439|\u042f\u043f\u043e\u043d\u0441\u043a\u0438\u0439|\u041a\u043e\u0439\u0441\u0430\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041f\u0430\u043b\u0430\u0443|\u0427\u0435\u0439\u0435\u043d\u043d|\u0422\u0430\u0442\u0441\u043a\u0438\u0439|\u0418\u043d\u0430\u043a\u0442\u0438\u0442\u0443\u0442|\u0418\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0438\u0439|\u041f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e|\u0418\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u041a\u0445\u0430\u0441\u0438|\u0427\u0435\u0440\u043e\u043a\u0438|\u041f\u0430\u043c\u043f\u0430\u043d\u0433\u0430|\u041f\u0435\u0445\u043b\u0435\u0432\u0438\u0439\u0441\u043a\u0438\u0439|\u0427\u043e\u043a\u0442\u0430\u0432|\u0427\u0438\u043d\u0443\u043a \u0436\u0430\u0440\u0433\u043e\u043d|\u041c\u0430\u0440\u0438\u0439\u0441\u043a\u0438\u0439 (\u0427\u0435\u0440\u0435\u043c\u0438\u0441\u0441\u043a\u0438\u0439)|\u0422\u0443\u0432\u0438\u043d\u0441\u043a\u0438\u0439|\u0411\u0430\u043d\u0442\u0443 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0418\u043d\u0430\u043f\u0438\u0430\u043a|\u041f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d|\u0427\u0443\u043a\u043e\u0442\u0441\u043a\u0438\u0439|\u0413\u0430\u0432\u0430\u0439\u0441\u043a\u0438\u0439|\u041b\u0430\u043c\u0431\u0430|\u0427\u0430\u0433\u0430\u0442\u0430\u0439\u0441\u043a\u0438\u0439|\u0421\u0442\u0430\u0440\u043e\u0438\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u0421\u043c\u0435\u0448\u0430\u043d\u043d\u044b\u0439 \u044f\u0437\u044b\u043a|\u041f\u0430\u043f\u0443\u0430\u0441\u0441\u043a\u043e-\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0439|\u041b\u0430\u0445\u043d\u0434\u0430|\u0427\u0438\u0431\u0447\u0430|\u0421\u043c\u0435\u0448\u0430\u043d\u043d\u044b\u0439 \u044f\u0437\u044b\u043a|\u041b\u0430\u0434\u0438\u043d\u043e|\u0425\u0430\u0439\u0434\u0430|\u0410\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439|\u0410\u0442\u0430\u043f\u0430\u0447\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0412\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0439|\u0414\u0430\u043a\u043e\u0442\u0430|\u0425\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439|\u0425\u0438\u043d\u0434\u0438|\u0414\u0438\u0443\u043b\u0430 (\u0414\u044c\u044e\u043b\u0430)|\u0418\u0432\u0440\u0438\u0442|\u0425\u043e\u0441\u0430|\u041b\u0443\u0436\u0438\u0446\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0413\u0443\u044f\u0440\u0430\u0442\u0438|\u0421\u0435\u043c\u0438\u0442\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0418\u0440\u043e\u043a\u0435\u0437\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0421\u0435\u043b\u044c\u043a\u0443\u043f\u0441\u043a\u0438\u0439|\u0413\u0443\u0430\u0440\u0430\u043d\u0438|\u0413\u0430\u043b\u0438\u0446\u0438\u0439\u0441\u043a\u0438\u0439|\u0410\u0440\u0430\u0432\u0430\u043a\u0441\u043a\u0438\u0439|\u0413\u0435\u044d\u0437|\u0418\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0413\u0430\u044d\u043b\u044c\u0441\u043a\u0438\u0439|\u0418\u0440\u0430\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0418\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439|\u0424\u0440\u0438\u0437\u0441\u043a\u0438\u0439|\u0421\u0438\u043a\u0441\u0438\u043a\u0430|\u0413\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0410\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0438\u0439|\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439|\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0439|\u0424\u0438\u0434\u0436\u0438|\u0424\u0438\u043d\u0441\u043a\u0438\u0439|\u041f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439|\u0411\u0430\u0441\u043a\u0441\u043a\u0438\u0439|\u042d\u0441\u0442\u043e\u043d\u0441\u043a\u0438\u0439|\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439|\u042d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e|\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439|\u0413\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0439|\u0410\u043b\u0442\u0430\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041d\u0438\u0443\u044d|\u041c\u043e\u0435\u0439|\u0411\u0443\u0442\u0430\u043d\u0441\u043a\u0438\u0439|\u041d\u0438\u0433\u0435\u0440-\u043a\u043e\u0440\u0434\u043e\u0444\u0430\u043d\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0424\u0438\u043d\u043d\u043e-\u0443\u0433\u043e\u0440\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041c\u043e\u0445\u0430\u0443\u043a|\u041b\u0443\u043e (\u041a\u0435\u043d\u0438\u044f \u0438 \u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f)|\u041b\u0443\u043d\u0434\u0430|\u041b\u0443\u0438\u0441\u0435\u043d\u044c\u043e|\u0425\u0443\u043b\u0430|\u0411\u0438\u043d\u0438|\u041d\u0435\u043c\u0435\u0446\u043a\u0438\u0439|\u0411\u0438\u043a\u043e\u043b\u044c\u0441\u043a\u0438\u0439|\u0412\u0430\u0448\u043e|\u041d\u0435\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439|\u0412\u0430\u0440\u0430\u0439|\u0414\u0430\u0442\u0441\u043a\u0438\u0439|\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0441\u0440\u0435\u0434\u043d\u0435\u0432\u0435\u043a\u043e\u0432\u044b\u0439|\u0412\u043e\u043b\u0430\u043c\u043e|\u041c\u0430\u043d\u043e\u0431\u043e \u044f\u0437\u044b\u043a\u0438|\u0412\u0430\u043a\u0430\u0448\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0412\u0430\u043b\u043b\u0438\u0439\u0441\u043a\u0438\u0439|\u0427\u0443\u0432\u0430\u0448\u0441\u043a\u0438\u0439|\u041c\u0430\u043d\u0438\u043f\u0443\u0440\u0441\u043a\u0438\u0439|\u0427\u0435\u0448\u0441\u043a\u0438\u0439|\u0421\u0430\u043c\u0430\u0440\u0438\u0442\u044f\u043d\u0441\u043a\u0438\u0439 \u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0438\u0439|\u0421\u0430\u043b\u0438\u0448\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0414\u0443\u0430\u043b\u0430|\u041a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439|\u042e\u0436\u043d\u043e\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0438 \u0438\u043d\u0434\u0435\u0439\u0446\u0435\u0432 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u042f\u043a\u0443\u0442\u0441\u043a\u0438\u0439|\u041a\u0430\u0432\u0438|\u0421\u0430\u043d\u0434\u0430\u0432\u0435|\u0411\u0445\u043e\u0434\u0436\u043f\u0443\u0440\u0438|\u0421\u0440\u0435\u0434\u043d\u0435\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439|\u041a\u0430\u0440\u0435\u043d\u0441\u043a\u0438\u0439|\u0418\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0413\u0430\u0439\u043e|\u041a\u0430\u0442\u0430\u043b\u0430\u043d\u0441\u043a\u0438\u0439|\u0423\u043c\u0431\u0443\u043d\u0434\u0443|\u041a\u0430\u043c\u0431\u0430|\u0426\u0438\u043c\u0448\u0438\u0430\u043d|\u0421\u0442\u0430\u0440\u043e\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439|\u041a\u0430\u0432\u043a\u0430\u0437\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u041a\u0430\u0431\u0438\u043b\u044c\u0441\u043a\u0438\u0439|\u041a\u0430\u0440\u0430\u043a\u0430\u043b\u043f\u0430\u043a\u0441\u043a\u0438\u0439|\u041a\u0430\u0440\u0438\u0431|\u0411\u0440\u0435\u0442\u043e\u043d\u0441\u043a\u0438\u0439|\u0422\u0438\u0431\u0435\u0442\u0441\u043a\u0438\u0439|\u0411\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439|\u0413\u0430|\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0438 \u0438\u043d\u0434\u0435\u0439\u0446\u0435\u0432 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0411\u0438\u0441\u043b\u0430\u043c\u0430|\u0411\u0438\u0445\u0430\u0440\u0441\u043a\u0438\u0439|\u0411\u043e\u043b\u0433\u0430\u0440\u0441\u043a\u0438\u0439|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439|\u041a\u0430\u0434\u0434\u043e|\u0411\u0430\u0448\u043a\u0438\u0440\u0441\u043a\u0438\u0439|\u0417\u0443\u043b\u0443\u0441\u0441\u043a\u0438\u0439|\u0417\u0435\u043d\u0430\u0433\u0441\u043a\u0438\u0439|\u0421\u0442\u0430\u0440\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u044c\u0441\u043a\u0438\u0439|\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438\u0439|\u0410\u044f\u043c\u0430\u0440\u0430|\u0410\u0441\u0441\u0430\u043c\u0441\u043a\u0438\u0439|\u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0439|\u0418\u043b\u043e\u043a\u043e|\u042d\u043b\u0430\u043c\u0441\u043a\u0438\u0439|\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439|\u041f\u0440\u0430\u043a\u0440\u0438\u0442\u044b \u044f\u0437\u044b\u043a\u0438|\u0410\u043c\u0445\u0430\u0440\u0441\u043a\u0438\u0439|\u041d\u0435\u0432\u0430\u0440\u0441\u043a\u0438\u0439|\u0417\u0443\u0430\u043d\u0433|\u0410\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441|\u0410\u0431\u0445\u0430\u0437\u0441\u043a\u0438\u0439|\u0410\u0444\u0430\u0440|\u0419\u043e\u0440\u0443\u0431\u0430|\u0410\u043b\u0433\u043e\u043d\u043a\u0438\u043d\u0441\u043a\u0438\u0435 \u044f\u0437\u044b\u043a\u0438|\u0410\u043b\u0435\u0443\u0442\u0441\u043a\u0438\u0439|\u041c\u043e\u043d\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0418\u0434\u0438\u0448|\u0414\u0440\u0430\u0432\u0438\u0434\u0438\u0439\u0441\u043a\u0438\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)|\u0411\u0435\u043c\u0431\u0430|\u0411\u0435\u0434\u0436\u0430";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yy" },
    { "mediumDateFormat", "dd.MM.yyyy" },
    { "longDateFormat", "d MMMM yyyy '\u0433.'" },
    { "fullDateFormat", "d MMMM yyyy '\u0433.'" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
