/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.CapCell;
import com.sun.electric.tool.generator.layout.CapFloorplan;
import com.sun.electric.tool.generator.layout.CapLayer;
import com.sun.electric.tool.generator.layout.Floorplan;
import com.sun.electric.tool.generator.layout.G;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.MetalFloorplan;
import com.sun.electric.tool.generator.layout.MetalLayer;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.VddGndStraps;

class FillCell {
    private int vddNum;
    private int gndNum;
    private String vddNm;
    private String gndNm;

    private String vddName() {
        int n = this.vddNum++;
        return this.vddNm + (n == 0 ? "" : "_" + n);
    }

    private String gndName() {
        int n = this.gndNum++;
        return this.gndNm + (n == 0 ? "" : "_" + n);
    }

    public void exportPerimeter(VddGndStraps lay, Cell cell, StdCellParams stdCell) {
        int i;
        for (i = 0; i < lay.numGnd(); ++i) {
            this.exportStripeEnds(i, lay, true, cell, stdCell);
        }
        for (i = 0; i < lay.numVdd(); ++i) {
            this.exportStripeEnds(i, lay, false, cell, stdCell);
        }
    }

    private void exportStripeEnds(int n, VddGndStraps lay, boolean gnd, Cell cell, StdCellParams stdCell) {
        PortInst pi;
        PrimitiveNode pin = lay.getPinType();
        PrimitiveArc metal = lay.getMetalType();
        double edge = (lay.isHorizontal() ? lay.getCellWidth() : lay.getCellHeight()) / 2.0;
        double center = gnd ? lay.getGndCenter(n) : lay.getVddCenter(n);
        double width = gnd ? lay.getGndWidth(n) : lay.getVddWidth(n);
        PortInst portInst = pi = gnd ? lay.getGnd(n) : lay.getVdd(n);
        if (lay.isHorizontal()) {
            this.export(-edge, center, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
            this.export(edge, center, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
        } else {
            this.export(center, -edge, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
            this.export(center, edge, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
        }
    }

    private void export(double x, double y, PrimitiveNode pin, PrimitiveArc metal, PortInst conn, double w, String name, boolean gnd, Cell cell, StdCellParams stdCell) {
        PortInst pi = LayoutLib.newNodeInst(pin, x, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
        G.noExtendArc(metal, w, conn, pi);
        Export e = Export.newInstance(cell, pi, name);
        e.setCharacteristic(gnd ? stdCell.getGndExportRole() : stdCell.getVddExportRole());
    }

    public void exportWiring(VddGndStraps lay, Cell cell, StdCellParams stdCell) {
        int i;
        for (i = 0; i < lay.numGnd(); ++i) {
            this.exportStripeCenter(i, lay, true, cell, stdCell);
        }
        for (i = 0; i < lay.numVdd(); ++i) {
            this.exportStripeCenter(i, lay, false, cell, stdCell);
        }
    }

    private void exportStripeCenter(int n, VddGndStraps lay, boolean gnd, Cell cell, StdCellParams stdCell) {
        PortInst pi;
        PrimitiveNode pin = lay.getPinType();
        PrimitiveArc metal = lay.getMetalType();
        double center = gnd ? lay.getGndCenter(n) : lay.getVddCenter(n);
        double width = gnd ? lay.getGndWidth(n) : lay.getVddWidth(n);
        PortInst portInst = pi = gnd ? lay.getGnd(n) : lay.getVdd(n);
        if (lay.isHorizontal()) {
            this.export(0.0, center, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
        } else {
            this.export(center, 0.0, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, stdCell);
        }
    }

    private String fillName(int lo, int hi, boolean wireLowest, StdCellParams stdCell) {
        StringBuffer buf = new StringBuffer();
        buf.append("fill");
        if (lo != 1 || hi != 6) {
            for (int i = lo; i <= hi; ++i) {
                buf.append(i);
            }
        }
        if (wireLowest) {
            buf.append("w");
        }
        if (!stdCell.getVddExportName().equals("vdd")) {
            buf.append("_pwr");
        }
        buf.append("{lay}");
        return buf.toString();
    }

    private VddGndStraps[] findHoriVert(VddGndStraps lay1, VddGndStraps lay2) {
        if (lay1.isHorizontal()) {
            LayoutLib.error(lay2.isHorizontal(), "adjacent layers both horizontal");
            return new VddGndStraps[]{lay1, lay2};
        }
        LayoutLib.error(!lay2.isHorizontal(), "adjacent layers both vertical");
        return new VddGndStraps[]{lay2, lay1};
    }

    private void connectVddStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getVddWidth(verNdx);
        double x = verLay.getVddCenter(verNdx);
        PrimitiveArc verMetal = verLay.getMetalType();
        PortInst verPort = verLay.getVdd(verNdx);
        double h = horLay.getVddWidth(horNdx);
        double y = horLay.getVddCenter(horNdx);
        PrimitiveArc horMetal = horLay.getMetalType();
        PrimitiveNode viaType = Tech.getViaFor(verMetal, horMetal);
        PortInst horPort = horLay.getVdd(horNdx);
        LayoutLib.error(viaType == null, "can't find via for metal layers");
        ViaDim d = new ViaDim(horLay, x, y, w, h);
        PortInst via = LayoutLib.newNodeInst(viaType, d.x, d.y, d.w, d.h, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(horMetal, Double.POSITIVE_INFINITY, horPort, via);
        LayoutLib.newArcInst(verMetal, Double.POSITIVE_INFINITY, via, verPort);
    }

    private void connectGndStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getGndWidth(verNdx);
        double x = verLay.getGndCenter(verNdx);
        PrimitiveArc verMetal = verLay.getMetalType();
        PortInst verPort = verLay.getGnd(verNdx);
        double h = horLay.getGndWidth(horNdx);
        double y = horLay.getGndCenter(horNdx);
        PrimitiveArc horMetal = horLay.getMetalType();
        PrimitiveNode viaType = Tech.getViaFor(verMetal, horMetal);
        PortInst horPort = horLay.getGnd(horNdx);
        LayoutLib.error(viaType == null, "can't find via for metal layers");
        ViaDim d = new ViaDim(horLay, x, y, w, h);
        PortInst via = LayoutLib.newNodeInst(viaType, d.x, d.y, d.w, d.h, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(horMetal, Double.POSITIVE_INFINITY, horPort, via);
        LayoutLib.newArcInst(verMetal, Double.POSITIVE_INFINITY, via, verPort);
    }

    private void connectLayers(VddGndStraps loLayer, VddGndStraps hiLayer, Cell cell) {
        int v;
        int h;
        VddGndStraps[] layers = this.findHoriVert(loLayer, hiLayer);
        VddGndStraps horLay = layers[0];
        VddGndStraps verLay = layers[1];
        for (h = 0; h < horLay.numVdd(); ++h) {
            for (v = 0; v < verLay.numVdd(); ++v) {
                this.connectVddStraps(horLay, h, verLay, v, cell);
            }
        }
        for (h = 0; h < horLay.numGnd(); ++h) {
            for (v = 0; v < verLay.numGnd(); ++v) {
                this.connectGndStraps(horLay, h, verLay, v, cell);
            }
        }
    }

    private Cell makeFillCell1(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, boolean wireLowest, StdCellParams stdCell) {
        String name = this.fillName(botLayer, topLayer, wireLowest, stdCell);
        Cell cell = Cell.newInstance(lib, name);
        VddGndStraps[] layers = new VddGndStraps[7];
        for (int i = topLayer; i >= botLayer; --i) {
            layers[i] = i == 1 ? new CapLayer(lib, (CapFloorplan)plans[i], capCell, cell, stdCell) : new MetalLayer(i, (MetalFloorplan)plans[i], cell);
            if (i == topLayer) continue;
            this.connectLayers(layers[i], layers[i + 1], cell);
        }
        if (layers[topLayer] != null) {
            this.exportPerimeter(layers[topLayer], cell, stdCell);
        }
        if (layers[topLayer - 1] != null) {
            this.exportPerimeter(layers[topLayer - 1], cell, stdCell);
        }
        if (wireLowest) {
            this.exportWiring(layers[botLayer], cell, stdCell);
        }
        double cellWidth = plans[topLayer].cellWidth;
        double cellHeight = plans[topLayer].cellHeight;
        LayoutLib.newNodeInst(Tech.essentialBounds, -cellWidth / 2.0, -cellHeight / 2.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, cellWidth / 2.0, cellHeight / 2.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
        return cell;
    }

    private FillCell(StdCellParams stdCell) {
        this.gndNm = stdCell.getGndExportName();
        this.vddNm = stdCell.getVddExportName();
    }

    public static Cell makeFillCell(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, boolean wireLowest, StdCellParams stdCell) {
        FillCell fc = new FillCell(stdCell);
        return fc.makeFillCell1(lib, plans, botLayer, topLayer, capCell, wireLowest, stdCell);
    }

    private static class ViaDim {
        public final double x;
        public final double y;
        public final double w;
        public final double h;

        public ViaDim(VddGndStraps lay, double x, double y, double w, double h) {
            if (x + w / 2.0 == lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x -= 0.5;
            } else if (x - w / 2.0 == -lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x += 0.5;
            }
            if (y + h / 2.0 == lay.getCellHeight() / 2.0) {
                h -= 1.0;
                y -= 0.5;
            } else if (y - h / 2.0 == -lay.getCellHeight() / 2.0) {
                h -= 1.0;
                y += 0.5;
            }
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

