/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class FileType {
    private static final ArrayList allTypes = new ArrayList();
    public static final FileType ANY = new FileType("All", new String[0], "All Files");
    public static final FileType CDL = new FileType("CDL", new String[]{"cdl"}, "CDL Deck (cdl)");
    public static final FileType CIF = new FileType("CIF", new String[]{"cif"}, "CIF File (cif)");
    public static final FileType COSMOS = new FileType("COSMOS", new String[]{"sim"}, "COSMOS File (sim)");
    public static final FileType DEF = new FileType("DEF", new String[]{"def"}, "DEF File (def)");
    public static final FileType DXF = new FileType("DXF", new String[]{"dxf"}, "DXF File (dxf)");
    public static final FileType EAGLE = new FileType("Eagle", new String[]{"txt"}, "Eagle File (txt)");
    public static final FileType ECAD = new FileType("ECAD", new String[]{"enl"}, "ECAD File (enl)");
    public static final FileType EDIF = new FileType("EDIF", new String[]{"edif"}, "EDIF File (edif)");
    public static final FileType ELIB = new FileType("ELIB", new String[]{"elib"}, "Library File (elib)");
    public static final FileType EPS = new FileType("Encapsulated PostScript", new String[]{"eps"}, "Encapsulated PostScript (eps)");
    public static final FileType ESIM = new FileType("ESIM", new String[]{"sim"}, "ESIM File (sim)");
    public static final FileType FASTHENRY = new FileType("FastHenry", new String[]{"inp"}, "FastHenry File (inp)");
    public static final FileType GDS = new FileType("GDS", new String[]{"gds"}, "GDS File (gds)");
    public static final FileType HSPICEOUT = new FileType("HSpiceOutput", new String[]{"tr0", "pa0"}, "HSpice Output File (tr0/pa0)");
    public static final FileType HTML = new FileType("HTML", new String[]{"html"}, "HTML File (html)");
    public static final FileType IRSIM = new FileType("IRSIM", new String[]{"sim"}, "IRSIM Deck (sim)");
    public static final FileType JAVA = new FileType("Java", new String[]{"java", "bsh"}, "Java Script File (java, bsh)");
    public static final FileType JELIB = new FileType("JELIB", new String[]{"jelib"}, "Library File (jelib)");
    public static final FileType L = new FileType("L", new String[]{"L"}, "L File (L)");
    public static final FileType LEF = new FileType("LEF", new String[]{"lef"}, "LEF File (lef)");
    public static final FileType MAXWELL = new FileType("Maxwell", new String[]{"mac"}, "Maxwell Deck (mac)");
    public static final FileType MOSSIM = new FileType("MOSSIM", new String[]{"ntk"}, "MOSSIM Deck (ntk)");
    public static final FileType PADARR = new FileType("PadArray", new String[]{"arr"}, "Pad Generator Array File (arr)");
    public static final FileType PADS = new FileType("Pads", new String[]{"asc"}, "Pads File (asc)");
    public static final FileType PAL = new FileType("PAL", new String[]{"pal"}, "PAL File (pal)");
    public static final FileType POSTSCRIPT = new FileType("PostScript", new String[]{"ps"}, "PostScript (ps)");
    public static final FileType PNG = new FileType("PNG", new String[]{"png"}, "PNG (png)");
    public static final FileType PSPICEOUT = new FileType("PSpiceOutput", new String[]{"spo"}, "PSpice/Spice3 Output File (spo)");
    public static final FileType RAWSPICEOUT = new FileType("RawSpiceOutput", new String[]{"raw"}, "Spice Raw Output File (raw)");
    public static final FileType RAWSSPICEOUT = new FileType("RawSmartSpiceOutput", new String[]{"raw"}, "SmartSPICE Raw Output File (raw)");
    public static final FileType READABLEDUMP = new FileType("ReadableDump", new String[]{"txt"}, "Readable Dump Library File (txt)");
    public static final FileType RSIM = new FileType("RSIM", new String[]{"sim"}, "RSIM File (sim)");
    public static final FileType SILOS = new FileType("Silos", new String[]{"sil"}, "Silos Deck (sil)");
    public static final FileType SKILL = new FileType("Skill", new String[]{"il"}, "Skill Deck (il)");
    public static final FileType SPICE = new FileType("Spice", new String[]{"spi", "sp"}, "Spice Deck (spi, sp)");
    public static final FileType SPICEOUT = new FileType("SpiceOutput", new String[]{"spo"}, "Spice/GNUCap Output File (spo)");
    public static final FileType SUE = new FileType("Sue", new String[]{"sue"}, "Sue File (sue)");
    public static final FileType TEGAS = new FileType("Tegas", new String[]{"tdl"}, "Tegas File (tdl)");
    public static final FileType TEXT = new FileType("Text", new String[]{"txt"}, "Text File (txt)");
    public static final FileType VERILOG = new FileType("Verilog", new String[]{"v"}, "Verilog Deck (v)");
    public static final FileType VERILOGOUT = new FileType("VerilogOutput", new String[]{"dump"}, "Verilog VCD Dump (vcd)");
    public static final FileType DEFAULTLIB = ELIB;
    public static final FileType[] libraryTypes = new FileType[]{ELIB, JELIB};
    private static String[] libraryTypesExt;
    private static String libraryTypesExtReadable;
    public static final FileType LIBRARYFORMATS;
    private final String name;
    private final String[] extensions;
    private final String desc;
    private FileFilterSwing ffs;
    private FileFilterAWT ffa;

    private FileType(String name, String[] extensions, String desc) {
        this.name = name;
        this.extensions = extensions;
        this.desc = desc;
        this.ffs = null;
        this.ffa = null;
        allTypes.add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public FileFilterSwing getFileFilterSwing() {
        if (this.ffs == null) {
            this.ffs = new FileFilterSwing(this.extensions, this.desc);
        }
        return this.ffs;
    }

    public FileFilterAWT getFileFilterAWT() {
        if (this.ffa == null) {
            this.ffa = new FileFilterAWT(this.extensions, this.desc);
        }
        return this.ffa;
    }

    public String toString() {
        return this.name;
    }

    public static FileType getType(FileFilter filter) {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            FileType type = (FileType)it.next();
            if (type.ffs != filter) continue;
            return type;
        }
        return null;
    }

    public static FileType getType(FilenameFilter filter) {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            FileType type = (FileType)it.next();
            if (type.ffa != filter) continue;
            return type;
        }
        return null;
    }

    static {
        ArrayList<String> exts = new ArrayList<String>();
        for (int i = 0; i < libraryTypes.length; ++i) {
            FileType type = libraryTypes[i];
            String[] typeExts = type.getExtensions();
            for (int j = 0; j < typeExts.length; ++j) {
                exts.add(typeExts[j]);
            }
        }
        libraryTypesExt = new String[exts.size()];
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < exts.size(); ++i) {
            FileType.libraryTypesExt[i] = (String)exts.get(i);
            buf.append((String)exts.get(i));
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.replace(buf.length() - 2, buf.length(), ")");
        }
        libraryTypesExtReadable = buf.toString();
        LIBRARYFORMATS = new FileType("LibraryFormtas", libraryTypesExt, "Library Formats " + libraryTypesExtReadable);
    }

    private static class FileFilterAWT
    implements FilenameFilter {
        private String[] extensions;
        private String desc;

        public FileFilterAWT(String[] extensions, String desc) {
            this.extensions = extensions;
            this.desc = desc;
        }

        public boolean accept(File f, String filename) {
            if (this.extensions.length == 0) {
                return true;
            }
            int i = filename.lastIndexOf(46);
            if (i < 0) {
                return false;
            }
            String thisExtension = filename.substring(i + 1);
            if (thisExtension == null) {
                return false;
            }
            for (int j = 0; j < this.extensions.length; ++j) {
                String extension = this.extensions[j];
                if (!extension.equalsIgnoreCase(thisExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    private static class FileFilterSwing
    extends FileFilter {
        private String[] extensions;
        private String desc;

        public FileFilterSwing(String[] extensions, String desc) {
            this.extensions = extensions;
            this.desc = desc;
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            if (this.extensions.length == 0) {
                return true;
            }
            String filename = f.getName();
            int i = filename.lastIndexOf(46);
            if (i < 0) {
                return false;
            }
            String thisExtension = filename.substring(i + 1);
            if (thisExtension == null) {
                return false;
            }
            for (int j = 0; j < this.extensions.length; ++j) {
                String extension = this.extensions[j];
                if (!extension.equalsIgnoreCase(thisExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

