/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Eagle
extends Output {
    public static final Variable.Key REF_DES_KEY = ElectricObject.newKey("ATTR_ref_des");
    public static final Variable.Key PKG_TYPE_KEY = ElectricObject.newKey("ATTR_pkg_type");
    public static final Variable.Key PIN_KEY = ElectricObject.newKey("ATTR_pin");
    private List networks;

    private Eagle() {
    }

    public static void writeEagleFile(Output.OutputCellInfo cellJob) {
        Eagle out = new Eagle();
        out.writeNetlist(cellJob.cell, cellJob.context, cellJob.filePath);
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        NetNames nn;
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        this.networks = new ArrayList();
        EagleNetlister netlister = new EagleNetlister();
        Netlist netlist = cell.getNetlist(true);
        HierarchyEnumerator.enumerateCell(cell, context, netlist, netlister);
        this.printWriter.println(";");
        if (this.networks.size() == 0) {
            System.out.println("ERROR: no output produced.  Packages need attribute 'ref_des' and ports need attribute 'pin'");
        }
        Collections.sort(this.networks, new NetNamesSort());
        int widestNodeName = 0;
        int widestNetName = 0;
        Iterator it = this.networks.iterator();
        while (it.hasNext()) {
            int netNameLen;
            nn = (NetNames)it.next();
            int nodeNameLen = nn.nodeName.length();
            if (nodeNameLen > widestNodeName) {
                widestNodeName = nodeNameLen;
            }
            if ((netNameLen = nn.netName.length()) <= widestNetName) continue;
            widestNetName = netNameLen;
        }
        widestNodeName += 4;
        widestNetName += 4;
        for (int i = 0; i < this.networks.size(); ++i) {
            NetNames oNn;
            nn = (NetNames)this.networks.get(i);
            String baseName = nn.netName;
            int endPos = i;
            int j = i + 1;
            while (j < this.networks.size()) {
                oNn = (NetNames)this.networks.get(j);
                if (!oNn.netName.equals(baseName)) break;
                endPos = j++;
            }
            if (endPos == i) continue;
            for (j = i; j <= endPos; ++j) {
                int k;
                oNn = (NetNames)this.networks.get(j);
                if (j == i) {
                    this.printWriter.print("Signal ");
                } else {
                    this.printWriter.print("       ");
                }
                this.printWriter.print("'" + oNn.netName + "'");
                for (k = oNn.netName.length(); k < widestNetName; ++k) {
                    this.printWriter.print(" ");
                }
                this.printWriter.print("'" + oNn.nodeName + "'");
                for (k = oNn.nodeName.length(); k < widestNodeName; ++k) {
                    this.printWriter.print(" ");
                }
                this.printWriter.println("'" + oNn.portName + "' \\");
            }
            this.printWriter.println(";");
        }
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private class EagleNetlister
    extends HierarchyEnumerator.Visitor {
        private EagleNetlister() {
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto np = no.getProto();
            if (np instanceof PrimitiveNode) {
                return false;
            }
            Variable var = no.getVar(REF_DES_KEY);
            if (var == null) {
                return true;
            }
            String context = "";
            Nodable pNo = info.getParentInst();
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null && pNo != null) {
                context = parentInfo.getUniqueNodableName(pNo, ".") + ".";
            }
            String nodeName = context + var.getPureValue(-1);
            String pkgType = no.getProto().getName();
            Variable pkgName = no.getVar(PKG_TYPE_KEY);
            if (pkgName != null) {
                pkgType = pkgName.getPureValue(-1);
            }
            Eagle.this.printWriter.println("ADD " + pkgType + " '" + nodeName + "' (0 0)");
            Iterator it = np.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                String pName = null;
                PortInst pi = no.getNodeInst().findPortInstFromProto(pp);
                Variable pVar = pi.getVar(PIN_KEY);
                if (pVar != null) {
                    pName = pVar.getPureValue(-1);
                } else {
                    pVar = pp.getVar(PIN_KEY);
                    if (pVar != null) {
                        pName = pVar.getPureValue(-1);
                    }
                }
                if (pName == null) continue;
                int[] ids = info.getPortNetIDs(no, pp);
                for (int i = 0; i < ids.length; ++i) {
                    NetNames nn = new NetNames();
                    nn.netName = info.getUniqueNetName(ids[i], ".");
                    nn.nodeName = nodeName;
                    nn.portName = pName;
                    Eagle.this.networks.add(nn);
                }
            }
            return false;
        }
    }

    private static class NetNamesSort
    implements Comparator {
        private NetNamesSort() {
        }

        public int compare(Object o1, Object o2) {
            NetNames nn1 = (NetNames)o1;
            NetNames nn2 = (NetNames)o2;
            String name1 = nn1.netName;
            String name2 = nn2.netName;
            return name1.compareToIgnoreCase(name2);
        }
    }

    private static class NetNames {
        String nodeName;
        String netName;
        String portName;

        private NetNames() {
        }
    }
}

