/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NetEquivalence;

public class NccResult {
    private boolean exportMatch;
    private boolean topologyMatch;
    private boolean sizeMatch;
    private NccGlobals globalData;

    public NccResult(boolean exportNameMatch, boolean topologyMatch, boolean sizeMatch, NccGlobals globalData) {
        this.exportMatch = exportNameMatch;
        this.topologyMatch = topologyMatch;
        this.sizeMatch = sizeMatch;
        this.globalData = globalData;
    }

    public void abandonNccGlobals() {
        this.globalData = null;
    }

    public void andEquals(NccResult result) {
        this.exportMatch &= result.exportMatch;
        this.topologyMatch &= result.topologyMatch;
        this.sizeMatch &= result.sizeMatch;
        this.globalData = result.globalData;
    }

    public boolean exportMatch() {
        return this.exportMatch;
    }

    public boolean topologyMatch() {
        return this.topologyMatch;
    }

    public boolean sizeMatch() {
        return this.sizeMatch;
    }

    public boolean match() {
        return this.exportMatch && this.topologyMatch && this.sizeMatch;
    }

    public NetEquivalence getNetEquivalence() {
        Object equivNets = this.globalData == null ? new HierarchyEnumerator.NetNameProxy[][]{new HierarchyEnumerator.NetNameProxy[0], new HierarchyEnumerator.NetNameProxy[0]} : this.globalData.getEquivalentNets();
        return new NetEquivalence((HierarchyEnumerator.NetNameProxy[][])equivNets);
    }

    public String summary(boolean checkSizes) {
        String s = this.exportMatch ? "exports match, " : "exports mismatch, ";
        s = this.topologyMatch ? s + "topologies match, " : s + "topologies mismatch, ";
        s = !checkSizes ? s + "sizes not checked" : (this.sizeMatch ? s + "sizes match" : s + "sizes mismatch");
        return s;
    }
}

