/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Wire
extends NetObject {
    private static final ArrayList DELETED = null;
    private ArrayList parts = new ArrayList();
    private Port port;
    private NccNameProxy.WireNameProxy nameProxy;

    public Wire(NccNameProxy.WireNameProxy name) {
        this.nameProxy = name;
    }

    public String getName() {
        return this.nameProxy.getName();
    }

    public NccNameProxy.WireNameProxy getNameProxy() {
        return this.nameProxy;
    }

    public Iterator getParts() {
        return this.parts.iterator();
    }

    public Iterator getConnected() {
        return this.getParts();
    }

    public void add(Part p) {
        Wire.error(p == null, "Wires can't add null Part");
        this.parts.add(p);
    }

    public Port addExport(String portName, PortCharacteristic type) {
        if (this.port == null) {
            this.port = new Port(portName, type, this);
        } else {
            this.port.addExport(portName, type);
        }
        return this.port;
    }

    public void putInFinalForm() {
        HashSet<Part> goodParts = new HashSet<Part>();
        Iterator it = this.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (p.isDeleted()) continue;
            goodParts.add(p);
        }
        this.parts = new ArrayList();
        this.parts.addAll(goodParts);
        this.parts.trimToSize();
    }

    public Port getPort() {
        return this.port;
    }

    public NetObject.Type getNetObjType() {
        return NetObject.Type.WIRE;
    }

    public void setDeleted() {
        this.parts = DELETED;
    }

    public boolean isDeleted() {
        return this.parts == DELETED;
    }

    public void checkMe(Circuit parent) {
        Wire.error(this.getParent() != parent, "wrong parent");
        Iterator it = this.getParts();
        while (it.hasNext()) {
            NetObject nn = (NetObject)it.next();
            Wire.error(!(nn instanceof Part), "expecting only parts");
            Part pp = (Part)nn;
            Wire.error(pp.numPinsConnected(this) == 0, "Part not connected back to wire");
        }
    }

    public boolean touches(Part p) {
        return this.parts.contains(p);
    }

    public boolean touches(Port p) {
        return this.port == p;
    }

    public Integer computeHashCode() {
        int sum = 0;
        Iterator it = this.getParts();
        while (it.hasNext()) {
            Part pp = (Part)it.next();
            sum += pp.getHashFor(this);
        }
        return new Integer(sum);
    }

    public int numParts() {
        return this.parts.size();
    }

    public String instanceDescription() {
        String inst = this.nameProxy.cellInstPath();
        String instMsg = inst.equals("") ? "" : " Cell instance: " + inst;
        return "Wire: " + this.nameProxy.leafName() + " in Cell: " + this.nameProxy.leafCell().libDescribe() + instMsg;
    }

    public String valueDescription() {
        return "";
    }

    public String connectionDescription(int maxParts) {
        if (this.parts.size() == 0) {
            return " unconnected";
        }
        String s = " connected to";
        if (this.numParts() > maxParts) {
            s = s + " " + this.parts.size() + " parts starting with";
        }
        s = s + ": ";
        Iterator it = this.getParts();
        for (int i = 0; it.hasNext() && i < maxParts; ++i) {
            Part p = (Part)it.next();
            String cc = p.instanceDescription();
            s = s + " (" + cc + " Port: " + p.connectionDescription(this) + ") ";
        }
        return s;
    }
}

