/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import [Ljava.awt.geom.Point2D;;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeInst
extends Geometric
implements Nodable,
Comparable {
    public static final String NODE_PROTO_TD;
    public static final String NODE_NAME_TD;
    public static final Variable.Key NODE_NAME;
    public static final Variable.Key TRACE;
    private static final Variable.Key TRANSISTOR_LENGTH_KEY;
    private static final PortInst[] NULL_PORT_INST_ARRAY;
    private static final Export[] NULL_EXPORT_ARRAY;
    private ImmutableNodeInst d;
    private NodeProto protoType;
    private int nodeIndex = -1;
    private PortInst[] portInsts = NULL_PORT_INST_ARRAY;
    private ArrayList connections = new ArrayList(2);
    private Export[] exports = NULL_EXPORT_ARRAY;
    private boolean wiped;
    private boolean expanded;
    private Rectangle2D visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isSpecialNode(NodeInst ni) {
        NodeProto np = ni.getProto();
        return np == Generic.tech.cellCenterNode || np == Generic.tech.drcNode || np == Generic.tech.essentialBoundsNode || np.getFunction() == PrimitiveNode.Function.PIN || np.getFunction() == PrimitiveNode.Function.CONNECT;
    }

    NodeInst(ImmutableNodeInst d, Cell parent) {
        this.parent = parent;
        this.protoType = d.protoId.inCurrentThread();
        this.d = d;
        this.portInsts = new PortInst[this.protoType.getNumPorts()];
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortProto pp = this.protoType.getPort(i);
            this.portInsts[i] = PortInst.newInstance(pp, this);
        }
        this.expanded = this.protoType instanceof Cell && ((Cell)this.protoType).isWantExpanded();
        this.redoGeometric();
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent) {
        return NodeInst.makeInstance(protoType, center, width, height, parent, Orientation.IDENT, null, 0);
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        NodeInst ni = NodeInst.newInstance(protoType, center, width, height, parent, orient, name, techBits);
        if (ni != null) {
            if (protoType instanceof Cell) {
                if (((Cell)protoType).isWantExpanded()) {
                    ni.setExpanded();
                }
            } else {
                protoType.getTechnology().setDefaultOutline(ni);
            }
            CircuitChanges.inheritAttributes(ni, false);
        }
        return ni;
    }

    public static NodeInst makeDummyInstance(NodeProto np) {
        return NodeInst.makeDummyInstance(np, EPoint.ORIGIN, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT);
    }

    public static NodeInst makeDummyInstance(NodeProto np, Point2D center, double width, double height, Orientation orient) {
        ImmutableNodeInst d = ImmutableNodeInst.newInstance(0, np.getId(), Name.findName("@"), 0, ImmutableTextDescriptor.getNodeTextDescriptor(), orient, EPoint.ORIGIN, width, height, 0, 0, ImmutableTextDescriptor.getInstanceTextDescriptor());
        return new NodeInst(d, null);
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent) {
        return NodeInst.newInstance(protoType, center, width, height, parent, Orientation.IDENT, null, 0);
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        return NodeInst.newInstance(parent, protoType, name, -1, null, center, width, height, orient, 0, techBits, null);
    }

    public static NodeInst newInstance(Cell parent, NodeProto protoType, String name, int duplicate, ImmutableTextDescriptor nameDescriptor, Point2D center, double width, double height, Orientation orient, int flags, int techBits, ImmutableTextDescriptor protoDescriptor) {
        ImmutableNodeInst d;
        NodeInst ni;
        Name nameKey;
        if (protoType == null) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        if (protoType instanceof Cell) {
            if (Cell.isInstantiationRecursive((Cell)protoType, parent)) {
                System.out.println("Cannot create instance of " + protoType + " in " + parent + " because it is recursive");
                return null;
            }
            height = 0.0;
            width = 0.0;
        }
        EPoint anchor = EPoint.snap(center);
        if (protoType == Generic.tech.cellCenterNode) {
            Iterator it = parent.getNodes();
            while (it.hasNext()) {
                NodeInst oNi = (NodeInst)it.next();
                if (oNi.getProto() != Generic.tech.cellCenterNode) continue;
                System.out.println("Can only be one cell-center in " + parent + ": new one ignored");
                return null;
            }
            anchor = EPoint.ORIGIN;
            height = 0.0;
            width = 0.0;
            orient = Orientation.IDENT;
        }
        Name name2 = nameKey = name != null ? Name.findName(name) : null;
        if (nameKey == null || nameKey.isTempname() && !parent.isUniqueName(nameKey, NodeInst.class, null) || NodeInst.checkNameKey(nameKey, parent, true)) {
            Name baseName;
            if (protoType instanceof Cell) {
                baseName = ((Cell)protoType).getBasename();
            } else {
                PrimitiveNode np = (PrimitiveNode)protoType;
                baseName = np.getTechnology().getPrimitiveFunction(np, techBits).getBasename();
            }
            nameKey = parent.getAutoname(baseName);
            duplicate = 0;
        }
        duplicate = parent.fixupNodeDuplicate(nameKey, duplicate);
        CellId parentId = (CellId)parent.getId();
        if (nameDescriptor == null) {
            nameDescriptor = ImmutableTextDescriptor.getNodeTextDescriptor();
        }
        if (protoDescriptor == null) {
            protoDescriptor = ImmutableTextDescriptor.getInstanceTextDescriptor();
        }
        if ((ni = new NodeInst(d = ImmutableNodeInst.newInstance(parentId.newNodeId(), protoType.getId(), nameKey, duplicate, nameDescriptor, orient, anchor, width, height, flags, techBits, protoDescriptor), parent)).checkAndRepair(true, null, null) > 0) {
            return null;
        }
        if (ni.lowLevelLink()) {
            return null;
        }
        Undo.newObject(ni);
        if (protoType == Generic.tech.cellCenterNode) {
            parent.adjustReferencePoint(center.getX(), center.getY());
        }
        if (protoType == Schematics.tech.globalNode) {
            System.out.println("Global-signal " + ni + " in " + parent + " has characteristic " + PortCharacteristic.findCharacteristic(ni.getTechSpecific()));
        }
        return ni;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("NodeInst already killed");
            return;
        }
        while (this.connections.size() > 0) {
            Connection con = (Connection)this.connections.get(this.connections.size() - 1);
            con.getArc().kill();
        }
        while (this.exports.length != 0) {
            Export pp = this.exports[this.exports.length - 1];
            pp.kill();
        }
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public void move(double dX, double dY) {
        this.modifyInstance(dX, dY, 0.0, 0.0, Orientation.IDENT);
    }

    public void resize(double dXSize, double dYSize) {
        this.modifyInstance(0.0, 0.0, dXSize, dYSize, Orientation.IDENT);
    }

    public void rotate(Orientation dOrient) {
        this.modifyInstance(0.0, 0.0, 0.0, 0.0, dOrient);
    }

    public void modifyInstance(double dX, double dY, double dXSize, double dYSize, Orientation dOrient) {
        ImmutableNodeInst oldD;
        if (this.protoType == Generic.tech.cellCenterNode) {
            this.parent.adjustReferencePoint(dX, dY);
            return;
        }
        ImmutableNodeInst d = oldD = this.getD();
        if (dX != 0.0 || dY != 0.0) {
            d = d.withAnchor(new EPoint(d.anchor.getX() + dX, d.anchor.getY() + dY));
        }
        if (this.protoType instanceof PrimitiveNode) {
            d = d.withSize(d.width + dXSize, d.height + dYSize);
        }
        d = d.withOrient(dOrient.concatenate(d.orient));
        this.lowLevelModify(d);
        Undo.modifyNodeInst(this, oldD);
    }

    public static void modifyInstances(NodeInst[] nis, double[] dXs, double[] dYs, double[] dXSizes, double[] dYSizes) {
        double dY;
        double dX;
        NodeInst ni;
        int i;
        double cX = 0.0;
        double cY = 0.0;
        for (i = 0; i < nis.length; ++i) {
            double dYSize;
            ni = nis[i];
            if (ni == null) continue;
            dX = dXs != null ? dXs[i] : 0.0;
            dY = dYs != null ? dYs[i] : 0.0;
            double dXSize = dXSizes != null ? dXSizes[i] : 0.0;
            double d = dYSize = dYSizes != null ? dYSizes[i] : 0.0;
            if (ni.getProto() == Generic.tech.cellCenterNode) continue;
            ni.modifyInstance(dX, dY, dXSize, dYSize, Orientation.IDENT);
        }
        for (i = 0; i < nis.length; ++i) {
            ni = nis[i];
            if (ni == null || ni.getProto() != Generic.tech.cellCenterNode) continue;
            dX = dXs != null ? dXs[i] : 0.0;
            dY = dYs != null ? dYs[i] : 0.0;
            ni.getParent().adjustReferencePoint(dX, dY);
        }
    }

    public NodeInst replace(NodeProto np, boolean ignorePortNames, boolean allowMissingPorts) {
        PortInst opi;
        int index;
        NodeInst newNi;
        if (np instanceof Cell && Cell.isInstantiationRecursive((Cell)np, this.getParent())) {
            System.out.println("Cannot replace because it would be recursive");
            return null;
        }
        EPoint oldCenter = this.getAnchorCenter();
        double newXS = np.getDefWidth();
        double newYS = np.getDefHeight();
        if (np instanceof PrimitiveNode && this.getProto() instanceof PrimitiveNode) {
            SizeOffset oldSO = this.getProto().getProtoSizeOffset();
            SizeOffset newSO = np.getProtoSizeOffset();
            newXS = this.getXSize() - oldSO.getLowXOffset() - oldSO.getHighXOffset() + newSO.getLowXOffset() + newSO.getHighXOffset();
            newYS = this.getYSize() - oldSO.getLowYOffset() - oldSO.getHighYOffset() + newSO.getLowYOffset() + newSO.getHighYOffset();
            if (newXS < np.getDefWidth()) {
                newXS = np.getDefWidth();
            }
            if (newYS < np.getDefHeight()) {
                newYS = np.getDefHeight();
            }
            if (this.getXSize() == this.getProto().getDefWidth()) {
                newXS = np.getDefWidth();
            }
            if (this.getYSize() == this.getProto().getDefHeight()) {
                newYS = np.getDefHeight();
            }
        }
        if ((newNi = NodeInst.newInstance(np, oldCenter, newXS, newYS, this.getParent(), this.getOrient(), null, 0)) == null) {
            return null;
        }
        if (np instanceof Cell && this.getProto() instanceof Cell) {
            if (this.isExpanded()) {
                newNi.setExpanded();
            } else {
                newNi.clearExpanded();
            }
        }
        PortAssociation[] oldAssoc = this.portAssociate(this, newNi, ignorePortNames);
        double arcDx = 0.0;
        double arcDy = 0.0;
        int arcCount = 0;
        Iterator it = this.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != con.getPortInst(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                if (allowMissingPorts) continue;
                System.out.println("No port on new node has same name and location as old node port: " + con.getPortInst().getPortProto().getName());
                newNi.kill();
                return null;
            }
            opi = oldAssoc[index].assn;
            ArcInst ai = con.getArc();
            if (!opi.getPortProto().connectsTo(ai.getProto())) {
                if (allowMissingPorts) continue;
                System.out.println(ai + " on old port " + con.getPortInst().getPortProto().getName() + " cannot connect to new port " + opi.getPortProto().getName());
                newNi.kill();
                return null;
            }
            Poly poly = opi.getPoly();
            if (!poly.isInside(con.getLocation())) {
                double xp = poly.getCenterX();
                double yp = poly.getCenterY();
                arcDx += xp - con.getLocation().getX();
                arcDy += yp - con.getLocation().getY();
            }
            ++arcCount;
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pp.getOriginalPort(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                System.out.println("No port on new node has same name and location as old node port: " + pp.getOriginalPort().getPortProto().getName());
                newNi.kill();
                return null;
            }
            opi = oldAssoc[index].assn;
            if (!pp.doesntConnect(opi.getPortProto().getBasePort())) continue;
            newNi.kill();
            return null;
        }
        ArrayList arcList = new ArrayList();
        Iterator it2 = this.getConnections();
        while (it2.hasNext()) {
            arcList.add(it2.next());
        }
        it2 = arcList.iterator();
        while (it2.hasNext()) {
            ArcInst newAi;
            NodeInst adjustThisNode;
            int ang;
            int ii;
            int index2;
            Connection con = (Connection)it2.next();
            for (index2 = 0; index2 < oldAssoc.length && oldAssoc[index2].portInst != con.getPortInst(); ++index2) {
            }
            if (index2 >= oldAssoc.length || oldAssoc[index2].assn == null) {
                if (allowMissingPorts) continue;
                System.out.println("No port on new node has same name and location as old node port: " + con.getPortInst().getPortProto().getName());
                newNi.kill();
                return null;
            }
            PortInst opi2 = oldAssoc[index2].assn;
            ArcInst ai = con.getArc();
            if (opi2 == null) {
                if (!allowMissingPorts) {
                    System.out.println("Cannot re-connect " + ai);
                    continue;
                }
                ai.kill();
                continue;
            }
            PortInst[] newPortInst = new PortInst[2];
            Point2D[] newPoint = new Point2D[2];
            int thisEnd = con.getEndIndex();
            newPortInst[thisEnd] = opi2;
            Poly poly = opi2.getPoly();
            newPoint[thisEnd] = poly.isInside(con.getLocation()) ? con.getLocation() : new EPoint(poly.getCenterX(), poly.getCenterY());
            int otherEnd = 1 - thisEnd;
            newPortInst[otherEnd] = ai.getPortInst(otherEnd);
            newPoint[otherEnd] = ai.getLocation(otherEnd);
            boolean zigzag = false;
            if (ai.isFixedAngle() && (newPoint[0].getX() != newPoint[1].getX() || newPoint[0].getY() != newPoint[1].getY()) && (ii = DBMath.figureAngle(newPoint[0], newPoint[1])) % 1800 != (ang = ai.getAngle()) % 1800) {
                zigzag = true;
            }
            if (zigzag && !ai.isRigid() && ai.getAngle() % 900 == 0 && (adjustThisNode = ai.getPortInst(otherEnd).getNodeInst()).getNumExports() == 0) {
                boolean adjustable = true;
                Iterator oIt = adjustThisNode.getConnections();
                while (oIt.hasNext()) {
                    Connection otherCon = (Connection)oIt.next();
                    ArcInst otherArc = otherCon.getArc();
                    if (otherArc == ai) continue;
                    if (otherArc.isRigid()) {
                        adjustable = false;
                        break;
                    }
                    if (otherArc.getAngle() % 900 != 0) {
                        adjustable = false;
                        break;
                    }
                    if ((ai.getAngle() / 900 & 1) != (otherArc.getAngle() / 900 & 1)) continue;
                    adjustable = false;
                    break;
                }
                if (adjustable) {
                    double dX = 0.0;
                    double dY = 0.0;
                    if (ai.getAngle() % 1800 == 0) {
                        dY = newPoint[1 - otherEnd].getY() - newPoint[otherEnd].getY();
                        newPoint[otherEnd] = new Point2D.Double(newPoint[otherEnd].getX(), newPoint[1 - otherEnd].getY());
                    } else {
                        dX = newPoint[1 - otherEnd].getX() - newPoint[otherEnd].getX();
                        newPoint[otherEnd] = new Point2D.Double(newPoint[1 - otherEnd].getX(), newPoint[otherEnd].getY());
                    }
                    ai.kill();
                    adjustThisNode.move(dX, dY);
                    ArcInst newAi2 = ArcInst.newInstance(ai.getProto(), ai.getWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], ai.getName(), 0);
                    if (newAi2 == null) {
                        newNi.kill();
                        return null;
                    }
                    newAi2.copyPropertiesFrom(ai);
                    continue;
                }
            }
            if (zigzag) {
                double cX = newPoint[0].getX();
                double cY = newPoint[1].getY();
                PrimitiveNode pinNp = ai.getProto().findOverridablePinProto();
                double psx = pinNp.getDefWidth();
                double psy = pinNp.getDefHeight();
                NodeInst pinNi = NodeInst.newInstance(pinNp, new Point2D.Double(cX, cY), psx, psy, this.getParent());
                PortInst pinPi = pinNi.getOnlyPortInst();
                newAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), newPortInst[1], pinPi, newPoint[1], new Point2D.Double(cX, cY), null, 0);
                if (newAi == null) {
                    return null;
                }
                newAi.copyPropertiesFrom(ai);
                ArcInst newAi2 = ArcInst.newInstance(ai.getProto(), ai.getWidth(), pinPi, newPortInst[0], new Point2D.Double(cX, cY), newPoint[0], null, 0);
                if (newAi2 == null) {
                    return null;
                }
                newAi2.copyConstraintsFrom(ai);
                if (newPortInst[0].getNodeInst() == this) {
                    ArcInst aiSwap = newAi;
                    newAi = newAi2;
                    newAi2 = aiSwap;
                }
            } else {
                newAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], null, 0);
                if (newAi == null) {
                    newNi.kill();
                    return null;
                }
                newAi.copyPropertiesFrom(ai);
            }
            ai.kill();
            newAi.setName(ai.getName());
        }
        ArrayList exportList = new ArrayList();
        Iterator it3 = this.getExports();
        while (it3.hasNext()) {
            exportList.add(it3.next());
        }
        it3 = exportList.iterator();
        while (it3.hasNext()) {
            int index3;
            Export pp = (Export)it3.next();
            for (index3 = 0; index3 < oldAssoc.length && oldAssoc[index3].portInst != pp.getOriginalPort(); ++index3) {
            }
            if (index3 >= oldAssoc.length || oldAssoc[index3].assn == null) continue;
            PortInst newPi = oldAssoc[index3].assn;
            pp.move(newPi);
        }
        newNi.copyVarsFrom(this);
        newNi.copyTextDescriptorFrom(this, NODE_NAME_TD);
        newNi.copyTextDescriptorFrom(this, NODE_PROTO_TD);
        newNi.copyStateBits(this);
        this.kill();
        newNi.setName(this.getName());
        return newNi;
    }

    public ImmutableNodeInst getD() {
        return this.d;
    }

    public boolean lowLevelLink() {
        if (!this.isDatabaseObject()) {
            System.out.println("NodeInst can't be linked because it is a dummy object");
            return true;
        }
        if (this.parent.addNode(this)) {
            return true;
        }
        this.parent.linkNode(this);
        return false;
    }

    public void lowLevelUnlink() {
        this.parent.removeNode(this);
        this.parent.unLinkNode(this);
        this.parent.checkInvariants();
    }

    public void lowLevelModify(ImmutableNodeInst d) {
        if (this.parent != null) {
            this.parent.unLinkNode(this);
        }
        this.d = d;
        this.redoGeometric();
        if (this.parent != null) {
            this.parent.linkNode(this);
            this.parent.setDirty();
        }
    }

    public boolean isIconOfParent() {
        return this.protoType instanceof Cell && ((Cell)this.protoType).isIconOf(this.parent);
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public final int getNodeIndex() {
        return this.nodeIndex;
    }

    public boolean isLinked() {
        try {
            return this.parent != null && this.parent.isLinked() && this.parent.getNode(this.nodeIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public ElectricObject getVarDefaultOwner() {
        if (this.getProto() instanceof Cell) {
            Cell proto = (Cell)this.getProto();
            if (proto.isIcon()) {
                Cell sch = proto.getCellGroup().getMainSchematics();
                if (sch != null) {
                    return sch;
                }
                return proto;
            }
            return proto;
        }
        return this;
    }

    public Orientation getOrient() {
        return this.d.orient;
    }

    public int getAngle() {
        return this.d.orient.getAngle();
    }

    public EPoint getAnchorCenter() {
        return this.d.anchor;
    }

    public double getAnchorCenterX() {
        return this.d.anchor.getX();
    }

    public double getAnchorCenterY() {
        return this.d.anchor.getY();
    }

    public double getXSize() {
        return this.protoType instanceof Cell ? this.protoType.getDefWidth() : this.d.width;
    }

    public double getYSize() {
        return this.protoType instanceof Cell ? this.protoType.getDefHeight() : this.d.height;
    }

    public boolean isMirroredAboutXAxis() {
        return this.isYMirrored();
    }

    public boolean isMirroredAboutYAxis() {
        return this.isXMirrored();
    }

    public boolean isXMirrored() {
        return this.d.orient.isXMirrored();
    }

    public boolean isYMirrored() {
        return this.d.orient.isYMirrored();
    }

    public Rectangle2D getBounds() {
        return this.visBounds;
    }

    public double[] getArcDegrees() {
        double[] returnValues = new double[2];
        returnValues[1] = 0.0;
        returnValues[0] = 0.0;
        if (!(this.protoType instanceof PrimitiveNode)) {
            return returnValues;
        }
        if (this.protoType != Artwork.tech.circleNode && this.protoType != Artwork.tech.thickCircleNode) {
            return returnValues;
        }
        Variable var = this.getVar(Artwork.ART_DEGREES);
        if (var != null) {
            Object addr = var.getObject();
            if (addr instanceof Integer) {
                Integer iAddr = (Integer)addr;
                returnValues[0] = 0.0;
                returnValues[1] = (double)iAddr.intValue() * Math.PI / 1800.0;
            } else if (addr instanceof Float[]) {
                Float[] fAddr = (Float[])addr;
                returnValues[0] = fAddr[0].doubleValue();
                returnValues[1] = fAddr[1].doubleValue();
            }
        }
        return returnValues;
    }

    public void setArcDegrees(double start, double curvature) {
        if (!(this.protoType instanceof PrimitiveNode)) {
            return;
        }
        if (this.protoType != Artwork.tech.circleNode && this.protoType != Artwork.tech.thickCircleNode) {
            return;
        }
        if (start == 0.0 && curvature == 0.0) {
            if (this.getVar(Artwork.ART_DEGREES) == null) {
                return;
            }
            this.delVar(Artwork.ART_DEGREES);
        } else {
            Float[] fAddr = new Float[]{new Float(start), new Float(curvature)};
            this.newVar(Artwork.ART_DEGREES, (Object)fAddr);
        }
    }

    public SizeOffset getSizeOffset() {
        Technology tech = this.protoType.getTechnology();
        return tech.getNodeInstSizeOffset(this);
    }

    private void redoGeometric() {
        this.visBounds = this.d.computeBounds(this);
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow_ wnd) {
        int totalText;
        int cellInstanceNameText = 0;
        if (this.protoType instanceof Cell && !this.isExpanded() && hardToSelect) {
            cellInstanceNameText = 1;
        }
        if (!User.isTextVisibilityOnInstance()) {
            cellInstanceNameText = 0;
        }
        int dispVars = this.numDisplayableVariables(false);
        int numExports = 0;
        int numExportVariables = 0;
        if (User.isTextVisibilityOnExport()) {
            numExports = this.getNumExports();
            Iterator it = this.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                numExportVariables += pp.numDisplayableVariables(false);
            }
        }
        if (this.protoType == Generic.tech.invisiblePinNode && !User.isTextVisibilityOnAnnotation()) {
            numExportVariables = 0;
            numExports = 0;
            dispVars = 0;
        }
        if (!User.isTextVisibilityOnNode()) {
            numExportVariables = 0;
            numExports = 0;
            dispVars = 0;
            cellInstanceNameText = 0;
        }
        if ((totalText = cellInstanceNameText + dispVars + numExports + numExportVariables) == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        int start = 0;
        if (cellInstanceNameText != 0) {
            double cX = this.getTrueCenterX();
            double cY = this.getTrueCenterY();
            ImmutableTextDescriptor td = this.getTextDescriptor(NODE_PROTO_TD);
            double offX = td.getXOff();
            double offY = td.getYOff();
            TextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            Point2D[] pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.getProto().describe(false));
            polys[start].setTextDescriptor(td);
            ++start;
        }
        if (numExports > 0) {
            AffineTransform unTrans = this.rotateIn();
            Iterator it = this.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                polys[start] = pp.getNamePoly();
                polys[start].transform(unTrans);
                Poly poly = pp.getOriginalPort().getPoly();
                int numadded = pp.addDisplayableVariables(poly.getBounds2D(), polys, ++start, wnd, false);
                for (int i = 0; i < numadded; ++i) {
                    polys[start + i].setPort(pp);
                }
                start += numadded;
            }
        }
        if (dispVars > 0) {
            this.addDisplayableVariables(this.getUntransformedBounds(), polys, start, wnd, false);
        }
        return polys;
    }

    public Rectangle2D getUntransformedBounds() {
        if (this.protoType instanceof PrimitiveNode) {
            SizeOffset so = this.getSizeOffset();
            double wid = this.getXSize();
            double hei = this.getYSize();
            double lx = this.getAnchorCenterX() - wid / 2.0;
            double hx = lx + wid;
            double ly = this.getAnchorCenterY() - hei / 2.0;
            double hy = ly + hei;
            Rectangle2D.Double ret = new Rectangle2D.Double(lx += so.getLowXOffset(), ly += so.getLowYOffset(), (hx -= so.getHighXOffset()) - lx, (hy -= so.getHighYOffset()) - ly);
            return ret;
        }
        Rectangle2D bounds = ((Cell)this.protoType).getBounds();
        Rectangle2D.Double ret = new Rectangle2D.Double(bounds.getMinX() + this.getAnchorCenterX(), bounds.getMinY() + this.getAnchorCenterY(), bounds.getWidth(), bounds.getHeight());
        return ret;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        int numVarsOnNode = super.numDisplayableVariables(multipleStrings);
        Iterator it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            numVarsOnNode += pi.numDisplayableVariables(multipleStrings);
        }
        return numVarsOnNode;
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow_ wnd, boolean multipleStrings) {
        int numAddedVariables = super.addDisplayableVariables(rect, polys, start, wnd, multipleStrings);
        Iterator it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            int justAdded = pi.addDisplayableVariables(rect, polys, start + numAddedVariables, wnd, multipleStrings);
            for (int i = 0; i < justAdded; ++i) {
                polys[start + numAddedVariables + i].setPort(pi.getPortProto());
            }
            numAddedVariables += justAdded;
        }
        return numAddedVariables;
    }

    public AffineTransform transformOut() {
        return this.d.orient.rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY(), 0.0, 0.0);
    }

    public AffineTransform transformOut(AffineTransform prevTransform) {
        AffineTransform transform = this.transformOut();
        transform.preConcatenate(prevTransform);
        return transform;
    }

    public AffineTransform transformIn() {
        return this.d.orient.inverse().rotateAbout(0.0, 0.0, -this.getAnchorCenterX(), -this.getAnchorCenterY());
    }

    public AffineTransform translateIn() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(-dx, -dy);
        return transform;
    }

    public AffineTransform translateIn(AffineTransform prevTransform) {
        AffineTransform transform = this.translateIn();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform translateOut() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(dx, dy);
        return transform;
    }

    public AffineTransform translateOut(AffineTransform prevTransform) {
        AffineTransform transform = this.translateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform pureRotateOut() {
        return this.d.orient.pureRotate();
    }

    public AffineTransform pureRotateIn() {
        return this.d.orient.inverse().pureRotate();
    }

    public AffineTransform rotateIn() {
        return this.d.orient.inverse().rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY());
    }

    public AffineTransform rotateIn(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateIn();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform rotateOut() {
        return this.d.orient.rotateAbout(this.getAnchorCenterX(), this.getAnchorCenterY());
    }

    public AffineTransform rotateOutAboutTrueCenter() {
        return this.d.orient.rotateAbout(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public AffineTransform rotateOut(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform rotateOutAboutTrueCenter(AffineTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOutAboutTrueCenter();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public Poly getShapeOfPort(PortProto thePort) {
        return this.getShapeOfPort(thePort, null, false, -1.0);
    }

    public Poly getShapeOfPort(PortProto thePort, Point2D selectPt, boolean forWiringTool, double arcWidth) {
        PortOriginal fp = new PortOriginal(this, thePort);
        AffineTransform trans = fp.getTransformToTop();
        NodeInst ni = fp.getBottomNodeInst();
        PrimitivePort pp = fp.getBottomPortProto();
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(ni, pp, selectPt);
        Rectangle2D box = poly.getBox();
        if (forWiringTool && box != null) {
            if (arcWidth != -1.0 && np.getFunction() == PrimitiveNode.Function.CONTACT) {
                SizeOffset so = np.getProtoSizeOffset();
                double width = ni.getXSize() - so.getHighXOffset() - so.getLowXOffset();
                double height = ni.getYSize() - so.getHighYOffset() - so.getLowYOffset();
                double newportwidth = width - arcWidth;
                double newportheight = height - arcWidth;
                if (newportwidth < 0.0) {
                    newportwidth = 0.0;
                }
                if (newportheight < 0.0) {
                    newportheight = 0.0;
                }
                double offsetX = 0.0;
                double offsetY = 0.0;
                if (newportwidth < box.getWidth()) {
                    offsetX = 0.5 * (newportwidth - box.getWidth());
                    box = new Rectangle2D.Double(box.getX() - offsetX, box.getY(), box.getWidth() + 2.0 * offsetX, box.getHeight());
                }
                if (newportheight < box.getHeight()) {
                    offsetY = 0.5 * (newportheight - box.getHeight());
                    box = new Rectangle2D.Double(box.getX(), box.getY() - offsetY, box.getWidth(), box.getHeight() + 2.0 * offsetY);
                }
            }
            if (ni.getXSize() == np.getDefWidth()) {
                double x = poly.getCenterX();
                box = new Rectangle2D.Double(x, box.getMinY(), 0.0, box.getHeight());
            }
            if (ni.getYSize() == np.getDefHeight()) {
                double y = poly.getCenterY();
                box = new Rectangle2D.Double(box.getMinX(), y, box.getWidth(), 0.0);
            }
            poly = new Poly(box);
        }
        poly.transform(trans);
        return poly;
    }

    public Point2D[] getTrace() {
        Variable var = this.getVar(TRACE, Point2D;.class);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Object[]) {
            return (Point2D[])obj;
        }
        return null;
    }

    public void setTrace(Point2D[] points) {
        double lY;
        double lX;
        double hX = lX = points[0].getX();
        double hY = lY = points[0].getY();
        for (int i = 1; i < points.length; ++i) {
            double y;
            double x = points[i].getX();
            if (x < lX) {
                lX = x;
            }
            if (x > hX) {
                hX = x;
            }
            if ((y = points[i].getY()) < lY) {
                lY = y;
            }
            if (!(y > hY)) continue;
            hY = y;
        }
        double newCX = (lX + hX) / 2.0;
        double newCY = (lY + hY) / 2.0;
        double newSX = hX - lX;
        double newSY = hY - lY;
        EPoint[] newPoints = new EPoint[points.length];
        for (int i = 0; i < newPoints.length; ++i) {
            newPoints[i] = new EPoint(points[i].getX() - newCX, points[i].getY() - newCY);
        }
        this.newVar(TRACE, (Object)newPoints);
        this.modifyInstance(newCX - this.getAnchorCenterX(), newCY - this.getAnchorCenterY(), newSX - this.getXSize(), newSY - this.getYSize(), this.getOrient().inverse());
    }

    public boolean traceWraps() {
        if (this.protoType == Artwork.tech.splineNode || this.protoType == Artwork.tech.openedPolygonNode || this.protoType == Artwork.tech.openedDottedPolygonNode || this.protoType == Artwork.tech.openedDashedPolygonNode || this.protoType == Artwork.tech.openedThickerPolygonNode) {
            return false;
        }
        return !this.isFET();
    }

    public Iterator getPortInsts() {
        return ArrayIterator.iterator(this.portInsts);
    }

    public int getNumPortInsts() {
        return this.portInsts.length;
    }

    public PortInst getPortInst(int portIndex) {
        return this.portInsts[portIndex];
    }

    public PortInst getOnlyPortInst() {
        int sz = this.portInsts.length;
        if (sz != 1) {
            System.out.println("NodeInst.getOnlyPortInst: " + this.parent + ", " + this + " doesn't have just one port, it has " + sz);
            return null;
        }
        return this.portInsts[0];
    }

    public PortInst findPortInst(String name) {
        PortProto pp = this.protoType.findPortProto(name);
        if (pp == null) {
            return null;
        }
        return this.portInsts[pp.getPortIndex()];
    }

    public PortInst findClosestPortInst(Point2D w) {
        double bestDist = Double.MAX_VALUE;
        PortInst bestPi = null;
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortInst pi = this.portInsts[i];
            Poly piPoly = pi.getPoly();
            Point2D.Double piPt = new Point2D.Double(piPoly.getCenterX(), piPoly.getCenterY());
            double thisDist = piPt.distance(w);
            if (!(thisDist < bestDist)) continue;
            bestDist = thisDist;
            bestPi = pi;
        }
        return bestPi;
    }

    public PortInst findPortInstFromProto(PortProto pp) {
        return this.portInsts[pp.getPortIndex()];
    }

    public void addPortInst(PortProto pp) {
        this.linkPortInst(PortInst.newInstance(pp, this));
    }

    public void linkPortInst(PortInst pi) {
        int portIndex = pi.getPortIndex();
        PortInst[] newPortInsts = new PortInst[this.portInsts.length + 1];
        System.arraycopy(this.portInsts, 0, newPortInsts, 0, portIndex);
        newPortInsts[portIndex] = pi;
        System.arraycopy(this.portInsts, portIndex, newPortInsts, portIndex + 1, this.portInsts.length - portIndex);
        this.portInsts = newPortInsts;
    }

    public void movePortInst(int oldPortIndex) {
        Connection con;
        PortInst pi = this.portInsts[oldPortIndex];
        int portIndex = pi.getPortIndex();
        if (portIndex == oldPortIndex) {
            return;
        }
        if (portIndex > oldPortIndex) {
            System.arraycopy(this.portInsts, oldPortIndex + 1, this.portInsts, oldPortIndex, portIndex - oldPortIndex);
        } else {
            System.arraycopy(this.portInsts, portIndex, this.portInsts, portIndex + 1, oldPortIndex - portIndex);
        }
        this.portInsts[portIndex] = pi;
        ArrayList<Connection> savedConnections = new ArrayList<Connection>();
        Iterator it = this.connections.iterator();
        while (it.hasNext()) {
            con = (Connection)it.next();
            if (con.getPortInst() != pi) continue;
            savedConnections.add(con);
            it.remove();
        }
        for (int i = 0; i < savedConnections.size(); ++i) {
            con = (Connection)savedConnections.get(i);
            this.addConnection(con);
        }
        this.check();
    }

    public PortInst removePortInst(PortProto pp) {
        int portIndex = pp.getPortIndex();
        PortInst pi = this.portInsts[portIndex];
        PortInst[] newPortInsts = this.portInsts.length > 1 ? new PortInst[this.portInsts.length - 1] : NULL_PORT_INST_ARRAY;
        System.arraycopy(this.portInsts, 0, newPortInsts, 0, portIndex);
        System.arraycopy(this.portInsts, portIndex + 1, newPortInsts, portIndex, newPortInsts.length - portIndex);
        this.portInsts = newPortInsts;
        return pi;
    }

    public Cell getProtoEquivalent() {
        if (!(this.protoType instanceof Cell)) {
            return null;
        }
        return ((Cell)this.protoType).getEquivalent();
    }

    public void addExport(Export e) {
        Export[] newExports = new Export[this.exports.length + 1];
        System.arraycopy(this.exports, 0, newExports, 0, this.exports.length);
        newExports[newExports.length - 1] = e;
        this.exports = newExports;
        this.redoGeometric();
    }

    public void removeExport(Export e) {
        int i;
        for (i = 0; i < this.exports.length && this.exports[i] != e; ++i) {
        }
        if (i >= this.exports.length) {
            throw new RuntimeException("Tried to remove a non-existant export");
        }
        Export[] newExports = this.exports.length > 1 ? new Export[this.exports.length - 1] : NULL_EXPORT_ARRAY;
        System.arraycopy(this.exports, 0, newExports, 0, i);
        System.arraycopy(this.exports, i + 1, newExports, i, newExports.length - i);
        this.exports = newExports;
        this.redoGeometric();
    }

    public Iterator getExports() {
        return ArrayIterator.iterator(this.exports);
    }

    public int getNumExports() {
        return this.exports.length;
    }

    private PortAssociation[] portAssociate(NodeInst ni1, NodeInst ni2, boolean ignorePortNames) {
        int total1 = ni1.getProto().getNumPorts();
        PortAssociation[] portInfo1 = new PortAssociation[total1];
        int k = 0;
        Iterator it1 = ni1.getPortInsts();
        while (it1.hasNext()) {
            PortInst pi1 = (PortInst)it1.next();
            portInfo1[k] = new PortAssociation();
            portInfo1[k].portInst = pi1;
            portInfo1[k].poly = pi1.getPoly();
            portInfo1[k].pos = new Point2D.Double(portInfo1[k].poly.getCenterX(), portInfo1[k].poly.getCenterY());
            portInfo1[k].assn = null;
            ++k;
        }
        int total2 = ni2.getProto().getNumPorts();
        PortAssociation[] portInfo2 = new PortAssociation[total2];
        k = 0;
        Iterator it2 = ni2.getPortInsts();
        while (it2.hasNext()) {
            PortInst pi2 = (PortInst)it2.next();
            portInfo2[k] = new PortAssociation();
            portInfo2[k].portInst = pi2;
            portInfo2[k].poly = pi2.getPoly();
            portInfo2[k].pos = new Point2D.Double(portInfo2[k].poly.getCenterX(), portInfo2[k].poly.getCenterY());
            portInfo2[k].assn = null;
            ++k;
        }
        if (!ignorePortNames) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || !pi2.getPortProto().getName().equalsIgnoreCase(pi1.getPortProto().getName())) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                if (portInfo1[i1].assn != null) continue;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || pass == 0 && !portInfo1[i1].poly.polySame(portInfo2[i2].poly)) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        return portInfo1;
    }

    public void computeWipeState() {
        this.wiped = false;
        NodeProto np = this.getProto();
        if (np instanceof PrimitiveNode && ((PrimitiveNode)np).isArcsWipe()) {
            Iterator it = this.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                if (!ai.getProto().isWipable()) continue;
                this.wiped = true;
                break;
            }
        }
    }

    public boolean pinUseCount() {
        if (this.connections.size() > 2) {
            return false;
        }
        if (this.getNumExports() != 0) {
            return true;
        }
        return this.connections.size() != 0;
    }

    public boolean isInlinePin() {
        if (this.protoType.getFunction() != PrimitiveNode.Function.PIN) {
            return false;
        }
        int j = 0;
        ArcInst[] reconAr = new ArcInst[2];
        Point2D.Double[] delta = new Point2D.Double[2];
        Iterator it = this.getConnections();
        while (it.hasNext()) {
            ArcInst ai;
            Connection con = (Connection)it.next();
            if (j >= 2) {
                j = 0;
                break;
            }
            reconAr[j] = ai = con.getArc();
            EPoint thisLocation = con.getLocation();
            EPoint thatLocation = ai.getLocation(1 - con.getEndIndex());
            delta[j] = new Point2D.Double(thatLocation.getX() - thisLocation.getX(), thatLocation.getY() - thisLocation.getY());
            ++j;
        }
        if (j != 2) {
            return false;
        }
        if (reconAr[0].getProto() != reconAr[1].getProto()) {
            return false;
        }
        if (reconAr[0].getWidth() != reconAr[1].getWidth()) {
            return false;
        }
        if (((Point2D)delta[0]).getX() != 0.0 || ((Point2D)delta[0]).getY() != 0.0 || ((Point2D)delta[1]).getX() != 0.0 || ((Point2D)delta[1]).getY() != 0.0) {
            Point2D.Double zero = new Point2D.Double(0.0, 0.0);
            if (!(((Point2D)delta[0]).getX() == 0.0 && ((Point2D)delta[0]).getY() == 0.0 || ((Point2D)delta[1]).getX() == 0.0 && ((Point2D)delta[1]).getY() == 0.0 || DBMath.figureAngle(zero, delta[0]) == DBMath.figureAngle(delta[1], zero))) {
                return false;
            }
        }
        if (reconAr[0].getVar(ArcInst.ARC_RADIUS) != null) {
            return false;
        }
        if (reconAr[1].getVar(ArcInst.ARC_RADIUS) != null) {
            return false;
        }
        Name name0 = reconAr[0].getNameKey();
        Name name1 = reconAr[1].getNameKey();
        return name0 == null || name1 == null || name0.isTempname() || name1.isTempname();
    }

    public PortProto connectsTo(ArcProto arc) {
        int numPorts = this.protoType.getNumPorts();
        for (int i = 0; i < numPorts; ++i) {
            PortProto pp = this.protoType.getPort(i);
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public void addConnection(Connection c) {
        PortInst pi = c.getPortInst();
        if (!$assertionsDisabled && pi.getNodeInst() != this) {
            throw new AssertionError();
        }
        int portIndex = pi.getPortIndex();
        int pos = this.searchConnections(portIndex + 1);
        this.connections.add(pos, c);
        this.computeWipeState();
        this.redoGeometric();
    }

    public void removeConnection(Connection c) {
        PortInst pi = c.getPortInst();
        if (!$assertionsDisabled && pi.getNodeInst() != this) {
            throw new AssertionError();
        }
        int portIndex = pi.getPortIndex();
        int pos = this.searchConnections(portIndex);
        while (!c.equals(this.connections.get(pos))) {
            ++pos;
        }
        this.connections.remove(pos);
        this.check();
        this.computeWipeState();
        this.redoGeometric();
    }

    public Iterator getConnections() {
        return this.connections.iterator();
    }

    Iterator getConnections(int portIndex) {
        return this.connections.listIterator(this.searchConnections(portIndex));
    }

    public int getNumConnections() {
        return this.connections.size();
    }

    private int searchConnections(int portIndex) {
        int low = 0;
        int high = this.connections.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Connection con = (Connection)this.connections.get(mid);
            if (con.getPortInst().getPortIndex() < portIndex) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    public Name getNameKey() {
        return this.d.name;
    }

    public void lowLevelRename(Name name, int duplicate) {
        this.parent.removeNodeName(this);
        this.d = this.d.withName(name, this.parent.fixupNodeDuplicate(name, duplicate));
        this.parent.addNodeName(this);
        this.parent.checkInvariants();
    }

    public int getDuplicate() {
        return this.d.duplicate;
    }

    public ImmutableTextDescriptor getTextDescriptor(String varName) {
        if (varName == NODE_NAME_TD) {
            return this.d.nameDescriptor;
        }
        if (varName == NODE_PROTO_TD) {
            return this.d.protoDescriptor;
        }
        return super.getTextDescriptor(varName);
    }

    public ImmutableTextDescriptor lowLevelSetTextDescriptor(String varName, ImmutableTextDescriptor td) {
        if (varName == NODE_NAME_TD) {
            ImmutableTextDescriptor oldDescriptor = this.d.nameDescriptor;
            this.d = this.d.withNameDescriptor(td.withDisplayWithoutParamAndCode());
            return oldDescriptor;
        }
        if (varName == NODE_PROTO_TD) {
            ImmutableTextDescriptor oldDescriptor = this.d.protoDescriptor;
            this.d = this.d.withProtoDescriptor(td.withDisplayWithoutParamAndCode());
            return oldDescriptor;
        }
        return super.lowLevelSetTextDescriptor(varName, td);
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == NODE_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
        if (key == TRACE && this.protoType instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)this.protoType;
            if (pn.isHoldsOutline() && this.getTrace() != null) {
                Poly[] polys = pn.getTechnology().getShapeOfNode(this);
                Rectangle2D.Double bounds = new Rectangle2D.Double();
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (i == 0) {
                        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
                        continue;
                    }
                    Rectangle2D.union(poly.getBounds2D(), bounds, bounds);
                }
                this.lowLevelModify(this.d.withSize(((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight()));
            }
        } else if (key == Artwork.ART_DEGREES) {
            this.lowLevelModify(this.d);
        }
    }

    public boolean isInvisiblePinWithText() {
        if (this.getProto() != Generic.tech.invisiblePinNode) {
            return false;
        }
        if (this.getNumExports() != 0) {
            return true;
        }
        return this.numDisplayableVariables(false) != 0;
    }

    public Point2D invisiblePinWithOffsetText(boolean repair) {
        Poly.Type style;
        Technology tech;
        Poly[] polyList;
        if (this.protoType.getFunction() != PrimitiveNode.Function.PIN) {
            return null;
        }
        if (this.getNumConnections() != 0) {
            return null;
        }
        if (this.protoType != Generic.tech.invisiblePinNode && (polyList = (tech = this.protoType.getTechnology()).getShapeOfNode(this)).length > 0 && !(style = polyList[0].getStyle()).isText()) {
            return null;
        }
        Iterator it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            ImmutableTextDescriptor td = pp.getTextDescriptor(Export.EXPORT_NAME_TD);
            if (td.getXOff() == 0.0 && td.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + td.getXOff(), this.getAnchorCenterY() + td.getYOff());
            if (repair) {
                pp.setOff(Export.EXPORT_NAME_TD, 0.0, 0.0);
            }
            return retVal;
        }
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay() || var.getXOff() == 0.0 && var.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + var.getXOff(), this.getAnchorCenterY() + var.getYOff());
            if (repair) {
                var.setOff(0.0, 0.0);
            }
            return retVal;
        }
        return null;
    }

    public String describe(boolean withQuotes) {
        String name;
        String description = this.protoType.describe(false);
        String string = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    public int compareTo(Object obj) {
        int cmp;
        NodeInst that = (NodeInst)obj;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.d.duplicate - that.d.duplicate;
    }

    public String toString() {
        if (this.protoType == null) {
            return "NodeInst no protoType";
        }
        return "node " + this.describe(true);
    }

    public NodeProto getProto() {
        return this.protoType;
    }

    public int getNumActualProtos() {
        return 1;
    }

    public NodeProto getActualProto(int i) {
        return i == 0 ? this.protoType : null;
    }

    public boolean contains(NodeInst ni, int arrayIndex) {
        return ni == this && arrayIndex == 0;
    }

    public NodeInst getNodeInst() {
        return this;
    }

    public PrimitiveNode.Function getFunction() {
        if (this.protoType instanceof Cell) {
            return PrimitiveNode.Function.UNKNOWN;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getPrimitiveFunction(np, this.getTechSpecific());
    }

    public boolean isPrimitiveTransistor() {
        PrimitiveNode.Function func = this.protoType.getFunction();
        return func == PrimitiveNode.Function.TRANS || func == PrimitiveNode.Function.TRANS4 || func == PrimitiveNode.Function.TRANMOS || func == PrimitiveNode.Function.TRAPMOS;
    }

    public boolean isPrimtiveSubstrateNode() {
        if (this.getFunction() != PrimitiveNode.Function.NODE) {
            return false;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        if (np.getLayers().length != 1) {
            return false;
        }
        return np.getLayers()[0].getLayer().getFunction().isSubstrate();
    }

    public boolean isSerpentineTransistor() {
        if (!this.isPrimitiveTransistor()) {
            return false;
        }
        PrimitiveNode pn = (PrimitiveNode)this.getProto();
        return pn.isHoldsOutline() && this.getTrace() != null;
    }

    public boolean isFET() {
        PrimitiveNode.Function fun = this.getFunction();
        return fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || fun == PrimitiveNode.Function.TRANJFET || fun == PrimitiveNode.Function.TRA4NJFET || fun == PrimitiveNode.Function.TRAPJFET || fun == PrimitiveNode.Function.TRA4PJFET || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES || fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES;
    }

    public boolean isBipolar() {
        PrimitiveNode.Function fun = this.getFunction();
        return fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4PNP;
    }

    public PrimitiveNodeSize getPrimitiveNodeSize(VarContext context) {
        PrimitiveNodeSize size = this.getTransistorSize(context);
        if (size == null) {
            size = this.getResistorSize(context);
        }
        return size;
    }

    private PrimitiveNodeSize getResistorSize(VarContext context) {
        if (!this.getFunction().isResistor()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getResistorSize(this, context);
    }

    public TransistorSize getTransistorSize(VarContext context) {
        if (!this.isPrimitiveTransistor() || !this.isFET()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSize(this, context);
    }

    public void setPrimitiveNodeSize(double width, double length) {
        if (!(this.isPrimitiveTransistor() || this.isFET() || this.getFunction().isResistor())) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        Job.checkChanging();
        np.getTechnology().setPrimitiveNodeSize(this, width, length);
    }

    public void setPrimitiveNodeSize(Object width, Object length) {
        Technology tech = this.protoType.getTechnology();
        if (tech != Schematics.tech) {
            return;
        }
        Job.checkChanging();
        Schematics.tech.setPrimitiveNodeSize(this, width, length);
    }

    public double getSerpentineTransistorLength() {
        Variable var = this.getVar(TRANSISTOR_LENGTH_KEY);
        if (var == null) {
            return -1.0;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return (Integer)obj / 120;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return TextUtils.atof((String)obj);
        }
        return -1.0;
    }

    public void setSerpentineTransistorLength(double length) {
        this.updateVar(TRANSISTOR_LENGTH_KEY, (Object)new Double(length));
    }

    public PortInst getTransistorGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorGatePort(this);
    }

    public PortInst getTransistorSourcePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSourcePort(this);
    }

    public PortInst getTransistorEmitterPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorEmitterPort(this);
    }

    public PortInst getTransistorBasePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBasePort(this);
    }

    public PortInst getTransistorCollectorPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorCollectorPort(this);
    }

    public PortInst getTransistorBiasPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBiasPort(this);
    }

    public PortInst getTransistorDrainPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorDrainPort(this);
    }

    public int checkAndRepair(boolean repair, List list, ErrorLogger errorLogger) {
        ErrorLogger.MessageLog error;
        String msg;
        int errorCount = 0;
        double width = this.getXSize();
        double height = this.getYSize();
        String sizeMsg = null;
        if (this.protoType instanceof Cell) {
            return 0;
        }
        PrimitiveNode pn = (PrimitiveNode)this.protoType;
        if (pn.getTechnology().cleanUnusedNodesInLibrary(this, list)) {
            if (errorLogger != null) {
                msg = "Prototype of node " + this.getName() + " is unused";
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
            }
            if (list != null) {
                if (repair) {
                    list.add(this);
                }
                return 1;
            }
        }
        if (this.getTrace() != null) {
            if (pn.isHoldsOutline()) {
                Rectangle2D.Double bounds = new Rectangle2D.Double();
                Poly[] polys = pn.getTechnology().getShapeOfNode(this);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (i == 0) {
                        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
                        continue;
                    }
                    Rectangle2D.union(poly.getBounds2D(), bounds, bounds);
                }
                width = DBMath.round(((RectangularShape)bounds).getWidth());
                height = DBMath.round(((RectangularShape)bounds).getHeight());
                if (width != this.getXSize() || height != this.getYSize()) {
                    sizeMsg = " but has outline of size ";
                }
            } else {
                msg = this.parent + ", " + this + " has unexpected outline";
                System.out.println(msg);
                if (errorLogger != null) {
                    error = errorLogger.logError(msg, this.parent, 1);
                    error.addGeom(this, true, this.parent, null);
                }
                if (repair) {
                    this.delVar(TRACE);
                }
            }
        }
        if (sizeMsg != null) {
            sizeMsg = this.parent + ", " + this + " is " + this.getXSize() + "x" + this.getYSize() + sizeMsg + width + "x" + height;
            if (repair) {
                this.checkChanging();
                sizeMsg = sizeMsg + " (REPAIRED)";
            }
            System.out.println(sizeMsg);
            if (errorLogger != null) {
                ErrorLogger.MessageLog error2 = errorLogger.logWarning(sizeMsg, this.parent, 1);
                error2.addGeom(this, true, this.parent, null);
            }
            if (repair) {
                this.d = this.d.withSize(width, height);
                this.redoGeometric();
            }
        }
        return errorCount;
    }

    public void check() {
        if (!$assertionsDisabled && this.d.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.d.duplicate < 0) {
            throw new AssertionError();
        }
        if (this.protoType instanceof Cell) {
            int foundUsage = 0;
            Iterator it = ((Cell)this.protoType).getUsagesOf();
            while (it.hasNext()) {
                CellUsage u = (CellUsage)it.next();
                if (u.parentId != this.parent.getId()) continue;
                ++foundUsage;
            }
            if (!$assertionsDisabled && foundUsage != 1) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.portInsts == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.portInsts.length != this.protoType.getNumPorts()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.portInsts.length; ++i) {
            PortProto pp = this.protoType.getPort(i);
            if (!$assertionsDisabled && pp.getPortIndex() != i) {
                throw new AssertionError();
            }
            PortInst pi = this.portInsts[i];
            if (!$assertionsDisabled && pi.getPortProto() != pp) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.exports == null) {
            throw new AssertionError();
        }
        int lastPortIndex = -1;
        for (int i = 0; i < this.connections.size(); ++i) {
            Connection con = (Connection)this.connections.get(i);
            PortInst pi = con.getPortInst();
            if (!$assertionsDisabled && pi.getNodeInst() != this) {
                throw new AssertionError();
            }
            int portIndex = pi.getPortIndex();
            if (!$assertionsDisabled && lastPortIndex > portIndex) {
                throw new AssertionError();
            }
            lastPortIndex = portIndex;
        }
        if (!$assertionsDisabled && lastPortIndex >= this.portInsts.length) {
            throw new AssertionError();
        }
    }

    public Name getBasename() {
        return this.protoType instanceof Cell ? ((Cell)this.protoType).getBasename() : this.getFunction().getBasename();
    }

    public void copyStateBits(NodeInst ni) {
        this.checkChanging();
        this.d = this.d.withFlags(ni.d.flags).withTechSpecific(ni.d.techBits);
        Undo.otherChange(this);
    }

    private void setFlag(ImmutableNodeInst.Flag flag, boolean value) {
        this.checkChanging();
        this.d = this.d.withFlag(flag, value);
        Undo.otherChange(this);
    }

    public void setExpanded(boolean value) {
        if (value != this.expanded && this.parent != null) {
            this.parent.expandStatusChanged();
        }
        this.expanded = value;
    }

    public void setExpanded() {
        this.setExpanded(true);
    }

    public void clearExpanded() {
        this.setExpanded(false);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isWiped() {
        return this.wiped;
    }

    public void setHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, true);
    }

    public void clearHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, false);
    }

    public boolean isHardSelect() {
        return this.d.is(ImmutableNodeInst.HARD_SELECT);
    }

    public void setVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, true);
    }

    public void clearVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, false);
    }

    public boolean isVisInside() {
        return this.d.is(ImmutableNodeInst.VIS_INSIDE);
    }

    public void setLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, true);
    }

    public void clearLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, false);
    }

    public boolean isLocked() {
        return this.d.is(ImmutableNodeInst.LOCKED);
    }

    public void setTechSpecific(int value) {
        this.checkChanging();
        this.d = this.d.withTechSpecific(value);
        if (this.parent != null) {
            Undo.otherChange(this);
        }
    }

    public int getTechSpecific() {
        return this.d.techBits;
    }

    public Rectangle2D findEssentialBounds() {
        NodeProto np = this.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        Rectangle2D eb = ((Cell)np).findEssentialBounds();
        if (eb == null) {
            return null;
        }
        AffineTransform xForm = this.translateOut();
        Point2D ll = new Point2D.Double(eb.getMinX(), eb.getMinY());
        ll = xForm.transform(ll, null);
        Point2D ur = new Point2D.Double(eb.getMaxX(), eb.getMaxY());
        ur = xForm.transform(ur, null);
        double minX = Math.min(ll.getX(), ur.getX());
        double minY = Math.min(ll.getY(), ur.getY());
        double maxX = Math.max(ll.getX(), ur.getX());
        double maxY = Math.max(ll.getY(), ur.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Object p;
        Iterator i;
        boolean found;
        Poly[] noPolyList;
        PrimitiveNode.Function noFunc;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInst no = (NodeInst)obj;
        if (this.getFunction() != no.getFunction()) {
            if (buffer != null) {
                buffer.append("Functions are not the same for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        NodeProto noProtoType = no.getProto();
        NodeProto protoType = this.getProto();
        if (protoType.getClass() != noProtoType.getClass()) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (!this.rotateOut().equals(no.rotateOut())) {
            if (buffer != null) {
                buffer.append("Not the same rotation for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (protoType instanceof Cell) {
            return noProtoType instanceof Cell;
        }
        PrimitiveNode np = (PrimitiveNode)protoType;
        PrimitiveNode noNp = (PrimitiveNode)noProtoType;
        PrimitiveNode.Function function = this.getFunction();
        if (function != (noFunc = no.getFunction())) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "':" + function.getName() + " v/s " + noFunc.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = np.getTechnology().getShapeOfNode(this);
        if (polyList.length != (noPolyList = noNp.getTechnology().getShapeOfNode(no)).length) {
            if (buffer != null) {
                buffer.append("Not same number of geometries in '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        ArrayList<Object> noCheckAgain = new ArrayList<Object>();
        for (int i2 = 0; i2 < polyList.length; ++i2) {
            found = false;
            for (int j = 0; j < noPolyList.length; ++j) {
                if (noCheckAgain.contains(noPolyList[j]) || !polyList[i2].compare(noPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(noPolyList[j]);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding geometry in '" + this.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        Iterator it = this.getPortInsts();
        while (it.hasNext()) {
            found = false;
            PortInst port = (PortInst)it.next();
            i = no.getPortInsts();
            while (i.hasNext()) {
                p = (PortInst)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port '" + port.getPortProto().getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getExports();
        while (it.hasNext()) {
            Export export = (Export)it.next();
            boolean found2 = false;
            i = no.getExports();
            while (i.hasNext()) {
                p = (Export)i.next();
                if (noCheckAgain.contains(p) || !export.compare(p, buffer)) continue;
                found2 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding export '" + export.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found3 = false;
            i = no.getVariables();
            while (i.hasNext()) {
                p = (Variable)i.next();
                if (noCheckAgain.contains(p) || !var.compare(p, buffer)) continue;
                found3 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found3) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + var + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !NodeInst.class.desiredAssertionStatus();
        NODE_PROTO_TD = new String("NODE_proto");
        NODE_NAME_TD = new String("NODE_name");
        NODE_NAME = Variable.newKey("NODE_name");
        TRACE = Variable.newKey("trace");
        TRANSISTOR_LENGTH_KEY = Variable.newKey("transistor_width");
        NULL_PORT_INST_ARRAY = new PortInst[0];
        NULL_EXPORT_ARRAY = new Export[0];
    }

    private static class PortAssociation {
        PortInst portInst;
        Poly poly;
        Point2D pos;
        PortInst assn;

        private PortAssociation() {
        }
    }
}

