/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.User;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkTool
extends Tool {
    private static final NetworkTool tool = new NetworkTool();
    static boolean networksValid = false;
    static Object mutex = new Object();
    static boolean debug = false;
    static boolean showInfo = true;
    public static int totalNumErrors = 0;
    static final int errorSortNetworks = 0;
    static final int errorSortNodes = 1;
    static final int errorSortPorts = 2;
    private Setting cacheIgnoreResistors;
    private static final boolean BUS_ASCENDING_DEFAULT = false;
    private static Pref cacheBusAscending = Pref.makeBooleanPref("BusAscending", NetworkTool.tool.prefs, false);

    public static void renumberNetlists() {
        new RenumberJob();
    }

    public NetworkTool() {
        super("network");
    }

    public static NetworkTool getNetworkTool() {
        return tool;
    }

    public static void setInformationOutput(boolean infoOutput) {
        showInfo = infoOutput;
    }

    public static Netlist acquireUserNetlist(Cell cell) {
        Netlist netlist = null;
        try {
            netlist = NetworkTool.getNetlist(cell, NetworkTool.isIgnoreResistors_());
        }
        catch (NetlistNotReady netlistNotReady) {
            // empty catch block
        }
        return netlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Netlist getUserNetlist(Cell cell) {
        EDatabase database = cell.getDatabase();
        NetworkManager mgr = database.getNetworkManager();
        if (database.canComputeNetlist()) {
            mgr.advanceSnapshot();
            NetCell netCell = mgr.getNetCell(cell);
            return netCell.getNetlist(NetworkTool.isIgnoreResistors_());
        }
        if (Job.getDebug() && SwingUtilities.isEventDispatchThread()) {
            System.out.println("getUserNetlist() used in GUI thread");
        }
        Netlist.ShortResistors shortResistors = NetworkTool.isIgnoreResistors_();
        Object object = mutex;
        synchronized (object) {
            while (!networksValid) {
                try {
                    System.out.println("Waiting for User Netlist...");
                    mutex.wait(1000L);
                    if (networksValid) continue;
                    throw new NetlistNotReady();
                }
                catch (InterruptedException e) {
                }
                catch (NetlistNotReady e) {
                    e.printStackTrace(System.err);
                }
            }
            NetCell netCell = mgr.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Netlist getNetlist(Cell cell, Netlist.ShortResistors shortResistors) {
        EDatabase database = cell.getDatabase();
        NetworkManager mgr = database.getNetworkManager();
        if (database.canComputeNetlist()) {
            if (!cell.isLinked()) {
                return null;
            }
            mgr.advanceSnapshot();
            NetCell netCell = mgr.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
        Object object = mutex;
        synchronized (object) {
            if (!networksValid) {
                throw new NetlistNotReady();
            }
            NetCell netCell = mgr.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
    }

    public static Set<Network> getNetworksOnPort(PortInst pi, Netlist netlist, Set<Network> nets) {
        boolean added = false;
        if (nets == null) {
            nets = new HashSet<Network>();
        }
        Iterator<Connection> aIt = pi.getConnections();
        while (aIt.hasNext()) {
            Connection con = aIt.next();
            ArcInst ai = con.getArc();
            int wid = netlist.getBusWidth(ai);
            for (int i = 0; i < wid; ++i) {
                Network net = netlist.getNetwork(ai, i);
                if (net == null) continue;
                added = true;
                nets.add(net);
            }
        }
        if (!added) {
            NodeInst ni = pi.getNodeInst();
            HashSet<PortInst> ports = new HashSet<PortInst>();
            ports.add(pi);
            Iterator<ElectricObject> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst otherpi = it.next();
                if (otherpi == pi || !netlist.sameNetwork(ni, pi.getPortProto(), ni, otherpi.getPortProto())) continue;
                ports.add(otherpi);
            }
            it = ni.getParent().getExports();
            while (it.hasNext()) {
                Export export = (Export)it.next();
                if (!ports.contains(export.getOriginalPort())) continue;
                Name name = export.getNameKey();
                for (int i = 0; i < name.busWidth(); ++i) {
                    nets.add(netlist.getNetwork(pi.getNodeInst(), pi.getPortProto(), i));
                    added = true;
                }
            }
        }
        if (!added) {
            PortProto pp = pi.getPortProto();
            if (pp instanceof Export) {
                int wid = netlist.getBusWidth((Export)pp);
                for (int i = 0; i < wid; ++i) {
                    Network net = netlist.getNetwork(pi.getNodeInst(), pp, i);
                    if (net == null) continue;
                    nets.add(net);
                }
            } else {
                Network net = netlist.getNetwork(pi);
                if (net != null) {
                    nets.add(net);
                }
            }
        }
        return nets;
    }

    public static Set<Network> getNetworks(Geometric geom, Netlist netlist, Set<Network> nets) {
        if (nets == null) {
            nets = new HashSet<Network>();
        } else {
            nets.clear();
        }
        if (geom instanceof ArcInst) {
            nets.add(netlist.getNetwork((ArcInst)geom, 0));
        } else {
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                nets = NetworkTool.getNetworksOnPort(pi, netlist, nets);
            }
        }
        return nets;
    }

    @Override
    public void init() {
        this.setOn();
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.init()");
    }

    public static boolean isIgnoreResistors() {
        return NetworkTool.tool.cacheIgnoreResistors.getBoolean();
    }

    private static Netlist.ShortResistors isIgnoreResistors_() {
        return Netlist.ShortResistors.NO;
    }

    public static Setting getIgnoreResistorsSetting() {
        return NetworkTool.tool.cacheIgnoreResistors;
    }

    @Override
    protected void initProjectSettings() {
        this.makeBooleanSetting("IgnoreResistors", "Netlists tab", "Networks ignore Resistors", false);
    }

    public static boolean isBusAscending() {
        return cacheBusAscending.getBoolean();
    }

    public static void setBusAscending(boolean a) {
        cacheBusAscending.setBoolean(a);
    }

    public static boolean isFactoryBusAscending() {
        return cacheBusAscending.getBooleanFactoryValue();
    }

    public static boolean isBusAscendingInNetlistEngine() {
        return false;
    }

    private static class RenumberJob
    extends Job {
        private RenumberJob() {
            super("Renumber All Networks", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() throws JobException {
            EDatabase.serverDatabase().getNetworkManager().redoNetworkNumbering(true);
            return true;
        }
    }

    public static class NetlistNotReady
    extends RuntimeException {
        public NetlistNotReady() {
            super("User netlist is not ready");
        }

        public NetlistNotReady(String s) {
            super(s);
        }
    }
}

