/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.ActivityLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class ToolBarButton
extends AbstractButton
implements Accessible,
ActionListener {
    private static HashMap<String, List<AbstractButton>> allButtons = new HashMap(15);
    public static ToolBarButton updater = new ToolBarButton(null, null);
    private String name;
    private static final ButtonLogger buttonLogger = new ButtonLogger();
    private static final String uiClassIDdefault = "ButtonUI";
    private static final String uiClassIDtoggle = "ToggleButtonUI";
    private String uiClassID;

    private ToolBarButton(String text2, Icon icon) {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.uiClassID = uiClassIDtoggle;
        this.init(null, icon);
        this.name = text2;
    }

    public String getName() {
        return this.name;
    }

    public static ToolBarButton newInstance(String text2, Icon icon) {
        List<Object> buttonGroup;
        ToolBarButton b = new ToolBarButton(text2, icon);
        b.addActionListener(updater);
        b.addActionListener(buttonLogger);
        if (!allButtons.containsKey(text2)) {
            buttonGroup = new ArrayList();
            allButtons.put(text2, buttonGroup);
        } else {
            buttonGroup = allButtons.get(text2);
        }
        buttonGroup.add(b);
        return b;
    }

    public void addActionListener(ActionListener l) {
        this.removeActionListener(buttonLogger);
        super.addActionListener(l);
        super.addActionListener(buttonLogger);
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        String name = source instanceof ToolBarButton ? ((ToolBarButton)source).getName() : source.getText();
        List<AbstractButton> list2 = allButtons.get(name);
        if (list2 == null) {
            return;
        }
        for (AbstractButton b : list2) {
            if (b == source) continue;
            b.setSelected(source.isSelected());
        }
    }

    public static void setIconForButton(String name, Icon icon) {
        List<AbstractButton> list2 = allButtons.get(name);
        if (list2 == null) {
            return;
        }
        for (AbstractButton b : list2) {
            b.setIcon(icon);
        }
    }

    public static boolean getButtonState(String name) {
        List<AbstractButton> list2 = allButtons.get(name);
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        AbstractButton b = list2.get(0);
        return b.isSelected();
    }

    public static void doClick(String name) {
        List<AbstractButton> list2 = allButtons.get(name);
        if (list2 == null) {
            return;
        }
        AbstractButton b = list2.get(0);
        b.doClick();
    }

    public void finished() {
        ActionListener[] actionListeners = this.getActionListeners();
        for (int j = 0; j < actionListeners.length; ++j) {
            ActionListener actionListener = actionListeners[j];
            this.removeActionListener(actionListener);
        }
        List<AbstractButton> list2 = allButtons.get(this.getName());
        if (list2 == null) {
            return;
        }
        list2.remove(this);
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return this.uiClassID;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleJButton() {
            super(ToolBarButton.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }

    private static class ButtonLogger
    implements ActionListener {
        private ButtonLogger() {
        }

        public void actionPerformed(ActionEvent e) {
            ToolBarButton b = (ToolBarButton)e.getSource();
            ActivityLogger.logToolBarButtonActivated(b.getName());
        }
    }
}

