/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config;

import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.config.model.Injection;
import com.sun.electric.util.config.model.Parameter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigVerification {
    private static XmlConfigVerification instance = new XmlConfigVerification();

    private XmlConfigVerification() {
    }

    public static XmlConfigVerification getInstance() {
        return instance;
    }

    public static boolean runVerification(Map<String, Injection> injections) throws LoopExistsException {
        return XmlConfigVerification.getInstance().verifyConfiguration(injections);
    }

    public boolean verifyConfiguration(Map<String, Injection> injections) throws LoopExistsException {
        HashMap<String, InjectionWrapper> wrappers = CollectionFactory.createHashMap();
        for (Map.Entry<String, Injection> entry : injections.entrySet()) {
            wrappers.put(entry.getKey(), new InjectionWrapper(entry.getValue()));
        }
        for (InjectionWrapper wrapper : wrappers.values()) {
            this.deepFirstSearch(wrapper, wrappers);
        }
        return true;
    }

    private void deepFirstSearch(InjectionWrapper wrapper, Map<String, InjectionWrapper> injections) throws LoopExistsException {
        if (wrapper.finished) {
            return;
        }
        if (wrapper.visited) {
            throw new LoopExistsException();
        }
        wrapper.visited = true;
        if (wrapper.injection.getParameters() != null) {
            for (Parameter param2 : wrapper.injection.getParameters()) {
                if (param2.getRef() == null) continue;
                this.deepFirstSearch(injections.get(param2.getRef()), injections);
            }
        }
        wrapper.finished = true;
    }

    public static class LoopExistsException
    extends Exception {
    }

    private class InjectionWrapper {
        private Injection injection;
        private boolean visited = false;
        private boolean finished = false;

        public InjectionWrapper(Injection parameter) {
            this.injection = parameter;
        }
    }
}

