/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.datastructures;

public abstract class PriorityQueue<E> {
    private int capacity = 0;
    private int size = 0;
    private E[] elements = null;
    final int MIN_CAPA = 32;

    public E[] getElements() {
        return this.elements;
    }

    public E top() {
        assert (this.size > 0);
        return this.elements[1];
    }

    public void pop() {
        this.remove(1);
    }

    public void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.set_index(this.elements[i], 0);
        }
        this.size = 0;
    }

    public void setEmpty() {
        this.size = 0;
    }

    private void remove(int i) {
        assert (i <= this.size);
        this.set_index(this.elements[i], 0);
        int bubble = this.move_bubble_down(i);
        if (bubble != this.size) {
            this.insert_and_bubble_up(bubble, this.elements[this.size]);
        }
        --this.size;
    }

    public void push(E element) {
        if (this.size >= this.capacity) {
            this.resize(2 * this.capacity);
        }
        this.insert_and_bubble_up(++this.size, element);
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size == 0;
    }

    private void insert_and_bubble_up(int i, E element) {
        while (i >= 2 && this.less(element, this.elements[i / 2])) {
            this.store_element(i, this.elements[i / 2]);
            i /= 2;
        }
        this.store_element(i, element);
    }

    private int move_bubble_down(int i) {
        int sz = this.size;
        int right_child = i * 2 + 1;
        while (right_child <= sz) {
            if (this.less(this.elements[right_child - 1], this.elements[right_child])) {
                --right_child;
            }
            this.store_element(i, this.elements[right_child]);
            i = right_child;
            right_child = i * 2 + 1;
        }
        if (right_child - 1 == sz) {
            this.store_element(i, this.elements[right_child - 1]);
            i = right_child - 1;
        }
        return i;
    }

    private void resize(int new_capacity) {
        this.capacity = new_capacity < 32 ? 32 : new_capacity;
        E[] new_elements = this.alloc_array(this.capacity + 1);
        if (this.elements != null) {
            for (int i = 1; i <= this.size; ++i) {
                new_elements[i] = this.elements[i];
            }
        }
        assert (new_elements != null);
        assert (this.capacity >= this.size);
        this.elements = new_elements;
    }

    private void store_element(int i, E element) {
        this.elements[i] = element;
        this.set_index(this.elements[i], i);
    }

    public void update(E element) {
        int i = this.get_index(element);
        if (i == 0) {
            this.push(element);
        } else {
            this.set_index(this.elements[i], 0);
            int bubble = this.move_bubble_down(i);
            this.insert_and_bubble_up(bubble, element);
        }
    }

    public void remove(E element) {
        int i = this.get_index(element);
        if (i > 0) {
            this.remove(i);
        }
    }

    protected abstract boolean less(E var1, E var2);

    protected abstract int get_index(E var1);

    protected abstract void set_index(E var1, int var2);

    protected abstract E[] alloc_array(int var1);
}

