/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.BenchmarkRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.RoutingArray;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Tupel;
import com.sun.electric.tool.routing.experimentalLeeMoore1.Wiring;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkPool;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkerThread;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class yana
extends BenchmarkRouter {
    protected final boolean output;
    private static int progressMax = 0;
    private static int progress = 0;
    private static UserInterface gui;
    public static int maxThreads;
    public RoutingFrame.RoutingParameter numPartitionsParameter;
    public static int numPartitions;
    public RoutingFrame.RoutingParameter regionDivideMethodParameter;
    public static int regionDivideMethod;
    public RoutingFrame.RoutingParameter maxLayerUseParameter;
    public static int maxLayerUse;
    public RoutingFrame.RoutingParameter minimumRegionBorderLengthParameter;
    public static int minimumRegionBorderLength;
    public static int distanceBetweenWires;
    public static CyclicBarrier barrierRouting;
    public static CyclicBarrier barrierWiring;
    public static ConcurrentHashMap<Integer, Boolean> unroutedNets;

    @Override
    public String getAlgorithmName() {
        return "Lee/Moore - 1";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        int i;
        ElapseTimer timer = ElapseTimer.createInstance().start();
        if (this.output) {
            System.out.println("electric goes yana...");
        }
        int maxRuntimeMs = this.maxRuntime.getIntValue() * 1000;
        maxThreads = this.numThreads.getIntValue() < 1 ? 1 : this.numThreads.getIntValue();
        numPartitions = this.numPartitionsParameter.getIntValue() < 1 ? 1 : this.numPartitionsParameter.getIntValue();
        minimumRegionBorderLength = this.minimumRegionBorderLengthParameter.getIntValue() < 2 ? 2 : this.minimumRegionBorderLengthParameter.getIntValue();
        regionDivideMethod = this.regionDivideMethodParameter.getIntValue();
        maxLayerUse = this.maxLayerUseParameter.getIntValue();
        if (maxLayerUse <= 0 || maxLayerUse > this.countLayers(allLayers)) {
            maxLayerUse = this.countLayers(allLayers);
        }
        int dist = 0;
        int width = 0;
        int currentLayer = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal() || currentLayer >= maxLayerUse) continue;
            if (rl.getMinSpacing(rl) > (double)dist) {
                dist = (int)Math.round(rl.getMinSpacing(rl));
            }
            if (rl.getMinWidth() > (double)width) {
                width = (int)Math.round(rl.getMinWidth());
            }
            ++currentLayer;
        }
        if (width < 5) {
            ++width;
        }
        distanceBetweenWires = dist + width;
        if (this.output) {
            System.out.println("Running " + maxThreads + " Threads on " + numPartitions + " partitions each minimum " + minimumRegionBorderLength + " length and " + distanceBetweenWires + " wire spacing.");
        }
        yana.initProgress();
        this.initializeWiringClass(allLayers, allContacts);
        barrierRouting = new CyclicBarrier(maxThreads, new Runnable(){

            @Override
            public void run() {
                WorkPool.prepare();
            }
        });
        barrierWiring = new CyclicBarrier(maxThreads);
        Tupel.setOffset(cell.getBounds().getLambdaX(), cell.getBounds().getLambdaY(), 10, this.output);
        RoutingArray ra = new RoutingArray(cell, maxLayerUse, blockages, 3.0);
        this.markStartEndAsBlocked(segmentsToRoute, ra);
        WorkerThread[] workerObjects = new WorkerThread[maxThreads];
        Thread[] workerThreads = new Thread[maxThreads];
        for (i = 0; i < maxThreads; ++i) {
            workerObjects[i] = new WorkerThread(i);
            workerThreads[i] = new Thread(workerObjects[i]);
        }
        maxRuntimeMs = (int)timer.currentTimeLong() + maxRuntimeMs;
        WorkerThread.init(workerObjects, maxLayerUse, ra, segmentsToRoute, maxRuntimeMs, this.output);
        for (i = 0; i < maxThreads; ++i) {
            workerThreads[i].start();
        }
        try {
            for (i = 0; i < maxThreads; ++i) {
                workerThreads[i].join();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(yana.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.output) {
            System.out.println("yana complete...");
        }
        yana.closeProgress();
        if (this.output) {
            timer.end();
            System.out.println("YANA-time: " + timer);
        }
        System.gc();
    }

    private void initializeWiringClass(List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts) {
        int metalLayers = 0;
        HashMap<String, Integer> metalLayerMap = new HashMap<String, Integer>();
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            metalLayerMap.put(rl.getName(), metalLayers);
            ++metalLayers;
        }
        Wiring.init(allLayers, metalLayerMap, allContacts, this.output);
    }

    private int countLayers(List<RoutingFrame.RoutingLayer> allLayers) {
        int layer = 0;
        for (RoutingFrame.RoutingLayer l : allLayers) {
            if (l == null || !l.isMetal()) continue;
            ++layer;
        }
        return layer;
    }

    public void printChipStatistics(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        int i;
        int metalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++metalLayers;
        }
        int[] layerDistance = new int[metalLayers];
        int[] layerMembership = new int[metalLayers];
        int[][] crossLayerMembership = new int[metalLayers][metalLayers];
        int singleLayer = 0;
        int crossLayer = 0;
        int maxNetID = Integer.MIN_VALUE;
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int distance;
            maxNetID = Math.max(maxNetID, rs.getNetID());
            int minStart = Integer.MAX_VALUE;
            int maxStart = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : rs.getStartLayers()) {
                minStart = Math.min(minStart, rl.getMetalNumber());
                maxStart = Math.max(maxStart, rl.getMetalNumber());
            }
            int minFinish = Integer.MAX_VALUE;
            int maxFinish = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : rs.getFinishLayers()) {
                minFinish = Math.min(minFinish, rl.getMetalNumber());
                maxFinish = Math.max(maxFinish, rl.getMetalNumber());
            }
            if (minStart != maxStart || minFinish != maxFinish) continue;
            int n = distance = Math.abs(minStart - minFinish);
            layerDistance[n] = layerDistance[n] + 1;
            if (minStart == minFinish) {
                ++singleLayer;
                int n2 = minStart - 1;
                layerMembership[n2] = layerMembership[n2] + 1;
                continue;
            }
            int min2 = Math.min(minStart, minFinish);
            int max2 = Math.max(minStart, minFinish);
            int[] nArray = crossLayerMembership[min2 - 1];
            int n3 = max2 - 1;
            nArray[n3] = nArray[n3] + 1;
            ++crossLayer;
        }
        int[] nets = new int[maxNetID + 1];
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int n = rs.getNetID();
            nets[n] = nets[n] + 1;
        }
        int numberOfNets = 0;
        int maxSegments = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < nets.length; ++i2) {
            if (nets[i2] != 0) {
                ++numberOfNets;
            }
            maxSegments = Math.max(maxSegments, nets[i2]);
        }
        int[] numberOfSegments = new int[maxSegments];
        for (int i3 = 0; i3 < nets.length; ++i3) {
            if (nets[i3] == 0) continue;
            int n = nets[i3] - 1;
            numberOfSegments[n] = numberOfSegments[n] + 1;
        }
        int[] blockagesOnLayer = new int[metalLayers];
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            int n = rg.getLayer().getMetalNumber() - 1;
            blockagesOnLayer[n] = blockagesOnLayer[n] + 1;
        }
        System.out.println("################### Cell statistics  ########################");
        System.out.println();
        System.out.println();
        System.out.print("#Metal-Layers: " + metalLayers + " { ");
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            System.out.print(rl.getMetalNumber() + ", ");
        }
        System.out.println("}\n");
        System.out.println("#Segments: " + segmentsToRoute.size());
        System.out.println("\t on one layer:  " + singleLayer);
        for (i = 0; i < layerMembership.length; ++i) {
            if (layerMembership[i] == 0) continue;
            System.out.println("\t\t Metal-" + (i + 1) + ": " + layerMembership[i]);
        }
        System.out.println("\t on two layers: " + crossLayer);
        for (i = 0; i < crossLayerMembership.length; ++i) {
            for (int j = 0; j < crossLayerMembership[0].length; ++j) {
                if (crossLayerMembership[i][j] == 0) continue;
                System.out.println("\t\t Metal-" + (i + 1) + " - Metal-" + (j + 1) + ": " + crossLayerMembership[i][j]);
            }
        }
        System.out.println();
        System.out.println("layer distance distribution");
        for (i = 0; i < layerDistance.length; ++i) {
            if (layerDistance[i] == 0) continue;
            System.out.println("\t distance " + i + ": " + layerDistance[i]);
        }
        System.out.println();
        System.out.println("#Blockages: " + blockages.size());
        for (i = 0; i < blockagesOnLayer.length; ++i) {
            if (blockagesOnLayer[i] == 0) continue;
            System.out.println("\t on Metal-" + (i + 1) + ": " + blockagesOnLayer[i]);
        }
        System.out.println();
        int countNumSegments = 0;
        System.out.println("#Nets: " + numberOfNets);
        for (int i4 = 0; i4 < numberOfSegments.length; ++i4) {
            if (numberOfSegments[i4] == 0) continue;
            countNumSegments += numberOfSegments[i4] * (i4 + 1);
            System.out.print("\t " + (i4 + 1) + " segments: " + numberOfSegments[i4] + "{ ");
            for (int j = 0; j < nets.length; ++j) {
                if (nets[j] != i4 + 1) continue;
                System.out.print(j + ", ");
            }
            System.out.println("}");
        }
        System.out.println("\tsum: " + countNumSegments + " segments");
        System.out.println("############################################################");
        System.out.println();
    }

    public static void initProgress() {
        gui = Job.getUserInterface();
        gui.startProgressDialog("Yana is working for you", null);
        gui.setProgressNote("Running...");
        gui.setProgressValue(0);
    }

    public static synchronized void setProgressMax(int size2) {
        progressMax += size2;
    }

    public static synchronized void updateProgress() {
        gui.setProgressNote("Routing segment " + ++progress + "/" + progressMax);
        gui.setProgressValue((int)((double)progress / (double)progressMax * 100.0));
    }

    public static void closeProgress() {
        gui.stopProgressDialog();
    }

    private void markStartEndAsBlocked(List<RoutingFrame.RoutingSegment> segmentsToRoute, RoutingArray ra) {
        Tupel[] startEndPoints = new Tupel[18];
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int i = 0;
            Tupel start = new Tupel(rs.getStartEnd().getLocation(), rs.getStartLayers().get(0).getMetalNumber() - 1);
            Tupel end = new Tupel(rs.getFinishEnd().getLocation(), rs.getFinishLayers().get(0).getMetalNumber() - 1);
            startEndPoints[i++] = start;
            startEndPoints[i++] = end;
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() + 1, start.getY_InsideRoutingArray(), start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray(), start.getY_InsideRoutingArray() + 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() + 1, start.getY_InsideRoutingArray() + 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() - 1, start.getY_InsideRoutingArray(), start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray(), start.getY_InsideRoutingArray() - 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() - 1, start.getY_InsideRoutingArray() - 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() + 1, start.getY_InsideRoutingArray() - 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(start.getX_InsideRoutingArray() - 1, start.getY_InsideRoutingArray() + 1, start.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() + 1, end.getY_InsideRoutingArray(), end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray(), end.getY_InsideRoutingArray() + 1, end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() + 1, end.getY_InsideRoutingArray() + 1, end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() - 1, end.getY_InsideRoutingArray(), end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray(), end.getY_InsideRoutingArray() - 1, end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() - 1, end.getY_InsideRoutingArray() - 1, end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() + 1, end.getY_InsideRoutingArray() - 1, end.getLayer(), false);
            startEndPoints[i++] = new Tupel(end.getX_InsideRoutingArray() - 1, end.getY_InsideRoutingArray() + 1, end.getLayer(), false);
            ra.reserveForRouting(startEndPoints, rs.getNetID());
        }
        ra.markReserved();
    }

    public yana() {
        this.output = this.enableOutput.getBooleanValue();
        this.numPartitionsParameter = new RoutingFrame.RoutingParameter((RoutingFrame)this, "partitions", "Number of partitions to use:", 26);
        this.regionDivideMethodParameter = new RoutingFrame.RoutingParameter((RoutingFrame)this, "region-generation-method", "Method used to devide the grid into regions:", 1);
        this.maxLayerUseParameter = new RoutingFrame.RoutingParameter((RoutingFrame)this, "maxLayerUse", "Restrict number of layers to use", 5);
        this.minimumRegionBorderLengthParameter = new RoutingFrame.RoutingParameter((RoutingFrame)this, "minimumRegionBorderLength", "Minumum length the regions must have:", 20);
    }

    public static void markSegmentAsUnroutable(RoutingFrame.RoutingSegment rs) {
        unroutedNets.put(rs.hashCode(), false);
    }

    public static boolean isRouteable(RoutingFrame.RoutingSegment rs) {
        return unroutedNets.get(rs.hashCode()) == null;
    }

    static {
        unroutedNets = new ConcurrentHashMap();
    }
}

