/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.general.RowCol;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class FDRowCol
extends RowCol {
    protected PlacementFrame.PlacementParameter numThreadsParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("threads", "Number of threads:", 4);
    protected PlacementFrame.PlacementParameter maxRuntimeParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("runtime", "Runtime (in seconds, 0 for no limit):", 240);
    protected PlacementFrame.PlacementParameter flipAlternateColsRows = (PlacementFrame)this.new PlacementFrame.PlacementParameter("flipColRow", "Flip alternate columns/rows", true);
    protected PlacementFrame.PlacementParameter makeStacksEven = (PlacementFrame)this.new PlacementFrame.PlacementParameter("makeStacksEven", "Force rows/columns to be equal length", true);
    private static final boolean DEBUGMODE = false;
    private static Map<RowCol.ProxyNode, NodeMotion> motionMap;
    private static List<PlacementFrame.PlacementNode> debugPlacementNodes;
    private static List<PlacementFrame.PlacementNetwork> debugAllNetworks;
    private static Map<String, NodeInst> placementMap;
    private static String plannedMoveNodeName;
    private static Map<RowCol.ProxyNode, PlacementAdapter.PlacementNode> backMap;

    @Override
    public String getAlgorithmName() {
        return "Force-Directed-Row/Col";
    }

    @Override
    public boolean runRowColPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.setParamterValues(this.numThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue());
        boolean stackWeight = true;
        while (true) {
            this.sortForces(allNetworks, placementNodes, stackWeight);
            RowCol.ProxyNode nodeToMove = this.doForceDirected(allNetworks, placementNodes);
            if (nodeToMove != null) continue;
            if (!stackWeight) break;
            stackWeight = false;
        }
        return true;
    }

    void sortForces(List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementFrame.PlacementNode> placementNodes, boolean stackWeight) {
        int i;
        motionMap = new HashMap<RowCol.ProxyNode, NodeMotion>();
        for (RowCol.ProxyNode pNode : this.nodesToPlace) {
            motionMap.put(pNode, new NodeMotion());
        }
        double[] stackWeights = new double[this.numStacks];
        double avgStackSize = 0.0;
        for (i = 0; i < this.numStacks; ++i) {
            avgStackSize += this.stackSizes[i];
        }
        avgStackSize /= (double)this.numStacks;
        for (i = 0; i < this.numStacks; ++i) {
            stackWeights[i] = stackWeight ? avgStackSize / this.stackSizes[i] : 1.0;
        }
        for (PlacementFrame.PlacementNetwork pNet : allNetworks) {
            PlacementFrame.PlacementPort lastPort = null;
            RowCol.ProxyNode lastPN = null;
            double lastX = 0.0;
            double lastY = 0.0;
            for (PlacementFrame.PlacementPort port : pNet.getPortsOnNet()) {
                RowCol.ProxyNode pn = (RowCol.ProxyNode)this.proxyMap.get(port.getPlacementNode());
                double currX = pn.getPlacementX();
                double currY = pn.getPlacementY();
                Orientation o = pn.getPlacementOrientation();
                currX = o == Orientation.X ? (currX -= port.getOffX()) : (currX += port.getOffX());
                currY = o == Orientation.Y ? (currY -= port.getOffY()) : (currY += port.getOffY());
                if (lastPort != null && pn != lastPN) {
                    double addX = (lastX - currX) * stackWeights[lastPN.getColumnRowIndex()];
                    double addY = (lastY - currY) * stackWeights[lastPN.getColumnRowIndex()];
                    NodeMotion pnNM = motionMap.get(pn);
                    pnNM.dX += addX;
                    pnNM.dY += addY;
                    ++pnNM.numMoved;
                    addX = (currX - lastX) * stackWeights[pn.getColumnRowIndex()];
                    addY = (currY - lastY) * stackWeights[pn.getColumnRowIndex()];
                    pnNM = motionMap.get(lastPN);
                    pnNM.dX += addX;
                    pnNM.dY += addY;
                    ++pnNM.numMoved;
                }
                lastPort = port;
                lastPN = pn;
                lastX = currX;
                lastY = currY;
            }
        }
        for (RowCol.ProxyNode node : this.nodesToPlace) {
            NodeMotion nodeNM = motionMap.get(node);
            nodeNM.dX /= (double)nodeNM.numMoved;
            nodeNM.dY /= (double)nodeNM.numMoved;
        }
        Collections.sort(this.nodesToPlace, new ProxyMovement());
    }

    RowCol.ProxyNode doForceDirected(List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementFrame.PlacementNode> placementNodes) {
        for (RowCol.ProxyNode biggestMoveNode : this.nodesToPlace) {
            int newPlaceInStack;
            RowCol.ProxyNode pn;
            double stackPos;
            NodeMotion nodeNM = motionMap.get(biggestMoveNode);
            double xPos = biggestMoveNode.getPlacementX() + nodeNM.dX;
            double yPos = biggestMoveNode.getPlacementY() + nodeNM.dY;
            int oldIndex = biggestMoveNode.getColumnRowIndex();
            int newIndex = this.columnPlacement ? (int)Math.round(xPos / biggestMoveNode.getCellGirth()) : (int)Math.round(yPos / biggestMoveNode.getCellGirth());
            if (newIndex < 0) {
                newIndex = 0;
            }
            if (newIndex >= this.numStacks) {
                newIndex = this.numStacks - 1;
            }
            if (this.columnPlacement) {
                xPos = (double)newIndex * biggestMoveNode.getCellGirth();
                stackPos = yPos;
            } else {
                yPos = (double)newIndex * biggestMoveNode.getCellGirth();
                stackPos = xPos;
            }
            List newStack = this.stackContents[newIndex];
            double stackLoc = 0.0;
            for (newPlaceInStack = 0; newPlaceInStack < newStack.size() && !(stackPos <= stackLoc); stackLoc += pn.getCellSize(), ++newPlaceInStack) {
                pn = (RowCol.ProxyNode)newStack.get(newPlaceInStack);
            }
            if (newIndex == oldIndex) {
                int oldPlaceInStack = this.stackContents[oldIndex].indexOf(biggestMoveNode);
                if (newPlaceInStack == oldPlaceInStack) continue;
                if (oldPlaceInStack < newPlaceInStack) {
                    --newPlaceInStack;
                }
            }
            this.proposeMove(biggestMoveNode, oldIndex, newIndex, newPlaceInStack);
            double networkMetricBefore = 0.0;
            double networkMetricAfter = 0.0;
            for (PlacementFrame.PlacementNetwork net : allNetworks) {
                networkMetricBefore += this.netLength(net, -1, -1);
                networkMetricAfter += this.netLength(net, newIndex, oldIndex);
            }
            double gain = networkMetricBefore - networkMetricAfter;
            if (!(gain > 0.0)) continue;
            this.implementMove(biggestMoveNode, oldIndex, newIndex, newPlaceInStack);
            return biggestMoveNode;
        }
        return null;
    }

    private void initializeDebugging(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        debugPlacementNodes = placementNodes;
        debugAllNetworks = allNetworks;
        backMap = new HashMap<RowCol.ProxyNode, PlacementAdapter.PlacementNode>();
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            PlacementAdapter.PlacementNode pnReal = (PlacementAdapter.PlacementNode)pn;
            backMap.put((RowCol.ProxyNode)this.proxyMap.get(pn), pnReal);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PlacementProgress();
            }
        });
    }

    private static class MakeIntermediateMove
    extends Job {
        private MakeIntermediateMove() {
            super("Place cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (PlacementFrame.PlacementNode plNode : debugPlacementNodes) {
                PlacementAdapter.PlacementNode pan = (PlacementAdapter.PlacementNode)plNode;
                NodeInst bmNI = pan.getOriginal();
                NodeInst newNI = (NodeInst)placementMap.get(bmNI.getName());
                double xPos = plNode.getPlacementX();
                double yPos = plNode.getPlacementY();
                Orientation orient = plNode.getPlacementOrientation();
                if (pan.getOriginal().isCellInstance()) {
                    Cell placementCell = (Cell)pan.getOriginal().getProto();
                    ERectangle bounds = placementCell.getBounds();
                    Point2D.Double centerOffset = new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY());
                    orient.pureRotate().transform(centerOffset, centerOffset);
                    xPos -= ((Point2D)centerOffset).getX();
                    yPos -= ((Point2D)centerOffset).getY();
                }
                if (newNI.getAnchorCenterX() == xPos && newNI.getAnchorCenterY() == yPos) continue;
                double dX = xPos - newNI.getAnchorCenterX();
                double dY = yPos - newNI.getAnchorCenterY();
                newNI.move(dX, dY);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            NodeInst newNI = (NodeInst)placementMap.get(plannedMoveNodeName);
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h = wnd.getHighlighter();
            h.clear();
            ERectangle area = newNI.getBounds();
            h.addArea(area, wnd.getCell());
            h.finished();
        }
    }

    public class PlacementProgress
    extends EDialog {
        private JButton theBut;
        private boolean planned;
        private boolean stackWeight;

        public PlacementProgress() {
            super((Frame)TopLevel.getCurrentJFrame(), false);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Debug Placement");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PlacementProgress.this.closeDialog(evt);
                }
            });
            this.theBut = new JButton("Plan Move");
            this.theBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PlacementProgress.this.planMove();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.theBut, gridBagConstraints);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
            this.planned = false;
            this.stackWeight = true;
        }

        @Override
        protected void escapePressed() {
            this.closeDialog(null);
        }

        private void planMove() {
            RowCol.ProxyNode biggestMoveNode;
            if (this.planned) {
                this.theBut.setText("Plan Move");
                new MakeIntermediateMove();
                this.planned = false;
                return;
            }
            this.theBut.setText("Do Move");
            this.planned = true;
            while (true) {
                FDRowCol.this.sortForces(debugAllNetworks, debugPlacementNodes, this.stackWeight);
                biggestMoveNode = FDRowCol.this.doForceDirected(debugAllNetworks, debugPlacementNodes);
                if (biggestMoveNode != null || !this.stackWeight) break;
                this.stackWeight = false;
            }
            placementMap = PlacementAdapter.getPlacementMap();
            plannedMoveNodeName = null;
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h = wnd.getHighlighter();
            h.clear();
            for (Object pn : FDRowCol.this.nodesToPlace) {
                NodeInst bmNI = ((PlacementAdapter.PlacementNode)backMap.get(pn)).getOriginal();
                NodeInst newNI = (NodeInst)placementMap.get(bmNI.getName());
                NodeMotion nodeNM = (NodeMotion)motionMap.get(pn);
                ERectangle area = newNI.getBounds();
                Poly poly = new Poly(area);
                h.addPoly(poly, wnd.getCell(), Color.GREEN);
                Poly polyL = new Poly(Poly.fromLambda(newNI.getBounds().getCenterX(), newNI.getBounds().getCenterY()), Poly.fromLambda(newNI.getBounds().getCenterX() + nodeNM.dX, newNI.getBounds().getCenterY() + nodeNM.dY));
                h.addPoly(polyL, wnd.getCell(), Color.CYAN);
            }
            if (biggestMoveNode != null) {
                for (Object pn : debugPlacementNodes) {
                    RowCol.ProxyNode p = (RowCol.ProxyNode)FDRowCol.this.proxyMap.get(pn);
                    ((PlacementFrame.PlacementNode)pn).setPlacement(p.getPlacementX(), p.getPlacementY());
                    ((PlacementFrame.PlacementNode)pn).setOrientation(p.getPlacementOrientation());
                }
                NodeMotion nodeNM = (NodeMotion)motionMap.get(biggestMoveNode);
                NodeInst bmNI = ((PlacementAdapter.PlacementNode)backMap.get(biggestMoveNode)).getOriginal();
                NodeInst newNI = (NodeInst)placementMap.get(bmNI.getName());
                plannedMoveNodeName = bmNI.getName();
                ERectangle area = newNI.getBounds();
                h.addLine(new Point2D.Double(((RectangularShape)area).getMinX(), ((RectangularShape)area).getMinY()), new Point2D.Double(((RectangularShape)area).getMinX(), ((RectangularShape)area).getMaxY()), wnd.getCell(), true, false);
                h.addLine(new Point2D.Double(((RectangularShape)area).getMinX(), ((RectangularShape)area).getMaxY()), new Point2D.Double(((RectangularShape)area).getMaxX(), ((RectangularShape)area).getMaxY()), wnd.getCell(), true, false);
                h.addLine(new Point2D.Double(((RectangularShape)area).getMaxX(), ((RectangularShape)area).getMaxY()), new Point2D.Double(((RectangularShape)area).getMaxX(), ((RectangularShape)area).getMinY()), wnd.getCell(), true, false);
                h.addLine(new Point2D.Double(((RectangularShape)area).getMaxX(), ((RectangularShape)area).getMinY()), new Point2D.Double(((RectangularShape)area).getMinX(), ((RectangularShape)area).getMinY()), wnd.getCell(), true, false);
                h.addLine(new Point2D.Double(newNI.getBounds().getCenterX(), newNI.getBounds().getCenterY()), new Point2D.Double(newNI.getBounds().getCenterX() + nodeNM.dX, newNI.getBounds().getCenterY() + nodeNM.dY), wnd.getCell(), true, false);
            }
            h.finished();
        }

        private void closeDialog(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class ProxyMovement
    implements Comparator<RowCol.ProxyNode> {
        private ProxyMovement() {
        }

        @Override
        public int compare(RowCol.ProxyNode c1, RowCol.ProxyNode c2) {
            double r2;
            NodeMotion nm1 = (NodeMotion)motionMap.get(c1);
            NodeMotion nm2 = (NodeMotion)motionMap.get(c2);
            double x1 = nm1.dX;
            double y1 = nm1.dY;
            double x2 = nm2.dX;
            double y2 = nm2.dY;
            double r1 = Math.sqrt(x1 * x1 + y1 * y1);
            if (r1 == (r2 = Math.sqrt(x2 * x2 + y2 * y2))) {
                return 0;
            }
            if (r1 < r2) {
                return 1;
            }
            return -1;
        }
    }

    private static class NodeMotion {
        double dX = 0.0;
        double dY = 0.0;
        int numMoved = 0;

        NodeMotion() {
        }
    }
}

