/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevisionProvider;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.UsageCollector;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class CellRevision {
    public static final CellRevision[] NULL_ARRAY = new CellRevision[0];
    public static final ImmutableArrayList<CellRevision> EMPTY_LIST = new ImmutableArrayList<CellRevision>(NULL_ARRAY);
    protected static final BitSet EMPTY_BITSET = new BitSet();
    protected static final int[] NULL_INT_ARRAY = new int[0];
    static final CellUsageInfo[] NULL_CELL_USAGE_INFO_ARRAY = new CellUsageInfo[0];
    static int cellRevisionsCreated = 0;
    public final ImmutableCell d;
    public final ImmutableNodeInst.Iterable nodes;
    final int[] nodeIndex;
    public final ImmutableArcInst.Iterable arcs;
    final int[] arcIndex;
    public final ImmutableExport.Iterable exports;
    int[] exportIndex;
    final BitSet techUsages;
    final CellUsageInfo[] cellUsages;
    final BitSet definedExports;
    final int definedExportsLength;
    final BitSet deletedExports;

    CellRevision(ImmutableCell d, ImmutableNodeInst.Iterable nodes, int[] nodeIndex, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        this.d = d;
        this.nodes = nodes;
        this.nodeIndex = nodeIndex;
        this.arcs = arcs;
        this.arcIndex = arcIndex;
        this.exports = exports;
        this.exportIndex = exportIndex;
        this.techUsages = techUsages;
        this.cellUsages = cellUsages;
        this.definedExports = definedExports;
        this.definedExportsLength = definedExportsLength;
        this.deletedExports = deletedExports;
        ++cellRevisionsCreated;
    }

    protected static BitSet makeTechUsages(TechId techId) {
        BitSet techUsages = new BitSet();
        techUsages.set(techId.techIndex);
        return techUsages;
    }

    public static CellRevisionProvider getProvider() {
        return CellRevisionProvider.INSTANCE;
    }

    public static CellRevision newInstance(ImmutableCell d) {
        return CellRevision.getProvider().createCellRevision(d);
    }

    abstract CellRevision lowLevelWith(ImmutableCell var1, ImmutableNodeInst.Iterable var2, int[] var3, ImmutableArcInst.Iterable var4, int[] var5, ImmutableExport.Iterable var6, int[] var7, BitSet var8, CellUsageInfo[] var9, BitSet var10, int var11, BitSet var12);

    public CellRevision withRevisionDate(long revisionDate) {
        if (this.d.revisionDate == revisionDate) {
            return this;
        }
        return this.lowLevelWith(this.d.withRevisionDate(revisionDate), this.nodes, this.nodeIndex, this.arcs, this.arcIndex, this.exports, this.exportIndex, this.techUsages, this.cellUsages, this.definedExports, this.definedExportsLength, this.deletedExports);
    }

    public CellRevision with(ImmutableCell d, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray) {
        ImmutableNodeInst.Iterable nodes = CellRevision.getProvider().createNodeList(nodesArray, this.nodes);
        ImmutableArcInst.Iterable arcs = CellRevision.getProvider().createArcList(arcsArray, this.arcs);
        ImmutableExport.Iterable exports = CellRevision.getProvider().createExportList(exportsArray, this.exports);
        if (this.d == d && this.nodes == nodes && this.arcs == arcs && this.exports == exports) {
            return this;
        }
        CellId cellId = d.cellId;
        boolean busNamesAllowed = d.busNamesAllowed();
        if (this.d != d && d.techId == null) {
            throw new NullPointerException("tech");
        }
        BitSet techUsages = this.techUsages;
        CellUsageInfo[] cellUsages = this.cellUsages;
        if (this.d.cellId != d.cellId || this.d.techId != d.techId || this.d.getVars() != d.getVars() || nodes != this.nodes || arcs != this.arcs || exports != this.exports) {
            UsageCollector uc = new UsageCollector(d, nodes, arcs, exports);
            techUsages = uc.getTechUsages(this.techUsages);
            cellUsages = uc.getCellUsages(this.cellUsages);
        }
        if (cellId.isIcon() && cellUsages.length != 0) {
            throw new IllegalArgumentException("Icon contains subcells");
        }
        int[] nodeIndex = this.nodeIndex;
        if (nodes != this.nodes) {
            boolean sameNodeIdAndIndex = true;
            boolean sameNodeIndex = nodes.size() == this.nodes.size();
            int nodeIndexLength = 0;
            boolean hasCellCenter = false;
            int nodeInd = 0;
            Iterator<ImmutableNodeInst> oldNodes = this.nodes.iterator();
            for (ImmutableNodeInst n : nodes) {
                sameNodeIdAndIndex = sameNodeIdAndIndex && n.nodeId == nodeInd;
                sameNodeIndex = sameNodeIndex && n.nodeId == oldNodes.next().nodeId;
                nodeIndexLength = Math.max(nodeIndexLength, n.nodeId + 1);
                if (ImmutableNodeInst.isCellCenter(n.protoId)) {
                    if (hasCellCenter) {
                        throw new IllegalArgumentException("Duplicate cell center");
                    }
                    hasCellCenter = true;
                }
                if (!busNamesAllowed && n.name.isBus()) {
                    throw new IllegalArgumentException("arrayedName " + n.name);
                }
                ++nodeInd;
            }
            if (sameNodeIdAndIndex) {
                nodeIndex = null;
            } else if (!sameNodeIndex) {
                nodeIndex = new int[nodeIndexLength];
                Arrays.fill(nodeIndex, -1);
                nodeInd = 0;
                for (ImmutableNodeInst n : nodes) {
                    int nodeId = n.nodeId;
                    if (nodeIndex[nodeId] >= 0) {
                        throw new IllegalArgumentException("nodeChronIndex");
                    }
                    nodeIndex[nodeId] = nodeInd++;
                }
                assert (!Arrays.equals(this.nodeIndex, nodeIndex));
            }
        }
        int[] arcIndex = this.arcIndex;
        if (arcs != this.arcs) {
            boolean sameArcIdAndIndex = true;
            boolean sameArcIndex = arcs.size() == this.arcs.size();
            int arcIndexLength = 0;
            int arcInd = 0;
            Iterator<ImmutableArcInst> oldArcs = this.arcs.iterator();
            for (ImmutableArcInst a : arcs) {
                sameArcIdAndIndex = sameArcIdAndIndex && a.arcId == arcInd;
                sameArcIndex = sameArcIndex && a.arcId == oldArcs.next().arcId;
                arcIndexLength = Math.max(arcIndexLength, a.arcId + 1);
                if (!busNamesAllowed && a.name.isBus()) {
                    throw new IllegalArgumentException("arrayedName " + a.name);
                }
                ++arcInd;
            }
            if (sameArcIdAndIndex) {
                arcIndex = null;
            } else if (!sameArcIndex) {
                arcIndex = new int[arcIndexLength];
                Arrays.fill(arcIndex, -1);
                arcInd = 0;
                for (ImmutableArcInst a : arcs) {
                    int arcId = a.arcId;
                    if (arcIndex[arcId] >= 0) {
                        throw new IllegalArgumentException("arcChronIndex");
                    }
                    arcIndex[arcId] = arcInd++;
                }
                assert (!Arrays.equals(this.arcIndex, arcIndex));
            }
        }
        int[] exportIndex = this.exportIndex;
        BitSet definedExports = this.definedExports;
        int definedExportsLength = this.definedExportsLength;
        BitSet deletedExports = this.deletedExports;
        if (exports != this.exports) {
            int chronIndex;
            boolean sameExportIndex = exports.size() == this.exports.size();
            int exportIndexLength = 0;
            int exportInd = 0;
            Iterator<ImmutableExport> oldExports = this.exports.iterator();
            for (ImmutableExport e : exports) {
                if (e.exportId.parentId != cellId) {
                    throw new IllegalArgumentException("exportId");
                }
                if (!busNamesAllowed && e.name.isBus()) {
                    throw new IllegalArgumentException("arrayedName " + e.name);
                }
                chronIndex = e.exportId.chronIndex;
                sameExportIndex = sameExportIndex && chronIndex == oldExports.next().exportId.chronIndex;
                exportIndexLength = Math.max(exportIndexLength, chronIndex + 1);
                ++exportInd;
            }
            if (!sameExportIndex) {
                exportIndex = new int[exportIndexLength];
                Arrays.fill(exportIndex, -1);
                exportInd = 0;
                for (ImmutableExport e : exports) {
                    chronIndex = e.exportId.chronIndex;
                    if (exportIndex[chronIndex] >= 0) {
                        throw new IllegalArgumentException("exportChronIndex");
                    }
                    exportIndex[chronIndex] = exportInd++;
                }
                assert (!Arrays.equals(this.exportIndex, exportIndex));
                definedExports = new BitSet();
                for (int chronIndex2 = 0; chronIndex2 < exportIndex.length; ++chronIndex2) {
                    if (exportIndex[chronIndex2] < 0) continue;
                    definedExports.set(chronIndex2);
                }
                if ((definedExports = UsageCollector.bitSetWith(this.definedExports, definedExports)) != this.definedExports) {
                    definedExportsLength = definedExports.length();
                    deletedExports = new BitSet();
                    deletedExports.set(0, definedExportsLength);
                    deletedExports.andNot(definedExports);
                    deletedExports = UsageCollector.bitSetWith(this.deletedExports, deletedExports);
                }
            }
        }
        return this.lowLevelWith(d, nodes, nodeIndex, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    CellRevision withRenamedIds(IdMapper idMapper, CellName newGroupName) {
        ImmutableCell d = this.d.withRenamedIds(idMapper).withGroupName(newGroupName);
        ImmutableNodeInst[] nodesArray = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ImmutableNodeInst oldNode = this.nodes.get(i);
            ImmutableNodeInst newNode = oldNode.withRenamedIds(idMapper);
            if (newNode != oldNode && nodesArray == null) {
                nodesArray = new ImmutableNodeInst[this.nodes.size()];
                for (int j = 0; j < i; ++j) {
                    nodesArray[j] = this.nodes.get(j);
                }
            }
            if (nodesArray == null) continue;
            nodesArray[i] = newNode;
        }
        ImmutableArcInst[] arcsArray = null;
        for (int i = 0; i < this.arcs.size(); ++i) {
            ImmutableArcInst oldArc = this.arcs.get(i);
            ImmutableArcInst newArc = oldArc.withRenamedIds(idMapper);
            if (newArc != oldArc && arcsArray == null) {
                arcsArray = new ImmutableArcInst[this.arcs.size()];
                for (int j = 0; j < i; ++j) {
                    arcsArray[j] = this.arcs.get(j);
                }
            }
            if (arcsArray == null) continue;
            arcsArray[i] = newArc;
        }
        ImmutableExport[] exportsArray = null;
        for (int i = 0; i < this.exports.size(); ++i) {
            ImmutableExport oldExport = this.exports.get(i);
            ImmutableExport newExport = oldExport.withRenamedIds(idMapper);
            if (newExport != oldExport && exportsArray == null) {
                exportsArray = new ImmutableExport[this.exports.size()];
                for (int j = 0; j < i; ++j) {
                    exportsArray[j] = this.exports.get(j);
                }
            }
            if (exportsArray == null) continue;
            exportsArray[i] = newExport;
        }
        if (this.d == d && nodesArray == null && arcsArray == null && exportsArray == null) {
            return this;
        }
        CellRevision newRevision = this.with(d, nodesArray, arcsArray, exportsArray);
        return newRevision;
    }

    public ImmutableNodeInst getNodeById(int nodeId) {
        if (this.nodeIndex == null) {
            return nodeId < this.nodes.size() ? this.nodes.get(nodeId) : null;
        }
        if (nodeId >= this.nodeIndex.length) {
            return null;
        }
        int nodeInd = this.nodeIndex[nodeId];
        return nodeInd >= 0 ? this.nodes.get(nodeInd) : null;
    }

    public int getNodeIndexByNodeId(int nodeId) {
        int nodeInd;
        int n = nodeInd = this.nodeIndex != null ? this.nodeIndex[nodeId] : nodeId;
        assert (0 <= nodeInd && nodeInd < this.nodes.size());
        return nodeInd;
    }

    public boolean hasNodeWithId(int nodeId) {
        if (nodeId < 0) {
            throw new IllegalArgumentException();
        }
        if (this.nodeIndex != null) {
            return nodeId < this.nodeIndex.length && this.nodeIndex[nodeId] >= 0;
        }
        return nodeId < this.nodes.size();
    }

    public int getMaxNodeId() {
        return (this.nodeIndex != null ? this.nodeIndex.length : this.nodes.size()) - 1;
    }

    public ImmutableArcInst getArcById(int arcId) {
        if (this.arcIndex == null) {
            return arcId < this.arcs.size() ? this.arcs.get(arcId) : null;
        }
        if (arcId >= this.arcIndex.length) {
            return null;
        }
        int arcInd = this.arcIndex[arcId];
        return arcInd >= 0 ? this.arcs.get(arcInd) : null;
    }

    public int getArcIndexByArcId(int arcId) {
        int arcInd;
        int n = arcInd = this.arcIndex != null ? this.arcIndex[arcId] : arcId;
        assert (0 <= arcInd && arcInd < this.arcs.size());
        return arcInd;
    }

    public int getMaxArcId() {
        return (this.arcIndex != null ? this.arcIndex.length : this.arcs.size()) - 1;
    }

    public ImmutableExport getExport(ExportId exportId) {
        if (exportId.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = exportId.chronIndex;
        if (chronIndex >= this.exportIndex.length) {
            return null;
        }
        int portIndex = this.exportIndex[chronIndex];
        return portIndex >= 0 ? this.exports.get(portIndex) : null;
    }

    public int getExportIndexByExportId(ExportId exportId) {
        if (exportId.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = exportId.chronIndex;
        return chronIndex < this.exportIndex.length ? this.exportIndex[chronIndex] : -1;
    }

    public int getMaxExportChronIndex() {
        return this.exportIndex.length - 1;
    }

    public int[] getInstCounts() {
        int l;
        for (l = this.cellUsages.length; l > 0 && (this.cellUsages[l - 1] == null || this.cellUsages[l - 1].instCount == 0); --l) {
        }
        if (l == 0) {
            return NULL_INT_ARRAY;
        }
        int[] instCounts = new int[l];
        for (int indexInParent = 0; indexInParent < l; ++indexInParent) {
            if (this.cellUsages[indexInParent] == null) continue;
            instCounts[indexInParent] = this.cellUsages[indexInParent].instCount;
        }
        return instCounts;
    }

    public int getInstCount(CellUsage u) {
        if (u.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        if (u.indexInParent >= this.cellUsages.length) {
            return 0;
        }
        CellUsageInfo cui = this.cellUsages[u.indexInParent];
        if (cui == null) {
            return 0;
        }
        return cui.instCount;
    }

    public Set<TechId> getTechUsages() {
        LinkedHashSet<TechId> techUsagesSet = new LinkedHashSet<TechId>();
        for (int techIndex = 0; techIndex < this.techUsages.length(); ++techIndex) {
            if (!this.techUsages.get(techIndex)) continue;
            techUsagesSet.add(this.d.cellId.idManager.getTechId(techIndex));
        }
        return techUsagesSet;
    }

    public abstract List<ImmutableArcInst> getConnections(BitSet var1, ImmutableNodeInst var2, PortProtoId var3);

    public abstract boolean hasConnections(ImmutableNodeInst var1, PortProtoId var2);

    public abstract int getNumConnections(ImmutableNodeInst var1);

    public abstract boolean hasExportsOnNode(ImmutableNodeInst var1);

    public abstract int getNumExportsOnNode(int var1);

    public abstract Iterator<ImmutableExport> getExportsOnNode(int var1);

    public boolean pinUseCount(ImmutableNodeInst pin) {
        int numConnections = this.getNumConnections(pin);
        if (numConnections > 2) {
            return false;
        }
        if (this.hasExportsOnNode(pin)) {
            return true;
        }
        return numConnections != 0;
    }

    void write(IdWriter writer) throws IOException {
        this.d.write(writer);
        writer.writeInt(this.nodes.size());
        for (ImmutableNodeInst n : this.nodes) {
            n.write(writer);
        }
        writer.writeInt(this.arcs.size());
        for (ImmutableArcInst a : this.arcs) {
            a.write(writer);
        }
        writer.writeInt(this.exports.size());
        for (ImmutableExport e : this.exports) {
            e.write(writer);
        }
    }

    static CellRevision read(IdReader reader) throws IOException {
        ImmutableCell d = ImmutableCell.read(reader);
        CellRevision revision = CellRevision.newInstance(d.withoutVariables());
        int nodesLength = reader.readInt();
        ImmutableNodeInst[] nodes = new ImmutableNodeInst[nodesLength];
        for (int i = 0; i < nodesLength; ++i) {
            nodes[i] = ImmutableNodeInst.read(reader);
        }
        int arcsLength = reader.readInt();
        ImmutableArcInst[] arcs = new ImmutableArcInst[arcsLength];
        for (int i = 0; i < arcsLength; ++i) {
            arcs[i] = ImmutableArcInst.read(reader);
        }
        int exportsLength = reader.readInt();
        ImmutableExport[] exports = new ImmutableExport[exportsLength];
        for (int i = 0; i < exportsLength; ++i) {
            exports[i] = ImmutableExport.read(reader);
        }
        revision = revision.with(d, nodes, arcs, exports);
        return revision;
    }

    public void check() {
        this.d.check();
        CellId cellId = this.d.cellId;
        boolean busNamesAllowed = this.d.busNamesAllowed();
        BitSet checkTechUsages = new BitSet();
        checkTechUsages.set(this.d.techId.techIndex);
        int[] checkCellUsages = this.getInstCounts();
        ImmutableNodeInst.checkList(this.nodes);
        boolean hasCellCenter = false;
        if (this.nodeIndex != null && this.nodeIndex.length > 0) {
            assert (this.nodeIndex[this.nodeIndex.length - 1] >= 0);
            for (int nodeId = 0; nodeId < this.nodeIndex.length; ++nodeId) {
                int nodeInd = this.nodeIndex[nodeId];
                if (nodeInd != -1) assert (this.nodes.get((int)nodeInd).nodeId == nodeId);
            }
        }
        int nodeInd = 0;
        for (ImmutableNodeInst n : this.nodes) {
            assert (this.nodeIndex == null ? n.nodeId == nodeInd : this.nodeIndex[n.nodeId] == nodeInd);
            assert (this.getNodeById(n.nodeId) == n);
            if (ImmutableNodeInst.isCellCenter(n.protoId)) {
                assert (!hasCellCenter);
                hasCellCenter = true;
            }
            assert (busNamesAllowed || !n.name.isBus());
            if (n.protoId instanceof CellId) {
                CellId subCellId = (CellId)n.protoId;
                CellUsage u = cellId.getUsageIn(subCellId);
                int n2 = u.indexInParent;
                checkCellUsages[n2] = checkCellUsages[n2] - 1;
                CellUsageInfo cui = this.cellUsages[u.indexInParent];
                assert (cui != null);
                for (int j = 0; j < n.ports.length; ++j) {
                    ImmutablePortInst pid = n.ports[j];
                    if (pid == ImmutablePortInst.EMPTY) continue;
                    this.checkPortInst(n, subCellId.getPortId(j));
                }
                if (subCellId.isIcon()) {
                    for (Variable param2 : n.getDefinedParams()) {
                        assert (cui.usedAttributes.get((Variable.AttrKey)param2.getKey()) == param2.getUnit());
                    }
                    Iterator<Variable> it = n.getVariables();
                    while (it.hasNext()) {
                        Variable.Key varKey = it.next().getKey();
                        if (varKey.isAttribute()) assert (cui.usedAttributes.get(varKey) == null);
                    }
                }
            } else {
                TechId techId = ((PrimitiveNodeId)n.protoId).techId;
                checkTechUsages.set(techId.techIndex);
            }
            ++nodeInd;
        }
        for (int i = 0; i < checkCellUsages.length; ++i) {
            assert (checkCellUsages[i] == 0);
        }
        ImmutableArcInst.checkList(this.arcs);
        if (this.arcIndex != null && this.arcIndex.length > 0) {
            assert (this.arcIndex[this.arcIndex.length - 1] >= 0);
            for (int arcId = 0; arcId < this.arcIndex.length; ++arcId) {
                int arcInd = this.arcIndex[arcId];
                if (arcInd != -1) assert (this.arcs.get((int)arcInd).arcId == arcId);
            }
        }
        int arcInd = 0;
        for (ImmutableArcInst a : this.arcs) {
            assert (this.arcIndex == null ? a.arcId == arcInd : this.arcIndex[a.arcId] == arcInd);
            assert (this.getArcById(a.arcId) == a);
            assert (busNamesAllowed || !a.name.isBus());
            this.checkPortInst(this.getNodeById(a.tailNodeId), a.tailPortId);
            this.checkPortInst(this.getNodeById(a.headNodeId), a.headPortId);
            checkTechUsages.set(a.protoId.techId.techIndex);
            ++arcInd;
        }
        ImmutableExport.checkList(this.exports);
        if (this.exportIndex.length > 0) {
            assert (this.exportIndex[this.exportIndex.length - 1] >= 0);
            for (int chronIndex = 0; chronIndex < this.exportIndex.length; ++chronIndex) {
                int exportInd = this.exportIndex[chronIndex];
                if (exportInd != -1) assert (this.exports.get((int)exportInd).exportId.chronIndex == chronIndex);
            }
        }
        assert (this.exportIndex.length == this.definedExportsLength);
        assert (this.definedExports.length() == this.definedExportsLength);
        int exportInd = 0;
        for (ImmutableExport e : this.exports) {
            assert (e.exportId.parentId == cellId);
            assert (this.exportIndex[e.exportId.chronIndex] == exportInd);
            assert (busNamesAllowed || !e.name.isBus());
            this.checkPortInst(this.getNodeById(e.originalNodeId), e.originalPortId);
            ++exportInd;
        }
        int exportCount = 0;
        for (int chronIndex = 0; chronIndex < this.exportIndex.length; ++chronIndex) {
            int portIndex = this.exportIndex[chronIndex];
            if (portIndex == -1) {
                assert (!this.definedExports.get(chronIndex));
                continue;
            }
            assert (this.definedExports.get(chronIndex));
            ++exportCount;
            assert (this.exports.get((int)portIndex).exportId.chronIndex == chronIndex);
        }
        assert (this.exports.size() == exportCount);
        BitSet checkDeleted = new BitSet();
        checkDeleted.set(0, this.definedExportsLength);
        checkDeleted.andNot(this.definedExports);
        assert (this.deletedExports.equals(checkDeleted));
        if (this.definedExports.isEmpty()) assert (this.definedExports == EMPTY_BITSET);
        if (this.deletedExports.isEmpty()) assert (this.deletedExports == EMPTY_BITSET);
        assert (this.techUsages.equals(checkTechUsages));
        if (this.d.cellId.isIcon()) assert (this.cellUsages.length == 0);
        for (int i = 0; i < this.cellUsages.length; ++i) {
            CellUsageInfo cui = this.cellUsages[i];
            if (cui == null) continue;
            cui.check(this.d.cellId.getUsageIn(i));
        }
    }

    private void checkPortInst(ImmutableNodeInst node, PortProtoId portId) {
        assert (node != null);
        assert (portId.getParentId() == node.protoId);
        if (portId instanceof ExportId) {
            this.checkExportId((ExportId)portId);
        }
    }

    private void checkExportId(ExportId exportId) {
        CellUsage u = this.d.cellId.getUsageIn(exportId.getParentId());
        assert (this.cellUsages[u.indexInParent].usedExports.get(exportId.getChronIndex()));
    }

    public boolean sameExports(CellRevision thatRevision) {
        if (thatRevision == this) {
            return true;
        }
        if (this.exports.size() != thatRevision.exports.size()) {
            return false;
        }
        for (int i = 0; i < this.exports.size(); ++i) {
            if (this.exports.get((int)i).exportId == thatRevision.exports.get((int)i).exportId) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.d.toString();
    }
}

