/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.IntegerUtil;
import org.gnunet.construct.parsers.Parser;

public class IntegerParser
implements Parser {
    public static final boolean UNSIGNED = false;
    public static final boolean SIGNED = true;
    private final int byteSize;
    private final boolean isSigned;
    private final ReflectUtil.NumField targetField;

    public IntegerParser(int byteSize, boolean isSigned, Field f) {
        this.byteSize = byteSize;
        this.isSigned = isSigned;
        this.targetField = new ReflectUtil.NumField(f);
    }

    @Override
    public int getSize(Message srcObj) {
        return this.byteSize;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        try {
            if (this.targetField.isBig()) {
                this.targetField.set((Object)dstObj, IntegerUtil.readBigInteger(srcBuf, this.isSigned, this.byteSize));
            } else {
                this.targetField.set((Object)dstObj, IntegerUtil.readLong(srcBuf, this.isSigned, this.byteSize));
            }
        }
        catch (BufferUnderflowException e) {
            throw new ProtocolViolationException("Underflow while parsing " + this.targetField);
        }
        return this.byteSize;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        if (this.targetField.isBig()) {
            IntegerUtil.writeBitInteger(this.targetField.getBig(srcObj), dstBuf, this.isSigned, this.byteSize);
        } else {
            IntegerUtil.writeLong(this.targetField.get(srcObj), dstBuf, this.isSigned, this.byteSize);
        }
        return this.byteSize;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
    }

    @Override
    public int getStaticSize() {
        return this.byteSize;
    }
}

