/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class SequenceParser
implements Parser {
    private final List<Parser> childParsers = new LinkedList<Parser>();
    private List<Field> myFrameSizePath;

    public void add(Parser p) {
        this.childParsers.add(p);
    }

    @Override
    public int getSize(Message src) {
        int size = 0;
        for (Parser p : this.childParsers) {
            size += p.getSize(src);
        }
        return size;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dst, List<Field> frameSizePath) {
        int size = 0;
        for (Parser p : this.childParsers) {
            try {
                size += p.parse(srcBuf, frameOffset, frameObj, dst, frameSizePath == null ? this.myFrameSizePath : frameSizePath);
            }
            catch (ProtocolViolationException e) {
                throw e.augmentPath("(sequence parser)");
            }
        }
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        int size = 0;
        for (Parser p : this.childParsers) {
            size += p.write(dstBuf, src);
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        if (this.myFrameSizePath != null) {
            ReflectUtil.justSetInt(frameObj, this.myFrameSizePath, frameSize);
        }
        for (Parser p : this.childParsers) {
            p.patch(m, frameSize, frameSizePath == null ? this.myFrameSizePath : frameSizePath, frameObj);
        }
    }

    @Override
    public int getStaticSize() {
        int accum = 0;
        for (Parser p : this.childParsers) {
            accum += p.getStaticSize();
        }
        return accum;
    }

    public void setFrameSizePath(List<Field> frameSizePath) {
        this.myFrameSizePath = frameSizePath;
    }
}

