/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.IntegerUtil;
import org.gnunet.construct.parsers.Parser;

public class VariableSizeIntegerArrayParser
implements Parser {
    private final Field targetField;
    private ReflectUtil.NumField sizeField;
    private int byteSize;
    private boolean signed;

    public VariableSizeIntegerArrayParser(Field sizeField, Field arrayField, boolean signed, int byteSize) {
        this.targetField = arrayField;
        this.sizeField = new ReflectUtil.NumField(sizeField);
        this.signed = signed;
        this.byteSize = byteSize;
    }

    @Override
    public int getSize(Message src) {
        Object arr = ReflectUtil.justGet(src, this.targetField);
        if (arr == null) {
            throw new RuntimeException("array not initialized");
        }
        return Array.getLength(arr) * this.byteSize;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int elemNumber = (int)this.sizeField.get(dstObj);
        Class<?> arrayElementType = this.targetField.getType().getComponentType();
        if (!arrayElementType.isPrimitive()) {
            throw new AssertionError((Object)("VariableSizeIntegerArray is expected to be of primitive type, not " + arrayElementType));
        }
        Object arr = Array.newInstance(arrayElementType, elemNumber);
        ReflectUtil.justSet(dstObj, this.targetField, arr);
        for (int i = 0; i < elemNumber; ++i) {
            long v = IntegerUtil.readLong(srcBuf, this.signed, this.byteSize);
            ReflectUtil.justSetArray(arr, i, v);
        }
        return this.byteSize * elemNumber;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        int size = 0;
        Object arr = ReflectUtil.justGet(src, this.targetField);
        for (int i = 0; i < Array.getLength(arr); ++i) {
            IntegerUtil.writeLong(ReflectUtil.justGetArrayLong(arr, i), dstBuf, this.signed, this.byteSize);
            size += this.byteSize;
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        int size = Array.getLength(ReflectUtil.justGet(m, this.targetField));
        this.sizeField.set((Object)m, size);
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

