/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import org.gnunet.construct.Construct;
import org.gnunet.construct.Message;
import org.gnunet.construct.NestedMessage;
import org.gnunet.util.crypto.ContentWithPurposeMessage;
import org.gnunet.util.crypto.EddsaPrivateKey;
import org.gnunet.util.crypto.EddsaPublicKey;
import org.gnunet.util.crypto.EddsaSignature;
import org.gnunet.util.crypto.SignedContentMessage;

public class EddsaSignedMessage
implements Message {
    @NestedMessage
    public EddsaSignature signature;
    @NestedMessage(newFrame=true)
    public ContentWithPurposeMessage cpm;

    public EddsaSignedMessage() {
    }

    public boolean verify(EddsaPublicKey signerPublicKey, Class<? extends SignedContentMessage> expectedClass) {
        if (!expectedClass.isInstance(this.cpm.m)) {
            return false;
        }
        byte[] data = Construct.toBinary(this.cpm);
        return this.signature.verifyRaw(data, signerPublicKey);
    }

    public EddsaSignedMessage(SignedContentMessage message, EddsaPrivateKey privateKey, EddsaPublicKey publicKey) {
        this.cpm = new ContentWithPurposeMessage();
        this.cpm.m = message;
        Construct.patch(this.cpm);
        byte[] data = Construct.toBinary(this.cpm);
        this.signature = privateKey.signRaw(publicKey, data);
    }

    public EddsaSignedMessage(SignedContentMessage message, EddsaPrivateKey privateKey) {
        this(message, privateKey, privateKey.getPublicKey());
    }
}

