/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.dialogs;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.buildins.dialogs.Predicate_dialog;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class TermFileFilter
extends FileFilter {
    protected String description;
    protected Set<String> extension = new HashSet<String>();

    public TermFileFilter(Term term) throws PrologException {
        String pattern = null;
        if (term instanceof AtomTerm) {
            pattern = ((AtomTerm)term).value;
            if ("prolog".equals(pattern)) {
                pattern = "*.pro;*.pl";
                this.description = "Prolog files";
            }
        } else if (term instanceof CompoundTerm && ((CompoundTerm)term).tag.arity == 1) {
            pattern = ((CompoundTerm)term).tag.functor.value;
            term = ((CompoundTerm)term).args[0].dereference();
            if (term instanceof AtomTerm) {
                this.description = ((AtomTerm)term).value;
            } else {
                PrologException.typeError(TermConstants.atomAtom, term);
            }
        } else {
            PrologException.domainError(Predicate_dialog.DIALOG_OPTION_ATOM, term);
        }
        Matcher m = Pattern.compile("(\\*(\\.[^;]*);?)", 2).matcher(pattern);
        while (m.find()) {
            this.extension.add(m.group(2));
        }
        if (this.extension.isEmpty()) {
            PrologException.domainError(Predicate_dialog.FILEMASK_TAG.functor, term);
        }
        this.description = this.description == null || this.description.length() == 0 ? pattern : String.format("%s (%s)", this.description, pattern);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (String pat : this.extension) {
            if (!f.getName().toLowerCase().endsWith(pat)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

