/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Simple demo of a multiplier used as a mixer.
 */

#include <VrSigSource.h>
#include <GrFFTSink.h>
#include <VrNullSink.h>
#include <GrMultiply.h>
#include <VrSum.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include "VrGUI.h" 

#define SAMPLING_FREQUENCY                          5e6
#define	MAX_FREQUENCY		(SAMPLING_FREQUENCY / 2)
#define	SIG_GEN_F1				   40e3
#define CARRIER_FREQ	          	        1.070e6	// AM 1070
#define AMPLITUDE                                   1.0
#define WAVEFORM                            VR_SIN_WAVE


#define IOTYPE float

VrSigSource<IOTYPE> *carrier;

void set_my_freq(double f) {
  cerr << "@@@ set_my_freq: " << f << '\n';
  carrier->setFrequency(f);
}

int main(int argc, char **argv) {
  GrFFTSink<IOTYPE> *sink;
  VrMultiTask *m = new VrMultiTask ();
  
  VrSigSource<IOTYPE> *f1 =
    new VrSigSource<IOTYPE>(SAMPLING_FREQUENCY, WAVEFORM, SIG_GEN_F1, AMPLITUDE);
  
  carrier =
    new VrSigSource<IOTYPE>(SAMPLING_FREQUENCY, WAVEFORM, CARRIER_FREQ, 2*AMPLITUDE);

  GrMultiply<IOTYPE,IOTYPE> *mult = new GrMultiply<IOTYPE,IOTYPE>();


  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  sink = new GrFFTSink<IOTYPE>(vert, 300, 450, 1024);

  m->add (sink);

  (void) new VrGUINumber(horiz, "Carrier", "Frequency (Hz)", set_my_freq,
			 MAX_FREQUENCY, CARRIER_FREQ);


  // now wire it all together from the sink, back to the sources
  
  NWO_CONNECT (f1, mult);
  NWO_CONNECT (carrier, mult);
  NWO_CONNECT (mult, sink);

  m->start();
  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
