/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRPULSE_H_
#define _VRPULSE_H_

#include <VrDecimatingSigProc.h>
#include <VrComplex.h>

template<class iType, class oType> 
class VrPulse : public VrDecimatingSigProc<iType,oType> {
protected:
public: 
  VrPulse() : VrDecimatingSigProc<iType, oType>() {}
  VrPulse(int outputs) : VrDecimatingSigProc<iType, oType>(outputs) {}
  VrPulse(int outputs, int dec) : VrDecimatingSigProc<iType, oType>(outputs, dec) {}
  virtual ~VrPulse() {}
  virtual float getSymbol_Period() = 0;
  virtual int setSymbol_Period(float) = 0;
  virtual int setSymbol_Timing(float) = 0;
  virtual void start_oversampling(int, int,int,VrComplex*,int*) = 0;
  virtual int version() = 0;
};
#endif
