/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef INCLUDED_GR_SIMPLE_CORRELATOR_H
#define INCLUDED_GR_SIMPLE_CORRELATOR_H

#include <gr_block.h>

class gr_simple_correlator;
typedef boost::shared_ptr<gr_simple_correlator> gr_simple_correlator_sptr;

gr_simple_correlator_sptr gr_make_simple_correlator (int payload_bytesize);

/*!
 * \brief inverse of gr_simple_framer (more or less)
 * \ingroup block
 *
 * TAPR DCC-2004 demo...
 */
class gr_simple_correlator : public gr_block
{
  static const int OVERSAMPLE = 8;
  enum state_t { ST_LOOKING, ST_LOCKED };
  
  int	  	 d_payload_bytesize;
  state_t	 d_state;
  int		 d_seqno;
  unsigned char *d_buf;
  int		 d_bufsize;
  int		 d_bi;			// buffer index
  unsigned char	*d_pktbuf;
  int		 d_best_fit;		// [0,7]
  unsigned int	 d_shift_reg[OVERSAMPLE];

  friend gr_simple_correlator_sptr gr_make_simple_correlator (int payload_bytesize);
  gr_simple_correlator (int payload_bytesize);

  void enter_locked ();
  void enter_looking ();
  
 public:
  ~gr_simple_correlator ();

  int general_work (int noutput_items,
		    gr_vector_int &ninput_items,
		    gr_vector_const_void_star &input_items,
		    gr_vector_void_star &output_items);
};


#endif /* INCLUDED_GR_SIMPLE_CORRELATOR_H */
