# FFmpeg project

## Organisation

The FFmpeg project is organized through a community working on global consensus.

Decisions are taken by the ensemble of active members, through voting and
are aided by two committees.

## General Assembly

The ensemble of active members is called the General Assembly (GA).

The General Assembly is sovereign and legitimate for all its decisions
regarding the FFmpeg project.

The General Assembly is made up of active contributors.

Contributors are considered "active contributors" if they have pushed more
than 20 patches in the last 36 months in the main FFmpeg repository, or
if they have been voted in by the GA.

Additional members are added to the General Assembly through a vote after
proposal by a member of the General Assembly.
They are part of the GA for two years, after which they need a confirmation by
the GA.

## Voting

Voting is done using a ranked voting system, currently running on https://vote.ffmpeg.org/ .

Majority vote means more than 50% of the expressed ballots.

## Technical Committee

The Technical Committee (TC) is here to arbitrate and make decisions when
technical conflicts occur in the project.
They will consider the merits of all the positions, judge them and make a
decision.

The TC resolves technical conflicts but is not a technical steering committee.

Decisions by the TC are binding for all the contributors.

Decisions made by the TC can be re-opened after 1 year or by a majority vote
of the General Assembly, requested by one of the member of the GA.

The TC is elected by the General Assembly for a duration of 1 year, and
is composed of 5 members.
Members can be re-elected if they wish. A majority vote in the General Assembly
can trigger a new election of the TC.

The members of the TC can be elected from outside of the GA.
Candidates for election can either be suggested or self-nominated.

The conflict resolution process is detailed in the [resolution process](resolution_process.md) document.

## Community committee

The Community Committee (CC) is here to arbitrage and make decisions when
inter-personal conflicts occur in the project. It will decide quickly and
take actions, for the sake of the project.

The CC can remove privileges of offending members, including removal of
commit access and temporary ban from the community.

Decisions made by the CC can be re-opened after 1 year or by a majority vote
of the General Assembly. Indefinite bans from the community must be confirmed
by the General Assembly, in a majority vote.

The CC is elected by the General Assembly for a duration of 1 year, and is
composed of 5 members.
Members can be re-elected if they wish. A majority vote in the General Assembly
can trigger a new election of the CC.

The members of the CC can be elected from outside of the GA.
Candidates for election can either be suggested or self-nominated.

The CC is governed by and responsible for enforcing the Code of Conduct.
