/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Class[] staticLib;
    private Class[] dynamicLib;
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;

    public Library(Class[] staticLib, Class[] dynamicLib) {
        this.staticLib = staticLib;
        this.dynamicLib = dynamicLib;
        this.rehash();
    }

    private String describe(String name, Class[] params) {
        String res = "";
        StringBuffer invp = new StringBuffer();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
                ++k;
            }
        }
        invp.append(')');
        res = invp.toString();
        return res;
    }

    int getDynamicMethodClassID(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return -1;
        }
        Integer id = (Integer)this.dynIDs.get(m);
        return id;
    }

    Method getMethod(String name, Class[] params) throws NoSuchMethodException {
        Hashtable signatures = (Hashtable)this.names.get(name);
        if (signatures == null) {
            throw new NoSuchMethodException("There is no function \"" + name + "\" defined.");
        }
        Vector<Method> applicable_methods = new Vector<Method>();
        Enumeration e = signatures.elements();
        while (e.hasMoreElements()) {
            Method cm = (Method)e.nextElement();
            Class<?>[] cp = cm.getParameterTypes();
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    int i = 0;
                    while (i < cp.length && applicable) {
                        applicable = ExpressionImage.canConvertByWidening(params[i], cp[i]);
                        ++i;
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.addElement(cm);
        }
        if (applicable_methods.size() == 0) {
            throw new NoSuchMethodException("Function \"" + name + "\" exists," + " but parameters " + this.describe(name, params) + " can not be accepted by it.");
        }
        if (applicable_methods.size() == 1) {
            return (Method)applicable_methods.firstElement();
        }
        Enumeration e2 = applicable_methods.elements();
        Method most_specific = (Method)e2.nextElement();
        Class[] most_specific_params = most_specific.getParameterTypes();
        while (e2.hasMoreElements()) {
            Method cm = (Method)e2.nextElement();
            Class[] cp = cm.getParameterTypes();
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            int i = 0;
            while (i < cp.length) {
                moreSpecific = moreSpecific && ExpressionImage.canConvertByWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && ExpressionImage.canConvertByWidening(most_specific_params[i], cp[i]);
                ++i;
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(name, most_specific_params) + "\" and \"" + this.describe(name, cp) + "\" on invocation \"" + this.describe(name, params) + "\" .");
        }
        return most_specific;
    }

    public boolean isStateless(Method m) {
        return this.stateless.containsKey(m);
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Library.test(t);
        t.summarize();
    }

    public void markStateDependent(String name, Class[] params) throws NoSuchMethodException {
        Method m = this.getMethod(name, params);
        Object removed = this.stateless.remove(m);
        Debug.assert(removed != null, "State dependent function \"" + m.toString() + "\"is made state dependend again.");
    }

    private void rehash() {
        int i;
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (this.staticLib != null) {
            i = 0;
            while (i < this.staticLib.length) {
                Method[] ma = this.staticLib[i].getMethods();
                int j = 0;
                while (j < ma.length) {
                    if (Modifier.isStatic(ma[j].getModifiers()) && this.rehash(ma[j])) {
                        this.stateless.put(ma[j], Boolean.TRUE);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.dynamicLib != null) {
            i = 0;
            while (i < this.dynamicLib.length) {
                Integer dynID = new Integer(i);
                Method[] ma = this.dynamicLib[i].getMethods();
                int j = 0;
                while (j < ma.length) {
                    if (!Modifier.isStatic(ma[j].getModifiers()) && this.rehash(ma[j])) {
                        this.dynIDs.put(ma[j], dynID);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean rehash(Method m) {
        String name = m.getName();
        String signature = ExpressionImage.getSignature(m);
        Hashtable signatures = (Hashtable)this.names.get(name);
        if (signatures == null) {
            Hashtable<String, Method> signatures_new = new Hashtable<String, Method>();
            signatures_new.put(signature, m);
            this.names.put(name, signatures_new);
            return true;
        }
        Method conflicting_method = (Method)signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, m);
            return true;
        }
        Debug.println("Conflict was detected during the library initialization. Conflicting method \"" + name + signature + "\", conflicting " + " classes : " + conflicting_method.getDeclaringClass().getName() + " and " + m.getDeclaringClass().getName() + " .");
        return false;
    }

    public static void test(Tester t) {
        Class[] par1;
        Method mf;
        Class[] par;
        Library ll = null;
        Class<?> math = null;
        try {
            math = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        t.startTest("Creating the library of java.lang.Math");
        try {
            Library l;
            Class[] sl = new Class[]{math};
            ll = l = new Library(sl, null);
            t.testOK();
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(double)");
        try {
            par = new Class[]{Double.TYPE};
            mf = ll.getMethod("round", par);
            if (mf != null && mf.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(float)");
        try {
            par = new Class[]{Float.TYPE};
            mf = ll.getMethod("round", par);
            if (mf != null && mf.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = ll.getMethod("round", par);
            par1 = new Class[]{Float.TYPE};
            if (mf != null && mf.equals(math.getMethod("round", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            par = new Class[]{Byte.TYPE};
            mf = ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            par = new Class[]{Character.TYPE};
            mf = ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation min(char,float) best is min(float,float)");
        try {
            par = new Class[]{Character.TYPE, Float.TYPE};
            mf = ll.getMethod("min", par);
            par1 = new Class[]{Float.TYPE, Float.TYPE};
            if (mf != null && mf.equals(math.getMethod("min", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Checking assignment of state dependence ");
        try {
            ll.markStateDependent("random", null);
            if (!ll.isStateless(ll.getMethod("random", null))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }
}

