
;;; d-unspacify.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-unspacify.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unspacify functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun unspacify ()
  (interactive)
  (assert (eq major-mode 'dired-mode))
  (if (string= (safe-expand-file-name dired-directory) (safe-expand-file-name "~/"))
      (error "You cannot run this command on the HOME folder"))
  (let ((list (directory-files-no-dotdotdot default-directory t nil)))
    (unspacify--list list))
  (sit-for 1)
  (revert-buffer))



(defun unspacify--init-lists ()

  (let (file-list)

    (setq file-list (directory-files-deep "c:/mp3/" nil "\\.mp3"))

    (setq file-list (directory-files "c:/mp3-files/singles/" t "\\.mp3$"))

    (setq file-list (directory-files "c:/mp3-files/albums/" t))

    (setq file-list (directory-files "c:/mp3-files/singles/" t))

    (progn
      (setq file-list (directory-files "c:/mp3-files/singles/" t "&"))
      (setq file-name (car file-list)))))



;; (unspacify--list file-list)
;; (unspacify--list (directory-files-no-dotdotdot "~/" t nil))
;;
(defun unspacify--list (file-list)
  (let ((ptr   file-list)
        (count 0))
    (while ptr
      (let* ((old-file (car ptr))
             (new-file (unspacify--de-ampersand (unspacify--file old-file))))
        (when (and (not (string= old-file new-file))
                   (not (file-exists-p new-file)))
          ;;(debug)
          (rename-file old-file new-file)
          (incf count)
          ;;(message "old-file=%s new-file=%s" old-file new-file)
          ))
      (setq ptr (cdr ptr)))
    (message "Files processed = %d" count)))

;; (unspacify--file "d:/Java Development/MastJava2")
;; (unspacify--file "d:/Java Development/Mast Java2")
(defun unspacify--file (full-name)
  (let* ((file-part (file-name-nondirectory full-name))
         (dir-part  (file-name-directory    full-name))
         (i         0)
         (len       (length file-part)))
  (while (< i len)
    (if (or (eq (aref file-part i) ? )
            (eq (aref file-part i) ?_))
        (aset file-part i ?-))
    (incf i))
  (concat dir-part file-part)
  )
  )

;; (unspacify--de-ampersand "d:/Java Development/MastJava2/")
;; (unspacify--de-ampersand "d:/Java Development/asf&rex.txt")
(defun unspacify--de-ampersand (full-name)
  (let* ((file-part (file-name-nondirectory full-name))
         (dir-part  (file-name-directory    full-name))
         (new-fp    "")
         (i         0)
         (len       (length file-part)))
    (while (< i len)
      (let ((ch (aref file-part i)))
        (if (eq ch ?&)
            (setq new-fp (concat new-fp "and"))
          (setq new-fp (format "%s%c" new-fp ch))))
      (incf i))
    (concat dir-part new-fp)))



(provide 'd-unspacify)
;;; d-unspacify.el ends here
