/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Symbol;
import gnu.mapping.TrivialConstraint;

public class UnboundConstraint
extends Constraint {
    Environment environment;
    static UnboundConstraint instance;

    public static UnboundConstraint getInstance(Environment environment) {
        UnboundConstraint unboundConstraint;
        if (environment != null) {
            unboundConstraint = environment.unboundConstraint;
            if (unboundConstraint == null) {
                environment.unboundConstraint = unboundConstraint = new UnboundConstraint(environment);
            }
        } else {
            unboundConstraint = instance;
            if (unboundConstraint == null) {
                instance = unboundConstraint = new UnboundConstraint(null);
            }
        }
        return unboundConstraint;
    }

    public static UnboundConstraint getInstance(Symbol symbol) {
        Constraint constraint = symbol.constraint;
        if (constraint instanceof UnboundConstraint) {
            return (UnboundConstraint)symbol.constraint;
        }
        return UnboundConstraint.getInstance(constraint.getEnvironment(symbol));
    }

    public UnboundConstraint(Environment environment) {
        this.environment = environment;
    }

    public Object get(Symbol symbol, Object object2) {
        Object object3 = symbol.value;
        if (object3 == null && this.environment != null && this.environment.previous != null) {
            symbol.value = object3 = this.environment.previous.lookup(symbol.getName());
        }
        if (object3 != null) {
            return ((Symbol)object3).get();
        }
        return object2;
    }

    public boolean isBound(Symbol symbol) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Symbol symbol, Object object2) {
        Environment environment = this.getEnvironment(symbol);
        if (environment != null && environment.locked) {
            throw new IllegalStateException("attempt to modify variable: " + symbol.getName() + " locked environment");
        }
        Symbol symbol2 = symbol;
        synchronized (symbol2) {
            if (symbol.constraint == this) {
                symbol.setConstraint(TrivialConstraint.getInstance(environment));
            }
            symbol.constraint.set(symbol, object2);
        }
    }

    public Environment getEnvironment(Symbol symbol) {
        return this.environment;
    }
}

