/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Signal;
import gnu.lists.SeqPosition;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import java.io.IOException;

public final class Marker
extends SeqPosition {
    Buffer buffer;

    public final boolean isPoint() {
        return this.buffer != null && this.sequence == null;
    }

    public Marker() {
    }

    public Marker(Marker marker) {
        this.buffer = marker.buffer;
        if (this.buffer != null) {
            if (marker.isPoint()) {
                this.set(this.buffer, this.buffer.getDot(), true);
            } else {
                this.set(marker);
            }
        }
    }

    public Marker(Buffer buffer, int offset, boolean isAfter) {
        super(buffer, offset, isAfter);
        this.buffer = buffer;
    }

    public int getOffset() {
        if (this.buffer == null) {
            return -1;
        }
        if (this.isPoint()) {
            return this.buffer.getDot();
        }
        return this.nextIndex();
    }

    public int getPoint() {
        return 1 + this.getOffset();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setDot(int newPosition) {
        this.set(this.buffer, newPosition);
    }

    public void set(Buffer newBuffer, int newPosition) {
        if (this.isPoint()) {
            if (newBuffer != this.buffer) {
                String msg = newBuffer == null ? "Can't make point-marker point nowhere: " : "Can't change buffer of point-marker: ";
                throw new Error(msg + this);
            }
            this.buffer.setDot(newPosition);
        } else {
            if (this.sequence != null) {
                this.release();
            }
            this.sequence = null;
            if (newBuffer == null) {
                this.buffer = null;
                return;
            }
            if (newPosition < 0) {
                newPosition = 0;
            } else {
                int newLength = newBuffer.length();
                if (newPosition > newLength) {
                    newPosition = newLength;
                }
            }
            this.set(newBuffer, newPosition, false);
        }
    }

    public void removeChar(int count) {
        if (this.isPoint()) {
            this.buffer.removeChar(count);
        } else {
            this.buffer.removePos(this.ipos, count);
        }
    }

    public void insert(char[] data, int off, int len, Object style) {
        int point = this.getOffset();
        this.buffer.insert(data, off, len, style, this.ipos);
        this.setDot(point += len);
    }

    public void insert(String string, Object style) {
        int point = this.getOffset();
        if (this.isPoint()) {
            this.buffer.insert(string, style);
        } else {
            this.buffer.insert(string, style, this.ipos);
        }
        this.setDot(point += string.length());
    }

    public void insert(char ch, int count, Object style) {
        if (count < 0) {
            return;
        }
        int n = count > 500 ? 500 : count;
        StringBuffer sbuf = new StringBuffer(n);
        int i = n;
        while (--i >= 0) {
            sbuf.append(ch);
        }
        String str = sbuf.toString();
        while (true) {
            this.insert(str, style);
            if ((count -= n) == 0) break;
            if (count >= 500) continue;
            n = count;
            sbuf.setLength(n);
            str = sbuf.toString();
        }
    }

    public void forwardChar(int i) {
        int max;
        int point = this.getOffset();
        if (point + i > (max = this.buffer.maxDot())) {
            point = max;
            Signal.signal("End of buffer");
        }
        this.setDot(point += i);
    }

    public void backwardChar(int i) {
        int point = this.getOffset();
        if (point < i) {
            point = 0;
            Signal.signal("Beginning of buffer");
        }
        this.setDot(point -= i);
    }

    public int currentColumn() {
        return this.buffer.currentColumn(this.getOffset());
    }

    public int moveToColumn(int column, boolean force) {
        int lineStart = this.buffer.lineStartOffset(this.getOffset());
        InPort port = this.buffer.openReader(lineStart, this.buffer.maxDot() - lineStart);
        int resultColumn = 0;
        try {
            int offset;
            block6: {
                int width;
                offset = lineStart;
                do {
                    int ch;
                    if ((ch = port.read()) < 0 || ch == 10) {
                        if (force) {
                            // empty if block
                        }
                        break block6;
                    }
                    width = this.buffer.charWidth((char)ch, resultColumn);
                    ++offset;
                } while ((resultColumn += width) < column);
                if (resultColumn <= column || !force) {
                    // empty if block
                }
            }
            this.setDot(offset);
            return resultColumn;
        }
        catch (IOException ex) {
            throw new WrappedException(ex);
        }
    }

    public int forwardLine(int lines) {
        long value = this.buffer.forwardLine(lines, this.getOffset());
        this.setDot((int)value);
        return (int)(value >> 32);
    }

    public boolean isBeginningOfLine() {
        int offset = this.getOffset();
        return offset == 0 || this.buffer.charAt(offset - 1) == '\n';
    }

    public boolean isEndOfLine() {
        int offset = this.getOffset();
        return offset == this.buffer.length() || this.buffer.charAt(offset) == '\n';
    }

    public int hashCode() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.hashCode() ^ this.getOffset();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Marker)) {
            return false;
        }
        Marker m2 = (Marker)other;
        return this.buffer == m2.buffer && this.getOffset() == m2.getOffset();
    }

    public String toString() {
        if (this.buffer == null) {
            return "#<marker in no buffer>";
        }
        StringBuffer sbuf = new StringBuffer(80);
        sbuf.append("#<marker at ");
        sbuf.append(this.getPoint());
        sbuf.append(" in ");
        sbuf.append(this.buffer.getName());
        sbuf.append('>');
        return sbuf.toString();
    }
}

