/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Language;
import gnu.jemacs.buffer.SelfInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.lang.ELispReadTableEntry;
import gnu.jemacs.lang.Print;
import gnu.jemacs.lang.SaveExcursion;
import gnu.jemacs.lang.While;
import gnu.jemacs.lang.defcustom;
import gnu.jemacs.lang.defgroup;
import gnu.jemacs.lang.lambda;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReaderVector;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.LocationEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import javax.swing.text.Position;
import kawa.lang.Quote;
import kawa.repl;
import kawa.standard.Scheme;
import kawa.standard.begin;
import kawa.standard.fluid_let;
import kawa.standard.let;
import kawa.standard.not;

public class ELisp
extends Lisp2 {
    static boolean charIsInt = false;
    static final ELisp instance;
    public static final Environment elispEnvironment;
    static final AbstractFormat writeFormat;
    static final AbstractFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int c) {
        if (charIsInt) {
            return IntNum.make(c);
        }
        return Char.make((char)c);
    }

    public static Numeric asNumber(Object arg) {
        if (arg instanceof Char) {
            return IntNum.make(((Char)arg).intValue());
        }
        if (arg instanceof Position) {
            return IntNum.make(1 + ((Position)arg).getOffset());
        }
        return (Numeric)arg;
    }

    public static char asChar(Object x) {
        if (x instanceof Char) {
            return ((Char)x).charValue();
        }
        int i = x instanceof Numeric ? ((Numeric)x).intValue() : (x instanceof Position ? ((Position)x).getOffset() + 1 : -1);
        if (i < 0 || i > 65535) {
            throw new Signal("error", "not a character value");
        }
        return (char)i;
    }

    public String getName() {
        return "Emacs-Lisp";
    }

    ELisp() {
        this.environ = elispEnvironment;
    }

    private void initELisp() {
        try {
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.jemacs.lang.NumberOps");
            this.loadClass("gnu.jemacs.lang.MiscOps");
            this.defProcStFld("emacs", "gnu.jemacs.buffer.emacs");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        this.defSntxStFld("if", "gnu.jemacs.lang.MiscOps", "if");
        this.defProcStFld("invoke", "gnu.kawa.reflect.Invoke", "invoke");
        this.defProcStFld("+", "gnu.jemacs.lang.AddOp", "$Pl");
        this.defProcStFld("-", "gnu.jemacs.lang.AddOp", "$Mn");
        this.defProcStFld("/", "gnu.jemacs.lang.DivideOp", "$Sl");
        this.defProcStFld("=", "gnu.jemacs.lang.NumberCompare", "$Eq");
        this.defProcStFld("<", "gnu.jemacs.lang.NumberCompare", "$Ls");
        this.defProcStFld(">", "gnu.jemacs.lang.NumberCompare", "$Gr");
        this.defProcStFld("<=", "gnu.jemacs.lang.NumberCompare", "$Ls$Eq");
        this.defProcStFld(">=", "gnu.jemacs.lang.NumberCompare", "$Gr$Eq");
        this.defun("self-insert-command", (Object)new SelfInsertCommand());
        lambda lambda2 = new lambda();
        lambda2.setKeywords(this.getSymbol("&optional"), this.getSymbol("&rest"), this.getSymbol("&key"));
        lambda2.defaultDefault = nilExpr;
        this.defun("lambda", (Object)lambda2);
        this.defun("defun", (Object)new defun(lambda2));
        this.defun("function", (Object)new function(lambda2));
        this.defun("quote", (Object)Quote.plainQuote);
        this.defun("defgroup", (Object)new defgroup());
        this.defun("defcustom", (Object)new defcustom());
        this.defun("defvar", (Object)new defvar(false));
        this.defun("defconst", (Object)new defvar(true));
        this.defun("defsubst", (Object)new defun(lambda2));
        this.defun("setq", (Object)new setq());
        this.defun("prog1", (Object)prog1.prog1);
        this.defun("prog2", (Object)prog1.prog2);
        this.defun("progn", (Object)new begin());
        this.defun("while", (Object)new While());
        this.defun("unwind-protect", (Object)new UnwindProtect());
        this.defun("save-excursion", (Object)new SaveExcursion(false));
        this.defun("save-current-buffer", (Object)new SaveExcursion(true));
        this.defun("let", (Object)new fluid_let(false, nilExpr));
        this.defun("%let", (Object)let.let);
        this.defun("let*", (Object)new fluid_let(true, nilExpr));
        this.defProcStFld("concat", "kawa.lib.strings", "string$Mnappend");
        not not2 = new not(this);
        this.defun("not", (Object)not2);
        this.defun("null", (Object)not2);
        this.defun("eq", (Object)new IsEq(this, "eq"));
        this.defun("equal", (Object)new IsEqual(this, "equal"));
        this.defun("typep", (Object)new InstanceOf(this));
        this.defun("princ", (Object)displayFormat);
        this.defun("prin1", (Object)writeFormat);
        LocationEnumeration e = Scheme.builtin().enumerateAllLocations();
        while (e.hasMoreElements()) {
            this.importLocation(e.nextLocation());
        }
        try {
            this.loadClass("gnu.jemacs.lisp.primitives");
            this.loadClass("gnu.jemacs.buffer.emacs");
            this.loadClass("gnu.jemacs.lisp.simple");
            this.loadClass("gnu.jemacs.lisp.autoloads");
            this.loadClass("gnu.jemacs.lisp.keymap");
            this.loadClass("gnu.jemacs.lisp.editfns");
            this.loadClass("gnu.jemacs.lisp.keydefs");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
    }

    public static ELisp getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(instance);
    }

    public AbstractFormat getFormat(boolean readable) {
        return readable ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String name) {
        if (name == "t") {
            name = "java.lang.Object";
        } else if (name == "marker") {
            name = "gnu.jemacs.buffer.Marker";
        } else if (name == "buffer") {
            name = "gnu.jemacs.buffer.Buffer";
        } else if (name == "window") {
            name = "gnu.jemacs.buffer.Window";
        }
        return Scheme.string2Type(name);
    }

    public Type getTypeFor(Class clas) {
        if (clas.isPrimitive()) {
            String name = clas.getName();
            if (name.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(name);
        }
        return Type.make(clas);
    }

    public ReadTable createReadTable() {
        ReadTable rt = super.createReadTable();
        rt.set(91, new ReaderVector(']'));
        rt.remove(93);
        rt.set(63, new ELispReadTableEntry(63));
        return rt;
    }

    public static void readableChar(char ch, StringBuffer buf, boolean quote) {
        if (quote && (ch == '\\' || ch == '\'' || ch == '\"')) {
            buf.append('\\');
            buf.append(ch);
        } else if (ch > '\u007f') {
            buf.append("\\u");
            String hex = Integer.toHexString(ch);
            for (int i = hex.length(); i < 4; ++i) {
                buf.append('0');
            }
            buf.append(hex);
        } else if (ch >= ' ') {
            buf.append(ch);
        } else if (ch == '\t') {
            buf.append("\\t");
        } else if (ch == '\r') {
            buf.append("\\r");
        } else if (ch == '\n') {
            buf.append("\\n");
        } else {
            buf.append("\\0");
            buf.append(ch >> 3 & 7);
            buf.append(ch & 7);
        }
    }

    public static String readableString(Object obj) {
        String str = obj.toString();
        StringBuffer buf = new StringBuffer(200);
        for (int i = 0; i < str.length(); ++i) {
            ELisp.readableChar(str.charAt(i), buf, false);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        repl.processArgs(new String[]{"--elisp"}, 0, 1);
        if (args.length == 0) {
            args = new String[]{"-e", "(emacs)", "--"};
        }
        repl.main(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        elispEnvironment = Environment.make("elisp-environment");
        instance = new ELisp();
        instance.define("t", TRUE);
        instance.define("nil", FALSE);
        CallContext ctx = CallContext.getInstance();
        Environment saveEnv = ctx.getEnvironmentRaw();
        try {
            ctx.setEnvironmentRaw(elispEnvironment);
            instance.initELisp();
        }
        finally {
            ctx.setEnvironmentRaw(saveEnv);
        }
        writeFormat = new Print(true);
        displayFormat = new Print(false);
    }
}

