/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.reflect.ArrayNew;
import gnu.kawa.reflect.ArraySet;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Language language;
    public static final Invoke invoke = new Invoke("invoke", '*');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');
    private PrimProcedure[] cacheMethods;
    private Expression[] cacheArgs;
    private int cacheDefinitelyApplicableMethodCount;
    private int cachePossiblyApplicableMethodCount;

    public Invoke(String name, char kind) {
        super(name);
        this.kind = kind;
        this.language = Language.getDefaultLanguage();
    }

    public Invoke(String name, char kind, Language language) {
        super(name);
        this.kind = kind;
        this.language = language;
    }

    public static Object invoke$V(Object[] args) throws Throwable {
        return invoke.applyN(args);
    }

    public static Object invokeStatic$V(Object[] args) throws Throwable {
        return invokeStatic.applyN(args);
    }

    public static Object make$V(Object[] args) throws Throwable {
        return make.applyN(args);
    }

    private static ObjectType typeFrom(Object arg, Invoke thisProc) {
        if (arg instanceof Class) {
            arg = Type.make((Class)arg);
        }
        if (arg instanceof ObjectType) {
            return (ObjectType)arg;
        }
        if (arg instanceof String || arg instanceof FString) {
            return ClassType.make(arg.toString());
        }
        if (arg instanceof Symbol) {
            return ClassType.make(((Symbol)arg).getName());
        }
        if (arg instanceof ClassNamespace) {
            return ((ClassNamespace)arg).getClassType();
        }
        throw new WrongType((Procedure)thisProc, 0, arg, "class-specifier");
    }

    public void apply(CallContext ctx) throws Throwable {
        Object[] args = ctx.getArgs();
        if (this.kind == 'S' || this.kind == 'V' || this.kind == 's' || this.kind == '*') {
            int nargs = args.length;
            Procedure.checkArgCount(this, nargs);
            Object arg0 = args[0];
            ClassType dtype = (ClassType)(this.kind == 'S' || this.kind == 's' ? Invoke.typeFrom(arg0, this) : Type.make(arg0.getClass()));
            MethodProc proc = this.lookupMethods(dtype, args[1]);
            Object[] margs = new Object[nargs - (this.kind == 'S' ? 2 : 1)];
            int i = 0;
            if (this.kind == 'V' || this.kind == '*') {
                margs[i++] = args[0];
            }
            System.arraycopy(args, 2, margs, i, nargs - 2);
            proc.checkN(margs, ctx);
        } else {
            ctx.writeValue(this.applyN(args));
        }
    }

    public Object applyN(Object[] args) throws Throwable {
        Object mname;
        ObjectType dtype;
        if (this.kind == 'P') {
            throw new RuntimeException(this.getName() + ": invoke-special not allowed at run time");
        }
        int nargs = args.length;
        Procedure.checkArgCount(this, nargs);
        Object arg0 = args[0];
        ObjectType objectType = dtype = this.kind != 'V' && this.kind != '*' ? Invoke.typeFrom(arg0, this) : (ObjectType)Type.make(arg0.getClass());
        if (this.kind == 'N') {
            Procedure constructor;
            mname = null;
            if (dtype instanceof TypeValue && (constructor = ((TypeValue)((Object)dtype)).getConstructor()) != null) {
                Object[] xargs = new Object[--nargs];
                System.arraycopy(args, 1, xargs, 0, nargs);
                return constructor.applyN(xargs);
            }
            if (dtype instanceof PairClassType) {
                PairClassType ptype = (PairClassType)dtype;
                dtype = ptype.instanceType;
            }
            if (dtype instanceof ArrayType) {
                boolean lengthSpecified;
                int i;
                int length;
                String name;
                Type elementType = ((ArrayType)dtype).getComponentType();
                int len = args.length - 1;
                if (len >= 2 && args[1] instanceof Keyword && ("length".equals(name = ((Keyword)args[1]).getName()) || "size".equals(name))) {
                    length = ((Number)args[2]).intValue();
                    i = 3;
                    lengthSpecified = true;
                } else {
                    length = len;
                    i = 1;
                    lengthSpecified = false;
                }
                Object arr = Array.newInstance(elementType.getReflectClass(), length);
                int index = 0;
                while (i <= len) {
                    Object arg = args[i];
                    if (lengthSpecified && arg instanceof Keyword && i < len) {
                        String kname = ((Keyword)arg).getName();
                        try {
                            index = Integer.parseInt(kname);
                        }
                        catch (Throwable ex) {
                            throw new RuntimeException("non-integer keyword '" + kname + "' in array constructor");
                        }
                        arg = args[++i];
                    }
                    Array.set(arr, index, elementType.coerceFromObject(arg));
                    ++index;
                    ++i;
                }
                return arr;
            }
        } else {
            mname = args[1];
        }
        MethodProc proc = this.lookupMethods((ClassType)dtype, mname);
        if (this.kind != 'N') {
            Object[] margs = new Object[nargs - (this.kind == 'S' || this.kind == 's' ? 2 : 1)];
            int i = 0;
            if (this.kind == 'V' || this.kind == '*') {
                margs[i++] = args[0];
            }
            System.arraycopy(args, 2, margs, i, nargs - 2);
            return proc.applyN(margs);
        }
        CallContext vars = CallContext.getInstance();
        int err = proc.matchN(args, vars);
        if (err == 0) {
            return vars.runUntilValue();
        }
        if ((nargs & 1) == 1) {
            for (int i = 1; i < nargs; i += 2) {
                if (args[i] instanceof Keyword) continue;
                throw MethodProc.matchFailAsException(err, proc, args);
            }
            Object result = proc.apply1(args[0]);
            for (int i = 1; i < nargs; i += 2) {
                Keyword key = (Keyword)args[i];
                Object arg = args[i + 1];
                SlotSet.apply(false, result, key.getName(), arg);
            }
            return result;
        }
        throw MethodProc.matchFailAsException(err, proc, args);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected MethodProc lookupMethods(ClassType dtype, Object name) {
        String mname;
        if (this.kind == 'N') {
            mname = "<init>";
        } else {
            if (name instanceof String || name instanceof FString) {
                mname = name.toString();
            } else if (name instanceof Symbol) {
                mname = ((Symbol)name).getName();
            } else {
                throw new WrongType((Procedure)this, 1, null);
            }
            mname = Compilation.mangleName(mname);
        }
        MethodProc proc = ClassMethods.apply(dtype, mname, (char)(this.kind == 'P' ? 80 : (this.kind == '*' || this.kind == 'V' ? 86 : 0)), this.language);
        if (proc == null) {
            throw new RuntimeException(this.getName() + ": no method named `" + mname + "' in class " + dtype.getName());
        }
        return proc;
    }

    protected PrimProcedure[] getMethods(ClassType ctype, String mname, Expression[] args, int margsLength, int argsStartIndex, int objIndex, ClassType caller) {
        if (args == this.cacheArgs) {
            return this.cacheMethods;
        }
        Type[] atypes = new Type[margsLength];
        int dst = 0;
        if (objIndex >= 0) {
            atypes[dst++] = ctype;
        }
        for (int src = argsStartIndex; src < args.length && dst < atypes.length; ++src, ++dst) {
            atypes[dst] = args[src].getType();
        }
        PrimProcedure[] methods = ClassMethods.getMethods(ctype, mname, this.kind == 'P' ? (char)'P' : (this.kind == '*' || this.kind == 'V' ? (char)'V' : '\u0000'), caller, this.language);
        long num = ClassMethods.selectApplicable(methods, atypes);
        this.cacheArgs = args;
        this.cacheDefinitelyApplicableMethodCount = (int)(num >> 32);
        this.cachePossiblyApplicableMethodCount = (int)num;
        this.cacheMethods = methods;
        return this.cacheMethods;
    }

    static Object[] checkKeywords(Type type, Expression[] args, int start, ClassType caller) {
        int len = args.length;
        if ((len - start & 1) != 0) {
            return null;
        }
        Object[] fields = new Object[len - start >> 1];
        int i = fields.length;
        while (--i >= 0) {
            Expression arg = args[start + 2 * i];
            if (!(arg instanceof QuoteExp)) {
                return null;
            }
            Object value = ((QuoteExp)arg).getValue();
            if (!(value instanceof Keyword)) {
                return null;
            }
            String name = ((Keyword)value).getName();
            Member slot = SlotSet.lookupMember((ClassType)type, name, caller);
            fields[i] = slot != null ? slot : name;
        }
        return fields;
    }

    public static int checkKnownClass(Type type, Compilation comp) {
        if (type instanceof ClassType && ((ClassType)type).isExisting()) {
            try {
                type.getReflectClass();
                return 1;
            }
            catch (Exception ex) {
                comp.error('e', "unknown class: " + type.getName());
                return -1;
            }
        }
        return 0;
    }

    public static ApplyExp inlineClassName(ApplyExp exp, int carg, InlineCalls walker) {
        Compilation comp = walker.getCompilation();
        Language language = comp.getLanguage();
        Expression[] args = exp.getArgs();
        if (args.length > carg) {
            Type type = language.getTypeFor(args[carg]);
            if (!(type instanceof Type)) {
                return exp;
            }
            Invoke.checkKnownClass(type, comp);
            Expression[] nargs = new Expression[args.length];
            System.arraycopy(args, 0, nargs, 0, args.length);
            nargs[carg] = new QuoteExp(type);
            ApplyExp nexp = new ApplyExp(exp.getFunction(), nargs);
            nexp.setLine(exp);
            return nexp;
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        block39: {
            int index;
            MethodProc[] methods;
            void var12_12;
            void var10_10;
            Expression[] args;
            block36: {
                int okCount;
                String name;
                ObjectType type;
                Compilation comp;
                block46: {
                    block47: {
                        StringBuffer errbuf;
                        Object[] slots;
                        Expression arg0;
                        block43: {
                            ApplyExp alloc2;
                            boolean lengthSpecified;
                            Type elementType;
                            ArrayType atype;
                            block38: {
                                int n;
                                block45: {
                                    block44: {
                                        block41: {
                                            block42: {
                                                ClassType caller;
                                                block40: {
                                                    Procedure constructor;
                                                    int nargs;
                                                    block37: {
                                                        void var15_22;
                                                        void var15_20;
                                                        Object arg1;
                                                        int objIndex;
                                                        int argsStartIndex;
                                                        int margsLength;
                                                        Type type0;
                                                        comp = walker.getCompilation();
                                                        args = exp.getArgs();
                                                        nargs = args.length;
                                                        if (!comp.mustCompile || nargs == 0 || (this.kind == 'V' || this.kind == '*') && nargs == 1) {
                                                            return exp;
                                                        }
                                                        arg0 = args[0];
                                                        Type type2 = type0 = this.kind == 'V' || this.kind == '*' ? arg0.getType() : this.language.getTypeFor(arg0);
                                                        type = type0 instanceof PairClassType ? ((PairClassType)type0).instanceType : (type0 instanceof ObjectType ? (ObjectType)type0 : null);
                                                        name = this.getMethodName(args);
                                                        if (this.kind == 'V' || this.kind == '*') {
                                                            margsLength = nargs - 1;
                                                            argsStartIndex = 2;
                                                            objIndex = 0;
                                                        } else if (this.kind == 'N') {
                                                            margsLength = nargs;
                                                            argsStartIndex = 0;
                                                            objIndex = -1;
                                                        } else if (this.kind == 'S' || this.kind == 's') {
                                                            margsLength = nargs - 2;
                                                            argsStartIndex = 2;
                                                            objIndex = -1;
                                                        } else {
                                                            if (this.kind != 'P') {
                                                                return exp;
                                                            }
                                                            margsLength = nargs - 2;
                                                            argsStartIndex = 3;
                                                            objIndex = 1;
                                                        }
                                                        if (this.kind != 'N' || !(type instanceof ArrayType)) break block37;
                                                        atype = (ArrayType)type;
                                                        elementType = atype.getComponentType();
                                                        Object var15_18 = null;
                                                        lengthSpecified = false;
                                                        if (args.length >= 3 && args[1] instanceof QuoteExp && (arg1 = ((QuoteExp)args[1]).getValue()) instanceof Keyword && ("length".equals(name = ((Keyword)arg1).getName()) || "size".equals(name))) {
                                                            Expression expression = args[2];
                                                            lengthSpecified = true;
                                                        }
                                                        if (var15_20 == null) {
                                                            QuoteExp quoteExp = QuoteExp.getInstance(new Integer(args.length - 1));
                                                        }
                                                        alloc2 = new ApplyExp(new ArrayNew(elementType), new Expression[]{var15_22});
                                                        if (lengthSpecified && args.length == 3) {
                                                            return alloc2;
                                                        }
                                                        break block38;
                                                    }
                                                    if (type == null || name == null) break block39;
                                                    if (type instanceof TypeValue && this.kind == 'N' && (constructor = ((TypeValue)((Object)type)).getConstructor()) != null) {
                                                        Expression[] xargs = new Expression[nargs];
                                                        System.arraycopy(args, 1, xargs, 0, nargs - 1);
                                                        return ((InlineCalls)walker).walkApplyOnly(new ApplyExp(constructor, xargs));
                                                    }
                                                    caller = comp == null ? null : (comp.curClass != null ? comp.curClass : comp.mainClass);
                                                    Invoke alloc2 = this;
                                                    synchronized (alloc2) {
                                                        try {
                                                            void var11_11;
                                                            methods = this.getMethods((ClassType)type, name, args, (int)var10_10, (int)var11_11, (int)var12_12, caller);
                                                        }
                                                        catch (Exception ex) {
                                                            comp.error('w', "unknown class: " + type.getName());
                                                            methods = null;
                                                        }
                                                        okCount = this.cacheDefinitelyApplicableMethodCount;
                                                        n = this.cachePossiblyApplicableMethodCount;
                                                        if (methods == null) break block39;
                                                    }
                                                    index = -1;
                                                    if (methods.length != 0) break block40;
                                                    if (comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                                                        comp.error('w', "no accessible method '" + name + "' in " + type.getName());
                                                    }
                                                    break block36;
                                                }
                                                if (okCount + n != 0) break block41;
                                                if (this.kind != 'N' || ClassMethods.selectApplicable((PrimProcedure[])methods, new Type[]{Compilation.typeClassType}) >> 32 != 1L || (slots = Invoke.checkKeywords(type, args, 1, caller)) == null) break block42;
                                                errbuf = null;
                                                break block43;
                                            }
                                            comp.error('w', "no possibly applicable method '" + name + "' in " + type.getName());
                                            break block36;
                                        }
                                        if (okCount != 1 && (okCount != 0 || n != 1)) break block44;
                                        index = 0;
                                        break block36;
                                    }
                                    if (okCount <= 0) break block45;
                                    index = MethodProc.mostSpecific(methods, okCount);
                                    if (index >= 0 || this.kind != 'S') break block46;
                                    break block47;
                                }
                                if (comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                                    StringBuffer sbuf = new StringBuffer();
                                    sbuf.append("more than one possibly applicable method '");
                                    sbuf.append(name);
                                    sbuf.append("' in ");
                                    sbuf.append(type.getName());
                                    this.append((PrimProcedure[])methods, n, sbuf);
                                    comp.error('w', sbuf.toString());
                                }
                                break block36;
                            }
                            LetExp let2 = new LetExp(new Expression[]{alloc2});
                            Declaration adecl = let2.addDeclaration(null, atype);
                            adecl.noteValue(alloc2);
                            BeginExp begin2 = new BeginExp();
                            int index2 = 0;
                            int i = lengthSpecified ? 3 : 1;
                            while (true) {
                                Object key;
                                if (i >= args.length) {
                                    begin2.add(new ReferenceExp(adecl));
                                    let2.body = begin2;
                                    return let2;
                                }
                                Expression arg = args[i];
                                if (lengthSpecified && i + 1 < args.length && arg instanceof QuoteExp && (key = ((QuoteExp)arg).getValue()) instanceof Keyword) {
                                    String kname = ((Keyword)key).getName();
                                    try {
                                        index2 = Integer.parseInt(kname);
                                        arg = args[++i];
                                    }
                                    catch (Throwable ex) {
                                        comp.error('e', "non-integer keyword '" + kname + "' in array constructor");
                                        return exp;
                                    }
                                }
                                begin2.add(new ApplyExp(new ArraySet(elementType), new Expression[]{new ReferenceExp(adecl), QuoteExp.getInstance(new Integer(index2)), arg}));
                                ++index2;
                                ++i;
                            }
                        }
                        for (int i = 0; i < slots.length; ++i) {
                            if (!(slots[i] instanceof String)) continue;
                            if (errbuf == null) {
                                errbuf = new StringBuffer();
                                errbuf.append("no field or setter ");
                            } else {
                                errbuf.append(", ");
                            }
                            errbuf.append('`');
                            errbuf.append(slots[i]);
                            errbuf.append('\'');
                        }
                        if (errbuf != null) {
                            errbuf.append(" in class ");
                            errbuf.append(type.getName());
                            comp.error('w', errbuf.toString());
                            break block36;
                        } else {
                            ApplyExp e = new ApplyExp(methods[0], new Expression[]{arg0});
                            int i = 0;
                            while (true) {
                                if (i >= slots.length) {
                                    return e.setLine(exp);
                                }
                                Expression[] sargs = new Expression[]{e, new QuoteExp(slots[i]), args[2 * i + 2]};
                                e = new ApplyExp(SlotSet.setFieldReturnObject, sargs);
                                ++i;
                            }
                        }
                    }
                    for (int i = 0; i < okCount; ++i) {
                        if (!((PrimProcedure)methods[i]).getStaticFlag()) continue;
                        if (index >= 0) {
                            index = -1;
                            break;
                        }
                        index = i;
                    }
                }
                if (index < 0 && comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("more than one definitely applicable method `");
                    sbuf.append(name);
                    sbuf.append("' in ");
                    sbuf.append(type.getName());
                    this.append((PrimProcedure[])methods, okCount, sbuf);
                    comp.error('w', sbuf.toString());
                }
            }
            if (index >= 0) {
                Expression[] margs = new Expression[var10_10];
                int dst = 0;
                if (var12_12 >= 0) {
                    margs[dst++] = args[var12_12];
                }
                for (void src = var11_11; src < args.length && dst < margs.length; ++src, ++dst) {
                    margs[dst] = args[src];
                }
                return new ApplyExp(methods[index], margs).setLine(exp);
            }
        }
        return exp;
    }

    private void append(PrimProcedure[] methods, int mcount, StringBuffer sbuf) {
        for (int i = 0; i < mcount; ++i) {
            sbuf.append("\n  candidate: ");
            sbuf.append(methods[i]);
        }
    }

    private String getMethodName(Expression[] args) {
        int nameIndex;
        if (this.kind == 'N') {
            return "<init>";
        }
        int n = nameIndex = this.kind == 'P' ? 2 : 1;
        if (args.length >= nameIndex + 1) {
            return ClassMethods.checkName(args[nameIndex], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType type, String name, Expression[] args) {
        PrimProcedure method = Invoke.getStaticMethod(type, name, args);
        if (method == null) {
            throw new RuntimeException("missing or ambiguous method `" + name + "' in " + type.getName());
        }
        return new ApplyExp(method, args);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType type, String name, Expression[] args) {
        MethodProc[] methods = invokeStatic.getMethods(type, name, args, args.length, 0, -1, null);
        int okCount = Invoke.invokeStatic.cacheDefinitelyApplicableMethodCount;
        int maybeCount = Invoke.invokeStatic.cachePossiblyApplicableMethodCount;
        int index = methods == null ? -1 : (okCount > 0 ? MethodProc.mostSpecific(methods, okCount) : (maybeCount == 1 ? 0 : -1));
        return index < 0 ? null : methods[index];
    }
}

