/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import gnu.text.URI_utils;
import gnu.xml.XMLFilter;
import gnu.xml.XMLParserChar;
import java.io.BufferedInputStream;
import java.io.IOException;

public class XMLParser
extends XMLParserChar
implements SourceLocator {
    XMLFilter filter;

    public XMLParser(LineBufferedReader reader, SourceMessages messages, Consumer out) {
        this(reader, new XMLFilter(out), messages);
    }

    public XMLParser(Object uri, SourceMessages messages, Consumer out) throws IOException {
        this(uri, messages, new XMLFilter(out), new LineBufferedReader(new BufferedInputStream(URI_utils.getInputStream(uri))));
    }

    private XMLParser(LineBufferedReader reader, XMLFilter resolver, SourceMessages messages) {
        super(null, 0, 0, resolver);
        this.filter = resolver;
        this.in = reader;
        resolver.setMessages(messages);
        resolver.setSourceLocator(this);
    }

    private XMLParser(Object uri, SourceMessages messages, XMLFilter resolver, LineBufferedReader lreader) throws IOException {
        this(lreader, resolver, messages);
        lreader.setName(uri);
    }

    public int fill(char[] buffer, int start, int pos) {
        LineBufferedReader reader = (LineBufferedReader)this.in;
        int saved = pos - start;
        try {
            if (saved > 0) {
                int skipped = reader.skip(start - reader.pos);
                reader.mark(saved + 1);
                skipped = reader.skip(saved);
            } else {
                reader.skip(pos - reader.pos);
            }
            int x = reader.read();
            if (x <= 0) {
                return -1;
            }
            if (saved > 0) {
                reader.reset();
                reader.skip(saved);
            } else {
                reader.unread_quick();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.pos = reader.pos;
        this.buffer = reader.buffer;
        return reader.limit - reader.pos;
    }

    public void error(char severity, String message) {
        LineBufferedReader reader = (LineBufferedReader)this.in;
        try {
            reader.skip(this.pos - reader.pos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.filter.error(severity, message);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return ((LineBufferedReader)this.in).getName();
    }

    public String getFileName() {
        return ((LineBufferedReader)this.in).getName();
    }

    public int getLineNumber() {
        int line = ((LineBufferedReader)this.in).getLineNumber();
        return line < 0 ? -1 : line + 1;
    }

    public int getColumnNumber() {
        int col = ((LineBufferedReader)this.in).getColumnNumber();
        return col < 0 ? -1 : col;
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

