/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.GenericProc;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.MethodFilter;
import gnu.lists.FString;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.util.Vector;

public class ClassMethods
extends Procedure2 {
    public static final ClassMethods classMethods = new ClassMethods();

    public Object apply2(Object object2, Object object3) {
        return ClassMethods.apply(this, object2, object3);
    }

    public static MethodProc apply(Procedure procedure, Object object2, Object object3) {
        MethodProc methodProc;
        ClassType classType;
        if (object2 instanceof Class) {
            object2 = Type.make((Class)object2);
        }
        if (object2 instanceof ClassType) {
            classType = (ClassType)object2;
        } else if (object2 instanceof String || object2 instanceof FString || object2 instanceof Symbol) {
            classType = ClassType.make(object2.toString());
        } else {
            throw new WrongType(procedure, 0, null);
        }
        if (!(object3 instanceof String || object3 instanceof FString || object3 instanceof Symbol)) {
            throw new WrongType(procedure, 1, null);
        }
        String string = object3.toString();
        if (!"<init>".equals(string)) {
            string = Compilation.mangleName(string);
        }
        if ((methodProc = ClassMethods.apply(classType, string, '\u0000', Language.getDefaultLanguage())) == null) {
            throw new RuntimeException("no applicable method named `" + string + "' in " + classType.getName());
        }
        return methodProc;
    }

    private static int removeRedundantMethods(Vector vector) {
        int n = vector.size();
        int n2 = 1;
        block0: while (n2 < n) {
            Method method = (Method)vector.elementAt(n2);
            ClassType classType = method.getDeclaringClass();
            Type[] typeArray = method.getParameterTypes();
            int n3 = typeArray.length;
            for (int i = 0; i < n2; ++i) {
                Method method2 = (Method)vector.elementAt(i);
                Type[] typeArray2 = method2.getParameterTypes();
                if (n3 != typeArray2.length) continue;
                int n4 = n3;
                while (--n4 >= 0 && typeArray[n4] == typeArray2[n4]) {
                }
                if (n4 >= 0) continue;
                if (classType.isSubtype(method2.getDeclaringClass())) {
                    vector.setElementAt(method, i);
                }
                vector.setElementAt(vector.elementAt(n - 1), n2);
                --n;
                continue block0;
            }
            ++n2;
        }
        return n;
    }

    public static PrimProcedure[] getMethods(ObjectType objectType, String string, char c, ClassType classType, Language language) {
        if (objectType == Type.tostring_type) {
            objectType = Type.string_type;
        }
        MethodFilter methodFilter = new MethodFilter(string, 0, 0, classType, c == 'P' ? null : objectType);
        boolean bl = c == 'P' || "<init>".equals(string);
        Vector<Method> vector = new Vector<Method>();
        objectType.getMethods(methodFilter, bl ? 0 : 2, vector);
        if (!(bl || objectType instanceof ClassType && !((ClassType)objectType).isInterface())) {
            Type.pointer_type.getMethods(methodFilter, 0, vector);
        }
        int n = bl ? vector.size() : ClassMethods.removeRedundantMethods(vector);
        PrimProcedure[] primProcedureArray = new PrimProcedure[n];
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            Method method = vector.elementAt(n3);
            if (!bl && method.getDeclaringClass() != objectType) {
                method = new Method(method, (ClassType)objectType.getImplementationType());
            }
            PrimProcedure primProcedure = new PrimProcedure(method, c, language);
            primProcedureArray[n2++] = primProcedure;
        }
        return primProcedureArray;
    }

    public static long selectApplicable(PrimProcedure[] primProcedureArray, Type[] typeArray) {
        int n = primProcedureArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            PrimProcedure primProcedure;
            int n5 = primProcedureArray[n4].isApplicable(typeArray);
            if (n5 < 0) {
                primProcedure = primProcedureArray[n - 1];
                primProcedureArray[n - 1] = primProcedureArray[n4];
                primProcedureArray[n4] = primProcedure;
                --n;
                continue;
            }
            if (n5 > 0) {
                primProcedure = primProcedureArray[n2];
                primProcedureArray[n2] = primProcedureArray[n4];
                primProcedureArray[n4] = primProcedure;
                ++n2;
                ++n4;
                continue;
            }
            ++n3;
            ++n4;
        }
        return ((long)n2 << 32) + (long)n3;
    }

    public static MethodProc apply(ObjectType objectType, String string, char c, Language language) {
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(objectType, string, c, null, language);
        GenericProc genericProc = null;
        PrimProcedure primProcedure = null;
        for (int i = 0; i < primProcedureArray.length; ++i) {
            PrimProcedure primProcedure2 = primProcedureArray[i];
            if (primProcedure != null && genericProc == null) {
                genericProc = new GenericProc();
                genericProc.add(primProcedure);
            }
            primProcedure = primProcedure2;
            if (genericProc == null) continue;
            genericProc.add(primProcedure);
        }
        if (genericProc != null) {
            genericProc.setName(objectType.getName() + "." + string);
            return genericProc;
        }
        return primProcedure;
    }

    static String checkName(Expression expression, boolean bl) {
        if (expression instanceof QuoteExp) {
            String string;
            Object object2 = ((QuoteExp)expression).getValue();
            if (object2 instanceof FString || object2 instanceof String) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                return null;
            }
            if (Compilation.isValidJavaName(string)) {
                return string;
            }
            return Compilation.mangleName(string, bl);
        }
        return null;
    }

    static String checkName(Expression expression) {
        if (expression instanceof QuoteExp) {
            Object object2 = ((QuoteExp)expression).getValue();
            if (object2 instanceof FString || object2 instanceof String) {
                return object2.toString();
            }
            if (object2 instanceof Symbol) {
                return ((Symbol)object2).getName();
            }
            return null;
        }
        return null;
    }

    static {
        classMethods.setName("class-methods");
    }
}

