/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.javafx;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import org.domterm.Backend;
import org.domterm.javafx.WebTerminal;

public class WebTerminalApp
extends Application {
    WebTerminal console;
    public static boolean exitOnStop;
    static Backend mainClient;
    static String defaultTitle;
    static WebTerminalApp instance;

    Scene createScene() throws Exception {
        final WebTerminal webTerminal = this.console = new WebTerminal(this.makeClient());
        Scene scene = new Scene((Parent)webTerminal);
        final ContextMenu contextMenu = new ContextMenu();
        webTerminal.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    contextMenu.show((Node)webTerminal, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                }
            }
        });
        webTerminal.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    mouseEvent.consume();
                }
            }
        });
        MenuItem menuItem = new MenuItem("Copy");
        contextMenu.getItems().add((Object)menuItem);
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                WebTerminalApp.this.console.doCopy();
            }
        });
        MenuItem menuItem2 = new MenuItem("Paste");
        contextMenu.getItems().add((Object)menuItem2);
        menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                WebTerminalApp.this.console.doPaste();
            }
        });
        if (this.console.backend.lineEditingMode != 'p') {
            Menu menu = new Menu("input mode");
            final ToggleGroup toggleGroup = new ToggleGroup();
            RadioMenuItem radioMenuItem = new RadioMenuItem("character mode");
            radioMenuItem.setToggleGroup(toggleGroup);
            RadioMenuItem radioMenuItem2 = new RadioMenuItem("line mode");
            radioMenuItem2.setToggleGroup(toggleGroup);
            RadioMenuItem radioMenuItem3 = new RadioMenuItem("auto mode");
            radioMenuItem3.setToggleGroup(toggleGroup);
            menu.getItems().add((Object)radioMenuItem);
            menu.getItems().add((Object)radioMenuItem2);
            menu.getItems().add((Object)radioMenuItem3);
            radioMenuItem3.setSelected(true);
            contextMenu.getItems().add((Object)menu);
            toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                    if (toggle2 != null) {
                        String string = ((RadioMenuItem)toggle2).getText();
                        WebTerminalApp.this.console.setLineEditing(string.charAt(0));
                        System.err.println("TOGGLE " + toggleGroup + " new:" + toggle2 + " - " + string);
                    }
                }
            });
        }
        instance = this;
        return scene;
    }

    public static void setDefaultBackend(Backend backend) {
        mainClient = backend;
    }

    protected Backend makeClient() throws Exception {
        if (mainClient == null) {
            throw new RuntimeException("internal error - mainClient not set");
        }
        return mainClient;
    }

    public void start(Stage stage) throws Exception {
        try {
            Scene scene = this.createScene();
            stage.setTitle(defaultTitle);
            stage.setScene(scene);
            stage.setWidth(700.0);
            stage.setHeight(500.0);
            stage.show();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public void stop() {
        System.err.println("Application stop called");
        if (exitOnStop) {
            System.exit(0);
        }
    }

    public static void startApp(Backend backend, String string, String[] stringArray) {
        exitOnStop = true;
        WebTerminalApp.setDefaultBackend(backend);
        defaultTitle = string;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Application.launch(WebTerminalApp.class, (String[])stringArray);
    }

    static {
        defaultTitle = "DomTerm";
    }
}

