/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var jsLoadObserver = require("js_load_observer/js_load_observer");
var tabs = require("sdk/tabs");

// use the two buckets.
var removedScripts = require("script_entries/removed_scripts").removedScripts;
var acceptedScripts = require("script_entries/accepted_scripts").acceptedScripts;

exports.testCheckInlineScriptAccepted = function (test) {
    var e = { target: {}, preventDefault: function () { console.log('default prevented'); } }; 
    e.target.ownerDocument = { URL: 'http://example.org/'};
    e.target.text = "var num = 10;";
    acceptedScripts.addAScript(e.target.ownerDocument.URL, {inline:true,
							    contents: e.target.text});
    jsLoadObserver.scriptAnalyzer.analyzeScriptBeforeExec(e);

    test.assertEqual(jsLoadObserver.scriptAnalyzer.checkInlineScript(e.target), true, "not found in accepted scripts");
};

exports.testCheckInlineScriptNotAcceptedThenAccepted = function (test) {
    var e = { target: {} };
    e.target.ownerDocument = { URL: 'http://example.org/'};
    e.target.text = "var num = 12;";

    test.assertEqual(jsLoadObserver.scriptAnalyzer.checkInlineScript(e.target), false, "found in accepted scripts");
     
    acceptedScripts.addAScript(e.target.ownerDocument.URL, {inline:true,
							    contents: e.target.text});
    test.assertEqual(jsLoadObserver.scriptAnalyzer.checkInlineScript(e.target), true, "not found in accepted scripts");
    
};

