/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "GameManagerTest.h"
#include "GameManager.h"
#include "StringDrawer.h"
#include <iostream>
#include "MapManager.h"
GameManagerTest::GameManagerTest(void)
{
}


GameManagerTest::~GameManagerTest(void)
{
}

int GameManagerTest::testStartANewGAmeAndPlaye6attack(){
	std::string myMap="width 32\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="  c.c c           a a                               b b b b b b \n";
	myMap+="c c c c c c c c c                                   b b b b b b \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b b ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer str(bBoard);
	GameManager gameM(&str,&bBoard);
	gameM.init();
	Player *toPlay=gameM.getActualPlayer();
	Player *toPlay2=gameM.getPlayer(1);
	gameM.attack(toPlay,2,0);
	gameM.attack(toPlay2,2,1);
	gameM.attack(toPlay,3,0);
	gameM.attack(toPlay,4,0);
	gameM.attack(toPlay,5,0);
	gameM.attack(toPlay,6,0);
	gameM.attack(toPlay,7,0);
	gameM.getRandomGenerator().setBool(true);
	gameM.getRandomGenerator().setIsFake(true);

	str.setCoord(0,0);
	str.setClearScreen(false);
	std::string tov2= "";str.drawScreen();
	
	gameM.endTurn();
	
	
	
	std::string tov= "";str.drawScreen();
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:b,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|                        aOAAAAAaaaaaaaaaaaaaaaaaaaaaaaa                      |\n";
	resultat+="|                         aoaaaaaaaaaaaaaaaaaaaaaaaaaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaaaaaa aaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaaa a  aaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaa      aaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaa       bbb                      |\n";
	resultat+="|                       aaaaaaaa aa  aaaaaaao   bb   bbb                      |\n";
	resultat+="|                       aaaaaa    aa  aaaaaa bbbbbbbbbbb                      |\n";
	resultat+="|                       aaaaa     oa  aaaaa bobbbbbbbbbb                      |\n";
	resultat+="|                        aaaa      aa  aaa  bbbbbbbbbbbb                      |\n";
	resultat+="|                        aaaa      aaa  aa   bbbbbbbbbbb                      |\n";
	resultat+="|                         a       aa a   a       bbbbbbb                      |\n";
	resultat+="|                         c      a                bbbbbb                      |\n";
	resultat+="|                        occ     aa               bbbbbb                      |\n";
	resultat+="|                       ccccccccc                 bbbbbb                      |\n";
	resultat+="|                       ccccccccc       ccc       bbbbbb                      |\n";
	resultat+="|                       cccccccccco    cccccc   bbbbbbbb                      |\n";
	resultat+="|                       cccccccccccc   ccccccccbbbbbbbbb                      |\n";
	resultat+="|                       cccccccccccccccccccccccbb bbbbbb                      |\n";
	resultat+="|                       ccccccccccccccccccccccc b bbbbbb                      |\n";
	resultat+="|                       ccccccccccccccccccccccc   bbbbbb                      |\n";
	resultat+="|                       cccccccccccccccccccccccc  bbbbbb                      |\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		/*
		std::cout << "ERROR : testDrawLittleScreen bad drawed map \n"<<tov<<std::endl;
		std::cout <<  "\033[2J"<<std::endl;
		std::cout <<  "Actual player"<<toPlay->getName()<<std::endl;
		//std::cout <<  ""<<tov2<<std::endl;
		std::cout <<  "d 2 0 "<<bBoard.getCaseNoThrow(2,0)->getType()<<":"<<Case::SELECTED<<std::endl;
	std::cout <<  "d 2 1 "<<bBoard.getCaseNoThrow(2,1)->getType()<<":"<<Case::FREE<<std::endl;
	*/
		std::cout << "ERROR : testDrawLittleScreen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		return 0;
		std::cout << "OK : testDrawLittleScreen"<<std::endl;
	}
}

int GameManagerTest::testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n";
	myMap+="a a a a a \n";
	myMap+="c c   a a \n";
	myMap+="c c c c c \n";
	myMap+="c c c.c c ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer str(bBoard);
	GameManager gameM(&str,&bBoard);
	gameM.init();
	Player *toPlay=gameM.getActualPlayer();
	Player *toPlay2=gameM.getPlayer(1);
	gameM.attack(toPlay,0,1);
	gameM.attack(toPlay,1,1);
	gameM.attack(toPlay,3,1);
	gameM.attack(toPlay,4,1);
	gameM.attack(toPlay,3,2);
	gameM.attack(toPlay,4,2);
	
	gameM.getRandomGenerator().setBool(true);
	gameM.getRandomGenerator().setIsFake(true);

	str.setCoord(0,0);
	str.setClearScreen(false);
	
	
	gameM.endTurn();
	std::string tov2= "";//str.drawScreen();
	toPlay=gameM.getActualPlayer();
	gameM.attack(toPlay,3,4);
	gameM.attack(toPlay,4,4);
	gameM.attack(toPlay,2,3);
	gameM.attack(toPlay,2,4);
	gameM.attack(toPlay,0,3);
	gameM.attack(toPlay,1,3);
	gameM.endTurn();
	std::string tov3;//= str.drawScreen();
	toPlay=gameM.getActualPlayer();

	gameM.guerilla(toPlay,2,3);
	gameM.endTurn();
	
	std::string tov;//= str.drawScreen();
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:c,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                     aaoaa                                   |\n";
	resultat+="|                                     AAaAA                                   |\n";
	resultat+="|                                     cc AA                                   |\n";
	resultat+="|                                     CCAcc                                   |\n";
	resultat+="|                                     ccOCC                                   |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
	/*
		std::cout << "ERROR :testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla  bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : bad drawed map \n"<<tov2<<std::endl;
		std::cout << "ERROR : bad drawed map \n"<<tov3<<std::endl;
		std::cout <<  "\033[2J"<<std::endl;
		*/
		std::cout << "ERROR :testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla  bad drawed map \n"<<std::endl;
		return 0;
		//std::cout <<  ""<<tov2<<std::endl;
		
	

	}
	else
	{
		return 0;
		std::cout << "OK : testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla"<<std::endl;
	}
}

int GameManagerTest::testStartANewGAmeAndPlaye6attackAdvAttackAndGuerillaAndWin(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n";
	myMap+="a a a a a \n";
	myMap+="c c   a a \n";
	myMap+="c c c a a \n";
	myMap+="c c c.c c ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer str(bBoard);
	GameManager gameM(&str,&bBoard);
	gameM.init();
	Player *toPlay=gameM.getActualPlayer();
	Player *toPlay2=gameM.getPlayer(1);
	gameM.attack(toPlay,0,1);
	gameM.attack(toPlay,1,1);
	gameM.attack(toPlay,3,3);
	gameM.attack(toPlay,4,3);
	gameM.attack(toPlay,3,2);
	gameM.attack(toPlay,4,2);
	
	gameM.getRandomGenerator().setBool(true);
	gameM.getRandomGenerator().setIsFake(true);

	str.setCoord(0,0);
	str.setClearScreen(false);
	
	
	gameM.endTurn();
	std::string tov2;//= str.drawScreen();
	toPlay=gameM.getActualPlayer();
	gameM.attack(toPlay,3,4);
	gameM.attack(toPlay,4,4);
	gameM.attack(toPlay,2,3);
	gameM.attack(toPlay,2,4);
	gameM.attack(toPlay,0,3);
	gameM.attack(toPlay,1,3);
	gameM.endTurn();
	std::string tov3;//;= str.drawScreen();
	toPlay=gameM.getActualPlayer();

	gameM.guerilla(toPlay,2,4);
	gameM.endTurn();
	
	std::string tov;//= str.drawScreen();
	//sdr.setCursor(0,0);
	std::string resultat="Winner:a\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                     aaoaa                                   |\n";
	resultat+="|                                     AAaaa                                   |\n";
	resultat+="|                                     aa AA                                   |\n";
	resultat+="|                                     aaaAA                                   |\n";
	resultat+="|                                     aaOaa                                   |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
	/*
		std::cout << "ERROR :testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla  bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : bad drawed map \n"<<tov2<<std::endl;
		std::cout << "ERROR : bad drawed map \n"<<tov3<<std::endl;
		std::cout <<  "\033[2J"<<std::endl;
		*/
		std::cout << "ERROR :testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla  bad drawed map \n"<<std::endl;
		return 0;
		//std::cout <<  ""<<tov2<<std::endl;
		
	

	}
	else
	{
		std::cout << "OK : testStartANewGAmeAndPlaye6attackAdvAttackAndGuerilla"<<std::endl;
		return 0;
	}
}
