/*
PSPP - a program for statistical analysis.
Copyright (C) 2017 Free Software Foundation, Inc.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* -*- mode: c; buffer-read-only: t -*-

   Generated by sys-file-encoding.pl.  Do not modify!
*/

#include <config.h>

#include "data/sys-file-private.h"

struct sys_encoding sys_codepage_number_to_name[] = {
  { 37, "IBM037" },
  { 256, "ibm-256" },
  { 259, "IBM-Symbols" },
  { 273, "IBM273" },
  { 274, "IBM274" },
  { 275, "IBM275" },
  { 277, "IBM277" },
  { 278, "IBM278" },
  { 280, "IBM280" },
  { 284, "IBM284" },
  { 285, "IBM285" },
  { 286, "EBCDIC-AT-DE-A" },
  { 290, "IBM290" },
  { 293, "ibm-293" },
  { 297, "IBM297" },
  { 300, "ibm-300" },
  { 301, "ibm-301" },
  { 367, "ANSI_X3.4-1968" },
  { 420, "IBM420" },
  { 424, "IBM424" },
  { 425, "ibm-425" },
  { 437, "IBM437" },
  { 500, "IBM500" },
  { 720, "windows-720" },
  { 737, "windows-737" },
  { 775, "IBM775" },
  { 803, "ibm-803" },
  { 806, "ibm-806" },
  { 808, "ibm-808" },
  { 813, "ISO-8859-7" },
  { 819, "ISO_8859-1:1987" },
  { 833, "ibm-833" },
  { 834, "ibm-834" },
  { 835, "ibm-835" },
  { 836, "ibm-836" },
  { 837, "ibm-837" },
  { 838, "IBM-Thai" },
  { 848, "ibm-848" },
  { 849, "ibm-849" },
  { 850, "IBM850" },
  { 851, "IBM851" },
  { 852, "IBM852" },
  { 855, "IBM855" },
  { 856, "cp856" },
  { 857, "IBM857" },
  { 858, "IBM00858" },
  { 859, "ibm-859" },
  { 860, "IBM860" },
  { 861, "IBM861" },
  { 862, "IBM862" },
  { 863, "IBM863" },
  { 864, "IBM864" },
  { 865, "IBM865" },
  { 866, "IBM866" },
  { 867, "ibm-867" },
  { 868, "IBM868" },
  { 869, "IBM869" },
  { 870, "IBM870" },
  { 871, "IBM871" },
  { 872, "ibm-872" },
  { 874, "windows-874" },
  { 875, "cp875" },
  { 878, "KOI8-R" },
  { 880, "IBM880" },
  { 896, "ibm-896" },
  { 897, "JIS_X0201" },
  { 901, "ibm-901" },
  { 902, "ibm-902" },
  { 905, "IBM905" },
  { 912, "ISO_8859-2:1987" },
  { 913, "ISO_8859-3:1988" },
  { 914, "ISO_8859-4:1988" },
  { 915, "ISO_8859-5:1988" },
  { 916, "ibm-916" },
  { 918, "IBM918" },
  { 920, "ISO_8859-9:1989" },
  { 921, "ISO-8859-13" },
  { 922, "cp922" },
  { 923, "ISO-8859-15" },
  { 924, "IBM00924" },
  { 926, "ibm-926" },
  { 927, "ibm-927" },
  { 928, "ibm-928" },
  { 930, "cp930" },
  { 932, "Shift_JIS" },
  { 933, "cp933" },
  { 935, "cp935" },
  { 936, "GBK" },
  { 937, "cp937" },
  { 939, "cp939" },
  { 941, "ibm-941" },
  { 943, "cp943" },
  { 944, "ibm-944" },
  { 946, "ibm-946" },
  { 947, "ibm-947" },
  { 948, "ibm-948" },
  { 949, "windows-949" },
  { 950, "Big5" },
  { 951, "ibm-951" },
  { 952, "ibm-952" },
  { 953, "JIS_X0212-1990" },
  { 954, "EUC-JP" },
  { 955, "ibm-955" },
  { 964, "cp964" },
  { 970, "EUC-KR" },
  { 971, "ibm-971" },
  { 1004, "ibm-1004" },
  { 1006, "cp1006" },
  { 1008, "ibm-1008" },
  { 1009, "ibm-1009" },
  { 1010, "NF_Z_62-010" },
  { 1011, "DIN_66003" },
  { 1012, "IT" },
  { 1013, "BS_4730" },
  { 1014, "ES2" },
  { 1015, "PT2" },
  { 1016, "NS_4551-1" },
  { 1017, "ibm-1017" },
  { 1018, "SEN_850200_B" },
  { 1019, "ibm-1019" },
  { 1020, "CSA_Z243.4-1985-1" },
  { 1021, "ibm-1021" },
  { 1023, "ES" },
  { 1025, "cp1025" },
  { 1026, "IBM1026" },
  { 1027, "ibm-1027" },
  { 1041, "ibm-1041" },
  { 1043, "ibm-1043" },
  { 1046, "ibm-1046" },
  { 1047, "IBM1047" },
  { 1051, "hp-roman8" },
  { 1088, "ibm-1088" },
  { 1089, "ISO_8859-6:1987" },
  { 1097, "cp1097" },
  { 1098, "cp1098" },
  { 1100, "DEC-MCS" },
  { 1101, "ibm-1101" },
  { 1102, "ibm-1102" },
  { 1103, "ibm-1103" },
  { 1104, "iso-ir-25" },
  { 1105, "ibm-1105" },
  { 1106, "ibm-1106" },
  { 1107, "DS_2089" },
  { 1112, "cp1112" },
  { 1114, "ibm-1114" },
  { 1115, "ibm-1115" },
  { 1122, "cp1122" },
  { 1123, "cp1123" },
  { 1124, "cp1124" },
  { 1125, "ibm-1125" },
  { 1127, "ibm-1127" },
  { 1129, "ibm-1129" },
  { 1130, "ibm-1130" },
  { 1131, "ibm-1131" },
  { 1132, "ibm-1132" },
  { 1133, "ibm-1133" },
  { 1137, "ibm-1137" },
  { 1140, "IBM01140" },
  { 1141, "IBM01141" },
  { 1142, "IBM01142" },
  { 1143, "IBM01143" },
  { 1144, "IBM01144" },
  { 1145, "IBM01145" },
  { 1146, "IBM01146" },
  { 1147, "IBM01147" },
  { 1148, "IBM01148" },
  { 1149, "IBM01149" },
  { 1153, "ibm-1153" },
  { 1154, "ibm-1154" },
  { 1155, "ibm-1155" },
  { 1156, "ibm-1156" },
  { 1157, "ibm-1157" },
  { 1158, "ibm-1158" },
  { 1160, "ibm-1160" },
  { 1161, "ibm-1161" },
  { 1162, "ibm-1162" },
  { 1163, "ibm-1163" },
  { 1164, "ibm-1164" },
  { 1165, "ibm-1165" },
  { 1166, "ibm-1166" },
  { 1167, "ibm-1167" },
  { 1168, "KOI8-U" },
  { 1174, "KZ-1048" },
  { 1200, "UTF-16LE" },
  { 1201, "UTF-16BE" },
  { 1205, "UTF-16" },
  { 1213, "SCSU" },
  { 1215, "BOCU-1" },
  { 1235, "UTF-32LE" },
  { 1237, "UTF-32" },
  { 1250, "windows-1250" },
  { 1251, "windows-1251" },
  { 1252, "windows-1252" },
  { 1253, "windows-1253" },
  { 1254, "windows-1254" },
  { 1255, "windows-1255" },
  { 1256, "windows-1256" },
  { 1257, "windows-1257" },
  { 1258, "windows-1258" },
  { 1276, "Adobe-Standard-Encoding" },
  { 1277, "ibm-1277" },
  { 1350, "ibm-1350" },
  { 1351, "ibm-1351" },
  { 1362, "ibm-1362" },
  { 1363, "ibm-1363" },
  { 1364, "ibm-1364" },
  { 1370, "ibm-1370" },
  { 1371, "ibm-1371" },
  { 1373, "ibm-1373" },
  { 1375, "Big5-HKSCS" },
  { 1380, "ibm-1380" },
  { 1381, "cp1381" },
  { 1382, "ibm-1382" },
  { 1383, "GB2312" },
  { 1385, "ibm-9577" },
  { 1386, "ibm-1386" },
  { 1390, "ibm-1390" },
  { 1392, "gb18030" },
  { 1399, "ibm-1399" },
  { 4517, "ibm-4517" },
  { 4899, "ibm-4899" },
  { 4902, "ibm-4902" },
  { 4909, "ibm-4909" },
  { 4930, "ibm-4930" },
  { 4933, "ibm-4933" },
  { 4948, "ibm-4948" },
  { 4951, "ibm-4951" },
  { 4952, "ibm-4952" },
  { 4960, "ibm-4960" },
  { 4971, "ibm-4971" },
  { 5012, "ISO_8859-8:1988" },
  { 5026, "cp930" },
  { 5035, "cp939" },
  { 5039, "ibm-5039" },
  { 5048, "ibm-5048" },
  { 5049, "ibm-5049" },
  { 5050, "cp33722" },
  { 5054, "JIS_Encoding" },
  { 5067, "ibm-5067" },
  { 5104, "ibm-5104" },
  { 5123, "ibm-5123" },
  { 5346, "windows-1250" },
  { 5347, "windows-1251" },
  { 5348, "windows-1252" },
  { 5349, "windows-1253" },
  { 5350, "windows-1254" },
  { 5351, "ibm-5351" },
  { 5352, "ibm-5352" },
  { 5353, "ibm-5353" },
  { 5354, "windows-1258" },
  { 5471, "MS950_HKSCS" },
  { 5478, "GB_2312-80" },
  { 8482, "ibm-8482" },
  { 8612, "ibm-8612" },
  { 9005, "ISO_8859-7:1987" },
  { 9027, "ibm-9027" },
  { 9030, "IBM-Thai" },
  { 9048, "ibm-9048" },
  { 9056, "ibm-9056" },
  { 9061, "ibm-9061" },
  { 9066, "TIS-620" },
  { 9067, "ibm-9067" },
  { 9145, "ibm-9145" },
  { 9238, "ibm-9238" },
  { 9400, "CESU-8" },
  { 9424, "UTF-32BE" },
  { 9447, "windows-1255" },
  { 9448, "windows-1256" },
  { 9449, "windows-1257" },
  { 9580, "ibm-1388" },
  { 10000, "macintosh" },
  { 10006, "windows-10006" },
  { 10007, "windows-10007" },
  { 10029, "windows-10029" },
  { 10081, "windows-10081" },
  { 12712, "ibm-12712" },
  { 13125, "ibm-13125" },
  { 13140, "ibm-13140" },
  { 13218, "ibm-13218" },
  { 13676, "ibm-13676" },
  { 16804, "ibm-16804" },
  { 17221, "ibm-17221" },
  { 17248, "ibm-17248" },
  { 17593, "UTF-8" },
  { 20127, "ANSI_X3.4-1968" },
  { 20780, "ibm-16684" },
  { 20866, "KOI8-R" },
  { 20880, "IBM880" },
  { 20905, "IBM905" },
  { 21344, "ibm-21344" },
  { 21427, "ibm-21427" },
  { 21866, "KOI8-U" },
  { 25546, "ibm-25546" },
  { 28592, "ISO_8859-2:1987" },
  { 28593, "ISO_8859-3:1988" },
  { 28594, "ISO_8859-4:1988" },
  { 28595, "ISO_8859-5:1988" },
  { 28596, "ISO_8859-6:1987" },
  { 28597, "ISO_8859-7:1987" },
  { 28598, "ISO_8859-8:1988" },
  { 28599, "ISO_8859-9:1989" },
  { 28603, "ISO-8859-13" },
  { 28605, "ISO-8859-15" },
  { 29875, "UTF-16LE" },
  { 33058, "ibm-33058" },
  { 33722, "cp33722" },
  { 51932, "Extended_UNIX_Code_Packed_Format_for_Japanese" },
  { 51949, "EUC-KR" },
  { 54936, "gb18030" },
  { 57002, "ibm-4902" },
  { 57004, "windows-57004" },
  { 57005, "windows-57005" },
  { 57006, "windows-57003" },
  { 57007, "windows-57007" },
  { 57008, "windows-57008" },
  { 57009, "windows-57009" },
  { 57010, "windows-57010" },
  { 57011, "windows-57011" },
  { 61956, "UTF-16BE" },
  { 65000, "UTF-7" },
  { 65001, "UTF-8" },
  { 65025, "ibm-65025" },
  { 0, NULL }
};

struct sys_encoding sys_codepage_name_to_number[] = {
  { 37, "037" },
  { 1006, "1006" },
  { 1025, "1025" },
  { 1026, "1026" },
  { 1047, "1047" },
  { 28596, "1089" },
  { 1097, "1097" },
  { 1098, "1098" },
  { 1112, "1112" },
  { 1122, "1122" },
  { 1123, "1123" },
  { 1124, "1124" },
  { 1381, "1381" },
  { 1383, "1383" },
  { 273, "273" },
  { 277, "277" },
  { 278, "278" },
  { 280, "280" },
  { 284, "284" },
  { 285, "285" },
  { 297, "297" },
  { 5050, "33722" },
  { 420, "420" },
  { 424, "424" },
  { 437, "437" },
  { 51949, "5601" },
  { 20127, "646" },
  { 737, "737" },
  { 775, "775" },
  { 813, "813" },
  { 819, "819" },
  { 9030, "838" },
  { 850, "850" },
  { 851, "851" },
  { 852, "852" },
  { 855, "855" },
  { 856, "856" },
  { 857, "857" },
  { 860, "860" },
  { 861, "861" },
  { 862, "862" },
  { 863, "863" },
  { 865, "865" },
  { 866, "866" },
  { 868, "868" },
  { 869, "869" },
  { 871, "871" },
  { 875, "875" },
  { 819, "8859_1" },
  { 28603, "8859_13" },
  { 28605, "8859_15" },
  { 28592, "8859_2" },
  { 28593, "8859_3" },
  { 28594, "8859_4" },
  { 28595, "8859_5" },
  { 28596, "8859_6" },
  { 813, "8859_7" },
  { 28598, "8859_8" },
  { 28599, "8859_9" },
  { 28592, "912" },
  { 28593, "913" },
  { 28594, "914" },
  { 28595, "915" },
  { 916, "916" },
  { 28599, "920" },
  { 922, "922" },
  { 28605, "923" },
  { 5026, "930" },
  { 933, "933" },
  { 935, "935" },
  { 937, "937" },
  { 5035, "939" },
  { 943, "943" },
  { 949, "949" },
  { 950, "950" },
  { 964, "964" },
  { 51949, "970" },
  { 20127, "ANSI_X3.4-1968" },
  { 20127, "ANSI_X3.4-1986" },
  { 20127, "ASCII" },
  { 28596, "ASMO-708" },
  { 1276, "Adobe-Standard-Encoding" },
  { 1215, "BOCU-1" },
  { 1013, "BS_4730" },
  { 950, "Big5" },
  { 1375, "Big5-HKSCS" },
  { 858, "CCSID00858" },
  { 924, "CCSID00924" },
  { 1140, "CCSID01140" },
  { 1141, "CCSID01141" },
  { 1142, "CCSID01142" },
  { 1143, "CCSID01143" },
  { 1144, "CCSID01144" },
  { 1145, "CCSID01145" },
  { 1146, "CCSID01146" },
  { 1147, "CCSID01147" },
  { 1148, "CCSID01148" },
  { 1149, "CCSID01149" },
  { 9400, "CESU-8" },
  { 858, "CP00858" },
  { 924, "CP00924" },
  { 1140, "CP01140" },
  { 1141, "CP01141" },
  { 1142, "CP01142" },
  { 1143, "CP01143" },
  { 1144, "CP01144" },
  { 1145, "CP01145" },
  { 1146, "CP01146" },
  { 1147, "CP01147" },
  { 1148, "CP01148" },
  { 1149, "CP01149" },
  { 1026, "CP1026" },
  { 273, "CP273" },
  { 274, "CP274" },
  { 280, "CP280" },
  { 284, "CP284" },
  { 285, "CP285" },
  { 500, "CP500" },
  { 868, "CP868" },
  { 870, "CP870" },
  { 871, "CP871" },
  { 20905, "CP905" },
  { 918, "CP918" },
  { 936, "CP936" },
  { 1020, "CSA_Z243.4-1985-1" },
  { 1100, "DEC-MCS" },
  { 1011, "DIN_66003" },
  { 720, "DOS-720" },
  { 862, "DOS-862" },
  { 1107, "DS_2089" },
  { 286, "EBCDIC-AT-DE-A" },
  { 274, "EBCDIC-BE" },
  { 275, "EBCDIC-BR" },
  { 277, "EBCDIC-CP-DK" },
  { 277, "EBCDIC-CP-NO" },
  { 20880, "EBCDIC-Cyrillic" },
  { 290, "EBCDIC-JP-kana" },
  { 28596, "ECMA-114" },
  { 28597, "ECMA-118" },
  { 28597, "ELOT_928" },
  { 1023, "ES" },
  { 1014, "ES2" },
  { 51932, "EUC-JP" },
  { 51949, "EUC-KR" },
  { 51932, "Extended_UNIX_Code_Packed_Format_for_Japanese" },
  { 1018, "FI" },
  { 54936, "GB18030" },
  { 1383, "GB2312" },
  { 936, "GBK" },
  { 5478, "GB_2312-80" },
  { 259, "IBM-Symbols" },
  { 9030, "IBM-Thai" },
  { 858, "IBM00858" },
  { 924, "IBM00924" },
  { 1140, "IBM01140" },
  { 1141, "IBM01141" },
  { 1142, "IBM01142" },
  { 1143, "IBM01143" },
  { 1144, "IBM01144" },
  { 1145, "IBM01145" },
  { 1146, "IBM01146" },
  { 1147, "IBM01147" },
  { 1148, "IBM01148" },
  { 1149, "IBM01149" },
  { 37, "IBM037" },
  { 1006, "IBM1006" },
  { 1026, "IBM1026" },
  { 1047, "IBM1047" },
  { 1098, "IBM1098" },
  { 1153, "IBM1153" },
  { 273, "IBM273" },
  { 274, "IBM274" },
  { 275, "IBM275" },
  { 277, "IBM277" },
  { 278, "IBM278" },
  { 280, "IBM280" },
  { 284, "IBM284" },
  { 285, "IBM285" },
  { 290, "IBM290" },
  { 297, "IBM297" },
  { 20127, "IBM367" },
  { 420, "IBM420" },
  { 424, "IBM424" },
  { 437, "IBM437" },
  { 500, "IBM500" },
  { 737, "IBM737" },
  { 775, "IBM775" },
  { 819, "IBM819" },
  { 9030, "IBM838" },
  { 850, "IBM850" },
  { 851, "IBM851" },
  { 852, "IBM852" },
  { 855, "IBM855" },
  { 856, "IBM856" },
  { 857, "IBM857" },
  { 860, "IBM860" },
  { 861, "IBM861" },
  { 862, "IBM862" },
  { 863, "IBM863" },
  { 864, "IBM864" },
  { 865, "IBM865" },
  { 866, "IBM866" },
  { 868, "IBM868" },
  { 869, "IBM869" },
  { 870, "IBM870" },
  { 871, "IBM871" },
  { 875, "IBM875" },
  { 20880, "IBM880" },
  { 20905, "IBM905" },
  { 918, "IBM918" },
  { 922, "IBM922" },
  { 5026, "IBM930" },
  { 5035, "IBM939" },
  { 1205, "ISO-10646-UCS-2" },
  { 1237, "ISO-10646-UCS-4" },
  { 5054, "ISO-2022-JP-1" },
  { 819, "ISO-8859-1" },
  { 28603, "ISO-8859-13" },
  { 28605, "ISO-8859-15" },
  { 28592, "ISO-8859-2" },
  { 28593, "ISO-8859-3" },
  { 28594, "ISO-8859-4" },
  { 28595, "ISO-8859-5" },
  { 28596, "ISO-8859-6" },
  { 28596, "ISO-8859-6-E" },
  { 28596, "ISO-8859-6-I" },
  { 28597, "ISO-8859-7" },
  { 28598, "ISO-8859-8" },
  { 28598, "ISO-8859-8-E" },
  { 28598, "ISO-8859-8-I" },
  { 28599, "ISO-8859-9" },
  { 1020, "ISO646-CA" },
  { 1011, "ISO646-DE" },
  { 1107, "ISO646-DK" },
  { 1023, "ISO646-ES" },
  { 1014, "ISO646-ES2" },
  { 1018, "ISO646-FI" },
  { 1010, "ISO646-FR" },
  { 1104, "ISO646-FR1" },
  { 1013, "ISO646-GB" },
  { 1012, "ISO646-IT" },
  { 1016, "ISO646-NO" },
  { 1015, "ISO646-PT2" },
  { 1018, "ISO646-SE" },
  { 20127, "ISO646-US" },
  { 20127, "ISO_646.irv:1991" },
  { 819, "ISO_8859-1:1987" },
  { 28592, "ISO_8859-2:1987" },
  { 28593, "ISO_8859-3:1988" },
  { 28594, "ISO_8859-4:1988" },
  { 28595, "ISO_8859-5:1988" },
  { 28596, "ISO_8859-6:1987" },
  { 28597, "ISO_8859-7:1987" },
  { 28598, "ISO_8859-8:1988" },
  { 28599, "ISO_8859-9:1989" },
  { 1012, "IT" },
  { 5054, "JIS_Encoding" },
  { 897, "JIS_X0201" },
  { 953, "JIS_X0212-1990" },
  { 20866, "KOI8-R" },
  { 21866, "KOI8-U" },
  /* KSC_5601 has multiple numbers for windows: 949 51949 */
  { 949, "KSC_5601" },
  /* KS_C_5601-1987 has multiple numbers for windows: 949 51949 */
  { 949, "KS_C_5601-1987" },
  { 949, "KS_C_5601-1989" },
  { 1174, "KZ-1048" },
  { 28605, "Latin-9" },
  { 874, "MS874" },
  { 936, "MS936" },
  { 5471, "MS950_HKSCS" },
  { 932, "MS_Kanji" },
  { 1010, "NF_Z_62-010" },
  { 1016, "NS_4551-1" },
  { 858, "PC-Multilingual-850+euro" },
  { 1015, "PT2" },
  { 1174, "RK1048" },
  { 1213, "SCSU" },
  { 1018, "SEN_850200_B" },
  { 1174, "STRK1048-2002" },
  { 932, "Shift_JIS" },
  { 874, "TIS-620" },
  { 20127, "US-ASCII" },
  { 1205, "UTF-16" },
  { 1201, "UTF-16BE" },
  { 1200, "UTF-16LE" },
  { 1237, "UTF-32" },
  { 9424, "UTF-32BE" },
  { 1235, "UTF-32LE" },
  { 65000, "UTF-7" },
  { 65001, "UTF-8" },
  { 1201, "UnicodeBigUnmarked" },
  { 1200, "UnicodeLittleUnmarked" },
  { 51932, "X-EUC-JP" },
  { 897, "X0201" },
  { 28596, "arabic" },
  { 20127, "ascii7" },
  { 1375, "big5hk" },
  { 1020, "ca" },
  { 5478, "chinese" },
  { 868, "cp-ar" },
  { 869, "cp-gr" },
  { 861, "cp-is" },
  { 37, "cp037" },
  { 1006, "cp1006" },
  { 1025, "cp1025" },
  { 1047, "cp1047" },
  { 28596, "cp1089" },
  { 1097, "cp1097" },
  { 1098, "cp1098" },
  { 1112, "cp1112" },
  { 1122, "cp1122" },
  { 1123, "cp1123" },
  { 1124, "cp1124" },
  { 1140, "cp1140" },
  { 1141, "cp1141" },
  { 1142, "cp1142" },
  { 1143, "cp1143" },
  { 1144, "cp1144" },
  { 1145, "cp1145" },
  { 1146, "cp1146" },
  { 1147, "cp1147" },
  { 1148, "cp1148" },
  { 1149, "cp1149" },
  { 1250, "cp1250" },
  { 1251, "cp1251" },
  { 1252, "cp1252" },
  { 1253, "cp1253" },
  { 1254, "cp1254" },
  { 1255, "cp1255" },
  { 1256, "cp1256" },
  { 1257, "cp1257" },
  { 1258, "cp1258" },
  { 1363, "cp1363" },
  { 1381, "cp1381" },
  { 1383, "cp1383" },
  { 275, "cp275" },
  { 277, "cp277" },
  { 278, "cp278" },
  { 290, "cp290" },
  { 297, "cp297" },
  { 5050, "cp33722" },
  { 20127, "cp367" },
  { 420, "cp420" },
  { 424, "cp424" },
  { 437, "cp437" },
  { 737, "cp737" },
  { 775, "cp775" },
  { 813, "cp813" },
  { 819, "cp819" },
  { 9030, "cp838" },
  { 850, "cp850" },
  { 851, "cp851" },
  { 852, "cp852" },
  { 855, "cp855" },
  { 856, "cp856" },
  { 857, "cp857" },
  { 858, "cp858" },
  { 860, "cp860" },
  { 861, "cp861" },
  { 862, "cp862" },
  { 863, "cp863" },
  { 864, "cp864" },
  { 865, "cp865" },
  { 866, "cp866" },
  { 869, "cp869" },
  { 9066, "cp874" },
  { 875, "cp875" },
  { 20880, "cp880" },
  { 28592, "cp912" },
  { 28593, "cp913" },
  { 28594, "cp914" },
  { 28595, "cp915" },
  { 916, "cp916" },
  { 28599, "cp920" },
  { 922, "cp922" },
  { 28605, "cp923" },
  { 5026, "cp930" },
  { 932, "cp932" },
  { 933, "cp933" },
  { 935, "cp935" },
  { 937, "cp937" },
  { 5035, "cp939" },
  { 943, "cp943" },
  { 932, "cp943c" },
  { 949, "cp949" },
  { 950, "cp950" },
  { 964, "cp964" },
  { 51949, "cp970" },
  { 284, "cpibm284" },
  { 285, "cpibm285" },
  { 297, "cpibm297" },
  { 37, "cpibm37" },
  { 20127, "csASCII" },
  { 1276, "csAdobeStandardEncoding" },
  { 1215, "csBOCU-1" },
  { 950, "csBig5" },
  { 1100, "csDECMCS" },
  { 286, "csEBCDICATDEA" },
  { 51949, "csEUCKR" },
  { 51932, "csEUCPkdFmtJapanese" },
  { 1383, "csGB2312" },
  { 1051, "csHPRoman8" },
  { 897, "csHalfWidthKatakana" },
  { 37, "csIBM037" },
  { 1026, "csIBM1026" },
  { 273, "csIBM273" },
  { 274, "csIBM274" },
  { 275, "csIBM275" },
  { 277, "csIBM277" },
  { 278, "csIBM278" },
  { 280, "csIBM280" },
  { 284, "csIBM284" },
  { 285, "csIBM285" },
  { 290, "csIBM290" },
  { 297, "csIBM297" },
  { 420, "csIBM420" },
  { 424, "csIBM424" },
  { 500, "csIBM500" },
  { 855, "csIBM855" },
  { 857, "csIBM857" },
  { 860, "csIBM860" },
  { 861, "csIBM861" },
  { 863, "csIBM863" },
  { 864, "csIBM864" },
  { 865, "csIBM865" },
  { 866, "csIBM866" },
  { 868, "csIBM868" },
  { 869, "csIBM869" },
  { 870, "csIBM870" },
  { 871, "csIBM871" },
  { 20880, "csIBM880" },
  { 20905, "csIBM905" },
  { 918, "csIBM918" },
  { 259, "csIBMSymbols" },
  { 9030, "csIBMThai" },
  { 1018, "csISO10Swedish" },
  { 1020, "csISO121Canadian1" },
  { 1012, "csISO15Italian" },
  { 1023, "csISO17Spanish" },
  { 1011, "csISO21German" },
  { 1104, "csISO25French" },
  { 1013, "csISO4UnitedKingdom" },
  { 5478, "csISO58GB231280" },
  { 1016, "csISO60DanishNorwegian" },
  { 1016, "csISO60Norwegian1" },
  { 1107, "csISO646Danish" },
  { 1010, "csISO69French" },
  { 1015, "csISO84Portuguese2" },
  { 1014, "csISO85Spanish2" },
  { 819, "csISOLatin1" },
  { 28592, "csISOLatin2" },
  { 28593, "csISOLatin3" },
  { 28594, "csISOLatin4" },
  { 28599, "csISOLatin5" },
  { 28596, "csISOLatinArabic" },
  { 28595, "csISOLatinCyrillic" },
  { 28597, "csISOLatinGreek" },
  { 28598, "csISOLatinHebrew" },
  { 5054, "csJISEncoding" },
  { 20866, "csKOI8R" },
  { 949, "csKSC56011987" },
  { 1174, "csKZ1048" },
  { 10000, "csMacintosh" },
  { 775, "csPC775Baltic" },
  { 850, "csPC850Multilingual" },
  { 851, "csPC851" },
  { 862, "csPC862LatinHebrew" },
  { 437, "csPC8CodePage437" },
  { 852, "csPCp852" },
  { 855, "csPCp855" },
  { 932, "csShiftJIS" },
  { 932, "csWindows31J" },
  { 1020, "csa7-1" },
  { 28605, "csisolatin0" },
  { 28605, "csisolatin9" },
  { 28595, "cyrillic" },
  { 1011, "de" },
  { 1100, "dec" },
  { 1107, "dk" },
  { 924, "ebcdic-Latin9--euro" },
  { 420, "ebcdic-cp-ar1" },
  { 918, "ebcdic-cp-ar2" },
  { 500, "ebcdic-cp-be" },
  { 37, "ebcdic-cp-ca" },
  { 500, "ebcdic-cp-ch" },
  { 284, "ebcdic-cp-es" },
  { 278, "ebcdic-cp-fi" },
  { 297, "ebcdic-cp-fr" },
  { 285, "ebcdic-cp-gb" },
  { 424, "ebcdic-cp-he" },
  { 871, "ebcdic-cp-is" },
  { 280, "ebcdic-cp-it" },
  { 37, "ebcdic-cp-nl" },
  { 870, "ebcdic-cp-roece" },
  { 278, "ebcdic-cp-se" },
  { 20905, "ebcdic-cp-tr" },
  { 37, "ebcdic-cp-us" },
  { 37, "ebcdic-cp-wt" },
  { 870, "ebcdic-cp-yu" },
  { 1141, "ebcdic-de-273+euro" },
  { 1142, "ebcdic-dk-277+euro" },
  { 1145, "ebcdic-es-284+euro" },
  { 1143, "ebcdic-fi-278+euro" },
  { 1147, "ebcdic-fr-297+euro" },
  { 285, "ebcdic-gb" },
  { 1146, "ebcdic-gb-285+euro" },
  { 1148, "ebcdic-international-500+euro" },
  { 871, "ebcdic-is" },
  { 1149, "ebcdic-is-871+euro" },
  { 1144, "ebcdic-it-280+euro" },
  { 1142, "ebcdic-no-277+euro" },
  { 1143, "ebcdic-se-278+euro" },
  { 278, "ebcdic-sv" },
  { 1140, "ebcdic-us-37+euro" },
  { 1350, "eucJP-Open" },
  { 954, "eucjis" },
  { 1010, "fr" },
  { 1013, "gb" },
  { 54936, "gb18030" },
  { 28597, "greek" },
  { 28597, "greek8" },
  { 28598, "hebrew" },
  { 1051, "hp-roman8" },
  { 1004, "ibm-1004" },
  { 1004, "ibm-1004_P100-1995" },
  { 1006, "ibm-1006" },
  { 1006, "ibm-1006_P100-1995" },
  { 1008, "ibm-1008" },
  { 1008, "ibm-1008_P100-1995" },
  { 1009, "ibm-1009" },
  { 1009, "ibm-1009_P100-1995" },
  { 1010, "ibm-1010" },
  { 1010, "ibm-1010_P100-1995" },
  { 1011, "ibm-1011" },
  { 1011, "ibm-1011_P100-1995" },
  { 1012, "ibm-1012" },
  { 1012, "ibm-1012_P100-1995" },
  { 1013, "ibm-1013" },
  { 1013, "ibm-1013_P100-1995" },
  { 1014, "ibm-1014" },
  { 1014, "ibm-1014_P100-1995" },
  { 1015, "ibm-1015" },
  { 1015, "ibm-1015_P100-1995" },
  { 1016, "ibm-1016" },
  { 1016, "ibm-1016_P100-1995" },
  { 1017, "ibm-1017" },
  { 1017, "ibm-1017_P100-1995" },
  { 1018, "ibm-1018" },
  { 1018, "ibm-1018_P100-1995" },
  { 1019, "ibm-1019" },
  { 1019, "ibm-1019_P100-1995" },
  { 1020, "ibm-1020" },
  { 1020, "ibm-1020_P100-2003" },
  { 1021, "ibm-1021" },
  { 1021, "ibm-1021_P100-2003" },
  { 1023, "ibm-1023" },
  { 1023, "ibm-1023_P100-2003" },
  { 1025, "ibm-1025" },
  { 1025, "ibm-1025_P100-1995" },
  { 1026, "ibm-1026" },
  { 1026, "ibm-1026_P100-1995" },
  { 1027, "ibm-1027" },
  { 1027, "ibm-1027_P100-1995" },
  { 1041, "ibm-1041" },
  { 1041, "ibm-1041_P100-1995" },
  { 1043, "ibm-1043" },
  { 1043, "ibm-1043_P100-1995" },
  { 1046, "ibm-1046" },
  { 1046, "ibm-1046_X110-1999" },
  { 1047, "ibm-1047" },
  { 1047, "ibm-1047_P100-1995" },
  { 1051, "ibm-1051" },
  { 1051, "ibm-1051_P100-1995" },
  { 1088, "ibm-1088" },
  { 1088, "ibm-1088_P100-1995" },
  { 28596, "ibm-1089" },
  { 28596, "ibm-1089_P100-1995" },
  { 1097, "ibm-1097" },
  { 1097, "ibm-1097_P100-1995" },
  { 1098, "ibm-1098" },
  { 1098, "ibm-1098_P100-1995" },
  { 1100, "ibm-1100" },
  { 1100, "ibm-1100_P100-2003" },
  { 1101, "ibm-1101" },
  { 1101, "ibm-1101_P100-2003" },
  { 1102, "ibm-1102" },
  { 1102, "ibm-1102_P100-2003" },
  { 1103, "ibm-1103" },
  { 1103, "ibm-1103_P100-2003" },
  { 1104, "ibm-1104" },
  { 1104, "ibm-1104_P100-2003" },
  { 1105, "ibm-1105" },
  { 1105, "ibm-1105_P100-2003" },
  { 1106, "ibm-1106" },
  { 1106, "ibm-1106_P100-2003" },
  { 1107, "ibm-1107" },
  { 1107, "ibm-1107_P100-2003" },
  { 1112, "ibm-1112" },
  { 1112, "ibm-1112_P100-1995" },
  { 1114, "ibm-1114" },
  { 1114, "ibm-1114_P100-2001" },
  { 1115, "ibm-1115" },
  { 1115, "ibm-1115_P100-1995" },
  { 1122, "ibm-1122" },
  { 1122, "ibm-1122_P100-1999" },
  { 1123, "ibm-1123" },
  { 1123, "ibm-1123_P100-1995" },
  { 1124, "ibm-1124" },
  { 1124, "ibm-1124_P100-1996" },
  { 1125, "ibm-1125" },
  { 1125, "ibm-1125_P100-1997" },
  { 1127, "ibm-1127" },
  { 1127, "ibm-1127_P100-2004" },
  { 1129, "ibm-1129" },
  { 1129, "ibm-1129_P100-1997" },
  { 1130, "ibm-1130" },
  { 1130, "ibm-1130_P100-1997" },
  { 1131, "ibm-1131" },
  { 1131, "ibm-1131_P100-1997" },
  { 1132, "ibm-1132" },
  { 1132, "ibm-1132_P100-1998" },
  { 1133, "ibm-1133" },
  { 1133, "ibm-1133_P100-1997" },
  { 1137, "ibm-1137" },
  { 1137, "ibm-1137_P100-1999" },
  { 1140, "ibm-1140" },
  { 1140, "ibm-1140_P100-1997" },
  { 1141, "ibm-1141" },
  { 1141, "ibm-1141_P100-1997" },
  { 1142, "ibm-1142" },
  { 1142, "ibm-1142_P100-1997" },
  { 1143, "ibm-1143" },
  { 1143, "ibm-1143_P100-1997" },
  { 1144, "ibm-1144" },
  { 1144, "ibm-1144_P100-1997" },
  { 1145, "ibm-1145" },
  { 1145, "ibm-1145_P100-1997" },
  { 1146, "ibm-1146" },
  { 1146, "ibm-1146_P100-1997" },
  { 1147, "ibm-1147" },
  { 1147, "ibm-1147_P100-1997" },
  { 1148, "ibm-1148" },
  { 1148, "ibm-1148_P100-1997" },
  { 1149, "ibm-1149" },
  { 1149, "ibm-1149_P100-1997" },
  { 1153, "ibm-1153" },
  { 1153, "ibm-1153_P100-1999" },
  { 1154, "ibm-1154" },
  { 1154, "ibm-1154_P100-1999" },
  { 1155, "ibm-1155" },
  { 1155, "ibm-1155_P100-1999" },
  { 1156, "ibm-1156" },
  { 1156, "ibm-1156_P100-1999" },
  { 1157, "ibm-1157" },
  { 1157, "ibm-1157_P100-1999" },
  { 1158, "ibm-1158" },
  { 1158, "ibm-1158_P100-1999" },
  { 1160, "ibm-1160" },
  { 1160, "ibm-1160_P100-1999" },
  { 1161, "ibm-1161" },
  { 1161, "ibm-1161_P100-1999" },
  { 1162, "ibm-1162" },
  { 1162, "ibm-1162_P100-1999" },
  { 1163, "ibm-1163" },
  { 1163, "ibm-1163_P100-1999" },
  { 1164, "ibm-1164" },
  { 1164, "ibm-1164_P100-1999" },
  { 1165, "ibm-1165" },
  { 1165, "ibm-1165_P101-2000" },
  { 1166, "ibm-1166" },
  { 1166, "ibm-1166_P100-2002" },
  { 1167, "ibm-1167" },
  { 1167, "ibm-1167_P100-2002" },
  { 21866, "ibm-1168" },
  { 21866, "ibm-1168_P100-2002" },
  { 1174, "ibm-1174" },
  { 1174, "ibm-1174_X100-2007" },
  { 1201, "ibm-1200" },
  { 1201, "ibm-1201" },
  { 1200, "ibm-1202" },
  { 1200, "ibm-1203" },
  { 1205, "ibm-1204" },
  { 1205, "ibm-1205" },
  { 65001, "ibm-1208" },
  { 65001, "ibm-1209" },
  { 1213, "ibm-1212" },
  { 1213, "ibm-1213" },
  { 1215, "ibm-1214" },
  { 1215, "ibm-1215" },
  { 9424, "ibm-1232" },
  { 9424, "ibm-1233" },
  { 1235, "ibm-1234" },
  { 1235, "ibm-1235" },
  { 1237, "ibm-1236" },
  { 1237, "ibm-1237" },
  { 1250, "ibm-1250" },
  { 1250, "ibm-1250_P100-1995" },
  { 1251, "ibm-1251" },
  { 1251, "ibm-1251_P100-1995" },
  { 1252, "ibm-1252" },
  { 1252, "ibm-1252_P100-2000" },
  { 1253, "ibm-1253" },
  { 1253, "ibm-1253_P100-1995" },
  { 1254, "ibm-1254" },
  { 1254, "ibm-1254_P100-1995" },
  { 1255, "ibm-1255" },
  { 1255, "ibm-1255_P100-1995" },
  { 1256, "ibm-1256" },
  { 1256, "ibm-1256_P110-1997" },
  { 1257, "ibm-1257" },
  { 1257, "ibm-1257_P100-1995" },
  { 1258, "ibm-1258" },
  { 1258, "ibm-1258_P100-1997" },
  { 12712, "ibm-12712" },
  { 12712, "ibm-12712_P100-1998" },
  { 1276, "ibm-1276" },
  { 1276, "ibm-1276_P100-1995" },
  { 1277, "ibm-1277" },
  { 1277, "ibm-1277_P100-1995" },
  { 13125, "ibm-13125" },
  { 13125, "ibm-13125_P100-1997" },
  { 13140, "ibm-13140" },
  { 13140, "ibm-13140_P101-2000" },
  { 13218, "ibm-13218" },
  { 13218, "ibm-13218_P100-1996" },
  { 1201, "ibm-13488" },
  { 1201, "ibm-13489" },
  { 1200, "ibm-13490" },
  { 1200, "ibm-13491" },
  { 65001, "ibm-13496" },
  { 65001, "ibm-13497" },
  { 1350, "ibm-1350" },
  { 1350, "ibm-1350_P110-1997" },
  { 1351, "ibm-1351" },
  { 1351, "ibm-1351_P110-1997" },
  { 1362, "ibm-1362" },
  { 1362, "ibm-1362_P110-1999" },
  { 1363, "ibm-1363" },
  { 1363, "ibm-1363_P110-1997" },
  { 1363, "ibm-1363_P11B-1998" },
  { 1364, "ibm-1364" },
  { 1364, "ibm-1364_P110-2007" },
  { 13676, "ibm-13676" },
  { 13676, "ibm-13676_P102-2001" },
  { 1370, "ibm-1370" },
  { 1370, "ibm-1370_P100-1999" },
  { 1371, "ibm-1371" },
  { 1371, "ibm-1371_P100-1999" },
  { 1373, "ibm-1373" },
  { 1373, "ibm-1373_P100-2002" },
  { 1375, "ibm-1375" },
  { 1375, "ibm-1375_P100-2007" },
  { 1380, "ibm-1380" },
  { 1380, "ibm-1380_P100-1995" },
  { 1381, "ibm-1381" },
  { 1381, "ibm-1381_P110-1999" },
  { 1382, "ibm-1382" },
  { 1382, "ibm-1382_P100-1995" },
  { 1383, "ibm-1383" },
  { 1383, "ibm-1383_P110-1999" },
  { 1385, "ibm-1385" },
  { 1386, "ibm-1386" },
  { 1386, "ibm-1386_P100-2001" },
  { 9580, "ibm-1388" },
  { 9580, "ibm-1388_P103-2001" },
  { 1390, "ibm-1390" },
  { 1390, "ibm-1390_P110-2003" },
  { 54936, "ibm-1392" },
  { 1399, "ibm-1399" },
  { 1399, "ibm-1399_P110-2003" },
  { 20780, "ibm-16684" },
  { 20780, "ibm-16684_P110-2003" },
  { 16804, "ibm-16804" },
  { 16804, "ibm-16804_X110-1999" },
  { 17221, "ibm-17221" },
  { 17221, "ibm-17221_P100-2001" },
  { 17248, "ibm-17248" },
  { 17248, "ibm-17248_X110-1999" },
  { 1201, "ibm-17584" },
  { 1201, "ibm-17585" },
  { 1200, "ibm-17586" },
  { 1200, "ibm-17587" },
  { 65001, "ibm-17592" },
  { 65001, "ibm-17593" },
  { 20780, "ibm-20780" },
  { 21344, "ibm-21344" },
  { 21344, "ibm-21344_P101-2000" },
  { 21427, "ibm-21427" },
  { 21427, "ibm-21427_P100-1999" },
  { 1201, "ibm-21680" },
  { 1201, "ibm-21681" },
  { 1200, "ibm-21682" },
  { 1200, "ibm-21683" },
  { 25546, "ibm-25546" },
  { 256, "ibm-256" },
  { 256, "ibm-256_P100-1995" },
  { 1201, "ibm-25776" },
  { 1201, "ibm-25777" },
  { 1200, "ibm-25778" },
  { 1200, "ibm-25779" },
  { 259, "ibm-259" },
  { 259, "ibm-259_P100-1995" },
  { 273, "ibm-273" },
  { 273, "ibm-273_P100-1995" },
  { 274, "ibm-274" },
  { 274, "ibm-274_P100-2000" },
  { 275, "ibm-275" },
  { 275, "ibm-275_P100-1995" },
  { 277, "ibm-277" },
  { 277, "ibm-277_P100-1995" },
  { 278, "ibm-278" },
  { 278, "ibm-278_P100-1995" },
  { 280, "ibm-280" },
  { 280, "ibm-280_P100-1995" },
  { 284, "ibm-284" },
  { 284, "ibm-284_P100-1995" },
  { 285, "ibm-285" },
  { 285, "ibm-285_P100-1995" },
  { 286, "ibm-286" },
  { 286, "ibm-286_P100-2003" },
  { 290, "ibm-290" },
  { 290, "ibm-290_P100-1995" },
  { 293, "ibm-293" },
  { 293, "ibm-293_P100-1995" },
  { 297, "ibm-297" },
  { 297, "ibm-297_P100-1995" },
  { 1201, "ibm-29872" },
  { 1201, "ibm-29873" },
  { 1200, "ibm-29874" },
  { 1200, "ibm-29875" },
  { 300, "ibm-300" },
  { 300, "ibm-300_P120-2006" },
  { 301, "ibm-301" },
  { 301, "ibm-301_P110-1997" },
  { 33058, "ibm-33058" },
  { 33058, "ibm-33058_P100-2000" },
  { 5050, "ibm-33722" },
  { 5050, "ibm-33722_P120-1999" },
  { 51932, "ibm-33722_P12A_P12A-2004_U2" },
  { 20127, "ibm-367" },
  { 37, "ibm-37" },
  { 37, "ibm-37_P100-1995" },
  { 420, "ibm-420" },
  { 420, "ibm-420_X120-1999" },
  { 424, "ibm-424" },
  { 424, "ibm-424_P100-1995" },
  { 425, "ibm-425" },
  { 425, "ibm-425_P101-2000" },
  { 437, "ibm-437" },
  { 437, "ibm-437_P100-1995" },
  { 4517, "ibm-4517" },
  { 4517, "ibm-4517_P100-2005" },
  { 4899, "ibm-4899" },
  { 4899, "ibm-4899_P100-1998" },
  { 57002, "ibm-4902" },
  { 4909, "ibm-4909" },
  { 4909, "ibm-4909_P100-1999" },
  { 4930, "ibm-4930" },
  { 4930, "ibm-4930_P110-1999" },
  { 4933, "ibm-4933" },
  { 4933, "ibm-4933_P100-2002" },
  { 4948, "ibm-4948" },
  { 4948, "ibm-4948_P100-1995" },
  { 4951, "ibm-4951" },
  { 4951, "ibm-4951_P100-1995" },
  { 4952, "ibm-4952" },
  { 4952, "ibm-4952_P100-1995" },
  { 4960, "ibm-4960" },
  { 4960, "ibm-4960_P100-1995" },
  { 4971, "ibm-4971" },
  { 4971, "ibm-4971_P100-1999" },
  { 500, "ibm-500" },
  { 500, "ibm-500_P100-1995" },
  { 28598, "ibm-5012" },
  { 28598, "ibm-5012_P100-1999" },
  { 5026, "ibm-5026" },
  { 5035, "ibm-5035" },
  { 5039, "ibm-5039" },
  { 5039, "ibm-5039_P11A-1998" },
  { 5048, "ibm-5048" },
  { 5048, "ibm-5048_P100-1995" },
  { 5049, "ibm-5049" },
  { 5049, "ibm-5049_P100-1995" },
  { 5050, "ibm-5050" },
  { 5054, "ibm-5054" },
  { 5067, "ibm-5067" },
  { 5067, "ibm-5067_P100-1995" },
  { 5104, "ibm-5104" },
  { 5104, "ibm-5104_X110-1999" },
  { 5123, "ibm-5123" },
  { 5123, "ibm-5123_P100-1999" },
  { 65001, "ibm-5304" },
  { 65001, "ibm-5305" },
  { 1250, "ibm-5346" },
  { 1250, "ibm-5346_P100-1998" },
  { 1251, "ibm-5347" },
  { 1251, "ibm-5347_P100-1998" },
  { 1252, "ibm-5348" },
  { 1252, "ibm-5348_P100-1997" },
  { 1253, "ibm-5349" },
  { 1253, "ibm-5349_P100-1998" },
  { 1254, "ibm-5350" },
  { 1254, "ibm-5350_P100-1998" },
  { 5351, "ibm-5351" },
  { 5351, "ibm-5351_P100-1998" },
  { 5352, "ibm-5352" },
  { 5352, "ibm-5352_P100-1998" },
  { 5353, "ibm-5353" },
  { 5353, "ibm-5353_P100-1998" },
  { 1258, "ibm-5354" },
  { 1258, "ibm-5354_P100-1998" },
  { 5471, "ibm-5471" },
  { 5471, "ibm-5471_P100-2006" },
  { 5478, "ibm-5478" },
  { 5478, "ibm-5478_P100-1995" },
  { 1201, "ibm-61955" },
  { 1201, "ibm-61956" },
  { 65025, "ibm-65025" },
  { 720, "ibm-720" },
  { 720, "ibm-720_P100-1997" },
  { 737, "ibm-737" },
  { 737, "ibm-737_P100-1997" },
  { 775, "ibm-775" },
  { 775, "ibm-775_P100-1996" },
  { 803, "ibm-803" },
  { 803, "ibm-803_P100-1999" },
  { 806, "ibm-806" },
  { 806, "ibm-806_P100-1998" },
  { 808, "ibm-808" },
  { 808, "ibm-808_P100-1999" },
  { 813, "ibm-813" },
  { 813, "ibm-813_P100-1995" },
  { 819, "ibm-819" },
  { 833, "ibm-833" },
  { 833, "ibm-833_P100-1995" },
  { 834, "ibm-834" },
  { 834, "ibm-834_P100-1995" },
  { 835, "ibm-835" },
  { 835, "ibm-835_P100-1995" },
  { 836, "ibm-836" },
  { 836, "ibm-836_P100-1995" },
  { 837, "ibm-837" },
  { 837, "ibm-837_P100-1995" },
  { 9030, "ibm-838" },
  { 9030, "ibm-838_P100-1995" },
  { 848, "ibm-848" },
  { 8482, "ibm-8482" },
  { 8482, "ibm-8482_P100-1999" },
  { 848, "ibm-848_P100-1999" },
  { 849, "ibm-849" },
  { 849, "ibm-849_P100-1999" },
  { 850, "ibm-850" },
  { 850, "ibm-850_P100-1995" },
  { 851, "ibm-851" },
  { 851, "ibm-851_P100-1995" },
  { 852, "ibm-852" },
  { 852, "ibm-852_P100-1995" },
  { 855, "ibm-855" },
  { 855, "ibm-855_P100-1995" },
  { 856, "ibm-856" },
  { 856, "ibm-856_P100-1995" },
  { 857, "ibm-857" },
  { 857, "ibm-857_P100-1995" },
  { 858, "ibm-858" },
  { 858, "ibm-858_P100-1997" },
  { 859, "ibm-859" },
  { 859, "ibm-859_P100-1999" },
  { 860, "ibm-860" },
  { 860, "ibm-860_P100-1995" },
  { 861, "ibm-861" },
  { 8612, "ibm-8612" },
  { 8612, "ibm-8612_P100-1995" },
  { 861, "ibm-861_P100-1995" },
  { 862, "ibm-862" },
  { 862, "ibm-862_P100-1995" },
  { 863, "ibm-863" },
  { 863, "ibm-863_P100-1995" },
  { 864, "ibm-864" },
  { 864, "ibm-864_X110-1999" },
  { 865, "ibm-865" },
  { 865, "ibm-865_P100-1995" },
  { 866, "ibm-866" },
  { 866, "ibm-866_P100-1995" },
  { 867, "ibm-867" },
  { 867, "ibm-867_P100-1998" },
  { 868, "ibm-868" },
  { 868, "ibm-868_P100-1995" },
  { 869, "ibm-869" },
  { 869, "ibm-869_P100-1995" },
  { 870, "ibm-870" },
  { 870, "ibm-870_P100-1995" },
  { 871, "ibm-871" },
  { 871, "ibm-871_P100-1995" },
  { 872, "ibm-872" },
  { 872, "ibm-872_P100-1999" },
  { 9066, "ibm-874" },
  { 9066, "ibm-874_P100-1995" },
  { 875, "ibm-875" },
  { 875, "ibm-875_P100-1995" },
  { 20866, "ibm-878" },
  { 20866, "ibm-878_P100-1996" },
  { 20880, "ibm-880" },
  { 20880, "ibm-880_P100-1995" },
  { 896, "ibm-896" },
  { 896, "ibm-896_P100-1995" },
  { 897, "ibm-897" },
  { 897, "ibm-897_P100-1995" },
  { 28597, "ibm-9005" },
  { 28597, "ibm-9005_X110-2007" },
  { 901, "ibm-901" },
  { 901, "ibm-901_P100-1999" },
  { 902, "ibm-902" },
  { 9027, "ibm-9027" },
  { 9027, "ibm-9027_P100-1999" },
  { 902, "ibm-902_P100-1999" },
  { 9030, "ibm-9030" },
  { 9048, "ibm-9048" },
  { 9048, "ibm-9048_P100-1998" },
  { 20905, "ibm-905" },
  { 9056, "ibm-9056" },
  { 9056, "ibm-9056_P100-1995" },
  { 20905, "ibm-905_P100-1995" },
  { 9061, "ibm-9061" },
  { 9061, "ibm-9061_P100-1999" },
  { 9066, "ibm-9066" },
  { 9067, "ibm-9067" },
  { 9067, "ibm-9067_X100-2005" },
  { 28592, "ibm-912" },
  { 28592, "ibm-912_P100-1995" },
  { 28593, "ibm-913" },
  { 28593, "ibm-913_P100-2000" },
  { 28594, "ibm-914" },
  { 9145, "ibm-9145" },
  { 9145, "ibm-9145_P110-1997" },
  { 28594, "ibm-914_P100-1995" },
  { 28595, "ibm-915" },
  { 28595, "ibm-915_P100-1995" },
  { 916, "ibm-916" },
  { 916, "ibm-916_P100-1995" },
  { 918, "ibm-918" },
  { 918, "ibm-918_P100-1995" },
  { 28599, "ibm-920" },
  { 28599, "ibm-920_P100-1995" },
  { 28603, "ibm-921" },
  { 28603, "ibm-921_P100-1995" },
  { 922, "ibm-922" },
  { 922, "ibm-922_P100-1999" },
  { 28605, "ibm-923" },
  { 9238, "ibm-9238" },
  { 9238, "ibm-9238_X110-1999" },
  { 28605, "ibm-923_P100-1998" },
  { 924, "ibm-924" },
  { 924, "ibm-924_P100-1998" },
  { 926, "ibm-926" },
  { 926, "ibm-926_P100-2000" },
  { 927, "ibm-927" },
  { 927, "ibm-927_P100-1995" },
  { 928, "ibm-928" },
  { 928, "ibm-928_P100-1995" },
  { 5026, "ibm-930" },
  { 5026, "ibm-930_P120-1999" },
  { 5035, "ibm-931" },
  { 932, "ibm-932" },
  { 933, "ibm-933" },
  { 933, "ibm-933_P110-1995" },
  { 935, "ibm-935" },
  { 935, "ibm-935_P110-1999" },
  { 937, "ibm-937" },
  { 937, "ibm-937_P110-1999" },
  { 5035, "ibm-939" },
  { 5035, "ibm-939_P120-1999" },
  { 9400, "ibm-9400" },
  { 941, "ibm-941" },
  { 941, "ibm-941_P13A-2001" },
  { 932, "ibm-942" },
  { 9424, "ibm-9424" },
  { 932, "ibm-942_P12A-1999" },
  { 943, "ibm-943" },
  { 943, "ibm-943_P130-1999" },
  { 932, "ibm-943_P15A-2003" },
  { 944, "ibm-944" },
  { 1255, "ibm-9447" },
  { 1255, "ibm-9447_P100-2002" },
  { 1256, "ibm-9448" },
  { 1256, "ibm-9448_X100-2005" },
  { 1257, "ibm-9449" },
  { 1257, "ibm-9449_P100-2002" },
  { 944, "ibm-944_P100-1995" },
  { 946, "ibm-946" },
  { 946, "ibm-946_P100-1995" },
  { 947, "ibm-947" },
  { 947, "ibm-947_P100-1995" },
  { 948, "ibm-948" },
  { 948, "ibm-948_P110-1999" },
  { 949, "ibm-949" },
  { 949, "ibm-949_P110-1999" },
  { 950, "ibm-950" },
  { 950, "ibm-950_P110-1999" },
  { 951, "ibm-951" },
  { 951, "ibm-951_P100-1995" },
  { 952, "ibm-952" },
  { 952, "ibm-952_P110-1997" },
  { 953, "ibm-953" },
  { 953, "ibm-953_P100-2000" },
  { 954, "ibm-954" },
  { 954, "ibm-954_P101-2007" },
  { 955, "ibm-955" },
  { 955, "ibm-955_P110-1997" },
  { 1385, "ibm-9577" },
  { 1385, "ibm-9577_P100-2001" },
  { 9580, "ibm-9580" },
  { 964, "ibm-964" },
  { 964, "ibm-964_P110-1999" },
  { 51949, "ibm-970" },
  { 51949, "ibm-970_P110_P110-2006_U2" },
  { 971, "ibm-971" },
  { 51949, "ibm-eucKR" },
  { 1018, "iso-ir-10" },
  { 819, "iso-ir-100" },
  { 28592, "iso-ir-101" },
  { 28593, "iso-ir-109" },
  { 28594, "iso-ir-110" },
  { 1020, "iso-ir-121" },
  { 28597, "iso-ir-126" },
  { 28596, "iso-ir-127" },
  { 28598, "iso-ir-138" },
  { 28595, "iso-ir-144" },
  { 28599, "iso-ir-148" },
  { 949, "iso-ir-149" },
  { 1012, "iso-ir-15" },
  { 1023, "iso-ir-17" },
  { 1011, "iso-ir-21" },
  { 1104, "iso-ir-25" },
  { 1013, "iso-ir-4" },
  { 5478, "iso-ir-58" },
  { 20127, "iso-ir-6" },
  { 1016, "iso-ir-60" },
  { 1010, "iso-ir-69" },
  { 1015, "iso-ir-84" },
  { 1014, "iso-ir-85" },
  { 28605, "iso8859_15_fdis" },
  { 20127, "iso_646.irv:1983" },
  { 20866, "koi8" },
  { 949, "korean" },
  { 819, "l1" },
  { 28592, "l2" },
  { 28593, "l3" },
  { 28594, "l4" },
  { 28599, "l5" },
  { 28605, "l9" },
  { 28605, "latin0" },
  { 819, "latin1" },
  { 28592, "latin2" },
  { 28593, "latin3" },
  { 28594, "latin4" },
  { 28599, "latin5" },
  { 10000, "mac" },
  { 10000, "macintosh" },
  { 10000, "macos-0_2-10.2" },
  { 10029, "macos-29-10.2" },
  { 10081, "macos-35-10.2" },
  { 10006, "macos-6_2-10.4" },
  { 10007, "macos-7_3-10.2" },
  { 10000, "macroman" },
  { 949, "ms949" },
  { 1016, "no" },
  { 1051, "r8" },
  { 1051, "roman8" },
  { 1018, "se" },
  { 9066, "tis620.2533" },
  { 1013, "uk" },
  { 20127, "us" },
  { 10000, "windows-10000" },
  { 10006, "windows-10006" },
  { 10007, "windows-10007" },
  { 10029, "windows-10029" },
  { 10081, "windows-10081" },
  { 1200, "windows-1200" },
  { 1201, "windows-1201" },
  { 1250, "windows-1250" },
  { 1251, "windows-1251" },
  { 1252, "windows-1252" },
  { 1253, "windows-1253" },
  { 1254, "windows-1254" },
  { 1255, "windows-1255" },
  { 1256, "windows-1256" },
  { 1257, "windows-1257" },
  { 1258, "windows-1258" },
  { 20127, "windows-20127" },
  { 20866, "windows-20866" },
  { 20880, "windows-20880" },
  { 20905, "windows-20905" },
  { 21866, "windows-21866" },
  { 28592, "windows-28592" },
  { 28593, "windows-28593" },
  { 28594, "windows-28594" },
  { 28595, "windows-28595" },
  { 28596, "windows-28596" },
  { 28597, "windows-28597" },
  { 28598, "windows-28598" },
  { 28599, "windows-28599" },
  { 28603, "windows-28603" },
  { 28605, "windows-28605" },
  { 932, "windows-31j" },
  { 437, "windows-437" },
  { 51932, "windows-51932" },
  { 51949, "windows-51949" },
  { 54936, "windows-54936" },
  { 57002, "windows-57002" },
  { 57006, "windows-57003" },
  { 57004, "windows-57004" },
  { 57005, "windows-57005" },
  { 57006, "windows-57006" },
  { 57007, "windows-57007" },
  { 57008, "windows-57008" },
  { 57009, "windows-57009" },
  { 57010, "windows-57010" },
  { 57011, "windows-57011" },
  { 65000, "windows-65000" },
  { 65001, "windows-65001" },
  { 720, "windows-720" },
  { 737, "windows-737" },
  { 775, "windows-775" },
  { 850, "windows-850" },
  { 852, "windows-852" },
  { 855, "windows-855" },
  { 857, "windows-857" },
  { 858, "windows-858" },
  { 861, "windows-861" },
  { 862, "windows-862" },
  { 866, "windows-866" },
  { 869, "windows-869" },
  { 874, "windows-874" },
  { 874, "windows-874-2000" },
  { 932, "windows-932" },
  { 936, "windows-936" },
  { 936, "windows-936-2000" },
  { 949, "windows-949" },
  { 949, "windows-949-2000" },
  { 950, "windows-950" },
  { 950, "windows-950-2000" },
  { 1006, "x-IBM1006" },
  { 1025, "x-IBM1025" },
  { 1027, "x-IBM1027" },
  { 1041, "x-IBM1041" },
  { 1043, "x-IBM1043" },
  { 1046, "x-IBM1046" },
  { 1046, "x-IBM1046S" },
  { 1088, "x-IBM1088" },
  { 1097, "x-IBM1097" },
  { 1098, "x-IBM1098" },
  { 1112, "x-IBM1112" },
  { 1114, "x-IBM1114" },
  { 1115, "x-IBM1115" },
  { 1122, "x-IBM1122" },
  { 1123, "x-IBM1123" },
  { 1124, "x-IBM1124" },
  { 1153, "x-IBM1153" },
  { 1351, "x-IBM1351" },
  { 1362, "x-IBM1362" },
  { 1363, "x-IBM1363" },
  { 1363, "x-IBM1363C" },
  { 1364, "x-IBM1364" },
  { 1370, "x-IBM1370" },
  { 1371, "x-IBM1371" },
  { 1380, "x-IBM1380" },
  { 1381, "x-IBM1381" },
  { 1382, "x-IBM1382" },
  { 1385, "x-IBM1385" },
  { 9580, "x-IBM1388" },
  { 1390, "x-IBM1390" },
  { 1399, "x-IBM1399" },
  { 300, "x-IBM300" },
  { 301, "x-IBM301" },
  { 5050, "x-IBM33722" },
  { 5050, "x-IBM33722A" },
  { 5050, "x-IBM33722C" },
  { 720, "x-IBM720" },
  { 737, "x-IBM737" },
  { 808, "x-IBM808" },
  { 833, "x-IBM833" },
  { 834, "x-IBM834" },
  { 835, "x-IBM835" },
  { 836, "x-IBM836" },
  { 837, "x-IBM837" },
  { 856, "x-IBM856" },
  { 859, "x-IBM859" },
  { 867, "x-IBM867" },
  { 9066, "x-IBM874" },
  { 875, "x-IBM875" },
  { 897, "x-IBM897" },
  { 28603, "x-IBM921" },
  { 922, "x-IBM922" },
  { 927, "x-IBM927" },
  { 5026, "x-IBM930" },
  { 5026, "x-IBM930A" },
  { 933, "x-IBM933" },
  { 935, "x-IBM935" },
  { 937, "x-IBM937" },
  { 5035, "x-IBM939" },
  { 5035, "x-IBM939A" },
  { 932, "x-IBM942" },
  { 932, "x-IBM942C" },
  { 943, "x-IBM943" },
  { 947, "x-IBM947" },
  { 948, "x-IBM948" },
  { 949, "x-IBM949" },
  { 950, "x-IBM950" },
  { 951, "x-IBM951" },
  { 954, "x-IBM954" },
  { 954, "x-IBM954C" },
  { 964, "x-IBM964" },
  { 51949, "x-IBM970" },
  { 971, "x-IBM971" },
  { 57002, "x-ISCII91" },
  { 28596, "x-ISO-8859-6S" },
  { 932, "x-JISAutoDetect" },
  { 1167, "x-KOI8_RU" },
  { 949, "x-KSC5601" },
  { 932, "x-MS932_0213" },
  { 5471, "x-MS950-HKSCS" },
  { 10029, "x-MacCentralEurope" },
  { 10007, "x-MacCyrillic" },
  { 10006, "x-MacGreek" },
  { 10081, "x-MacTurkish" },
  { 10007, "x-MacUkraine" },
  { 1350, "x-eucJP-Open" },
  { 57006, "x-iscii-as" },
  { 57006, "x-iscii-be" },
  { 57002, "x-iscii-de" },
  { 57010, "x-iscii-gu" },
  { 57008, "x-iscii-ka" },
  { 57009, "x-iscii-ma" },
  { 57007, "x-iscii-or" },
  { 57011, "x-iscii-pa" },
  { 57004, "x-iscii-ta" },
  { 57005, "x-iscii-te" },
  { 10029, "x-mac-ce" },
  { 10029, "x-mac-centraleurroman" },
  { 10007, "x-mac-cyrillic" },
  { 10006, "x-mac-greek" },
  { 10081, "x-mac-turkish" },
  { 10000, "x-macroman" },
  { 932, "x-ms-cp932" },
  { 932, "x-sjis" },
  { 1201, "x-utf-16be" },
  { 1200, "x-utf-16le" },
  { 1256, "x-windows-1256S" },
  { 5054, "x-windows-50221" },
  { 874, "x-windows-874" },
  { 950, "x-windows-950" },
  { 0, NULL }
};
