%{
#include "genfun.h"

#if 0
#define PUSH(s) \
        yy_push_state(s); \
        generateNewLine(); \
        generate_normal("<!-- PUSH  " #s " -->"); \
        generateNewLine();

#define POP(s) \
        yy_pop_state(); \
        generateNewLine(); \
        generate_normal("<!-- POP   " #s " -->"); \
        generateNewLine();
#else
    #define PUSH(s) yy_push_state(s);
    #define POP(s) yy_pop_state();
#endif

#define TRIMNORMAL(n)\
            do{ if(yyleng > n){\
                    yytext[yyleng - n]= '\0';\
                    generate_normal(yytext);\
                }}while(0)

%}

%option stack nomain yylineno noyywrap nounput nodefault
%option prefix="changelog_scanner_"


%x HEADER FILES FUNCS

VNAME       [[:alnum:]_][[:alnum:]_]*
NL	        \r?\n
NOT_WS		[^[:blank:]\r\n]
NUMESCSEQ	\\(([0-7]{1,3})|x([[:xdigit:]]{1,2}))
OPTWS		[[:blank:]]*
WS          [[:blank:]]

D               [[:digit:]]
D2              {D}{2}
YEAR            {D}{2,4}
ISO8601-DATE1   {YEAR}-?{D2}-?{D2}     
ISO8601-DATE2   {D}{4}-?{D}{3}
ISO8601-DATE3   {YEAR}-?W{D2}-?{D}
ISO8601-DATE    {ISO8601-DATE1}|{ISO8601-DATE2}|{ISO8601-DATE3}
TZ              Z|[-+]({D2}(:?{D2})?)
ISO8601-TIME    {D2}(:?{D2}(:?{D2})?([.,]{D}+)?)?{TZ}?

ISO8601-DATETIME {ISO8601-DATE}([ T]{ISO8601-TIME})?

%%
<INITIAL>{
    ^{ISO8601-DATETIME}         generateKeyWord(yytext); BEGIN(HEADER);
    ^{WS}+[*+]                  generateSymbol(yytext); BEGIN(FILES);
    {NL}                        generateNewLine();
    .                           generate_normal(yytext);
}
<HEADER>{
    "<"[^>\n]+">"               generateFunction(yytext);
    .|[^<\n]+                   generateBaseType(yytext);
    {NL}                        generateNewLine(); BEGIN(0);
}
<FILES>{
    [^:\n]+:                    yytext[yyleng-1]='\0'; generatePreProc(yytext); generateSymbol(":"); BEGIN(FUNCS);
    {NL}                        generateNewLine(); BEGIN(0);
    .                           generate_normal(yytext);
}
<FUNCS>{
    [^\n]                       generateFunction(yytext);
    {NL}                        generateNewLine(); BEGIN(0);
}
%%

